<?php

/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2024 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

/**
 * @property ModelReturnAuthorizationReturnAuthorization $model_return_authorization_return_authorization
 */
class ControllerPagesReturnAuthorizationReturnAuthorization extends AController
{
    public $data = [];
    private $error = [];

    public function main() {
        //if (!$this->customer->isLogged()) {
        //    redirect($this->html->getSecureURL('account/login'));
        //}

        $this->document->addScript($this->view->templateResource('/javascript/lightbox.min.js'));
        $this->document->addScript($this->view->templateResource('/javascript/fileinput.min.js'));

        $this->document->addStyle(
            [
                'href' => $this->view->templateResource('/stylesheet/lightbox.min.css'),
                'rel' => 'stylesheet',
            ]
        );

        $this->document->addStyle(
            [
                'href' => $this->view->templateResource('/stylesheet/fileinput.min.css'),
                'rel' => 'stylesheet',
            ]
        );

        $this->document->addStyle(
            [
                'href' => 'https://cdn.jsdelivr.net/npm/bootstrap-icons@1.5.0/font/bootstrap-icons.min.css',
                'rel' => 'stylesheet',
            ]
        );

        $order_id = (int)$this->request->get['order_id'];

        $customer_email = '';
        if ($order_id) {
            $allowed_order_statuses = unserialize($this->config->get('return_authorization_order_status'));
            $this->loadModel('account/order');

            if ($this->customer->isLogged()) {
                $order_info = $this->model_account_order->getOrder($order_id);
            } else {
                $order_info = $this->model_account_order->getOrder($order_id, '', 'view');
            }

            $customer_email = $order_info['email'];
            $days = (int)abs($this->config->get('return_authorization_period'));
            $range = $days * 86400;

            if (!in_array($order_info['order_status_id'], $allowed_order_statuses) || ($range != 0 && time() - dateISO2Int($order_info['date_added']) > $range)) {
                redirect($this->html->getSecureURL('account/invoice', '&order_id=' . $order_id));
            }
        }

        $this->loadLanguage('return_authorization/return_authorization');
        $this->loadModel('return_authorization/return_authorization');
        $this->document->setTitle($this->language->get('ra_heading_title'));
        $this->data = $this->model_return_authorization_return_authorization->getRequest($order_id);
        $this->data['details'] = unserialize($this->data['details']);
        if ($this->customer->isLogged()) {
            $customer_id = $this->customer->getId();
        } else {
            $customer_id = $order_info['customer_id'];
        }

        if ($this->request->is_POST() && $this->_validatePost()) {
            $data = $this->request->post;
            $data['order_id'] = $this->request->get['order_id'];
            if ($this->customer->isLogged()) {
                $customer_id = $this->customer->getId();
            } else {
                $customer_id = $order_info['customer_id'];
            }
            $data['customer_id'] = $customer_id;
            $data['details'] = (array)$this->data['details'];
            $data['details']['quantity'] = $this->request->post['quantity'];

            $this->model_return_authorization_return_authorization->editRequest($data);
            $this->session->data['success'] = $this->language->get('text_ra_success_submitted');

            redirect($this->html->getSecureURL('return_authorization/return_authorization', '&order_id=' . $data['order_id']));
        }

        if ($this->customer->isLogged()) {
            $cust_email = !$this->data['customer_email'] ?  $this->customer->getEmail() : $this->data['customer_email'];
        } else {
            $cust_email = !$this->data['customer_email'] ?  $customer_email : $this->data['customer_email'];
        }

        $this->data['customer_email'] = $cust_email;

        if (isset($this->session->data['warning'])) {
            $this->data['error_warning'] = $this->session->data['warning'];
            $this->session->data['warning'] = '';
        }
        if (isset($this->session->data['success'])) {
            $this->data['success'] = $this->session->data['success'];
            $this->session->data['success'] = '';
        }
        $this->data['heading_title'] = $this->language->get('ra_heading_title');

        $form = new AForm();
        $form->setForm(
            ['form_name' => 'addRequestFrm']
        );

        $this->data['form']['id'] = 'addRequestFrm';
        $this->data['form']['form_open'] = $form->getFieldHtml(
            ['type' => 'form',
                'name' => 'addRequestFrm',
                'action' => $this->html->getSecureURL('return_authorization/return_authorization', '&order_id=' . $this->request->get['order_id'])
            ]);

        $this->data['form']['back'] = $form->getFieldHtml(
            ['type' => 'button',
                'name' => 'back',
                'text' => $this->language->get('button_back'),
                'href' => $this->html->getSecureURL('account/invoice', '&order_id=' . $order_id),
                'icon' => 'icon-arrow-right'
            ]);

        $this->data['form']['submit'] = $form->getFieldHtml(
            ['type' => 'button',
                'name' => 'submit',
                'text' => $this->language->get('button_continue'),
                'style' => 'button1',
                'icon' => 'icon-arrow-right'
            ]);

        if (isset($this->request->post['ra_action'])) {
            $this->data['ra_action'] = $this->request->post['ra_action'];
        }

        $this->data['text_ra_action'] = $this->language->get('text_ra_action');
        if ($this->data['request_status_id'] > 1) {
            if ($this->data['ra_action'] == 1) {
                $language = $this->language->get('text_ra_action_replace');
            } elseif ($this->data['ra_action'] == 2) {
                $language = $this->language->get('text_ra_action_refund_to_payment');
            } else {
                $language = $this->language->get('text_ra_action_refund_store_credit');
            }

            $this->data['form']['ra_action'] = $language;
            $this->data['form']['ra_request_status'] = $this->model_return_authorization_return_authorization->getRequestStatusName($this->data['request_status_id']);
        } else {
            $this->data['form']['ra_action'] = $form->getFieldHtml(
                ['type' => 'selectbox',
                    'name' => 'ra_action',
                    'options' => [
                        1 => $this->language->get('text_ra_action_replace'),
                        2 => $this->language->get('text_ra_action_refund_to_payment'),
                        3 => $this->language->get('text_ra_action_refund_store_credit')
                    ],
                    'value' => $this->data['ra_action'],
                    'required' => true
                ]);
        }

        if (isset($this->request->post['reason'])) {
            $this->data['reason'] = $this->request->post['reason'];
        }

        $this->data['text_reason'] = $this->language->get('text_reason');
        if ($this->data['request_status_id'] > 1) {
            $this->data['form']['reason'] = $this->data['reason'];
        } else {
            $this->data['form']['reason'] = $form->getFieldHtml(
                ['type' => 'input',
                    'name' => 'reason',
                    'value' => $this->data['reason'],
                    'required' => true
                ]);
        }
        $this->data['text_comment'] = $this->language->get('text_conversation');
        $this->data['form']['conversation'] = unserialize($this->data['conversation']);

        if (isset($this->request->post['conversation'])) {
            $this->data['conversation'] = $this->request->post['conversation'];
        } else {
            $this->data['conversation'] = '';
        }

        if ($this->data['request_status_id'] < 6 || !isset($this->data['request_status_id'])) {
            $this->data['form']['comment'] = $form->getFieldHtml(
                ['type' => 'textarea',
                    'name' => 'conversation',
                    'value' => $this->data['conversation'],
                    'required' => true,
                    'style' => 'input-large',
                    'attr' => 'rows="10" cols="100" '
                ]);
        }

        $this->data['text_upload_damaged_product_proof'] = $this->language->get('text_upload_damaged_product_proof');

        if ($this->data['request_status_id'] < 6 || !isset($this->data['request_status_id'])) {
            $this->data['form']['upload_damaged_product_proof'] = $form->getFieldHtml(
                [
                    'type' => 'file',
                    'name' => 'upload_damaged_product_proof[]',
                    'attr' => 'accept="image/png, image/gif, image/jpeg" multiple'
                ]);
        } else {
            $this->data['form']['upload_damaged_product_proof'] = '';
        }

        $damage_proof = $this->model_return_authorization_return_authorization->getImage($customer_id,$order_id);
        $base = HTTPS ? HTTPS_SERVER : HTTP_SERVER;

        $image_url = '';
        foreach ($damage_proof as $img_url) {
            $image_url .= '<a href="' . $base . $img_url['image_url']  . '" data-lightbox="roadtrip"><img width="100px" height="100px" src="' . $base . $img_url['image_url']  . '" alt=""/></a>';
        }

        $this->data['text_your_damaged_product_proof'] = $this->language->get('text_your_damaged_product_proof');

        $this->data['form']['your_damaged_product_proof'] = $image_url;
        if (!file_exists(DIR_IMAGE . 'RA')) {
            mkdir(DIR_IMAGE . 'RA',0755);
        }

        if (!file_exists(DIR_IMAGE . 'RA/' . $order_id)) {
            mkdir(DIR_IMAGE . 'RA/' . $order_id, 0755);
        }

        $upload_dir = 'image/RA/' . $order_id . '/';

        $this->data['ra_url'] = $this->html->getCatalogURL('r/return_authorization/return_authorization/upload','&directory='.$upload_dir.'&order_id='.$order_id.'&customer_id='.$customer_id);

        $this->data['text_email'] = $this->language->get('ra_text_email');
        if ($this->data['request_status_id'] > 1) {
            $this->data['form']['email'] = $this->data['customer_email'];
        } else {
            $this->data['form']['email'] = $form->getFieldHtml(
                ['type' => 'input',
                    'name' => 'customer_email',
                    'value' => $this->data['customer_email'],
                    'required' => true
                ]);
        }

        $this->data['text_ra_products'] = $this->language->get('text_ra_products');
        $this->loadModel('account/order');
        $order_products = $this->model_account_order->getOrderProducts($this->request->get['order_id']);
        foreach ($order_products as $k => $product) {
            $options = $this->model_account_order->getOrderOptions($this->request->get['order_id'], $product['order_product_id']);
            $option_data = [];
            foreach ($options as $option) {
                $option_data[] = [
                    'name' => $option['name'],
                    'value' => $option['value'],
                ];
            }

            $options = [];
            for ($i = 0; $i <= $product['quantity']; $i++) {
                $options[$i] = $i;
            }

            $this->data['form']['ra_products'][$k] = [
                'order_product_id' => $product['order_product_id'],
                'product_id' => $product['product_id'],
                'name' => $product['name'],
                'model' => $product['model'],
                'option' => $option_data,
                'price' => $this->currency->format($product['price'], $order_info['currency'], $order_info['value']),
                'total' => $this->currency->format($product['total'], $order_info['currency'], $order_info['value']),
                'href' => $this->html->getSecureURL('product/product', '&product_id=' . $product['product_id'])
            ];

            if (isset($this->request->post['quantity'][$product['order_product_id']])) {
               $this->data['quantity[' . $product['order_product_id'] . ']'] = (int)$this->request->post['quantity'][$product['order_product_id']];
            } else {
               $this->data['quantity[' . $product['order_product_id'] . ']'] = (int)$this->data['details']['quantity'][$product['order_product_id']];
            }

            if ($this->data['request_status_id'] > 1) {
                $this->data['form']['ra_products'][$k]['quantity'] = $this->data['details']['returns'][$product['order_product_id']]['return_quantity'];
            } else {
                $this->data['form']['ra_products'][$k]['quantity'] = $form->getFieldHtml(
                    [
                        'type' => 'selectbox',
                        'name' => 'quantity[' . $product['order_product_id'] . ']',
                        'value' => $this->data['quantity[' . $product['order_product_id'] . ']'],
                        'options' => $options,
                        'style' => 'short input-short'
                    ]);
            }
        }

        if ($this->data['return_code']) {
            $this->data['text_return_code'] = $this->language->get('text_return_code');
            $this->data['form']['return_code'] = htmlentities($this->data['return_code'], ENT_QUOTES, 'UTF-8');
        }

        if ($this->data['request_id']) {
            $this->data['form']['request_id'] = $form->getFieldHtml(
                ['type' => 'hidden',
                    'name' => 'request_id',
                    'value' => $this->data['request_id']
                ]);
        }

        $this->data['text_close'] = $this->language->get('text_close');

        if ($this->data['request_status_id'] < 6) {
            if ($this->config->get('config_checkout_id')) {
                $this->loadModel('catalog/content');
                $content_info = $this->model_catalog_content->getContent($this->config->get('return_authorization_content'));
                if ($content_info) {
                    $this->data['text_accept_agree'] = $this->language->get('text_continue_request');
                    $this->data['text_accept_agree_href'] = $this->html->getURL(
                        'r/content/content/loadInfo',
                        '&content_id=' . $this->config->get('return_authorization_content'),
                        true
                    );
                    $this->data['text_accept_agree_href_link'] = $content_info['title'];
                } else {
                    $this->data['text_accept_agree'] = '';
                }
            } else {
                $this->data['text_accept_agree'] = '';
            }
        }

        $this->data['text_additional_notes'] = $this->language->get('text_additional_notes');

        $this->view->batchAssign($this->data);
        $this->processTemplate('pages/return_authorization/return_authorization.tpl');

    }

    private function _validatePost() {
        $this->error = '';
        if (!isset($this->request->post['request_id'])) {
            if (!trim($this->request->post['reason']) || !trim($this->request->post['conversation'])) {
                $this->error = $this->language->get('error_ra_required');
            }

            $pattern = '/^[A-Z0-9._%-]+@[A-Z0-9][A-Z0-9.-]{0,61}[A-Z0-9]\.[A-Z]{2,6}$/i';
            if (!preg_match($pattern, $this->request->post['customer_email'])) {
                $this->error = $this->language->get('error_ra_email');
            }
        }

        if ($this->error) {
            $this->session->data['warning'] = $this->error;
            return false;
        } else {
            return true;
        }
    }
}
