<?php

/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2024 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

// add new menu item
$menu = new AMenu ( "admin" );
$menu->insertMenuItem ( [ "item_id" => "return_authorization",
								 "parent_id"=>"sale",
								 "item_text" => "return_authorization_name",
								 "item_url" => "return_authorization/return_authorization/listing",
								 "item_type"=>"extension",
								 "sort_order"=>"8"]
								);

$this->db->query("CREATE TABLE IF NOT EXISTS ".$this->db->table("ra_requests")." (
  `request_id` int(11) NOT NULL AUTO_INCREMENT,
  `customer_id` int(11) NOT NULL,
  `order_id` int(11) NOT NULL DEFAULT '0',
  `request_status_id` int(11) NOT NULL DEFAULT '0',
  `ra_action` int(11) NOT NULL DEFAULT '0' COMMENT '1 - replacement, 2 - refund,3 - both',
  `reason` varchar(255) DEFAULT '',
  `details` text,
  `conversation` text,
  `return_code` varchar(255) NOT NULL DEFAULT '',
  `customer_email` varchar(255) DEFAULT '',
  `date_added` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`request_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_bin AUTO_INCREMENT=1");

$this->db->query("CREATE TABLE IF NOT EXISTS ".$this->db->table("ra_requests_proof_image")." (
  `ra_requests_proof_image_id` int(11) NOT NULL AUTO_INCREMENT,
  `customer_id` int(11) NOT NULL,
  `order_id` int(11) NOT NULL DEFAULT '0',
  `image_url` TEXT,
  `uploaded_at` DATETIME NULL,
PRIMARY KEY (`ra_requests_proof_image_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_bin AUTO_INCREMENT=1");

$this->db->query("INSERT INTO ".$this->db->table("pages")." (`page_id`, `parent_page_id`, `controller`, `key_param`, `key_value`, `date_added`)
VALUES (NULL, 0, 'pages/return_authorization/return_authorization', '', '', now() )");

$this->db->query("INSERT INTO ".$this->db->table("page_descriptions")." (`page_id`, `language_id`, `name`, `title`, `seo_url`, `keywords`, `description`, `content`, `date_added`)
VALUES (LAST_INSERT_ID(), 1, 'Customers Return Request Page', '', '', '', '', '', now() )");

$this->db->query("INSERT INTO ".$this->db->table("pages_layouts")." (`layout_id`, `page_id`) VALUES (18, LAST_INSERT_ID())");

$sql1 = "CREATE TABLE IF NOT EXISTS ".$this->db->table("return_authorization_license_info") ."(
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `public_key` TEXT NOT NULL,
  `license_data` TEXT NOT NULL,
  `license_key` TEXT NOT NULL,
  `store_id` int(11) NOT NULL,
  `last_check` int(11),
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci";

$this->db->query($sql1);
$sql2 = "CREATE TABLE IF NOT EXISTS ".$this->db->table("return_authorization_updater_notification") ."(
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `msg_id` int(11) NOT NULL,
  `cart_version` VARCHAR(10),
  `extension_version` VARCHAR(10),
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci";

$this->db->query($sql2);

if (file_exists(DIR_EXT . 'email_editor')) {
    $query_exist = $this->db->query("SELECT COUNT(*) as total FROM " . $this->db->table('email_editor_templates') . " WHERE `section`='return_authorization'");
    $exist = $query_exist->row['total'];
    if ($exist === '0') {
        $return_authorization_subject = '{{return_status_subject}} ';
        $return_authorization_content = 'Order ID: {{order_id}}<br>';
        $return_authorization_content .= 'Order Date {{order_date}}<br>';
        $return_authorization_content .= 'Return Code: {{return_code}}<br>';
        $return_authorization_content .= 'Return Request Status: {{return_status}} <br>';
        $return_authorization_content .= 'Return Requested Date: {{request_date}} <br>';
        $return_authorization_content .= 'Return Request URL: {{return_url}}<br><br>';
        $return_authorization_content .= 'Comment:<br> {{comment}}<br><br>';
        $return_authorization_content .= 'If reporting damage please keep all original packaging until claim is completed.';

        $this->db->query('INSERT INTO ' . $this->db->table('email_editor_templates') . "  SET 
                         `sender_name`='',`sender_email`='',`section` = 'return_authorization', 
                         `subject`='" . $this->db->escape($return_authorization_subject) . "', 
                         `default_subject`='" . $this->db->escape($return_authorization_subject) . "' , 
                         `content` = '" . $this->db->escape($return_authorization_content) . "', 
                         `default_content` = '" . $this->db->escape($return_authorization_content) . "',
                         `allowed_placeholders`='return_status_subject, order_id, order_date, return_code, return_status, request_date, return_url, comment',
                         `email_signature_id` = 0,
                         `notify_admin`=0, `store_id`='0'
                         ON DUPLICATE KEY UPDATE `section`=VALUES(`section`),`default_subject`=VALUES(`default_subject`),`default_content`=VALUES(`default_content`)");

        $this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_return_authorization_info','Important Notes: <br>
        1.&nbsp;This template has several defined tags such as {{return_status_subject}}, {{order_id}}, {{order_date}}, {{return_code}}, {{return_status}}, {{request_date}}, {{return_url}}, {{comment}}. You should not remove or edit them as they are used by this extension  and are necessary for the system generated input.<br>
        2.&nbsp;Preview Email Template won\'t replace the defined tags into system generated input, it will only let you preview how the logo, content and email signatures looks like within the email.',now(),now())");

        $this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_return_authorization_subject','Return Authorization Email Subject:',now(),now())");

        $this->db->query("INSERT INTO " . $this->db->table("language_definitions") . " (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_return_authorization_content','Return Authorization Email Content:',now(),now())");
    }
}

if (!file_exists(DIR_SYSTEM.'lib/license.php')) {
    /**
     *  Function to Copy folders and files
     * @param $src
     * @param $dst
     * @return array
     */
    function custom_copy($src, $dst) {
        $error = [];
        // open the source directory
        $dir = opendir($src);
        if (!is_dir($dst)) {
            @mkdir($dst);
        }
        // Loop through the files in source directory
        foreach (scandir($src) as $file) {
            if (($file != '.') && ($file != '..')) {
                if (is_dir($src . '/' . $file)) {
                    // Recursively calling custom copy function
                    // for sub directory
                    custom_copy($src . '/' . $file, $dst . '/' . $file);
                } else {
                    if (!copy($src . '/' . $file, $dst . '/' . $file)) {
                        $error['error_copy'][] = "Failed to copy $file";
                    }
                }
            }
        }
        if (sizeof($error)>0) {
            $log=new ALog(DIR_SYSTEM.'logs/error.txt');
            $log->write(var_export($error,true));
        }
        closedir($dir);
        return $error;
    }

    $copy = custom_copy(DIR_EXT . 'return_authorization' . DIR_EXT_CORE . 'lib', DIR_SYSTEM.'lib');
}