<?php

/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2024 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

/**
 * Class ModelReturnAuthorizationReturnAuthorization
 * @property ModelSaleCustomerTransaction $model_sale_customer_transaction
 * @property ModelSaleOrder $model_sale_order
 * @property ModelExtensionEmailOrder $model_extension_email_order
 */
class ModelReturnAuthorizationReturnAuthorization extends Model {
    public $data = [];
    private $error = [];
    public $placeholders = [];

    public function verifyEmailEditor() {
        if ($this->config->get('email_editor_status')) {
            $this->load->model('extension/email_editor_license_info');
            $license_key = $this->config->get('email_editor_license_code');
            if ($license_key) {
                $exist = $this->db->query("SHOW TABLES LIKE '" . $this->db->table('email_editor_license_info') . "'");
                if ($exist->num_rows === 1) {
                    $store_id = $this->model_extension_email_editor_license_info->getStoreId();
                    $license_key = $this->model_extension_email_editor_license_info->getLicenseCode($store_id);
                    $license_info = $this->model_extension_email_editor_license_info->getLicenseData($store_id);
                    $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                    $license = new License($path_to_phpseclib);
                    $license_manager = $license->getManager();
                    $license_manager->setKeys($license_key, $license_info['public_key'], 'email_editor');
                    $ttl = 1209600;
                    $validate = $license_manager->validate($license_info['license_data'], $ttl);
                    $store_status = $this->model_extension_email_editor_license_info->getLicensedStoreStatus();
                    if ($validate['status'] === 'valid' && $store_status == 1) {
                        return true;
                    } else {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                return false;
            }
        }
    }

    /**
     * @param array $data
     * @param string $mode
     * @return array | int
     */
    public function getRequests($data, $mode = '') {
        $sql = "SELECT *, CONCAT(COALESCE(o.firstname,c.firstname), ' ', COALESCE(o.lastname,c.lastname)) AS `name`
				FROM " . $this->db->table('ra_requests') . " ra
				LEFT JOIN " . $this->db->table('orders') . " o ON o.order_id = ra.order_id
				LEFT JOIN " . $this->db->table('customers') . " c ON c.customer_id = ra.customer_id ";

        if (has_value($data['filter_request_status_id'])) {
            $sql .= " WHERE COALESCE(ra.request_status_id,1) = '" . (int)$data['filter_request_status_id'] . "'";
        } else {
            $sql .= " WHERE COALESCE(ra.request_status_id,-1) >= '0'";
        }

        if (has_value($data['filter_return_code'])) {
            $sql .= " AND return_code LIKE  '%" . $this->db->escape($data['filter_return_code']) . "%'";
        }

        if (has_value($data['filter_payment_country'])) {
            $sql .= " AND payment_country LIKE  '%" . $this->db->escape($data['filter_payment_country']) . "%'";
        }

        if (has_value($data['subsql_filter'])) {
            $sql .= " AND " . str_replace('LOWER(`name`)', 'LOWER(CONCAT(COALESCE(o.firstname,c.firstname), \' \', COALESCE(o.lastname,c.lastname)))', $data['subsql_filter']);
        }

        $sort_data = [
            'request_id',
            'ra.order_id',
            'name',
            'request_status_id',
            'return_code',
            'o.payment_company'];

        if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
            $sql .= " ORDER BY " . $data['sort'];
        } else {
            $sql .= " ORDER BY request_id";
        }

        if (isset($data['order']) && (strtoupper($data['order']) == 'DESC')) {
            $sql .= " DESC";
        } else {
            $sql .= " ASC";
        }

        if (isset($data['start']) || isset($data['limit'])) {
            if ($data['start'] < 0) {
                $data['start'] = 0;
            }

            if ($data['limit'] < 1) {
                $data['limit'] = 20;
            }

            $sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
        }

        $result = $this->db->query($sql);

        if ($mode == 'total') {
            return (int)$result->num_rows;
        }
        if ($result->num_rows) {
            return $result->rows;
        }
        return [];
    }

    /**
     * @param array $data
     * @return int
     */
    public function getTotalRequests($data) {
        return $this->getRequests($data, 'total');
    }

    /**
     * @param $data
     * @return array
     * @throws AException
     */
    public function editRequest($data) {
        $this->load->model('sale_order');
        $order_info = $this->model_sale_order->getOrder($data['order_id']);
        if ($result = $this->getRequest((int)$data['order_id'])) {
            $data['request_id'] = (int)$result['request_id'];
            $conversation = unserialize($result['conversation']);
            if ($result['request_status_id'] != $data['request_status_id']) {
                $conversation[] = '(' . date($this->language->get('date_format_short') . ' ' . $this->language->get('time_format')) . ') ' . $this->language->get('text_request_status_changed') . " " . $this->getRequestStatusName($data['request_status_id']);
            }
        }

        $allowed_fields = ['request_status_id', 'ra_action', 'reason', 'details', 'conversation', 'customer_email', 'return_code'];
        $update = [];

        if ($data['request_id']) {
            $customer_id = (int)$data['customer_id'];
            foreach ($allowed_fields as $field_name) {
                if (isset($data[$field_name])) {
                    if ($field_name == 'conversation') {
                        if ($data[$field_name]) {
                            $data[$field_name] = htmlentities($data[$field_name], ENT_QUOTES, 'UTF-8');
                            $data['comment'] = htmlentities($data[$field_name], ENT_QUOTES, 'UTF-8');
                            $conversation[] = '(' . date($this->language->get('date_format_short') . ' ' . $this->language->get('time_format')) . ') ' . $this->language->get('ra_text_merchant') . ":\n" . $data[$field_name];
                        }
                        $data[$field_name] = serialize($conversation);
                    } elseif ($field_name == 'details') {
                        $data[$field_name] = serialize($data[$field_name]);
                    }
                    $update[] = "`" . $field_name . "`='" . $this->db->escape($data[$field_name]) . "'";
                }
            }

            $sql = "UPDATE " . $this->db->table('ra_requests') . "
					SET " . implode(", ", $update) . "
					WHERE customer_id=" . $customer_id . "
						AND order_id =".$data['order_id']." AND request_id = " . $data['request_id'] . ";";
             $this->db->query($sql);
        } else {
            $allowed_fields[] = 'order_id';
            $allowed_fields[] = 'customer_id';

            if ($data['conversation']) {
                $data['comment'] = htmlentities($data['conversation'], ENT_QUOTES, 'UTF-8');
            }
            foreach ($allowed_fields as $field_name) {
                if (isset($data[$field_name])) {
                    if ($field_name == 'details') {
                        $data[$field_name] = serialize($data[$field_name]);
                    }
                    $update[$field_name] = $this->db->escape($data[$field_name]);
                }
            }

            $sql = "INSERT INTO " . $this->db->table('ra_requests') . " (`" . implode("`, `", array_keys($update)) . "`)
					VALUES ('" . implode("', '", $update) . "');";
            $this->db->query($sql);
            $data['request_id'] = $this->db->getLastId();
        }

        $comment = '';
        if ($data['conversation']) {
            $comment .= $data['comment'].'<br>';
        }

        $this->_processRequest($comment,$data['request_id'], $data['request_status_id'], $data['return_stock']);

        if ($result->num_rows) {
            return $result->rows;
        }
        return [];
    }

    public function getRequest($order_id = 0, $request_id = 0)  {
        $order_id = (int)$order_id;
        $request_id = (int)$request_id;

        if (!$order_id && !$request_id) {
            return [];
        }

        $sql = "SELECT *,ra.date_added AS request_date,
						COALESCE(o.firstname,c.firstname) as first_name,
						COALESCE(o.lastname,c.lastname) AS last_name,
						COALESCE(ra.customer_email, o.email, c.email) as customer_email
				FROM " . $this->db->table('ra_requests') . " ra
				LEFT JOIN " . $this->db->table('orders') . " o ON o.order_id = ra.order_id
				LEFT JOIN " . $this->db->table('customers') . " c ON c.customer_id = ra.customer_id ";
        if ($order_id) {
            $sql .= "WHERE ra.order_id=" . $order_id;
        } else {
            $sql .= "WHERE ra.request_id=" . $request_id;
        }

        $result = $this->db->query($sql);
        if ($result->num_rows) {
            return $result->row;
        }
        return [];
    }

    public function getRequestStatusName($status_id) {
        switch ($status_id) {
            case 1:
                $text = $this->language->get('text_ra_request_status_requested');
                break;
            case 2:
                $text = $this->language->get('text_ra_request_status_in_progress');
                break;
            case 3:
                $text = $this->language->get('text_ra_request_status_approved');
                break;
            case 4:
                $text = $this->language->get('text_ra_request_status_declined');
                break;
            case 5:
                $text = $this->language->get('text_ra_request_waiting_for_returns');
                break;
            case 6:
                $text = $this->language->get('text_ra_request_status_completed');
                break;
            default:
                $text = $this->language->get('text_ra_request_status_requested');
        }
        return $text;
    }


    /**
     * @return array
     * @throws AException
     */
    public function getRequestStatusNames() {
        $output = [];
        $ids = [1, 2, 3, 4, 5];
        foreach ($ids as $id) {
            $output[$id] = $this->getRequestStatusName($id);
        }
        return $output;
    }

    /**
     * Do process order when request status changing
     * @param $comment
     * @param $request_id
     * @param $request_status_id
     * @param bool $recalculate_stock
     * @return bool
     * @internal param $order_id
     * @internal param array $data
     */
    private function _processRequest($comment,$request_id, $request_status_id, $recalculate_stock = false) {
        //check is request exists
        $request_info = $this->getRequest(0, $request_id);
        $this->load->model('sale/order');
        $order_info = $this->model_sale_order->getOrder($request_info['order_id']);
        if (!$request_info) {
            $this->error = $this->language->get('error_request_not_exists');
            return false;
        }

        $request_details = unserialize($request_info['details']);
        if (!$request_details) {
            $request_details['refund'] = 0;
            $request_details['returns'] = [];
        }

        //for requested
        if ($request_status_id == 1) {
            $message_text = $comment.sprintf($this->language->get('ra_request_sent_message'), '#storefront#rt=return_authorization/return_authorization&order_id=' . (int)$request_info['order_id']);
            $message_subj = html_entity_decode($this->language->get('ra_request_sent_message_subject'), ENT_QUOTES, 'UTF-8');
            $request_status = $this->language->get('ra_request_sent_message_subject');
            //for approved
        } else if ($request_status_id == 2) {
            $message_text = $comment.sprintf($this->language->get('ra_request_in_process_message'), '#storefront#rt=return_authorization/return_authorization&order_id=' . (int)$request_info['order_id']);
            $message_subj = html_entity_decode($this->language->get('ra_request_in_process_subject'), ENT_QUOTES, 'UTF-8');
            $request_status = $this->language->get('text_ra_request_status_in_progress');
            // for in process requests
        } else if ($request_status_id == 3) {
            $message_text = $comment.sprintf($this->language->get('ra_request_approved_message'), '#storefront#rt=return_authorization/return_authorization&order_id=' . (int)$request_info['order_id']);
            $message_subj = html_entity_decode($this->language->get('ra_request_approved_subject'), ENT_QUOTES, 'UTF-8');
            $request_status = $this->language->get('text_ra_request_status_approved');
            // for declined requests
        } else if ($request_status_id == 4) {
            $sql = "DELETE FROM " . $this->db->table('order_totals') . "
					WHERE order_id = '" . (int)$request_info['order_id'] . "'
						AND `type`='ra'";
            $this->db->query($sql);
            $message_text = $comment.sprintf($this->language->get('ra_request_declined_message'), '#storefront#rt=return_authorization/return_authorization&order_id=' . (int)$request_info['order_id']);
            $message_subj = html_entity_decode($this->language->get('ra_request_declined_subject'), ENT_QUOTES, 'UTF-8');
            $request_status = $this->language->get('text_ra_request_status_declined');
        }else if ($request_status_id == 5) {
            $sql = "DELETE FROM " . $this->db->table('order_totals') . "
					WHERE order_id = '" . (int)$request_info['order_id'] . "'
						AND `type`='ra'";
            $this->db->query($sql);
            $message_text = $comment . sprintf($this->language->get('ra_request_waiting_for_returns_message'), '#storefront#rt=return_authorization/return_authorization&order_id=' . (int)$request_info['order_id']);
            $message_subj = html_entity_decode($this->language->get('ra_request_waiting_for_returns_subject'), ENT_QUOTES, 'UTF-8');
            $request_status = $this->language->get('text_ra_request_waiting_for_returns');
        } else if ($request_status_id == 6) {
            if (has_value($request_details['refund'])) {
                $refund_value = round((float)$this->currency->convert((float)$request_details['refund'], $request_info['currency'], $this->config->get('config_currency')), 2);

                $sql = "INSERT INTO " . $this->db->table('order_totals') . " (`order_id`,`title`,`text`,`value`,`sort_order`,`type`)
							VALUES ('" . (int)$request_info['order_id'] . "',
									'" . $this->db->escape($this->language->get('ra_total_title')) . "',
									'-" . $this->currency->format((float)$request_details['refund'], $request_info['currency'], 1) . "',
									'-" . $refund_value . "',
									'400',
									'ra_refund')";
                $this->db->query($sql);

                $sql = "SELECT *
						FROM " . $this->db->table('order_totals') . "
						WHERE type='total' AND order_id = '" . (int)$request_info['order_id'] . "'";
                $res = $this->db->query($sql);
                $total = $res->row;

                $value = round($total['value'], 2) - $refund_value;

                $text = $this->currency->format($value, $request_info['currency'], 1);

                $sql = "UPDATE " . $this->db->table('order_totals') . "
						SET `text` = '" . $text . "',
						`value` = '" . $value . "'
						WHERE order_id = '" . (int)$request_info['order_id'] . "'
							AND type='total'";
                $this->db->query($sql);

                if ($request_details['enroll_in_balance']) {
                    $this->load->model('sale/customer_transaction');
                    $transaction_data = [
                        'order_id' => (int)$request_info['order_id'],
                        'customer_id' => (int)$request_info['customer_id'],
                        'credit' => $refund_value,
                        'notify' => true,
                        'transaction_type' => 'ra_refund',
                        'description' => sprintf($this->language->get('text_ra_transaction_comment'),
                            $this->currency->format((float)$request_details['refund'], $request_info['currency'], 1),
                            $request_info['return_code'])];

                    $this->model_sale_customer_transaction->addCustomerTransaction($transaction_data);
                }

                // IF NEEDs TO RECALCULATE STOCK BALANCE
                if ($recalculate_stock && has_value($request_details['returns'])) {
                    $this->load->model('sale/order');
                    $order_products = $this->model_sale_order->getOrderProducts((int)$request_info['order_id']);
                    $request_order_product_ids = array_keys($request_details['returns']);

                    foreach ($order_products as $order_product) {
                        $order_product_id = $order_product['order_product_id'];
                        if (in_array($order_product_id, $request_order_product_ids)) {
                            $to_return = (int)$request_details['returns'][$order_product_id]['return_quantity'];
                            if ($order_product['quantity'] >= $to_return && $to_return > 0) {
                                // if needs to recalculate stock
                                $sql = "UPDATE `" . $this->db->table("products") . "`
										SET quantity = (quantity + " . $to_return . ")
										WHERE product_id = '" . (int)$order_product['product_id'] . "'";
                                $this->db->query($sql);

                                $sql = "SELECT *
										FROM " . $this->db->table("order_options") . "
										WHERE order_id = '" . (int)$request_info['order_id'] . "'
											AND order_product_id = '" . (int)$order_product_id . "'";
                                $option_query = $this->db->query($sql);

                                foreach ($option_query->rows as $option) {
                                    $sql = "UPDATE " . $this->db->table("product_option_values") . "
											SET quantity = (quantity + " . $to_return . ")
											WHERE product_option_value_id = '" . (int)$option['product_option_value_id'] . "'";
                                    $this->db->query($sql);
                                }
                            }
                        }
                    }

                }
                $message_text = $comment.sprintf($this->language->get('ra_request_completed_message'), '#storefront#rt=return_authorization/return_authorization&order_id=' . (int)$request_info['order_id']);
                $message_subj = html_entity_decode($this->language->get('ra_request_completed_subject'), ENT_QUOTES, 'UTF-8');
                $request_status = $this->language->get('text_ra_request_status_completed');
            }
        }

        if ($request_info['customer_email']) {
            if ($message_text) {
                $date_added =  dateISO2Display(
                    $order_info['date_added'],
                    $this->language->get('date_format_short').' '.$this->language->get('time_format')
                );

                $ra_date = dateISO2Display(
                    $request_info['request_date'],
                    $this->language->get('date_format_short') . ' ' . $this->language->get('time_format')
                );

                if ($this->verifyEmailEditor()) {
                    $this->load->model('extension/email_order');
                    $details = $this->model_extension_email_order->getDetails('return_authorization');
                    $sender_name=$details['sender_name'] ? $details['sender_name']:$this->config->get('store_name');
                    $sender_email=$details['sender_email'] ? $details['sender_email']:$this->config->get('store_main_email');

                    $request_url = $this->html->getCatalogURL('return_authorization/return_authorization', '&order_id=' . (int)$request_info['order_id']);

                    $signature = html_entity_decode($details['signature']);
                    $this->data['mail_template_data']['return_status_subject'] = $message_subj;
                    $this->data['mail_template_data']['order_id'] = $request_info['order_id'];
                    $this->data['mail_template_data']['order_date'] = $date_added;
                    $this->data['mail_template_data']['notification_email'] = $request_info['customer_email'];
                    $this->data['mail_template_data']['return_code'] = $request_info['return_code'];
                    $this->data['mail_template_data']['return_status'] = $request_status;
                    $this->data['mail_template_data']['request_date'] = $ra_date;
                    $this->data['mail_template_data']['return_url'] = '<a href="' . $request_url . '">' . $request_url . '</a>';
                    $this->data['mail_template_data']['comment'] = $comment;
                    $mustache = new Mustache_Engine(['escape' => function ($value) {
                        return $value;
                    }]);

                    $arAllowedPlaceholders = explode(',', $details['allowed_placeholders']);

                    foreach ($arAllowedPlaceholders as &$placeholder) {
                        $placeholder = trim($placeholder);
                    }

                    foreach ( $this->data['mail_template_data'] as $key => $val) {
                        if (in_array($key, $arAllowedPlaceholders, true)) {
                            $this->placeholders[$key] = $val;
                        }
                    }

                    $subject = $mustache->render($details['subject'], $this->placeholders);

                    $content = $mustache->render($details['content'], $this->placeholders);
                    $content = html_entity_decode($content);

                    $notify_admin=$details['notify_admin'];
                    $logos = $this->dispatch('pages/extension/email_logo',[]);
                    $logo=$logos->dispatchGetOutput();

                    $this->data['mail_template_data']['logo']=html_entity_decode($logo);
                    $this->data['mail_template_data']['content']=$content;
                    $this->data['mail_template_data']['signature']=$signature;
                    //$this->data['mail_template_data']['text_project_label'] = project_base();

                    $this->data['mail_template'] = DIR_EXT.'return_authorization'.DIR_EXT_CORE.'lib/return_authorization.tpl';

                    $view = new AView($this->registry, 0);
                    $view->batchAssign($this->data['mail_template_data']);
                    $html_body = $view->fetch($this->data['mail_template']);
                    $languageId = $this->language->getContentLanguageID() ?? $this->language->getLanguageID();
                    $mailLogo = $this->config->get('config_mail_logo_'.$languageId)
                        ? : $this->config->get('config_mail_logo');
                    $mailLogo = $mailLogo ? : $this->config->get('config_logo_'.$languageId);
                    $mailLogo = $mailLogo ? : $this->config->get('config_logo');

                    $this->data['mail_plain_text'] = $view->fetch($this->data['mail_template']);
                    $this->data['mail_plain_text'] = html_entity_decode($this->data['mail_plain_text'], ENT_QUOTES, 'UTF-8');
                    //remove html-tags
                    $breaks = ["<br />", "<br>", "<br/>"];
                    $this->data['mail_plain_text'] = str_ireplace($breaks, "\r\n", $this->data['mail_plain_text']);

                    $this->_send_email($request_info['customer_email'], [
                            'subject'          => $subject,
                            'sender_email'     => $sender_email,
                            'sender_name'      => $sender_name,
                            'txt_body'         => $this->data['mail_plain_text'],
                            'html_body'        => $html_body,
                            'config_mail_logo' => $mailLogo,
                            'notify_admin'     => $notify_admin
                        ]
                    );
                } else {
                    $request_url = $this->html->getCatalogURL('return_authorization/return_authorization', '&order_id=' . (int)$request_info['order_id']);
                    $cust_text = $this->language->get('text_request_order_id') . $request_info['order_id'] . '<br>';
                    $cust_text .= $this->language->get('text_date_added') . $date_added . '<br>';
                    $cust_text .= $this->language->get('text_return_code') . $request_info['return_code'] . '<br>';
                    $cust_text .= $this->language->get('text_notification_email') . $request_info['customer_email'] . '<br>';
                    $cust_text .= $this->language->get('text_request_status') . $request_status . '<br>';
                    $cust_text .= $this->language->get('text_request_date') . $ra_date . '<br>';
                    $cust_text .= $this->language->get('text_return_url') . '<a href="' . $request_url . '">' . $request_url . '</a>' . '<br><br>';
                    $cust_text .= $this->language->get('text_comment') . '<br>' . $comment . '<br><br>';
                    $cust_text .= $this->language->get('text_additional_notes');
                    $this->_sendDefaultEmail($request_info['customer_email'], $message_subj, $cust_text);
                }
            }
        }

        return true;
    }

    private function _sendDefaultEmail($to, $message_subj, $message_text) {

        $view = new AView($this->registry, 0);
        $data = [];

        $data['text_message'] = $message_text;

        $languageId = $this->language->getLanguageID();
        $mailLogo = $this->config->get('config_mail_logo_'.$languageId)
            ?: $this->config->get('config_mail_logo');
        $mailLogo = $mailLogo ?: $this->config->get('config_logo_'.$languageId);
        $mailLogo = $mailLogo ?: $this->config->get('config_logo');

        if ($mailLogo) {
            $result = getMailLogoDetails($mailLogo);
            $data['logo_uri'] = $result['uri'];
            $data['logo_html'] = $result['html'];
        }

        $view->batchAssign($data);

        $mail = new AMail($this->config);
        $mail->setTo($to);
        $mail->setFrom($this->config->get('store_main_email'));
        $mail->setSender($this->config->get('store_name'));
        $mail->setSubject($message_subj);
        $mail->setHtml($view->fetch('pages/return_authorization/return_authorization_mail.tpl'));

        $attachments = [];
        if (is_file(DIR_RESOURCE.$mailLogo)) {
            $attachments[] = [
                'file' => DIR_RESOURCE.$mailLogo,
                'name' => md5(pathinfo($mailLogo, PATHINFO_FILENAME))
                    .'.'
                    .pathinfo($mailLogo, PATHINFO_EXTENSION)
            ];
        }

        $attachments = array_merge($attachments, (array)$this->data['mail_attachments']);
        foreach($attachments as $attachment) {
            $mail->addAttachment(
                $attachment['file'],
                $attachment['name']
            );
        }

        $mail->send();
        if ($mail->error) {
            $this->error = 'Error: Emails does not sent! Please see error log for details.';
            return false;
        }
        return true;
    }

    /**
     * @param $customer_id
     * @return mixed
     * @throws AException
     */
    public function getImage($order_id) {
        $query = $this->db->query("SELECT * FROM ".$this->db->table('ra_requests_proof_image') ." WHERE `order_id`=".$order_id." ORDER BY uploaded_at DESC");
        return $query->rows;
    }

    protected function dispatch($dispatch_rt, $args =[]) {
        return new ADispatcher($dispatch_rt, $args);
    }

    /**
     * @param $order_id
     * @param $transaction_type
     * @return mixed
     * @throws AException
     */
    public function getCustomerTransaction($order_id, $transaction_type) {
        // get decrypted customer name first
        $sql = "SELECT * FROM ".$this->db->table("customer_transactions")." WHERE `order_id`= ".$order_id." AND transaction_type like '%".$this->db->escape($transaction_type)."%'";
        $query = $this->db->query($sql);
        return $query->row;
    }

    protected function _send_email($email, $data) {
        $mail = new AMail($this->config);
        $mail->setTo($email);
        $mail->setFrom($data['sender_email']);
        $mail->setSender($data['sender_name']);
        $mail->setSubject($data['subject']);
        $mail->setText(html_entity_decode($data['txt_body'], ENT_QUOTES, 'UTF-8'));

        if (is_file(DIR_RESOURCE.$data['config_mail_logo'])) {
            $mail->addAttachment(DIR_RESOURCE.$data['config_mail_logo'],
                md5(pathinfo($data['config_mail_logo'], PATHINFO_FILENAME))
                .'.'.pathinfo($data['config_mail_logo'], PATHINFO_EXTENSION));
        }
        $mail->setHtml($data['html_body']);
        $mail->send();

        if ($data['notify_admin']==='1') {
            $mail = new AMail($this->config);
            if ($this->config->get('return_authorization_emails')) {
                if (substr($this->config->get('return_authorization_emails'), -1) ===',') {
                    if ($data['sender_email']) {
                        $email_addresses = $this->config->get('return_authorization_emails').$data['sender_email'];
                    } else {
                        $email_addresses = $this->config->get('return_authorization_emails').$this->config->get('store_main_email');
                    }
                } else {
                    if ($data['sender_email']) {
                        $email_addresses = $this->config->get('return_authorization_emails').','.$data['sender_email'];
                    } else {
                        $email_addresses = $this->config->get('return_authorization_emails').','.$this->config->get('store_main_email');
                    }
                }
                $emails = implode(',',array_unique(explode(',', $email_addresses )));
            } else {
                if ($data['sender_email']) {
                    $emails = $data['sender_email'];
                } else {
                    $emails = $this->config->get('store_main_email');
                }
            }
            $mail->setTo($emails);
            $mail->setFrom($data['sender_email']);
            $mail->setSender($data['sender_name']);
            $mail->setSubject('(Copy) '.$data['subject']);
            $mail->setText(html_entity_decode($data['txt_body'], ENT_QUOTES, 'UTF-8'));

            if (is_file(DIR_RESOURCE.$data['config_mail_logo'])) {
                $mail->addAttachment(DIR_RESOURCE.$data['config_mail_logo'],
                    md5(pathinfo($data['config_mail_logo'], PATHINFO_FILENAME))
                    .'.'.pathinfo($data['config_mail_logo'], PATHINFO_EXTENSION));
            }
            $mail->setHtml($data['html_body']);
            $mail->send();
        }
    }
}