<?php

/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2024 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

/**
 * @property ModelReturnAuthorizationReturnAuthorization $model_return_authorization_return_authorization
 */

class ControllerResponsesReturnAuthorizationReturnAuthorization extends AController {

	public $data = [];
	private $error = [];

	public function main() {
		$this->loadLanguage('sale/order');
		$this->loadModel('sale/order');

		$page = $this->request->post['page']; // get the requested page
		$limit = $this->request->post['rows']; // get how many rows we want to have into the grid
		$sidx = $this->request->post['sidx']; // get index row - i.e. user click to sort
		$sord = $this->request->post['sord']; // get the direction

		// process jGrid search parameter
		$allowedSortFields = ['request_id', 'order_id', 'name', 'status', 'return_code','payment_company'];

		$allowedDirection = ['asc', 'desc'];

		if (!in_array($sidx, $allowedSortFields)) $sidx = $allowedSortFields[0];
		if (!in_array($sord, $allowedDirection)) $sord = $allowedDirection[0];

		if ($sidx == 'request_id' || $sidx == 'order_id' || $sidx == 'update_date' || $sidx == 'total' || $sidx == 'payment_company') {
			$sidx = 'o.' . $sidx;
		}

		$data = [
			'sort' => $sidx,
			'order' => $sord,
			'start' => ($page - 1) * $limit,
			'limit' => $limit,
		];

		if (has_value($this->request->get['status']) && $this->request->get['status']>0){
			$data['filter_request_status_id'] = (int)$this->request->get['status'];
		}

		if (has_value($this->request->get['return_code']) ) {
			$data['filter_return_code'] = trim($this->request->get['return_code']);
			if($this->language->get('text_search_hint')==$data['filter_return_code']){
				unset($data['filter_return_code']);
			}
		}

        if (has_value($this->request->post['payment_company']) ) {
            $data['filter_payment_company'] = trim($this->request->post['payment_company']);
        }

		$grid_filter_params = ['request_id', 'name', 'order_id','return_code','payment_company'];
		$filter_grid = new AFilter([ 'method' => 'post', 'grid_filter_params' => $grid_filter_params ]);
		$data = array_merge($data,$filter_grid->getFilterData());

		$total = $this->model_return_authorization_return_authorization->getTotalRequests($data);

		if ($total > 0) {
			$total_pages = ceil($total / $limit);
		} else {
			$total_pages = 0;
		}

		$response = new stdClass();
		$response->page = $page;
		$response->total = $total_pages;
		$response->records = $total;

		$results = $this->model_return_authorization_return_authorization->getRequests($data);

		$i = 0;
        $img = '';
		foreach ($results as $result) {
            $refund_info = $this->model_return_authorization_return_authorization->getCustomerTransaction($result['order_id'],'ra_refund');
            $image_urls = $this->model_return_authorization_return_authorization->getImage($result['order_id']);
            if ($image_urls) {
                $base = HTTPS ? HTTPS_SERVER : HTTP_SERVER;
                $image_url = '';
                foreach ($image_urls as $img_url) {
                    $image_url .= '<strong><a href="' . $base . $img_url['image_url'] . '" target="_BLANK">' . $base . $img_url['image_url'] . '</a></strong><br>';
                }
            } else {
                $image_url = '---';
            }
			$response->rows[$i]['id'] = $result['order_id'];
			$response->rows[$i]['cell'] = [
                $result['request_id'],
				$result['order_id'],
				$result['name'],
                $result['payment_company'],
				$this->model_return_authorization_return_authorization->getRequestStatusName($result['request_status_id']),
                $result['return_code'],
                $this->currency->format($refund_info['credit']),
                $image_url,
            ];
			$i++;
		}

		//update controller data
		$this->extensions->hk_UpdateData($this, __FUNCTION__);

		$this->load->library('json');
		$this->response->setOutput(AJson::encode($response));
	}

}