<?php

/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2024 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

require_once DIR_SYSTEM . "lib/vendor/autoload.php";
require_once DIR_SYSTEM . "lib/license.php";
require_once DIR_EXT . "return_authorization" . DIR_EXT_CORE . "updater.php";

/**
 * @property ModelReturnAuthorizationReturnAuthorization $model_return_authorization_return_authorization
 */
class ControllerPagesReturnAuthorizationReturnAuthorization extends AController{
	public $data = [];
	private $error = '';

    public function verify() {
        if ($this->config->get('return_authorization_status') === '1') {
            $this->load->model('extension/return_authorization_license_info');
            $license_key = $this->config->get('return_authorization_license_code');
            if ($license_key) {
                $exist = $this->db->query("SHOW TABLES LIKE '" . $this->db->table('return_authorization_license_info') . "'");
                if ($exist->num_rows === 1) {
                    $store_id = $this->model_extension_return_authorization_license_info->getStoreId();
                    $license_key = $this->model_extension_return_authorization_license_info->getLicenseCode($store_id);
                    $license_info = $this->model_extension_return_authorization_license_info->getLicenseData($store_id);
                    $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                    $license = new License($path_to_phpseclib);
                    $license_manager = $license->getManager();
                    $license_manager->setKeys($license_key, $license_info['public_key'], 'return_authorization');
                    $ttl = 1209600;
                    $validate = $license_manager->validate($license_info['license_data'], $ttl);
                    $store_status = $this->model_extension_return_authorization_license_info->getLicensedStoreStatus();
                    if ($validate['status'] === 'valid' && $store_status == 1) {
                        return true;
                    } else {
                        return false;
                    }
                }
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

    public function main(){
        if ($this->verify()) {
            if (!(int)$this->request->get['order_id']) {
                redirect($this->html->getSecureURL('return_authorization/return_authorization/listing'));
            }

            $this->document->addScript($this->view->templateResource('/javascript/lightbox.min.js'));
            $this->document->addStyle(
                [
                    'href' => $this->view->templateResource('/stylesheet/lightbox.min.css'),
                    'rel' => 'stylesheet',
                ]
            );

            $this->loadLanguage('sale/order');
            $this->loadLanguage('return_authorization/return_authorization');
            $this->loadModel('return_authorization/return_authorization');
            $this->loadModel('sale/order');
            $order_id = $this->request->get['order_id'];
            $order_info = $this->model_sale_order->getOrder($order_id);

            if ($this->request->is_POST() && $this->_validatePost()) {
                $request_info = $this->model_return_authorization_return_authorization->getRequest($order_id);
                $details = unserialize($request_info['details']);
                $data = $this->request->post;
                $data['order_id'] = $order_id;
                $details['returns'] = $data['returns'];
                $details['refund'] = preg_replace('/[^0-9\.]/', '', $data['refund']);
                $details['enroll_in_balance'] = $data['enroll_in_balance'];

                $data['details'] = $details;
                $data['customer_id'] = $order_info['customer_id'];

                if (!$this->request->post['customer_email']) {
                    $data['customer_email'] = $order_info['email'];
                }

                $this->model_return_authorization_return_authorization->editRequest($data);

                if ($this->model_return_authorization_return_authorization->error) {
                    $this->session->data['warning'] = $this->model_return_authorization_return_authorization->error;
                } else {
                    $this->session->data['success'] = $this->language->get('text_success_saved');

                }
                redirect($this->html->getSecureURL('return_authorization/return_authorization', '&order_id=' . $order_id));
            } else {
                $this->data['request_data'] = $this->model_return_authorization_return_authorization->getRequest($order_id);
                $this->data['request_data']['details'] = unserialize($this->data['request_data']['details']);
            }

            if (isset($this->session->data['warning'])) {
                $this->data['error'] = $this->session->data['warning'];
                $this->session->data['warning'] = '';
            }

            if (isset($this->session->data['success'])) {
                $this->data['success'] = $this->session->data['success'];
            }
            unset($this->session->data['success']);

            $this->data['heading_title'] = $this->language->get('return_authorization_ra');
            $this->data['ra_requests'] = $this->model_return_authorization_return_authorization->getRequests($customer_id, $limit, $offset);

            $this->document->initBreadcrumb([
                'href' => $this->html->getSecureURL('index/home'),
                'text' => $this->language->get('text_home'),
                'separator' => false
            ]);

            $this->document->addBreadcrumb([
                'href' => $this->html->getSecureURL('sale/order'),
                'text' => $this->language->get('heading_title'),
                'separator' => ' :: '
            ]);
            $this->document->addBreadcrumb([
                'href' => $this->html->getSecureURL('sale/order/details', '&order_id=' . $order_id),
                'text' => $this->language->get('edit_title_details'),
                'separator' => ' :: '
            ]);
            $this->document->addBreadcrumb([
                'href' => $this->html->getSecureURL('return_authorization/return_authorization', '&order_id=' . $order_id),
                'text' => $this->language->get('return_authorization_ra') . " " . $this->language->get('text_order_id') . '#' . $order_id,
                'separator' => ' :: ',
                'current' => true
            ]);

            $this->document->setTitle($this->language->get('return_authorization_ra'));

            $this->data['form_title'] = $this->language->get('return_authorization_request_id');
            $form = new AForm('HT');
            $form->setForm(
                ['form_name' => 'addRequestFrm']
            );

            $this->data ['cancel'] = $this->html->getSecureURL('return_authorization/return_authorization');

            $this->data['form']['id'] = 'addRequestFrm';
            $this->data['form']['form_open'] = $form->getFieldHtml(
                ['type' => 'form',
                    'name' => 'addRequestFrm',
                    'action' => $this->html->getSecureURL('return_authorization/return_authorization', '&order_id=' . $order_id)
                ]);

            $this->data['form']['submit'] = $form->getFieldHtml(
                ['type' => 'button',
                    'name' => 'submit',
                    'text' => $this->language->get('text_apply'),
                    'style' => 'button1',
                ]);
            if (isset($this->data['request_data']['request_id'])) {
                $this->data['form']['request_id'] = $form->getFieldHtml(
                    ['type' => 'hidden',
                        'name' => 'request_id',
                        'value' => (int)$this->data['request_data']['request_id']
                    ]);
            }

            switch ((int)$this->data['request_data']['request_status_id']) {
                case 1:
                    $this->data['text_current_status'] = $this->language->get('text_ra_request_status_requested');
                    $options = [
                        1 => $this->language->get('text_ra_request_status_requested'),
                        2 => $this->language->get('text_ra_request_status_in_progress'),
                        3 => $this->language->get('text_ra_request_status_approved'),
                        4 => $this->language->get('text_ra_request_status_declined')];
                    break;
                case 2:
                    $this->data['text_current_status'] = $this->language->get('text_ra_request_status_in_progress');
                    $options = [
                        2 => $this->language->get('text_ra_request_status_in_progress'),
                        3 => $this->language->get('text_ra_request_status_approved'),
                        4 => $this->language->get('text_ra_request_status_declined'),
                        5 => $this->language->get('text_ra_request_waiting_for_returns'),];
                    break;
                case 3:
                    $this->data['text_current_status'] = $this->language->get('text_ra_request_status_approved');
                    $options = [
                        2 => $this->language->get('text_ra_request_status_in_progress'),
                        3 => $this->language->get('text_ra_request_status_approved'),
                        5 => $this->language->get('text_ra_request_waiting_for_returns'),
                        6 => $this->language->get('text_ra_request_status_completed')];
                    break;
                case 4:
                    $this->data['text_current_status'] = $this->language->get('text_ra_request_status_declined');
                    $options = [
                        2 => $this->language->get('text_ra_request_status_in_progress'),
                        4 => $this->language->get('text_ra_request_status_declined')];
                    break;
                case 5:
                    $this->data['text_current_status'] = $this->language->get('text_ra_request_waiting_for_returns');
                    $options = [
                        2 => $this->language->get('text_ra_request_status_in_progress'),
                        5 => $this->language->get('text_ra_request_waiting_for_returns'),
                        6 => $this->language->get('text_ra_request_status_completed')];
                    break;
                case 6:
                    $this->data['text_current_status'] = $this->language->get('text_ra_request_status_completed');
                    break;
                default:
                    $this->data['text_current_status'] = $this->language->get('text_ra_request_status_requested');
                    $options = [
                        1 => $this->language->get('text_ra_request_status_requested'),
                        2 => $this->language->get('text_ra_request_status_in_progress'),
                        3 => $this->language->get('text_ra_request_status_approved'),
                        4 => $this->language->get('text_ra_request_status_declined')];
            }

            $this->data['text_request_status'] = $this->language->get('text_ra_request_status');
            if ((int)$this->data['request_data']['request_status_id'] != 6) {
                $this->data['form']['request_status'] = $this->language->get('text_ra_change_request_status') . $form->getFieldHtml(
                        ['type' => 'selectbox',
                            'name' => 'request_status_id',
                            'options' => $options,
                            'value' => $this->data['request_data']['request_status_id'],
                            'style' => 'col-sm-1 medium-field'
                        ]);
            }

            $this->data['text_ra_return_code'] = $this->language->get('text_ra_return_code');

            //if (!$this->data['request_data']['return_code']) {
            //    $date_format = str_replace("/","",$this->language->get('date_format_short'));
            //    $this->data['form']['return_code'] = $form->getFieldHtml(
            //        [
            //            'type' => 'input',
            //            'name' => 'return_code',
            //            'value' => 'RA-'.date($date_format).'-'.substr(md5(rand()),0,12),
            //            'style' => 'large-field'
            //        ]
            //    );
            //} else {
                $this->data['form']['return_code'] = htmlentities($this->data['request_data']['return_code'], ENT_QUOTES, 'UTF-8');
            //}

            $this->data['text_ra_action'] = $this->language->get('text_ra_action');
            if ((int)$this->data['request_data']['request_status_id'] != 6) {
                $this->data['form']['ra_action'] = $form->getFieldHtml(
                    [
                        'type' => 'selectbox',
                        'name' => 'ra_action',
                        'options' => [
                            1 => $this->language->get('text_ra_action_replace'),
                            2 => $this->language->get('text_ra_action_refund_to_payment'),
                            3 => $this->language->get('text_ra_action_refund_store_credit')
                        ],
                        'value' => $this->data['request_data']['ra_action']
                    ]
                );
            } else {
               if ($this->data['request_data']['ra_action'] == 1) {
                     $language = $this->language->get('text_ra_action_replace');
                } elseif ($this->data['request_data']['ra_action'] == 2) {
                    $language = $this->language->get('text_ra_action_refund_to_payment');
                } else {
                    $language = $this->language->get('text_ra_action_refund_store_credit');
                }

                $this->data['form']['ra_action'] = $language;
            }

            $this->data['text_reason'] = $this->language->get('text_reason');
            if ((int)$this->data['request_data']['request_status_id'] != 6) {
                $this->data['form']['reason'] = $form->getFieldHtml(
                    ['type' => 'input',
                        'name' => 'reason',
                        'value' => $this->data['request_data']['reason'],
                        'required' => !$this->data['request_data']['reason'] ? true : false,
                        'attr' => ($this->data['request_data']['reason'] ? 'readonly' : '')
                    ]);
            } else {
                $this->data['form']['reason'] = $this->data['request_data']['reason'];
            }

            $this->data['text_comment'] = $this->language->get('text_comment');
            $this->data['text_message_history'] = $this->language->get('text_message_history');

            $this->data['form']['conversation'] = unserialize($this->data['request_data']['conversation']);
            if ((int)$this->data['request_data']['request_status_id'] != 6) {
                $this->data['form']['comment'] = $form->getFieldHtml(
                    ['type' => 'textarea',
                        'name' => 'conversation',
                        'value' => '',
                        'style' => 'large-field'

                    ]);
            }

            $this->data['ra_text_email'] = $this->language->get('ra_text_email');
            if ((int)$this->data['request_data']['request_status_id'] != 6) {
                $this->data['form']['email'] = $form->getFieldHtml(
                    ['type' => 'input',
                        'name' => 'customer_email',
                        'value' => $this->data['request_data']['customer_email'] ? : $order_info['email']
                    ]);
            } else {
                $this->data['form']['email'] = $this->data['request_data']['customer_email'];
            }

            $this->data['text_image_url'] = $this->language->get('text_image_url');
            $base = HTTPS ? HTTPS_SERVER : HTTP_SERVER;

            $damage_proof = $this->model_return_authorization_return_authorization->getImage($order_id);

            $image_url = '';
            foreach ($damage_proof as $img_url) {
                $image_url .= '<a href="' . $base . $img_url['image_url']  . '" data-lightbox="roadtrip"><img width="100px" height="100px" src="' . $base . $img_url['image_url']  . '" alt=""/></a>';
            }

            $this->data['form']['image_url'] = $image_url;

            $this->_initTabs('ra');
            $this->addChild('pages/sale/order_summary', 'summary_form', 'pages/sale/order_summary.tpl');

            $this->loadModel('sale/order');
            $this->data['order_products'] = [];

            $order_products = $this->model_sale_order->getOrderProducts($order_id);
            foreach ($order_products as $order_product) {
                $option_data = [];

                $options = $this->model_sale_order->getOrderOptions($order_id, $order_product['order_product_id']);

                foreach ($options as $option) {
                    $option_data[] = [
                        'name' => $option['name'],
                        'value' => $option['value']
                    ];
                }

                $value = isset($this->data['request_data']['details']['returns'][$order_product['order_product_id']]['return_quantity'])
                    ? (int)$this->data['request_data']['details']['returns'][$order_product['order_product_id']]['return_quantity']
                    : (int)$this->data['request_data']['details']['quantity'][$order_product['order_product_id']];
                $qnty_options = [];
                for ($i = 0; $i <= $order_product['quantity']; $i++) {
                    $qnty_options[$i] = $i;
                }
                if ((int)$this->data['request_data']['request_status_id'] != 6) {
                    $return_qty = $form->getFieldHtml([
                        'type' => 'selectbox',
                        'name' => 'returns[' . $order_product['order_product_id'] . '][return_quantity]',
                        'style' => 'medium-field',
                        'options' => $qnty_options,
                        'value' => (int)$value]);
                } else {
                    $return_qty = (int)$value;
                }

                $this->data['order_products'][] = [
                    'order_product_id' => $order_product['order_product_id'],
                    'product_id' => $order_product['product_id'],
                    'name' => $order_product['name'],
                    'model' => $order_product['model'],
                    'option' => $option_data,
                    'quantity' => $order_product['quantity'],
                    'return_quantity' => $return_qty,
                    'price' => $this->currency->format($order_product['price'], $order_info['currency'], $order_info['value']),
                    'total' => $this->currency->format($order_product['total'], $order_info['currency'], $order_info['value']),
                    'href' => $this->html->getSecureURL('catalog/product/update', '&product_id=' . $order_product['product_id'])
                ];
            }

            $this->data['totals'] = $this->model_sale_order->getOrderTotals($order_id);

            if ((int)$this->data['request_data']['request_status_id'] != 6) {
                $this->data['form']['text_return_stock'] = $this->language->get('text_ra_return_stock');
                $this->data['form']['return_stock'] = $form->getFieldHtml(
                    ['type' => 'checkbox',
                        'name' => 'return_stock',
                        'label_text' => $this->data['form']['text_return_stock'],
                        'value' => 1,
                        'checked' => false
                    ]);

                $this->data['text_refund'] = $this->language->get('text_refund') . ' (' . $order_info['currency'] . ')';
                $this->data['form']['refund'] = $form->getFieldHtml(
                    ['type' => 'input',
                        'name' => 'refund',
                        'value' => (float)$this->data['request_data']['details']['refund']
                    ]);

                $this->data['form']['text_enroll_in_balance'] = $this->language->get('text_ra_enroll_in_balance');
                $this->data['form']['enroll_in_balance'] = $form->getFieldHtml(
                    ['type' => 'checkbox',
                        'name' => 'enroll_in_balance',
                        'label_text' => $this->data['form']['text_enroll_in_balance'],
                        'value' => 1
                    ]);
            } else {
                $this->data['text_refund'] = $this->language->get('text_refund') . ' (' . $order_info['currency'] . ')';
                $this->data['form']['refund'] = moneyDisplayFormat($this->data['request_data']['details']['refund']);
            }
        }

		$this->view->batchAssign($this->data);
		$this->processTemplate('pages/return_authorization/return_authorization.tpl');

	}

	private function _validatePost(){
		$this->error = '';
        if (!isset($this->request->post['request_id'])){
			if (!trim($this->request->post['reason']) || !trim($this->request->post['conversation'])){
				$this->error = $this->language->get('error_ra_required');
			}

			if ($this->request->post['customer_email']){
				$pattern = '/^[A-Z0-9._%-]+@[A-Z0-9][A-Z0-9.-]{0,61}[A-Z0-9]\.[A-Z]{2,6}$/i';
				if (!preg_match($pattern, $this->request->post['customer_email'])){
					$this->error = $this->language->get('error_ra_email');
				}
			}
		}

		if ($this->error){
			$this->session->data['warning'] = $this->error;
			return false;
		} else{
			return true;
		}
	}

	private function _initTabs($active){
		$this->data['active'] = $active;
		//load tabs controller
		$tabs_obj = $this->dispatch('pages/sale/order_tabs', [$this->data]);
		$this->data['order_tabs'] = $tabs_obj->dispatchGetOutput();
	}


	//LISTING
	public function listing(){

		$this->loadLanguage('sale/order');
		$this->loadLanguage('return_authorization/return_authorization');
		$this->loadModel('return_authorization/return_authorization');

		$this->document->setTitle($this->language->get('return_authorization_name'));
		$this->document->initBreadcrumb([
				'href'      => $this->html->getSecureURL('index/home'),
				'text'      => $this->language->get('text_home'),
				'separator' => false
		]);
		$this->document->addBreadcrumb([
				'href'      => $this->html->getSecureURL('return_authorization/return_authorization'),
				'text'      => $this->language->get('return_authorization_name'),
				'separator' => ' :: ',
				'current' => true
		]);

		$this->document->setTitle($this->language->get('return_authorization_name'));

		if (isset($this->session->data['error'])){
			$this->data['error_warning'] = $this->session->data['error'];
			unset($this->session->data['error']);
		} elseif (isset($this->error['warning'])){
			$this->data['error_warning'] = $this->error['warning'];
		} else{
			$this->data['error_warning'] = '';
		}

		if (isset($this->session->data['success'])){
			$this->data['success'] = $this->session->data['success'];
			unset($this->session->data['success']);
		} else{
			$this->data['success'] = '';
		}

		$grid_settings = [
			//id of grid
				'table_id'    => 'ra_grid',
			// url to load data from
				'url'         => $this->html->getSecureURL('r/return_authorization/return_authorization'),
				'sortname'    => 'update_date',
				'sortorder'   => 'desc',
				'multiselect' => 'false',
			// actions
				'actions'     => [
						'edit' => [
								'text' => $this->language->get('text_edit'),
								'href' => $this->html->getSecureURL('return_authorization/return_authorization', '&order_id=%ID%')
						]
				],
		];

        $grid_settings['colNames'] = [
            $this->language->get('column_request_id'),
            $this->language->get('column_order'),
            $this->language->get('column_name'),
            $this->language->get('column_company'),
            $this->language->get('column_status'),
            $this->language->get('column_return_code'),
            $this->language->get('column_refund'),
            $this->language->get('column_image_url'),
        ];
        $grid_settings['colModel'] = [
            ['name' => 'request_id',
                'index' => 'request_id',
                'width' => 150,
                'align' => 'center',
                'search' => false],
            ['name' => 'order_id',
                'index' => 'order_id',
                'width' => 100,
                'align' => 'center',
                'search' => false],
            ['name' => 'name',
                'index' => 'name',
                'width' => 140,
                'align' => 'center'],
            ['name' => 'payment_company',
                'index' => 'payment_company',
                'width' => 140,
                'align' => 'center'],
            ['name' => 'status',
                'index' => 'status',
                'width' => 140,
                'align' => 'center',
                'search' => false],
            ['name' => 'return_code',
                'index' => 'return_code',
                'width' => 150,
                'align' => 'center',
                'search' => false,
            ],
            ['name' => 'refund',
                'index' => 'refund',
                'width' => 150,
                'align' => 'center',
                'search' => false,
                'sortable' => false,
            ],
            ['name' => 'image_url',
                'index' => 'image_url',
                'width' => 600,
                'align' => 'center',
                'search' => false,
                'sortable' => false,],
        ];

		$this->loadModel('localisation/order_status');
		$statuses = $this->model_return_authorization_return_authorization->getRequestStatusNames();

		$statuses = array_merge([0 => $this->language->get('text_select_status')], $statuses);

		$form = new AForm();
		$form->setForm([
				'form_name' => 'ra_grid_search',
		]);

		$grid_search_form = [];
		$grid_search_form['id'] = 'ra_grid_search';
		$grid_search_form['form_open'] = $form->getFieldHtml([
				'type'   => 'form',
				'name'   => 'ra_grid_search',
				'action' => '',
		]);
		$grid_search_form['submit'] = $form->getFieldHtml([
				'type'  => 'button',
				'name'  => 'submit',
				'text'  => $this->language->get('button_go'),
				'style' => 'button1',
		]);
		$grid_search_form['reset'] = $form->getFieldHtml([
				'type'  => 'button',
				'name'  => 'reset',
				'text'  => $this->language->get('button_reset'),
				'style' => 'button2',
		]);
		$grid_search_form['fields']['status'] = $form->getFieldHtml([
				'type'    => 'selectbox',
				'name'    => 'status',
				'options' => $statuses,
		]);

		$grid_search_form['fields']['return_code'] = $form->getFieldHtml([
				'type'  => 'input',
				'name'  => 'return_code',
				'placeholder' => $this->language->get('text_search_hint'),
				'style' => 'large-field'
		]);
		$grid_settings['search_form'] = true;

		$grid = $this->dispatch('common/listing_grid', [$grid_settings]);
		$this->view->assign('listing_grid', $grid->dispatchGetOutput());
		$this->view->assign('search_form', $grid_search_form);

		$this->processTemplate('pages/return_authorization/return_authorization_listing.tpl');
	}

}