<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2023 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

class ModelReorderReorder extends Model {

	/**
	 * @param int $order_id
	 * @param int $order_product_id
	 *
	 * @return array
	 */
	public function getOrderOptions($order_id, $order_product_id) {
		$query = $this->db->query("SELECT *
                                    FROM ".$this->db->table("order_options")." oo
                                    LEFT JOIN ".$this->db->table('product_option_values')." pov 
                                        ON pov.product_option_value_id = oo.product_option_value_id
                                    LEFT JOIN ".$this->db->table('product_options')." po 
                                        ON po.product_option_id = pov.product_option_id
                                    WHERE oo.order_id = '".(int)$order_id."' 
                                        AND oo.order_product_id = '".(int)$order_product_id."'");
		return $query->rows;
	}

	public function getOrderProduct($order_id, $order_product_id) {
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "order_products WHERE order_id = '" . (int)$order_id . "' AND order_product_id = " . (int)$order_product_id);
		return $query->row;
	}

	public function getProduct($product_id)	{
		if (!(int)$product_id) {
			return [];
		}
		$query = $this->db->query(
			"SELECT DISTINCT *,
                        pd.name AS name,
                        m.name AS manufacturer,
                        ss.name AS stock_status,
                        stock_checkout,
                        lcd.unit as length_class_name, ".
			$this->_sql_avg_rating_string().", ".
			$this->_sql_final_price_string()." ".
			$this->_sql_join_string().
			" LEFT JOIN ".$this->db->table("length_class_descriptions")." lcd
                                    ON (p.length_class_id = lcd.length_class_id
                                        AND lcd.language_id = '".(int)$this->config->get('storefront_language_id')."')
                WHERE p.product_id = '".(int)$product_id."'
                        AND p2s.store_id = '".(int)$this->config->get('config_store_id')."'
                        AND p.date_available <= NOW()");
		return $query->row;
	}

	protected function _sql_avg_rating_string() {
		$sql = " ( SELECT AVG(r.rating)
                         FROM ".$this->db->table("reviews")." r
                         WHERE p.product_id = r.product_id AND status = 1
                         GROUP BY r.product_id 
                 ) AS rating ";
		return $sql;
	}

	protected function _sql_final_price_string() {
		//special prices
		if (is_object($this->customer) && $this->customer->isLogged()) {
			$customer_group_id = (int)$this->customer->getCustomerGroupId();
		} else {
			$customer_group_id = (int)$this->config->get('config_customer_group_id');
		}

		$sql = " ( SELECT p2sp.price
                    FROM ".$this->db->table("product_specials")." p2sp
                    WHERE p2sp.product_id = p.product_id
                            AND p2sp.customer_group_id = '".$customer_group_id."'
                            AND ((p2sp.date_start = '0000-00-00' OR p2sp.date_start < NOW())
                            AND (p2sp.date_end = '0000-00-00' OR p2sp.date_end > NOW()))
                    ORDER BY p2sp.priority ASC, p2sp.price ASC LIMIT 1
                 ) ";
		$sql = "COALESCE( ".$sql.", p.price) as final_price";

		return $sql;
	}

	protected function _sql_join_string() {
		return "FROM ".$this->db->table("products")." p
                LEFT JOIN ".$this->db->table("product_descriptions")." pd
                    ON (p.product_id = pd.product_id
                            AND pd.language_id = '".(int)$this->config->get('storefront_language_id')."')
                LEFT JOIN ".$this->db->table("products_to_stores")." p2s ON (p.product_id = p2s.product_id)
                LEFT JOIN ".$this->db->table("manufacturers")." m ON (p.manufacturer_id = m.manufacturer_id)
                LEFT JOIN ".$this->db->table("stock_statuses")." ss
                        ON (p.stock_status_id = ss.stock_status_id
                            AND ss.language_id = '".(int)$this->config->get('storefront_language_id')."')";
	}
}
