<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2023 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if ( ! defined( 'DIR_CORE' ) ) {
	header( 'Location: static_pages/' );
}

require_once DIR_SYSTEM . "lib/vendor/autoload.php";
require_once DIR_SYSTEM . "lib/license.php";

/**
 * Class ControllerResponsesReorderReorder
 * @property ModelCheckoutOrder $model_checkout_order
 * @property ModelBuildAGiftBuildAGift $model_build_a_gift_build_a_gift
 * @property ModelReorderReorder $model_reorder_reorder
 */
class ControllerResponsesReorderReorder extends AController {
	public $data = [];

	public function verifyBuildAGift() {
        if ($this->config->get('build_a_gift_status')==='1') {
            $this->load->model('extension/build_a_gift_license_info');
            $license_key = $this->config->get('build_a_gift_license_code');
            if ($license_key) {
                $exist = $this->db->query("SHOW TABLES LIKE '" . $this->db->table('build_a_gift_license_info') . "'");
                if ($exist->num_rows === 1) {
                    $store_id = $this->model_extension_build_a_gift_license_info->getStoreId();
                    $license_key = $this->model_extension_build_a_gift_license_info->getLicenseCode($store_id);
                    $license_info = $this->model_extension_build_a_gift_license_info->getLicenseData($store_id);
                    $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                    $license = new License($path_to_phpseclib);
                    $license_manager = $license->getManager();
                    $license_manager->setKeys($license_key, $license_info['public_key'], 'build_a_gift');
                    $ttl = 1209600;
                    $validate = $license_manager->validate($license_info['license_data'], $ttl);
                    $store_status = $this->model_extension_build_a_gift_license_info->getLicensedStoreStatus();
                    if ($validate['status'] === 'valid' && $store_status == 1) {
                        return true;
                    } else {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                return false;
            }
        } else {
            return false;
        }
	}

	public function main() {
		$post     = $this->request->post;
		$order_id = $post['order_id'];
		$this->load->model( 'account/order' );
		$this->load->model( 'reorder/reorder' );
		$this->load->model( 'catalog/product' );
		$this->load->language( 'reorder/reorder' );
		$order_products = $this->model_account_order->getOrderProducts( $order_id );
		$text_warning_info=$added_products='';
		$text_warning_order       =  str_replace("[order_id]",$order_id,$this->language->get( 'text_warning_order' ));
		$text_warning_order_multiple       =  str_replace("[order_id]",$order_id,$this->language->get( 'text_warning_order_multiple' ));
		$text_partial_added = str_replace("[order_id]",$order_id,$this->language->get( 'text_partially_added_to_cart' ));
		$text_partial_warning = $this->language->get( 'text_partially_not_added_to_cart' );
		$warning=0;
		$success=0;
		$success_products_index=1;
		$error_products_index=1;

		if ( $order_products ) {
			foreach ( $order_products as $product ) {
				$productId    = $product['product_id'];
				$product_info = $this->model_reorder_reorder->getProduct( $productId );
				$stockInfo    = $this->model_catalog_product->getProductsStockInfo( [ $productId ] );
				if ( $product_info ) {
					if ( $product_info['status'] === '1' && ( ( $stockInfo[ $productId ]['subtract'] === true && $stockInfo[ $productId ]['quantity'] !== 0 ) || $stockInfo[ $productId ]['subtract'] === false ) ) {
                        $option_data = [];
						$options     = $this->model_reorder_reorder->getOrderOptions( $order_id, $product['order_product_id'] );
						if($options) {
                            foreach ($options as $option) {
                                // S - Select,
                                // R - radio buttons,
                                // M - multivalue select,
                                // C - Checkbox,
                                // G -Checkbox Group,
                                // I - text input,
                                // T - Text area,
                                if ($option['element_type'] === 'S' || $option['element_type'] === 'R') {
                                    $option_data[$option['product_option_id']] = $option['product_option_value_id'];
                                } elseif ($option['element_type'] === 'G' || $option['element_type'] === 'M') {
                                    $option_data[$option['product_option_id']][] = $option['product_option_value_id'];
                                } elseif ($option['element_type'] === 'I' || $option['element_type'] === 'T') {
                                    $option_data[$option['product_option_id']] = $option['value'];
                                } elseif ($option['element_type'] === 'C') {
                                    $option_data[$option['product_option_id']] = 'array';
                                }
                            }
                        }
						$this->cart->add( $product['product_id'], $product['quantity'], $option_data );
						if ( $this->verifyBuildAGift() ) {
							$this->load->model( 'build_a_gift/build_a_gift' );
							$child_products = unserialize( base64_decode($product['child_products_original']) );
							if ( $product['child_products_original'] !== null ) {
								if ( $this->customer && ( $this->customer->isLogged() || $this->customer->isUnauthCustomer() ) && $product['product_id'] ) {
									$data['customer_id']    = $this->customer->isLogged() ? $this->customer->isLogged() : $this->customer->isUnauthCustomer();
									$data['child_products'] = $product['child_products_original'];
									$data['product_id']     = $product['product_id'];

									$this->model_build_a_gift_build_a_gift->addBagCart( $data );
								} else {
									unset( $this->session->data['build_a_gift'] );
									$this->session->data['build_a_gift'][ $product['product_id'] ][] = $child_products[0];
								}
							}
						}
						$added_products.=$success_products_index.'. '.$product['name'].'<br>';
						$success_products_index++;
						$success++;
					} elseif ( $product_info['status'] === '0' ) {
						$text_warning_info                                .= $error_products_index.'. '.str_replace( '[product_name]', $product['name'], $this->language->get( 'text_inactive' ) ).'<br>';
						$warning++;
						$error_products_index++;
					} elseif ( $stockInfo[ $productId ]['subtract'] === true && $stockInfo[ $productId ]['quantity'] == 0 ) {
						$text_warning_info                            .= $error_products_index.'. '.str_replace( '[product_name]', $product['name'], $this->language->get( 'text_out_of_stock' ) ).'<br>';
						$warning++;
						$error_products_index++;
					}
				} else {
					$text_warning_info                           .= $error_products_index.'. '.str_replace( '[product_name]', $product['name'], $this->language->get( 'text_not_available' ) ).'<br>';
					$warning++;
					$error_products_index++;
				}
			}
			if ($warning!=0 && $success!=0)  {
				$this->session->data['reorder_product_error'] = $text_partial_added.'<br>'.$added_products.'<br>';
				$this->session->data['reorder_product_error'] .= '&nbsp;&nbsp;&nbsp;&nbsp;'.$text_partial_warning . '<br>' . $text_warning_info;
			} elseif ($warning==1 && $success==0)  {
				$this->session->data['reorder_product_error'] .= $text_warning_order . '<br>' . $text_warning_info;
			} elseif ($warning > 1 && $success==0) {
				$this->session->data['reorder_product_error'] .= $text_warning_order_multiple . '<br>' . $text_warning_info;
			} elseif ($warning==0) {
				$text_success                           = str_replace( '[order_id]', $order_id, $this->language->get( 'text_reorder_success' ) );
				if ($option_data) {
					$text_success.='<br>'.$this->language->get('text_check_options');
				}
				$this->session->data['reorder_success'] = $text_success;
			}
		}

        $this->load->library('json');

        $this->response->addJSONHeader();
        $this->response->setOutput(AJson::encode($this->data));
	}

	public function reorderProduct() {
		$post     = $this->request->post;
		$order_id = $post['order_id'];
		$order_product_id = $post['order_product_id'];
		$this->load->model( 'account/order' );
		$this->load->model( 'reorder/reorder' );
		$this->load->language( 'reorder/reorder' );
		$this->load->model('catalog/product');
		$this->load->model('checkout/order');
		$order_products = $this->model_reorder_reorder->getOrderProduct( $order_id, $order_product_id );
		if ( $order_products ) {
			$productId    = $order_products['product_id'];
			$product_info = $this->model_reorder_reorder->getProduct( $productId );
			$stockInfo    = $this->model_catalog_product->getProductsStockInfo( [ $productId ] );
			if ( $product_info ) {
				if ( $product_info['status'] === '1' && ( ( $stockInfo[ $productId ]['subtract'] === true && $stockInfo[ $productId ]['quantity'] !== 0 ) || $stockInfo[ $productId ]['subtract'] === false ) ) {
					//foreach ( $order_products as $product ) {
					$options     = $this->model_reorder_reorder->getOrderOptions( $order_id, $order_products['order_product_id'] );
					$option_data = [];
                    if($options) {
                        foreach ($options as $option) {
                            // S - Select,
                            // R - radio buttons,
                            // M - multivalue select,
                            // C - Checkbox,
                            // G -Checkbox Group,
                            // I - text input,
                            // T - Text area,
                            if ($option['element_type'] === 'S' || $option['element_type'] === 'R') {
                                $option_data[$option['product_option_id']] = $option['product_option_value_id'];
                            } elseif ($option['element_type'] === 'G' || $option['element_type'] === 'M') {
                                $option_data[$option['product_option_id']][] = $option['product_option_value_id'];
                            } elseif ($option['element_type'] === 'I' || $option['element_type'] === 'T') {
                                $option_data[$option['product_option_id']] = $option['value'];
                            } elseif ($option['element_type'] === 'C') {
                                $option_data[$option['product_option_id']] = 'array';
                            }
                        }
                    }
                  	$this->cart->add( $order_products['product_id'], $order_products['quantity'], $option_data );
					if ( $this->verifyBuildAGift() ) {
						$this->load->model( 'build_a_gift/build_a_gift' );
						$child_products = unserialize( base64_decode($order_products['child_products_original']) );
						if ( $order_products['child_products'] !== null ) {
							if ( $this->customer && ( $this->customer->isLogged() || $this->customer->isUnauthCustomer() ) && $order_products['product_id'] ) {
								$data['customer_id']    = $this->customer->isLogged() ? $this->customer->isLogged() : $this->customer->isUnauthCustomer();
								$data['child_products'] = $order_products['child_products_original'];
								$data['product_id']     = $order_products['product_id'];
								$this->model_build_a_gift_build_a_gift->addBagCart( $data );
							} else {
								unset( $this->session->data['build_a_gift'] );
								$this->session->data['build_a_gift'][ $order_products['product_id'] ][] = $child_products[0];
							}
						}
					}
					//}

					$text_reorder_product_success                   = str_replace( '[product_name]', $order_products['name'], $this->language->get( 'text_reorder_product_success' ) );
					if ($option_data) {
						$text_reorder_product_success.='<br>&nbsp;&nbsp;&nbsp;&nbsp;'.$this->language->get('text_check_options');
					}
					$this->session->data['reorder_product_success'] = $text_reorder_product_success;
				} elseif ( $product_info['status'] === '0' ) {
					$warning                                      = $this->language->get( 'text_warning' );
					$text_inactive                                = str_replace( '[product_name]', $order_products['name'], $this->language->get( 'text_inactive' ) );
					$this->session->data['reorder_product_error'] = $warning . ' ' . $text_inactive;
				} elseif ( $stockInfo[ $productId ]['subtract'] === true && $stockInfo[ $productId ]['quantity'] == 0 ) {
					$warning                                      = $this->language->get( 'text_warning' );
					$text_out_of_stock                            = str_replace( '[product_name]', $order_products['name'], $this->language->get( 'text_out_of_stock' ) );
					$this->session->data['reorder_product_error'] = $warning . ' ' . $text_out_of_stock;
				}
			} else {
				$warning                                      = $this->language->get( 'text_warning' );
				$text_not_available                           = str_replace( '[product_name]', $order_products['name'], $this->language->get( 'text_not_available' ) );
				$this->session->data['reorder_product_error'] = $warning . ' ' . $text_not_available;
			}
		}
        $this->load->library('json');

        $this->response->addJSONHeader();
        $this->response->setOutput(AJson::encode($this->data));
	}
}
