<?php

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}
class ControllerPagesCheckoutQuickOrder extends AController
{
    public $error = [];
    public $data = [];

    /**
     * @throws AException
     *                    NOTE: this method have a few hk_processData calls
     */
    public function main()
    {
        $error_msg = [];

        $cart_rt = 'checkout/cart';
        $quick_rt = 'checkout/quick_order';
        $product_rt = 'product/product';
        $checkout_rt = 'checkout/shipping';
        // is this an embed mode
        if (true == $this->config->get('embed_mode')) {
            $cart_rt = 'r/checkout/cart/embed';
        }

        // init controller data
        $this->extensions->hk_InitData($this, __FUNCTION__);

        $this->loadModel('checkout/quick_order');
        $this->loadLanguage('checkout/quick_order');

        // process all possible requests first
        if ($this->request->is_GET() && isset($this->request->get['product_id'])) {
            if (isset($this->request->get['option'])) {
                $option = $this->request->get['option'];
            } else {
                $option = [];
            }

            if (isset($this->request->get['quantity'])) {
                $quantity = $this->request->get['quantity'];
            } else {
                $quantity = 1;
            }

            $this->_unset_methods_data_in_session();

            $this->cart->add($this->request->get['product_id'], $quantity, $option);
            $this->extensions->hk_ProcessData($this, 'add_product');
            redirect($this->html->getSecureURL($quick_rt));
        } else {
            if ($this->request->is_GET() && isset($this->request->get['remove'])) {
                // remove product with button click.
                $this->cart->remove($this->request->get['remove']);
                $this->extensions->hk_ProcessData($this, 'remove_product');
                redirect($this->html->getSecureURL($quick_rt));
            } else {
                if ($this->request->is_POST()) {
                    $post = $this->request->post;
                    // if this is coupon, validate and apply
                    if ((isset($post['reset_coupon']) || isset($post['coupon'])) && !$this->csrftoken->isTokenValid()) {
                        $this->error['error_warning'] = $this->language->get('error_unknown');
                    } else {
                        if (isset($post['reset_coupon'])) {
                            // remove coupon
                            unset($this->session->data['coupon']);
                            $this->data['success'] = $this->language->get('text_coupon_removal');
                            unset($this->session->data['success']);
                            $this->reapplyBalance();
                            // process data
                            $this->extensions->hk_ProcessData($this, 'reset_coupon');
                        } else {
                            if (isset($post['coupon']) && $this->_validateCoupon()) {
                                $this->session->data['coupon'] = $post['coupon'];
                                $this->data['success'] = $this->language->get('text_coupon_success');
                                unset($this->session->data['success']);
                                $this->reapplyBalance();
                                // process data
                                $this->extensions->hk_ProcessData($this, 'apply_coupon');
                            }
                        }
                    }

                    if ($this->error['error_warning']) {
                        $error_msg[] = $this->error['error_warning'];
                    }

                    if (isset($post['quantity'])) {
                        // we update cart
                        if (!is_array($post['quantity'])) {
                            $this->loadModel('catalog/product', 'storefront');
                            $product_id = $post['product_id'];

                            if (isset($post['option'])) {
                                $options = $post['option'];
                            } else {
                                $options = [];
                            }

                            // for FILE-attributes
                            if (has_value($this->request->files['option']['name'])) {
                                $fm = new AFile();
                                foreach ($this->request->files['option']['name'] as $id => $name) {
                                    $attribute_data = $this->model_catalog_product->getProductOption($product_id, $id);
                                    $attribute_data['settings'] = unserialize($attribute_data['settings']);
                                    $file_path_info = $fm->getUploadFilePath($attribute_data['settings']['directory'], $name);

                                    $options[$id] = $file_path_info['name'];

                                    if (!has_value($name)) {
                                        continue;
                                    }

                                    if ($attribute_data['required'] && !$this->request->files['option']['size'][$id]) {
                                        $this->session->data['error'] = $this->language->get('error_required_options');
                                        redirect($_SERVER['HTTP_REFERER']);
                                    }

                                    $file_data = [
                                        'option_id' => $id,
                                        'name' => $file_path_info['name'],
                                        'path' => $file_path_info['path'],
                                        'type' => $this->request->files['option']['type'][$id],
                                        'tmp_name' => $this->request->files['option']['tmp_name'][$id],
                                        'error' => $this->request->files['option']['error'][$id],
                                        'size' => $this->request->files['option']['size'][$id],
                                    ];

                                    $file_errors = $fm->validateFileOption($attribute_data['settings'], $file_data);

                                    if (has_value($file_errors)) {
                                        $this->session->data['error'] = implode('<br/>', $file_errors);
                                        redirect($_SERVER['HTTP_REFERER']);
                                    } else {
                                        $result = move_uploaded_file($file_data['tmp_name'], $file_path_info['path']);

                                        if (!$result || $this->request->files['package_file']['error']) {
                                            $this->session->data['error'] .= '<br>Error: ' . getTextUploadError($this->request->files['option']['error'][$id]);
                                            redirect($_SERVER['HTTP_REFERER']);
                                        }
                                    }

                                    $dataset = new ADataset('file_uploads', 'admin');
                                    $dataset->addRows(
                                        [
                                            'date_added' => date('Y-m-d H:i:s', time()),
                                            'name' => $file_path_info['name'],
                                            'type' => $file_data['type'],
                                            'section' => 'product_option',
                                            'section_id' => $attribute_data['attribute_id'],
                                            'path' => $file_path_info['path'],
                                        ]
                                    );
                                }
                            }

                            if ($text_errors = $this->model_catalog_product->validateProductOptions($product_id, $options)) {
                                $this->session->data['error'] = $text_errors;
                                // send options values back via _GET
                                $url = '&' . http_build_query(['option' => $post['option']]);
                                redirect($this->html->getSecureURL($product_rt, '&product_id=' . $post['product_id'] . $url));
                            }

                            $this->cart->add($post['product_id'], $post['quantity'], $options);
                        } else {
                            foreach ($post['quantity'] as $key => $value) {
                                $this->cart->update($key, $value);
                            }
                        }
                        $this->_unset_methods_data_in_session();
                    }

                    if (isset($post['remove'])) {
                        foreach (array_keys($post['remove']) as $key) {
                            $this->cart->remove($key);
                        }
                    }

                    $this->extensions->hk_ProcessData($this);

                    // next page is requested after cart update
                    if (isset($post['next_step'])) {
                        redirect($this->html->getSecureURL($post['next_step']));
                    }

                    if (isset($post['redirect'])) {
                        $this->session->data['redirect'] = $post['redirect'];
                    }

                    if (isset($post['quantity']) || isset($post['remove'])) {
                        $this->_unset_methods_data_in_session();
                        redirect($this->html->getSecureURL($quick_rt));
                    }
                }
            }
        }

        $this->document->setTitle($this->language->get('heading_title'));
        $this->document->resetBreadcrumbs();

        $this->document->addBreadcrumb(
            [
                'href' => $this->html->getHomeURL(),
                'text' => $this->language->get('text_home'),
                'separator' => false,
            ]);

        $this->document->addBreadcrumb(
            [
                'href' => $this->html->getSecureURL('checkout/quick_order'),
                'text' => $this->language->get('text_quick_order'),
                'separator' => $this->language->get('text_separator'),
            ]);

        // if ($this->cart->hasProducts()) {
        if (!$this->cart->hasStock() && !$this->config->get('config_stock_checkout')) {
            $error_msg[] = $this->language->get('error_stock');
        }

        $this->loadModel('tool/seo_url', 'storefront');

        $form = new AForm();
        $form->setForm(['form_name' => 'cart']);
        $this->data['form']['form_open'] = $form->getFieldHtml(
            [
                'type' => 'form',
                'name' => 'cart',
                'action' => $this->html->getSecureURL($quick_rt),
            ]
        );

        //$cart_products = $this->cart->getProducts();

        //$product_ids = [];
        //foreach ($cart_products as $result) {
        //    $product_ids[] = (int) $result['product_id'];
        //}

        //$resource = new AResource('image');
        //$thumbnails = $resource->getMainThumbList(
        //    'products',
        //    $product_ids,
        //    $this->config->get('config_image_cart_width'),
        //    $this->config->get('config_image_cart_height')
        //);

        $cart_products = $this->cart->getProducts() + $this->cart->getVirtualProducts();
        $product_ids = array_column($cart_products, 'product_id');
        $resource = new AResource('image');
        $thumbnails = $product_ids
            ? $resource->getMainThumbList(
                'products',
                $product_ids,
                $this->config->get('config_image_additional_width'),
                $this->config->get('config_image_additional_width')
            )
            : [];

        $products = [];
        foreach ($cart_products as $result) {
            $option_data = [];
            $thumbnail = $thumbnails[$result['product_id']];
            foreach ($result['option'] as $option) {
                $title = '';
                if ('H' == $option['element_type']) {
                    continue;
                } // hide hidden options

                $value = $option['value'];
                // hide binary value for checkbox
                if ('C' == $option['element_type'] && in_array($value, [0, 1])) {
                    $value = '';
                }

                // strip long textarea value
                if ('T' == $option['element_type']) {
                    $title = strip_tags($value);
                    $title = str_replace('\r\n', "\n", $title);

                    $value = str_replace('\r\n', "\n", $value);
                    if (mb_strlen($value) > 64) {
                        $value = mb_substr($value, 0, 64) . '...';
                    }
                }

                $option_data[] = [
                    'name' => $option['name'],
                    'value' => $value,
                    'title' => $title,
                ];
                // product image by option value
                $mSizes = [
                    'main' => [
                        'width' => $this->config->get('config_image_cart_width'),
                        'height' => $this->config->get('config_image_cart_height'),
                    ],
                    'thumb' => [
                        'width' => $this->config->get('config_image_cart_width'),
                        'height' => $this->config->get('config_image_cart_height'),
                    ],
                ];

                $main_image = $resource->getResourceAllObjects(
                    'product_option_value',
                    $option['product_option_value_id'],
                    $mSizes,
                    1,
                    false
                );

                if (!empty($main_image)) {
                    $thumbnail['origin'] = $main_image['origin'];
                    $thumbnail['title'] = $main_image['title'];
                    $thumbnail['description'] = $main_image['description'];
                    $thumbnail['thumb_html'] = $main_image['thumb_html'];
                    $thumbnail['thumb_url'] = $main_image['thumb_url'];
                }
            }

            $price_with_tax = $this->tax->calculate($result['price'], $result['tax_class_id'], $this->config->get('config_tax'));

            $products[] = [
                'remove' => $form->getFieldHtml(
                    [
                        'type' => 'checkbox',
                        'name' => 'remove[' . $result['key'] . ']',
                    ]),
                'remove_url' => $this->html->getSecureURL($quick_rt, '&remove=' . $result['key']),
                'key' => $result['key'],
                'name' => $result['name'],
                'model' => $result['model'],
                'thumb' => $thumbnail,
                'option' => $option_data,
                'quantity' => $form->getFieldHtml(
                    [
                        'type' => 'input',
                        'name' => 'quantity[' . $result['key'] . ']',
                        'value' => $result['quantity'],
                        'attr' => ' size="3" ',
                        'style' => 'short',
                    ]),
                'stock' => $result['stock'],
                'tax_class_id' => $result['tax_class_id'],
                'price' => $this->currency->format($price_with_tax),
                'total' => $this->currency->format_total($price_with_tax, $result['quantity']),
                'href' => $this->html->getSEOURL($product_rt, '&product_id=' . $result['product_id'] . '&key=' . $result['key'], true),
            ];
        }

        $this->data['products'] = $products;
        $this->data['form']['update'] = $form->getFieldHtml(
            [
                'type' => 'submit',
                'name' => $this->language->get('button_update'),
            ]);

        $this->data['form']['checkout'] = $form->getFieldHtml(
            [
                'type' => 'button',
                'name' => 'checkout',
                'text' => $this->language->get('button_checkout'),
                'style' => 'button',
            ]);

        if ($this->config->get('config_cart_weight')) {
            $this->data['weight'] = $this->weight->format($this->cart->getWeight(), $this->config->get('config_weight_class'));
        } else {
            $this->data['weight'] = false;
        }

        $display_totals = $this->cart->buildTotalDisplay();
        $this->data['totals'] = $display_totals['total_data'];

        if (isset($this->session->data['redirect'])) {
            $this->data['continue'] = str_replace('&amp;', '&', $this->session->data['redirect']);
            unset($this->session->data['redirect']);
        } else {
            $this->data['continue'] = $this->html->getHomeURL();
        }
        $this->data['form']['continue_shopping'] = $form->getFieldHtml(
            [
                'type' => 'button',
                'name' => 'continue_shopping',
                'text' => $this->language->get('button_shopping'),
                'style' => 'button',
                'href' => $this->data['continue'],
            ]
        );

        $this->data['checkout'] = $this->html->getSecureURL($checkout_rt);
        $this->data['checkout_rt'] = $checkout_rt;

        // Check if order total max/min is set and met
        $cf_total_min = $this->config->get('total_order_minimum');
        $cf_total_max = $this->config->get('total_order_maximum');
        if (!$this->cart->hasMinRequirement()) {
            $this->data['form']['checkout'] = '';
            $error_msg[] = sprintf($this->language->get('error_order_minimum'), $this->currency->format($cf_total_min));
        }
        if (!$this->cart->hasMaxRequirement()) {
            $this->data['form']['checkout'] = '';
            $error_msg[] = sprintf($this->language->get('error_order_maximum'), $this->currency->format($cf_total_max));
        }

        /*if ($this->config->get('config_shipping_tax_estimate')) {
            $form = new AForm();
            $form->setForm(array('form_name' => 'estimate'));
            $this->data['form_estimate']['form_open'] = $form->getFieldHtml(
              array(
                  'type' => 'form',
                  'name' => 'estimate',
                  'action' => $this->html->getSecureURL($cart_rt),
              ));
            $this->data['estimates_enabled'] = true;
        }*/

        if ($this->session->data['error']) {
            if (is_array($this->session->data['error'])) {
                $error_msg = array_merge($error_msg, $this->session->data['error']);
            } else {
                $error_msg[] = $this->session->data['error'];
            }
            unset($this->session->data['error']);
        }

        // $this->view->assign('error_warning', $error_msg);
        // $this->view->setTemplate('pages/checkout/cart.tpl');
        // $this->view->setTemplate('pages/checkout/quick_order.tpl');
        // }

        // && !$this->config->get('config_customer_price')
        if (!$this->customer->isLogged()) {
            $error_msg[] = sprintf($this->language->get('error_please_login'),
                "\n" . $this->html->getSecureURL('account/login', '&rid=' . $rid)
            );
        // $redirect_url = $this->session->data['redirect'];
        } else {
            // unset($error_msg[]);
            // unset($this->session->data['redirect']);
        }

        $this->data['actionaj_quick_order'] = $this->html->getURL('checkout/cart', '', '&encode');
        if ($this->customer->isLogged()) {
            $this->data['actionaj_quick_login'] = $this->html->getURL('checkout/cart', '', '&encode');
            $this->data['actionaj_islogged'] = true;
            unset($this->session->data['redirect']);
        } else {
            $this->data['error_warning'] = $error_msg;
            $this->session->data['redirect'] = $this->html->getURL('checkout/quick_order', '', '&encode');
            $this->data['actionaj_quick_login'] = $this->html->getURL('account/login', '', '&encode');
            $this->data['actionaj_islogged'] = false;
        }
        $this->data['actionaj_quick_search'] = $this->html->getURL('r/checkout/quick_order/products');
        $this->data['cart_page'] = $this->html->getSEOURL('checkout/cart', '', '&encode');

        $this->view->batchAssign($this->data);
        $this->processTemplate();

        // init controller data
        $this->extensions->hk_UpdateData($this, __FUNCTION__);
    }

    private function _unset_methods_data_in_session()
    {
        unset($this->session->data['shipping_methods'],
            $this->session->data['shipping_method'],
            $this->session->data['payment_methods'],
            $this->session->data['payment_method']);
    }
}
