<?php

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}
class ControllerResponsesCheckoutQuickOrder extends AController
{
    private $error = array();
    public $data = array();

    /*public function __construct()
    {
        $this->registry = Registry::getInstance();
    }*/

    public function main()
    {
        //init controller data
        $this->extensions->hk_InitData($this, __FUNCTION__);

        if ($this->request->is_POST()) {
            if (isset($this->request->post['quantity'])) {
                if (!is_array($this->request->post['quantity'])) {
                    if (isset($this->request->post['option'])) {
                        $option = $this->request->post['option'];
                    } else {
                        $option = array();
                    }

                    $this->cart->add($this->request->post['product_id'], $this->request->post['quantity'], $option);
                } else {
                    foreach ($this->request->post['quantity'] as $key => $value) {
                        $this->cart->update($key, $value);
                    }
                }

                unset($this->session->data['shipping_methods']);
                unset($this->session->data['shipping_method']);
                unset($this->session->data['payment_methods']);
                unset($this->session->data['payment_method']);
            }

            if (isset($this->request->post['remove'])) {
                foreach (array_keys($this->request->post['remove']) as $key) {
                    $this->cart->remove($key);
                }
            }

            if (isset($this->request->post['redirect'])) {
                $this->session->data['redirect'] = $this->request->post['redirect'];
            }

            if (isset($this->request->post['quantity']) || isset($this->request->post['remove'])) {
                unset($this->session->data['shipping_methods']);
                unset($this->session->data['shipping_method']);
                unset($this->session->data['payment_methods']);
                unset($this->session->data['payment_method']);
            }
        }

        //init controller data
        $this->extensions->hk_UpdateData($this, __FUNCTION__);
    }

    /*quick search*/
    public function products()
    {
        $products_data = array();
        $post = &$this->request->post;
        $get = &$this->request->get;
        $exclude = (array) $post['exclude'];
        if (isset($get['exclude'])) {
            $get['exclude'] = (array) $get['exclude'];
            $exclude = array_merge($get['exclude'], $exclude);
        }
        //init controller data
        $this->extensions->hk_InitData($this, __FUNCTION__);
        $this->loadModel('catalog/product');
        if (isset($post['coupon_product'])) {
            $products = $post['coupon_product'];
            foreach ($products as $product_id) {
                $product_info = $this->model_catalog_product->getProduct($product_id);
                if ($product_info) {
                    $products_data[] = array(
                        'id' => $product_info['product_id'],
                        'name' => $product_info['name'],
                        'meta' => $product_info['model'],
                        'sort_order' => (int) $product_info['sort_order'],
                    );
                }
            }
        } else {
            //search keyword
            if (isset($post['term']) or $this->request->get['term']) {
                if (isset($post['term'])) {
                    $searchterm = $post['term'];
                } else {
                    $searchterm = $this->request->get['term'];
                }
                $filter = array(
                    'limit' => 20,
                    'content_language_id' => $this->language->getContentLanguageID(),
                    'filter' => array(
                        'keyword' => $searchterm,
                        'match' => 'all',
                        'exclude' => array('product_id' => $exclude),
                    ),
                );
                //if need to show only available products
                //if ('enabled_only' == $this->request->post['filter']) {
                $filter['filter']['status'] = 1;
                $filter['subsql_filter'] = 'date_available<=NOW()';
                //}
                $products = $this->model_catalog_product->getProducts($filter);

                $product_ids = array();
                foreach ($products as $result) {
                    $product_ids[] = (int) $result['product_id'];
                }

                $resource = new AResource('image');
                $thumbnails = $resource->getMainThumbList(
                    'products',
                    $product_ids,
                    $this->config->get('config_image_grid_width'),
                    $this->config->get('config_image_grid_height')
                );

                foreach ($products as $product_data) {
                    $thumbnail = $thumbnails[$product_data['product_id']];

                    if ($get['currency_code']) {
                        $price = round($this->currency->convert($product_data['price'],
                            $this->config->get('config_currency'),
                            $get['currency_code']), 2);
                    } else {
                        $price = $product_data['price'];
                    }

                    $formatted_price = $this->currency->format($product_data['price'], ($get['currency_code']
                        ? $get['currency_code']
                        : $this->config->get('config_currency')));
                    //$this->log->write(print_r($product_data, true).' $product_data');
                    $products_data[] = array(
                        'image' => $thumbnail['thumb_url'],
                        'id' => $product_data['product_id'],
                        'name' => $product_data['name'],
                        'price' => $price,
                        'sku' => $product_data['sku'],
                        'meta' => $product_data['model'],
                        'sort_order' => (int) $product_data['sort_order'],
                    );
                }
            }
        }
        if (count($products_data)) {
            $disp_ship = $disp_im = array();
            if (count($products_data) > 1) {
                $disp_ship[0] = (string) $first_result;
                $disp_im[0] = '';
            }
            foreach ($products_data as $shp_data) {
                //$this->log->write(print_r($shp_data, true).' productsINFO');
                //$shp_data['image']  //localhost/abantecart/image/thumbnails/18/6b/demo_product02_3_jpg-100029-57x57.jpg
                $disp_ship[$shp_data['id']] = $shp_data['name'].' - '.$shp_data['meta'];
                $disp_im[] = $shp_data['image'];
                //$disp_im[$shp_data['id']] = $shp_data['image']; // product_id => image
                //$shp_data['image']="<img src="//localhost/abantecart/image/thumbnails/18/6b/demo_product02_3_jpg-100029-57x57.jpg" width="57" height="57"   alt="" >"
            }
            $selectbox = HtmlElementFactory::create(array(
            'type' => 'selectbox',
            'name' => 'searchanswer',
            'options' => $disp_ship,
            'style' => 'large-field', //chosen-select
            //'data-placeholder' => 'Search and select product',
            ));
            $this->data['selectbox'] = $selectbox->getHTML();
            $this->data['selectbox_images'] = $disp_im;
        }
        $this->data['products_data'] = $products_data;
        //update controller data
        $this->extensions->hk_UpdateData($this, __FUNCTION__);

        $this->load->library('json');
        $this->response->addJSONHeader();
        $this->response->setOutput(AJson::encode($this->data));
    }

    /**
     * change_zone_get_shipping_methods()
     * Ajax function to apply new country and zone to be used in tax and/or shipping culculation.
     * Return: List of available shipping methods and cost.
     */
    public function change_zone_get_shipping_methods()
    {
        //init controller data
        $this->extensions->hk_InitData($this, __FUNCTION__);
        $output = array();
        $this->load->library('json');
        if ($this->request->is_GET()) {
            $this->response->setOutput(AJson::encode($output));

            return '';
        }

        //need to reset zone for tax even if shipping is not needed
        $this->loadModel('localisation/country');
        $this->loadModel('localisation/zone');
        $country_info = $this->model_localisation_country->getCountry($this->request->post['country_id']);
        $zone_info = $this->model_localisation_zone->getZone($this->request->post['zone_id']);
        $shipping_address = array(
          'postcode' => $this->request->post['postcode'],
          'country_id' => $this->request->post['country_id'],
          'country_iso_code2' => $country_info['iso_code_2'],
          'iso_code_2' => $country_info['iso_code_2'],
          'zone_id' => $this->request->post['zone_id'],
          'zone_code' => $zone_info['code'],
      );

        $this->tax->setZone($shipping_address['country_id'], $shipping_address['zone_id']);

        //skip shipping processing if not required.
        if ($this->cart->hasShipping()) {
            $this->loadModel('checkout/extension');

            $results = $this->model_checkout_extension->getExtensions('shipping');
            foreach ($results as $result) {
                $this->loadModel('extension/'.$result['key']);

                /** @noinspection PhpUndefinedMethodInspection */
                $quote = $this->{'model_extension_'.$result['key']}->getQuote($shipping_address);

                if ($quote) {
                    $output[$result['key']] = array(
                      'title' => $quote['title'],
                      'quote' => $quote['quote'],
                      'sort_order' => $quote['sort_order'],
                      'error' => $quote['error'],
                  );
                }
            }

            $sort_order = array();
            foreach ($output as $key => $value) {
                $sort_order[$key] = $value['sort_order'];
            }
            array_multisort($sort_order, SORT_ASC, $output);
            $this->session->data['shipping_methods'] = $output;

            //add ready selectbox element
            if (count($output)) {
                $disp_ship = array();
                foreach ($output as $shp_data) {
                    $shp_data['quote'] = (array) $shp_data['quote'];
                    foreach ($shp_data['quote'] as $qt_data) {
                        $disp_ship[$qt_data['id']] = $qt_data['title'].' - '.$qt_data['text'];
                    }
                }

                if ($disp_ship) {
                    $selectbox = HtmlElementFactory::create(array(
                      'type' => 'selectbox',
                      'name' => 'shippings',
                      'options' => $disp_ship,
                      'style' => 'large-field',
                  ));
                    $output['selectbox'] = $selectbox->getHTML();
                } else {
                    $output['selectbox'] = '';
                }
            }
        } else {
            $output['selectbox'] = '';
        }

        $this->data = $output;
        //init controller data
        $this->extensions->hk_UpdateData($this, __FUNCTION__);

        $this->response->setOutput(AJson::encode($this->data));
    }

    public function grab_product()
    {
        //init controller data
        $this->extensions->hk_InitData($this, __FUNCTION__);
        $output = array();
        $this->load->library('json');
        if ($this->request->is_GET()) {
            $this->response->setOutput(AJson::encode($output));

            return '';
        }
        $this->registry = Registry::getInstance();
        $view = new AView($this->registry, 0);
        $this->html = new AHtml($this->registry);

        $this->loadLanguage('product/product');
        //$this->loadLanguage('options_listing/options_listing');
        $this->loadModel('catalog/product');

        if ($this->customer->isLogged()) {
            $promotion = new APromotion();
        }
        $prod_id = (int) $this->request->post['product_id'];

        $product_info = $this->model_catalog_product->getProduct($prod_id);
        //$this->log->write((int) $prod_id.' pr='.print_r($product_info, true).' productsINFO');
        $this->data['product_info'] = $product_info;
        $this->data['formatted_price'] = $this->currency->format($product_info['final_price']);
        if ($this->config->get('options_listing_status')) {
            $this->loadModel('extension/options_listing');
            $this->data['unit'] = $this->model_extension_options_listing->getProductSettings($prod_id);
        }

        /*$product_discounts = $promotion->getProductDiscounts($prod_id);
        $discounts = array();
        foreach ($product_discounts as $discount) {
            $discounts[] = array(
                'quantity' => $discount['quantity'],
                'price' => $this->currency->format($this->tax->calculate($discount['price'], $product_info['tax_class_id'], (bool) $this->config->get('config_tax'))),
            );
        }
        $this->data['discounts'] = $discounts;*/

        $elements_with_options = HtmlElementFactory::getElementsWithOptions();
        //$this->log->write((int) $prod_id.' pr='.print_r($elements_with_options, true).' $elements_with_options');
        $options = array();
        $cart_product_info = array();
        $cart_product_info = $this->model_catalog_product->getProduct($prod_id);
        $product_options = $this->model_catalog_product->getProductOptions($prod_id);
        //$this->log->write((int) $prod_id.' pr='.print_r($product_options, true).' $product_options');
        foreach ($product_options as $option) {
            $values = array();
            $disabled_values = array();
            $name = $price = '';
            $default_value = $cart_product_info['options'][$option['product_option_id']];
            if ('R' == $option['element_type']) {
                $default_value = is_array($default_value) ? current($default_value) : (string) $default_value;
            }
            $preset_value = $default_value;
            $opt_stock_message = '';
            foreach ($option['option_value'] as $option_value) {
                $default_value = $option_value['default'] && !$default_value ? $option_value['product_option_value_id'] : $default_value;
                // for case when trying to add to cart without required options. we get option-array back inside _GET
                if (has_value($request['option'][$option['product_option_id']])) {
                    $default_value = $request['option'][$option['product_option_id']];
                }

                $name = $option_value['name'];
                //check if we disable option based on stock settings
                if ($option_value['subtract'] && $this->config->get('config_nostock_autodisable') && $option_value['quantity'] <= 0) {
                    continue;
                }

                //Stock and status
                $opt_stock_message = '';
                //if options has stock tracking and not allowed to be purchased out of stock
                if ($option_value['subtract'] && !$product_info['stock_checkout']) {
                    if ($option_value['quantity'] <= 0) {
                        //show out of stock message
                        $opt_stock_message = $this->language->get('text_out_of_stock');
                        $disabled_values[] = $option_value['product_option_value_id'];
                    } else {
                        if ($this->config->get('config_stock_display')) {
                            if ($option_value['quantity'] > 0) {
                                $opt_stock_message = $option_value['quantity'].' '.$this->language->get('text_instock');
                                $opt_stock_message = "({$opt_stock_message})";
                            }
                        }
                    }
                } else {
                    if ($option_value['subtract'] && $product_info['stock_checkout']) {
                        if ($option_value['quantity'] <= 0) {
                            $opt_stock_message = "({$product_info['stock_status']})";
                        }
                    }
                }

                //Apply option price modifier
                if ('%' == $option_value['prefix']) {
                    $price = $this->tax->calculate(
                    ($product_price * $option_value['price'] / 100),
                    $product_info['tax_class_id'],
                    (bool) $this->config->get('config_tax')
                );
                    if (0 != $price) {
                        $price = $this->currency->format($price);
                    } else {
                        $price = '';
                    }
                } else {
                    $price = $this->tax->calculate($option_value['price'], $product_info['tax_class_id'], (bool) $this->config->get('config_tax'));
                    if (0 != $price) {
                        $price = $this->currency->format($price);
                    } else {
                        $price = '';
                    }
                }

                $values[$option_value['product_option_value_id']] = $option_value['name'].' '.$price.' '.$opt_stock_message;
                //disable stock tracking for product if some of option have subtract
                if ($option_value['subtract']) {
                    $product_info['subtract'] = false;
                }

                if ('B' == $option['element_type']) {
                    $name = $default_value = preg_replace("/\r|\n/", ' ', $option_value['name']);
                    if ($price) {
                        $default_value .= '</br>';
                        $name .= ' ';
                    }
                    if ($price) {
                        $default_value .= $price.' ';
                        $name .= $price;
                    }
                    $option['required'] = false;
                }
            }

            $option_data = array();

            //if not values are build, nothing to show
            if (count($values)) {
                $value = '';
                //add price to option name if it is not element with options
                if (!in_array($option['element_type'], $elements_with_options) && 'B' != $option['element_type']) {
                    $option['name'] .= ' <small>'.$price.'</small>';
                    if ($opt_stock_message) {
                        $option['name'] .= '<br />'.$opt_stock_message;
                    }
                    $value = $default_value ? $default_value : $name;
                } else {
                    if ('B' == $option['element_type']) {
                        $value = $name;
                    }
                }

                //set default selection is nothing selected
                if (!has_value($value)) {
                    if (has_value($default_value)) {
                        $value = $default_value;
                    }
                }

                //for checkbox with empty value
                if ('' == $value && 'C' == $option['element_type']) {
                    $value = 1;
                }

                $option_data = array(
                'type' => $option['html_type'],
                'name' => !in_array($option['element_type'], HtmlElementFactory::getMultivalueElements()) ? 'option['.$option['product_option_id'].']' : 'option['.$option['product_option_id'].'][]',
                'value' => $value,
                'options' => $values,
                'disabled_options' => $disabled_values,
                'required' => $option['required'],
                'placeholder' => $option['option_placeholder'],
                'regexp_pattern' => $option['regexp_pattern'],
                'error_text' => $option['error_text'],
            );

                if ('C' == $option['element_type']) {
                    if (!in_array($value, array('0', '1'))) {
                        $option_data['label_text'] = $value;
                    }
                    $option_data['checked'] = $preset_value ? true : false;
                }

                $options[] = array(
                'name' => $option['name'],
                'html' => $this->html->buildElement($option_data),  // not a string!!! it's object!
            );
                //$this->log->write(print_r($this->html->buildElement($option_data), true).' buildElement in Ajax');
            }
        }
        $this->data['options'] = $options;
        //$this->log->write(print_r($options, true).' $options in Ajax');
        //generate options html
        if ($options) {
            $options_html = '';
            foreach ($options as $option) {
                $options_html .= '<div class="form-group">';
                if (!in_array($option['html']->type, array('hidden'))) {
                    $options_html .= '<label class="control-label">'.$option['name'].'</label>';
                }
                $options_html .= '<div class="input-group col-sm-">'.$option['html'].'</div></div>';
            }
            $this->data['options_html'] = $options_html;
            //$this->log->write(print_r($options_html, true).' $options_html in Ajax');
        }
        //end generate html
        if ($cart_product_info['minimum'] > 0) {
            $minimum_quanity = (int) $cart_product_info['minimum'];
        } else {
            $minimum_quanity = 1;
        }

        $this->data['minimum_quanity'] = $minimum_quanity;

        //need to reset zone for tax even if shipping is not needed
        /*$this->loadModel('localisation/country');
        $this->loadModel('localisation/zone');
        $country_info = $this->model_localisation_country->getCountry($this->request->post['country_id']);
        $zone_info = $this->model_localisation_zone->getZone($this->request->post['zone_id']);
        $shipping_address = array(
          'postcode' => $this->request->post['postcode'],
          'country_id' => $this->request->post['country_id'],
          'country_iso_code2' => $country_info['iso_code_2'],
          'iso_code_2' => $country_info['iso_code_2'],
          'zone_id' => $this->request->post['zone_id'],
          'zone_code' => $zone_info['code'],
      );

        $this->tax->setZone($shipping_address['country_id'], $shipping_address['zone_id']);

        //skip shipping processing if not required.
        if ($this->cart->hasShipping()) {
            $this->loadModel('checkout/extension');

            $results = $this->model_checkout_extension->getExtensions('shipping');
            foreach ($results as $result) {
                $this->loadModel('extension/'.$result['key']);


                $quote = $this->{'model_extension_'.$result['key']}->getQuote($shipping_address);

                if ($quote) {
                    $output[$result['key']] = array(
                      'title' => $quote['title'],
                      'quote' => $quote['quote'],
                      'sort_order' => $quote['sort_order'],
                      'error' => $quote['error'],
                  );
                }
            }

            $sort_order = array();
            foreach ($output as $key => $value) {
                $sort_order[$key] = $value['sort_order'];
            }
            array_multisort($sort_order, SORT_ASC, $output);
            $this->session->data['shipping_methods'] = $output;

            //add ready selectbox element
            if (count($output)) {
                $disp_ship = array();
                foreach ($output as $shp_data) {
                    $shp_data['quote'] = (array) $shp_data['quote'];
                    foreach ($shp_data['quote'] as $qt_data) {
                        $disp_ship[$qt_data['id']] = $qt_data['title'].' - '.$qt_data['text'];
                    }
                }

                if ($disp_ship) {
                    $selectbox = HtmlElementFactory::create(array(
                      'type' => 'selectbox',
                      'name' => 'shippings',
                      'options' => $disp_ship,
                      'style' => 'large-field',
                  ));
                    $output['selectbox'] = $selectbox->getHTML();
                } else {
                    $output['selectbox'] = '';
                }
            }
        } else {
            $output['selectbox'] = '';
        }*/

        //$this->data = $output;
        //init controller data
        $this->extensions->hk_UpdateData($this, __FUNCTION__);

        $this->response->setOutput(AJson::encode($this->data));
    }

    public function recalc_totals()
    {
        //init controller data
        $this->extensions->hk_InitData($this, __FUNCTION__);
        $output = array();

        $this->load->library('json');

        if ($this->request->is_GET()) {
            $this->response->setOutput(AJson::encode($output));

            return '';
        }

        if ($this->request->post['country_id'] && $this->request->post['zone_id']) {
            $this->tax->setZone($this->request->post['country_id'], $this->request->post['zone_id']);
        }

        $clear_shipping = false;
        if ($this->request->post['shipping_method']) {
            $shipping = explode('.', $this->request->post['shipping_method']);
            if (!$this->session->data['shipping_method']) {
                $clear_shipping = true;
            }
            $this->session->data['shipping_method'] = $this->session->data['shipping_methods'][$shipping[0]]['quote'][$shipping[1]];
        } else {
            unset($this->session->data['shipping_address_id']);
            unset($this->session->data['shipping_method']);
            unset($this->session->data['shipping_methods']);
        }

        $display_totals = $this->cart->buildTotalDisplay(true);
        $output['totals'] = $display_totals['total_data'];
        $this->data = $output;
        //init controller data
        $this->extensions->hk_UpdateData($this, __FUNCTION__);

        //if shipping was not set before calculation - clear it from session
        if ($clear_shipping) {
            unset($this->session->data['shipping_method']);
        }

        $this->response->setOutput(AJson::encode($this->data));
    }

    public function embed()
    {
        //init controller data
        $this->extensions->hk_InitData($this, __FUNCTION__);

        try {
            $this->config->set('embed_mode', true);
            $cart = $this->dispatch('pages/checkout/cart');
            $cart_html = $cart->dispatchGetOutput();
        } catch (AException $e) {
        }

        $this->extensions->hk_UpdateData($this, __FUNCTION__);

        $this->response->setOutput($cart_html);
    }
}
