<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2023 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

require_once DIR_EXT.'quick_grid_export'.DIR_EXT_CORE.'lib/vendor/autoload.php';

use PhpOffice\PhpSpreadsheet\Spreadsheet;

class ControllerResponsesExtensionQuickGridExport extends AController {
    private $error = [];

    public function main() {

        $controller = $this->request->get['controller'];
        if(!$controller){
            return null;
        }
        $this->load->library('json');
        $skip_columns = ['icon','action',''];
        $spreadsheet = new Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();
        $this->load->language('quick_grid_export/quick_grid_export');
        $this->request->post['rows'] = 15000;
        $this->request->post['_search'] = 'true';

        if ($this->request->get['filters']) {
            $this->request->post['filters'] = $this->request->get['filters'];
            $this->load->library('json');
            $filters = json_decode(html_entity_decode($this->request->get['filters']),true);
            $this->request->post['sidx'] = $filters['sidx'];
            $this->request->post['sord'] = $filters['sord'];
            unset($this->request->get['filters']);
        }

        if ($controller==='listing_grid/email_templates') {
            $this->load->model('design/email_template');
            $data['store_id'] = (int)$this->config->get('config_store_id');
            $info = $this->model_design_email_template->getEmailTemplates($data);
            $page_total = ceil($info['total']/$info['limit']);
            $rows=[];
            for ($i=1;$i<=$page_total;$i++) {
                $this->request->post['page'] = $i;
                $grid = $this->dispatch('responses/' . $controller);
                $results = $grid->dispatchGetOutput();
                $results = AJson::decode($results, true);
                $rows = array_merge_recursive($rows,$results['rows']);
            }
            $result['rows'] = $rows;
        } else {
            $this->request->post['page'] = 1;
            $grid = $this->dispatch('responses/' . $controller);
            $result = $grid->dispatchGetOutput();
            $result = AJson::decode($result, true);
        }

        $grid_settings = $this->session->data['quick_grid_export_settings'];

        $excel_grid = [];
        $skip = [];

        //get table header
        $headerCol='A';

        $headerColName=[];
        foreach($grid_settings['colNames'] as $cell_key =>$col_name ){
            // skip some columns

            if(in_array($grid_settings['colModel'][$cell_key]['name'], $skip_columns)){
                continue;
            }
            if($col_name && $col_name!=='sort_order'){
                $sheet->setCellValue( $headerCol.'1', $col_name );
                $headerColName[]=$headerCol;
                $headerCol++;
            }else{
                $skip[] = $cell_key;
            }
        }

        if ($controller==='listing_grid/category') {
            $this->load->model('catalog/category');
            $sheet->setCellValue($headerCol . '1', $this->language->get('column_parent_category'));
            $headerColName[] = $headerCol;
        }
        $styleArray = [
            'borders' => [
                'top'    => [
                    'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                ],
                'left'   => [
                    'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                ],
                'right'  => [
                    'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                ],
                'bottom' => [
                    'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                ],
            ]
        ];

        foreach($headerColName as $headerName) {
            $spreadsheet->getActiveSheet()->getColumnDimension( $headerName )->setAutoSize( true );
            $spreadsheet->getActiveSheet()->getStyle( $headerName.'1' )->applyFromArray( $styleArray );
        }

        $index=2;
        $cat_name='';
        foreach($result['rows'] as $row_num => $row){
            $cellCol='A';
            if ($controller==='listing_grid/category') {
                $parent_id = $row['cell'][8];
                if (!is_null($parent_id)) {
                    $cat_descriptions = $this->model_catalog_category->getCategoryDescriptions($parent_id);
                    $lang_id = $this->language->getContentLanguageID();
                    $cat_name = $cat_descriptions[$lang_id]['name'];
                }
            }

            foreach($row['cell'] as $cell_key=>$cell_html) {
                // skip some columns
                if(in_array($grid_settings['colModel'][$cell_key]['name'], $skip_columns) || in_array($cell_key,$skip)){
                    continue;
                }
                // parse html-inputs in future
                $cell_html=str_replace('readonly','',$cell_html);
                $cell = trim(strip_tags($cell_html,'<input><select>'));
                if ($cell_key===1 && is_null($row['cell'][8])) {
                    $cat_name = $cell;
                }
                $cell = str_replace(['OFF','ON', $this->language->get('text_on'), $this->language->get('text_off')],'',$cell);
                $xml = simplexml_load_string($cell,"SimpleXMLElement", LIBXML_NOERROR);

                if($xml){
                    $attr = $xml->attributes();
                    $cell = $attr['value'][0] ? (string)$attr['value'][0] : $attr['data-orgvalue'][0];
                    // for checkboxes
                    if((string)$attr['type'][0]=='checkbox'){
                        $cell = (string)$attr['checked'][0]=='checked' ? 1 : 0;
                    }
                    if(strpos(strtolower($grid_settings['colModel'][$cell_key]['name']),'status')!==false){
                        $cell = $cell=='1' ? 'On' : 'Off';
                    }else if(strpos(strtolower($grid_settings['colModel'][$cell_key]['name']),'featured')!==false){
                        $cell = $cell=='1' ? 'Yes' : 'No';
                    }else if(strpos(strtolower($grid_settings['colModel'][$cell_key]['name']),'approved')!==false){
                        $cell = $cell=='1' ? 'Yes' : 'No';
                    } else if(strpos(strtolower($grid_settings['colModel'][$cell_key]['name']),'track_stock')!==false){
                        $cell = $cell=='1' ? 'Yes' : 'No';
                    }
                }
                $sheet->setCellValue( $cellCol . $index, html_entity_decode($cell) );
                $spreadsheet->getActiveSheet()->getStyle( $cellCol . $index )->applyFromArray( $styleArray );
                $cellCol++;
            }
            if ($controller === 'listing_grid/category') {
                if (!is_null($parent_id)) {
                    $sheet->setCellValue($cellCol . $index, $cat_name);
                } else {
                    $sheet->setCellValue($cellCol . $index, '-');
                }

                $spreadsheet->getActiveSheet()->getStyle($cellCol . $index)->applyFromArray($styleArray);
            }
            $index++;
            if ($controller==='listing_grid/category') {
                $this->request->post['nodeid'] = $row['id'];
                $grid = $this->dispatch('responses/' . $controller);
                $subcats = $grid->dispatchGetOutput();
                $subcats = AJson::decode($subcats, true);
                if (isset($subcats['rows'])) {
                    foreach ($subcats['rows'] as $num_row => $subcat_row) {
                        $subcatCellCol='A';
                        foreach($subcat_row['cell'] as $subcat_cell_key=>$subcat_cell_html) {
                            // skip some columns
                            if(in_array($grid_settings['colModel'][$subcat_cell_key]['name'], $skip_columns) || in_array($subcat_cell_key,$skip)){
                                continue;
                            }
                            // parse html-inputs in future
                            $subcat_cell_html=str_replace('readonly','',$subcat_cell_html);
                            $subcat_cell = trim(strip_tags($subcat_cell_html,'<input><select>'));
                            $subcat_cell = str_replace(['OFF','ON', $this->language->get('text_on'), $this->language->get('text_off')],'',$subcat_cell);

                            $xml = simplexml_load_string($subcat_cell,"SimpleXMLElement", LIBXML_NOERROR);

                            if($xml){
                                $attr = $xml->attributes();
                                $subcat_cell = (string)$attr['value'][0];
                                // for checkboxes
                                if((string)$attr['type'][0]=='checkbox'){
                                    $subcat_cell = (string)$attr['checked'][0]=='checked' ? 1 : 0;
                                }
                                if(strpos(strtolower($grid_settings['colModel'][$subcat_cell_key]['name']),'status')!==false){
                                    $subcat_cell = $subcat_cell=='1' ? 'On' : 'Off';
                                }else if(strpos(strtolower($grid_settings['colModel'][$subcat_cell_key]['name']),'featured')!==false){
                                    $subcat_cell = $subcat_cell=='1' ? 'Yes' : 'No';
                                }else if(strpos(strtolower($grid_settings['colModel'][$subcat_cell_key]['name']),'approved')!==false){
                                    $subcat_cell = $subcat_cell=='1' ? 'Yes' : 'No';
                                }
                            }
                            $sheet->setCellValue( $subcatCellCol . $index, html_entity_decode($subcat_cell) );
                            $spreadsheet->getActiveSheet()->getStyle( $subcatCellCol . $index )->applyFromArray( $styleArray );
                            $subcatCellCol++;
                        }
                        if ($controller==='listing_grid/category') {
                            $sheet->setCellValue($subcatCellCol . $index, html_entity_decode($cat_name));
                            $spreadsheet->getActiveSheet()->getStyle($subcatCellCol . $index)->applyFromArray($styleArray);
                        }
                        $index++;
                    }
                }
            }

        }

        $format = $this->request->get['format'];
        header( 'Content-type: application/vnd.ms-excel' );
        // It will be called order.xls
        header( "Content-Disposition: attachment; filename=".$grid_settings['table_id'].'.'.strtolower($format));
        $writer = \PhpOffice\PhpSpreadsheet\IOFactory::createWriter( $spreadsheet, ucfirst($format) );
        ob_end_clean();
        // Write file to the browser
        $writer->save( 'php://output' );
        die();
    }
}