<?php

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

/**
 * @property ModelCatalogProduct      $model_catalog_product
 * @property ModelCatalogManufacturer $model_catalog_manufacturer
 * @property ModelAccountAddress      $model_account_address
 */
class ModelTotalPromotionTotal extends Model
{
    private $total;
    private $total_data;
    private $taxes;

    public function getTotal(&$total_data, &$total, &$taxes)
    {
        $status = $this->config->get('promotion_total_status');

        if (!$this->config->get('promotion_cart')
            && in_array($this->request->get['rt'], array('checkout/cart', 'r/checkout/cart/recalc_totals'))) {
            $status = 0;
        }
        if (!$this->config->get('promotion_status')) {
            $status = 0;
        }

        if ($status) {
            $this->total_data = $total_data;
            $this->total = $total;
            $this->taxes = $taxes;
            $this->_apply();
            $total_data = $this->total_data;
            $total = $this->total;
            $taxes = $this->taxes;
        }
    }

    private function _apply()
    {
        $promotions = $this->cache->get('promotions');
        if (is_null($promotions)) {
            $sql = "SELECT p.*, COALESCE(`end_date`, '2200-00-00 00:00:00') as end_date,  COALESCE(pd.name,'promotion') as name
                    FROM " . $this->db->table('promotions') . ' p
                    LEFT JOIN ' . $this->db->table('promotion_descriptions') . " pd
                        ON pd.promotion_id=p.promotion_id AND pd.language_id = '" . $this->language->getLanguageID() . "'
                    WHERE `status` = '1'
                    ORDER BY priority;";

            $promotions = $this->db->query($sql);
            $promotions = $promotions->rows;

            foreach ($promotions as &$promo) {
                $promo['conditions'] = unserialize($promo['conditions']);
                $promo['conditions']['relation']['value'] = 'false' == $promo['conditions']['relation']['value']
                                                            ? false
                                                            : true;
                $promo['bonuses'] = unserialize($promo['bonuses']);
            }
            unset($promo);
            $this->cache->set('promotions', $promotions);
        }

        foreach ($promotions as $promotion) {
            $start_date = strtotime($promotion['start_date']);
            $end_date = '0000-00-00 00:00:00' != $promotion['end_date'] ? strtotime($promotion['end_date']) : false;
            $end_date = false === $end_date ? (time() + 86400) : $end_date;
            if (time() < $start_date || time() > $end_date) {
                continue;
            }
            $result = $this->_check_conditions($promotion['conditions']);
            if ($result) {
                $res = $this->_apply_bonuses($promotion['name'], $promotion['bonuses'], $promotion);
                if ($res && $promotion['stop']) {
                    break;
                }
            }
        }
    }

    /**
     * @param array $conditions
     *
     * @return bool|null
     *
     * @throws AException
     */
    private function _check_conditions($conditions)
    {
        if (!is_array($conditions['conditions'])) {
            return null;
        }
        $p_excluded = $c_excluded = array();
        foreach ($conditions['conditions'] as $condition) {
            if ('products' == $condition['object']) {
                $products = $this->cart->getProducts();
                foreach ($products as $product) {
                    $products_ids[] = $product['product_id'];
                }
                //array_diff() function returns the values in the first array that are not present in any of the other arrays
                if (array_intersect($products_ids, $condition['value'])) {
                    $p_excluded = array_diff($products_ids, $condition['value']);
                }
            }

            if ('categories' == $condition['object']) {
                $products = $this->cart->getProducts();
                $this->load->model('catalog/product');
                $cart_categories = array();
                foreach ($products as $product) {
                    $res = $this->model_catalog_product->getCategories($product['product_id']);
                    foreach ($res as $row) {
                        $cart_categories[] = $row['category_id'];
                    }
                }
                $cart_categories = array_unique($cart_categories);
                if (array_intersect($cart_categories, $condition['value'])) {
                    $c_excluded = array_diff($cart_categories, $condition['value']);
                }
            }
            $result = $this->_check_condition($condition, $c_excluded, $p_excluded);
            if ('any' == $conditions['relation']['if']
                && $result === $conditions['relation']['value']
            ) {
                return true;
            } elseif ('all' == $conditions['relation']['if']
                && $result !== $conditions['relation']['value']
            ) {
                return false;
            }
        }

        // if still not returned
        return 'any' == $conditions['relation']['if'] ? false : true;
    }

    /**
     * @param array $condition
     *
     * @return bool|null
     *
     * @throws AException
     */
    private function _check_condition($condition, $c_excluded, $p_excluded)
    {
        $result = null;

        if (!$condition['object']) {
            return null;
        }
        $products_ids = array(); //$p_excluded = $c_excluded = array();
        switch ($condition['object']) {
            case 'products':
                $products = $this->cart->getProducts();
                if (count($c_excluded) > 0) {
                    $products = $c_excluded;
                    //$this->log->write(print_r($c_excluded, true) . ' $c_excluded in ProductCase');
                }
                foreach ($products as $product) {
                    $products_ids[] = $product['product_id'];
                }

                return $this->_run_comparison($products_ids, $condition['value'], $condition['operator']);
                break;
            case 'categories':
                  $products = $this->cart->getProducts();
                  if (count($p_excluded) > 0) {
                      $products = $p_excluded;
                      //$this->log->write(print_r($p_excluded, true) . ' $p_excluded in categoryCase');
                  }

                  $this->load->model('catalog/product');
                  $cart_categories = array();
                  foreach ($products as $product) {
                      if (count($p_excluded) > 0) {
                          $res = $this->model_catalog_product->getCategories($product);
                      } else {
                          $res = $this->model_catalog_product->getCategories($product['product_id']);
                      }
                      //$res = $this->model_catalog_product->getCategories($product['product_id']);
                      foreach ($res as $row) {
                          $cart_categories[] = $row['category_id'];
                      }
                  }
                  $cart_categories = array_unique($cart_categories);

                  return $this->_run_comparison($cart_categories, $condition['value'], $condition['operator']);
                  break;
            case 'product_price':
                $products = $this->cart->getProducts();
                foreach ($products as $product) {
                    if ($this->_run_comparison($product['price'], $condition['value'], $condition['operator'])) {
                        return true;
                    }
                }

                return false;
                break;

            case 'brands':
                $products = $this->cart->getProducts();
                $this->load->model('catalog/manufacturer');
                $cart_brands = array();
                foreach ($products as $product) {
                    $res = $this->model_catalog_manufacturer->getManufacturerByProductId($product['product_id']);
                    foreach ($res as $row) {
                        $cart_brands[] = $row['manufacturer_id'];
                    }
                }
                $cart_brands = array_unique($cart_brands);

                return $this->_run_comparison($cart_brands, $condition['value'], $condition['operator']);
                break;

            case 'customers':
                $customer = $this->customer->getId();

                return $this->_run_comparison($customer, $condition['value'], $condition['operator']);
                break;

            case 'customer_groups':
                $customer_group = $this->customer->getCustomerGroupId();

                return $this->_run_comparison($customer_group, $condition['value'], $condition['operator']);
                break;

            case 'customer_country':
            case 'customer_postcode':
                $address_id = $this->session->data['shipping_address_id'];
                $address_id = !$address_id ? $this->customer->getAddressId() : $address_id;

                $this->load->model('account/address');
                $res = $this->model_account_address->getAddress($address_id);

                if ('customer_country' == $condition['object']) {
                    $id = (int) $res['country_id'];
                } else {
                    $id = (int) $res['postcode'];
                }

                return $this->_run_comparison($id, $condition['value'], $condition['operator']);
                break;
            case 'order_subtotal':
                $subtotal = $this->cart->getSubtotal();
                if (!in_array($condition['operator'], array('in', 'notin'))) {
                    $condition['value'] = (float) $condition['value'];
                } else {
                    $condition['value'] = explode(',', $condition['value']);
                }

                return $this->_run_comparison($subtotal, $condition['value'], $condition['operator']);
                break;
            case 'order_product_count':

                $products_count = $this->cart->countProducts();
                if (!in_array($condition['operator'], array('in', 'notin'))) {
                    $condition['value'] = (int) $condition['value'];
                } else {
                    $condition['value'] = explode(',', $condition['value']);
                }

                return $this->_run_comparison($products_count, $condition['value'], $condition['operator']);
                break;
            case 'order_product_weight':
                $weight = round($this->cart->getWeight(), 2);
                if (!in_array($condition['operator'], array('in', 'notin'))) {
                    $condition['value'] = round((float) $condition['value'], 2);
                } else {
                    $condition['value'] = explode(',', $condition['value']);
                }

                return $this->_run_comparison($weight, $condition['value'], $condition['operator']);
                break;
            case 'payment_method':
                $payment_method = $this->session->data['payment_method']['id'];

                return $this->_run_comparison($payment_method, $condition['value'], $condition['operator']);
                break;
            case 'shipping_method':
                $shipping_method = $this->session->data['shipping_method']['id'];
                $shipping_method = explode('.', $shipping_method);
                $shipping_method = $shipping_method[0];

                return $this->_run_comparison($shipping_method, $condition['value'], $condition['operator']);
                break;
            case 'coupon_code':
                $coupon_code = $this->session->data['coupon'];

                return $this->_run_comparison($coupon_code, $condition['value'], $condition['operator']);
                break;
        }

        return $result;
    }

    /**
     * @param mixed $value1
     * @param mixed $value2
     * @param string $operator
     *
     * @return bool
     */
    private function _run_comparison($value1, $value2, $operator)
    {
        switch ($operator) {
            case 'eq':
                return $value1 == $value2;
                break;
            case 'neq':
                return $value1 != $value2;
                break;
            case 'eqlt':
                return $value1 <= $value2;
                break;
            case 'eqgt':
                return $value1 >= $value2;
                break;
            case 'lt':
                return $value1 < $value2;
                break;
            case 'gt':
                return $value1 > $value2;
                break;
            case 'in':
                $value2 = (array) $value2;
                if (!is_array($value1)) {
                    return in_array($value1, $value2);
                } else {
                    return array_intersect($value1, $value2) ? true : false;
                }
                break;
            case 'notin':
                $value2 = (array) $value2;
                if (!is_array($value1)) {
                    return !in_array($value1, $value2);
                } else {
                    return !array_intersect($value1, $value2) ? true : false;
                }
                break;
            case 'notin2':

                  $value2 = (array) $value2; //condition
                  //$this->log->write(' +++++++++++++++ ');
                  //$this->log->write(print_r($value2, true) . ' $value2=conditions');
                  //$this->log->write(print_r($value1, true) . ' $value1=cart');
                  //$this->log->write(print_r(in_array($value1, $value2), true) . ' :in_array');

                  //$this->log->write(print_r(array_intersect($value1, $value2), true) . ' :array_intersect----------------');
                  //$this->log->write(print_r(array_diff($value1, $value2), true) . ' :array_diff');
                  if (!is_array($value1)) { // cart objects
                      return !in_array($value1, $value2);
                  } else {
                      if (!array_intersect($value1, $value2)) {
                          //$this->log->write(' !array_intersect so=TRUE');
                          return true;
                      } else {
                          //return false;
                          return !array_diff($value1, $value2) ? false : true;
                      }
                      //return !array_intersect($value1, $value2) ? true : false;
                  }
                break;
            case 'ctn':
                return is_int(strpos((string) $value1, (string) $value2)) ? true : false;
                break;
            case 'nctn':
                return !is_int(strpos((string) $value1, (string) $value2)) ? true : false;
                break;
            default:
                return false;
                break;
        }
    }

    /**
     * @param string $promotions_name
     * @param array $bonuses
     * @promotion all data
     *
     * @return bool
     */
    private function _apply_bonuses($promotions_name, $bonuses, $promotion)
    {
        $applied = array();
        $discount = 0;

        foreach ($bonuses as $bonus) {
            if (!in_array($bonus['object'], $applied)) {
                $bonus_discount = $this->_process_bonus($bonus, $promotion);
                //$this->log->write(print_r($bonus, true) . ' Bonus OBJEXT');
                if (($discount + $bonus_discount) > $this->total) {
                    break; // prevent negative total
                }
                $discount += $bonus_discount;
            }
            $applied[] = $bonus['object']; //order_discount
        }
        if ($discount) {
            //$this->log->write(print_r($discount, true) . ' $discount detected in Pr_apply_bonuses function');
            $this->total_data[] = array(
                'id' => 'promotion',
                'title' => $promotions_name,
                'text' => ' - ' . $this->currency->format($discount),
                'value' => -$discount,
                'sort_order' => $this->config->get('promotion_total_sort_order'),
                'total_type' => $this->config->get('promotion_total_total_type'),
            );
            $this->total -= $discount;
            foreach ($this->cart->getProducts() as $product) {
                if ($product['tax_class_id']) {
                    $this->taxes[$product['tax_class_id']]['total'] -= $discount;
                    $this->taxes[$product['tax_class_id']]['tax'] -= $this->tax->calcTotalTaxAmount($product['total'], $product['tax_class_id']) - $this->tax->calcTotalTaxAmount($product['total'] - $discount, $product['tax_class_id']);
                }
            }

            return true;
        }

        return false;
    }

    /**
     * @param array $bonus
     * @promotion all data
     *
     * @return bool|float|int|null
     */
    private function _process_bonus($bonus, $promotion)
    {
        //$this->log->write(print_r($bonus, true) . ' $bonus detected in _process_bonus function');
        //$this->log->write(print_r($promotion, true) . ' $promotion all data in  _process_bonus function');
        $bonus['value'] = !isset($bonus['value']) ? array() : $bonus['value'];
        $discount = 0;
        switch ($bonus['object']) {
            case 'order_discount':
                $subtotal = false;
                foreach ($this->total_data as $item) {
                    if ('subtotal' == $item['id']) {
                        $subtotal = $item['value'];
                        break;
                    }
                }
                if (false === $subtotal) {
                    return null;
                }

                //remove "not in but others" from discount
                $products = $this->cart->getProducts();
                foreach ($products as $product) {
                    $products_ids[] = $product['product_id'];
                }
                $pb_excluded = $cb_excluded = array();
                foreach ($promotion['conditions']['conditions'] as $promotioncond) {
                    //$this->log->write(' debug1');
                    //stage 1 remove with notin2 Productscondition
                    $this->load->model('catalog/product');

                    if ($promotioncond['object'] == 'products' and $promotioncond['operator'] == 'notin2') {
                        //$productstoremove = $promotioncond['value'];
                        if (array_intersect($products_ids, $promotioncond['value'])) {
                            $pb_excluded = array_diff($products_ids, $promotioncond['value']);
                            //$this->log->write(print_r($pb_excluded, true) . ' $pb_excluded all data in  _process_bonus function');
                        }
                    }

                    //stage 2 remove with notin2 Category condition
                    //parse current categories in cart?
                    if ($promotioncond['object'] == 'categories' and $promotioncond['operator'] == 'notin2') {
                        //$categoriestoremove = $promotioncond['value'];
                        $cart_categories = array();
                        foreach ($products as $productc) {
                            $res = $this->model_catalog_product->getCategories($productc['product_id']);
                            foreach ($res as $row) {
                                //if $row['category_id'] exist in NOT Allowed $promotioncond['value'] skip?
                                $cart_categories[] = $row['category_id'];
                            }
                        }
                        $cart_categories = array_unique($cart_categories);
                        //$this->log->write(print_r($cart_categories, true) . ' $cart_categories _process_bonus function');
                        if (array_intersect($cart_categories, $promotioncond['value'])) {
                            //$this->log->write(' $cb_excluded array_intersect');
                            $cb_excluded = array_diff($cart_categories, $promotioncond['value']);
                            //$this->log->write(print_r($cb_excluded, true) . ' $cb_excluded all data in  _process_bonus function------');
                        }
                    }

                    if (count($pb_excluded) > 0) {
                        $pre_allowedproducts = $pb_excluded; // cart product exclude products within NOTIN2 conditiom
                        //$this->log->write('detected $pb_excluded in cate++');
                    } else {
                        $pre_allowedproducts = $products_ids;
                    }

                    //find products ids in cart within allowed categories
                    if (count($cb_excluded) > 0) {
                        //$pre_allowedproductscategories = $cb_excluded;
                        foreach ($pre_allowedproducts as $preky => $prev) {
                            //$this->log->write(print_r($prev, true) . ' $prev');
                            $rez = $this->model_catalog_product->getCategories((int) $prev);
                            //if(in_array((int)$prev, )){}

                            foreach ($rez as $roz) {
                                if (in_array($roz['category_id'], $cb_excluded)) {
                                    //allow
                                } else {
                                    //remove product
                                    if (array_key_exists($preky, $pre_allowedproducts)) {
                                        unset($pre_allowedproducts[$preky]);
                                    }
                                }
                                //if $roz['category_id'] exist in NOT Allowed $promotioncond['value'] skip
                            //$cart_categories[] = $roz['category_id'];
                            }
                        }
                    }
                    //calc new subtotal to apply bonus
                }
                //$this->log->write(print_r($pre_allowedproducts, true) . ' ALLOWED Product IDs TO CALC');
                if (count($pre_allowedproducts) > 0) {
                    //$cart_products
                    //$this->log->write(print_r($this->cart->getProducts(), true) . ' all products in the cart');
                    $newsubtotal = 0;
                    foreach ($products as $producta) {
                        if (in_array($producta['product_id'], $pre_allowedproducts)) {
                            //calculate
                            $newsubtotal += $producta['quantity'] * $producta['price'];
                        }
                        //$products_ids[] = $producta['product_id'];
                    }
                    $discount = $this->_get_discount($bonus['operator'], $newsubtotal, $bonus['value']);
                } else {
                    //skip and do not apply any bonus?
                    //$discount = $this->_get_discount($bonus['operator'], $subtotal, $bonus['value']);
                }

                break;
            case 'free_shipping':
                $shipping_cost = false;
                foreach ($this->total_data as $item) {
                    if ('shipping' == $item['id']) {
                        $shipping_method = $this->session->data['shipping_method']['id'];
                        $shipping_method = explode('.', $shipping_method);
                        $shipping_method = $shipping_method[0];

                        if (in_array($shipping_method, $bonus['value'])) {
                            $shipping_cost = $item['value'];
                            break;
                        }
                    }
                }
                if (false === $shipping_cost) {
                    return null;
                }
                $discount = $shipping_cost;
                break;
            case 'discount_products':
                $products = $this->cart->getProducts();
                foreach ($products as $product) {
                    if (in_array($product['product_id'], array_keys($bonus['products']))) {
                        $total = $product['price'] * $bonus['products'][$product['product_id']]['quantity'];
                        $discount += $this->_get_discount($bonus['operator'], $total, $bonus['value']);
                        unset($bonus['products'][$products['product_id']]); // prevent repetition of bonus
                    }
                }
                break;
            case 'free_products':
                $products = $this->cart->getProducts();
                foreach ($products as $product) {
                    if (in_array($product['product_id'], array_keys($bonus['products']))) {
                        $discount += $product['price'] * $bonus['products'][$product['product_id']]['quantity'];
                        unset($bonus['products'][$products['product_id']]); // prevent repetition of bonus
                    }
                }
                break;
        }

        return $discount;
    }

    private function _get_discount($operator, $price, $value)
    {
        $discount = 0;

        if ('to_prc' == $operator) {
            $discount = $price * (100 - $value) / 100;
        } elseif ('by_prc' == $operator) {
            $discount = $price * $value / 100;
        } elseif ('to_fixed' == $operator) {
            $discount = $price - $value;
        } elseif ('by_fixed' == $operator) {
            $discount = $value;
        }

        if ($discount < 0) {
            $discount = 0;
        }

        return $discount;
    }
}
