<?php

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

/**
 * @property ModelSalePromotion $model_sale_promotion
 * @property Aform              $form
 */
class ControllerResponsesListingGridPromotion extends AController
{
    public $data = array();
    private $error = array();
    protected $form;

    public function main()
    {
        //init controller data
        $this->extensions->hk_InitData($this, __FUNCTION__);

        $this->loadLanguage('promotion/promotion');
        $this->loadModel('sale/promotion');

        //Prepare filter config
        $grid_filter_params = array('name');
        $filter = new AFilter(array('method' => 'post', 'grid_filter_params' => $grid_filter_params));
        $filter_data = $filter->getFilterData();

        $total = $this->model_sale_promotion->getPromotions($filter_data, 'total_only');
        $response = new stdClass();
        $response->page = $filter->getParam('page');
        $response->total = $filter->calcTotalPages($total);
        $response->records = $total;
        $response->userdata = (object) array('');
        $results = $this->model_sale_promotion->getPromotions($filter_data);

        $results = !$results ? array() : $results;

        $i = 0;
        foreach ($results as $result) {
            $daterange = dateISO2Display($result['start_date'], $this->language->get('date_format_short'));
            if ('0000-00-00 00:00:00' != $result['end_date']) {
                $daterange .= ' - '.dateISO2Display($result['end_date'], $this->language->get('date_format_short'));
            } else {
                $daterange .= ' - '.$this->language->get('promotion_no_expiration');
            }

            $response->rows[$i]['id'] = $result['promotion_id'];
            $response->rows[$i]['cell'] = array(
                    $result['name'],
                    $this->html->buildInput(array(
                            'name' => 'priority['.$result['promotion_id'].']',
                            'value' => $result['priority'],
                    )),
                    $daterange,
                    $this->html->buildCheckbox(array(
                            'name' => 'status['.$result['promotion_id'].']',
                            'value' => $result['status'],
                            'style' => 'btn_switch',
                    )),
            );
            ++$i;
        }
        //update controller data
        $this->extensions->hk_UpdateData($this, __FUNCTION__);

        $this->load->library('json');
        $this->response->setOutput(AJson::encode($response));
    }

    public function getFieldsByConditionObject($value)
    {
        $this->loadLanguage('promotion/promotion');

        $promo = new APromotion();
        $cond_objects = $promo->getConditionObjects();
        if (!in_array($this->request->post['condition_object'], $cond_objects)) {
            return null;
        }

        $this->form = new AForm('HT');
        $this->form->setForm(array(
                'form_name' => 'promotionFrm',
                'update' => $this->html->getSecureURL('listing_grid/promotion/update_field', '&promotion_id='.$this->request->get['promotion_id']),
        ));
        $method = '_getFieldsFor'.str_replace(' ', '', ucwords(str_replace('_', ' ', $this->request->post['condition_object'])));

        if (method_exists($this, $method)) {
            $response = call_user_func(array($this, $method), $value);
        }
        if ($response['fields']) {
            $value = $this->request->post['condition_object'];
            $response['fields'] .= $this->form->getFieldHtml(
                    array(
                            'type' => 'hidden',
                            'name' => 'conditions[conditions]['.$this->request->post['idx'].'][object]',
                            'value' => $value,
                    )
            );
        }

        $this->load->library('json');
        $this->response->setOutput(AJson::encode($response));
    }

    /** @noinspection PhpUnusedPrivateMethodInspection */
    private function _getFieldsForProducts($value = '')
    {
        $listing_data = array();
        if (is_array($value['value']) && $value['value']) {
            $this->loadModel('catalog/product');
            $filter = array('subsql_filter' => 'p.product_id in ('.implode(',', $value['value']).')');

            $results = $this->model_catalog_product->getProducts($filter);
            if ($results) {
                $resource = new AResource('image');
                foreach ($results as $r) {
                    $product_id = $r['product_id'];
                    $thumbnail = $resource->getMainThumb(
                            'products',
                            $product_id,
                            (int) $this->config->get('config_image_grid_width'),
                            (int) $this->config->get('config_image_grid_height'),
                            true);
                    $listing_data[$product_id]['name'] = $r['name'].' ('.$r['model'].')';
                    $listing_data[$product_id]['image'] = $thumbnail['thumb_html'];
                }
            }
        }

        $response['text'] = $this->language->get('entry_products');
        $response['fields'] = $this->form->getFieldHtml(
                array('type' => 'selectbox',
                       'name' => 'conditions[conditions]['.$this->request->post['idx'].'][operator]',
                       'options' => array(
                               'in' => $this->language->get('text_in'),
                               'notin' => $this->language->get('text_not_in'),
                                                             'notin2' => $this->language->get('text_not_in2'),
                       ),
                       'value' => $value['operator'],
                ));

        $response['fields'] .= $this->form->getFieldHtml(
                array(
                        'type' => 'multiselectbox',
                        'name' => 'conditions[conditions]['.$this->request->post['idx'].'][value][]',
                        'value' => !$value ? '' : $value['value'],
                        'options' => $listing_data,
                        'style' => 'chosen',
                        'ajax_url' => $this->html->getSecureURL('r/product/product/products'),
                        'placeholder' => $this->language->get('text_select_from_lookup'),
                ));

        return $response;
    }

    private function _getFieldsForProductPrice($value = array())
    {
        $response['text'] = $this->language->get('entry_product_price');
        $response['fields'] = $this->form->getFieldHtml(
                array('type' => 'selectbox',
                       'name' => 'conditions[conditions]['.$this->request->post['idx'].'][operator]',
                       'options' => array(
                               'eq' => $this->language->get('text_equal'),
                               'neq' => $this->language->get('text_not_equal'),
                               'eqlt' => $this->language->get('text_equal_or_less'),
                               'eqgt' => $this->language->get('text_equal_or_greater'),
                               'lt' => $this->language->get('text_less'),
                               'gt' => $this->language->get('text_greater'),
                       ),
                       'value' => $value['operator'],
                ));
        $response['fields'] .= $this->form->getFieldHtml(
                array('type' => 'input',
                       'name' => 'conditions[conditions]['.$this->request->post['idx'].'][value]',
                       'value' => !$value ? '' : $value['value'],
                       'style' => 'small-field',
                )
        );
        $response['fields'] .= '('.$this->config->get('config_currency').')';

        return $response;
    }

    private function _getFieldsForCategories($value = '')
    {
        $response['text'] = $this->language->get('entry_categories');
        $response['fields'] = $this->form->getFieldHtml(
                array('type' => 'selectbox',
                       'name' => 'conditions[conditions]['.$this->request->post['idx'].'][operator]',
                       'options' => array(
                               'in' => $this->language->get('text_in'),
                               'notin' => $this->language->get('text_not_in'),
                                                             'notin2' => $this->language->get('text_not_in2'),
                       ),
                       'value' => !$value ? '' : $value['operator'],
                ));
        $this->loadModel('catalog/category');
        $results = $this->model_catalog_category->getCategories(0);
        foreach ($results as $r) {
            $categories[$r['category_id']] = $r['name'];
        }

        $response['fields'] .= $this->form->getFieldHtml(array(
                'type' => 'checkboxgroup',
                'name' => 'conditions[conditions]['.$this->request->post['idx'].'][value][]',
                'value' => !$value ? '' : $value['value'],
                'options' => $categories,
                'style' => 'chosen',
                'placeholder' => $this->language->get('text_select_category'),
        ));

        return $response;
    }

    private function _getFieldsForBrands($value = '')
    {
        $response['text'] = $this->language->get('entry_brands');
        $response['fields'] = $this->form->getFieldHtml(
                array('type' => 'selectbox',
                       'name' => 'conditions[conditions]['.$this->request->post['idx'].'][operator]',
                       'options' => array(
                               'in' => $this->language->get('text_in'),
                               'notin' => $this->language->get('text_not_in'),
                       ),
                       'value' => !$value ? '' : $value['operator'],
                ));
        $this->loadModel('catalog/manufacturer');
        $results = $this->model_catalog_manufacturer->getManufacturers();
        foreach ($results as $r) {
            $manufacturers[$r['manufacturer_id']] = $r['name'];
        }
        $response['fields'] .= $this->form->getFieldHtml(array(
                'type' => 'checkboxgroup',
                'name' => 'conditions[conditions]['.$this->request->post['idx'].'][value][]',
                'value' => !$value ? '' : $value['value'],
                'options' => $manufacturers,
                'style' => 'chosen',
                'placeholder' => $this->language->get('text_select_manufacturer'),
        ));

        return $response;
    }

    private function _getFieldsForCustomers($value = '')
    {
        $listing_data = array();
        if (is_array($value['value'])) {
            $this->loadModel('sale/customer');
            foreach ($value['value'] as $customer_id) {
                $result = $this->model_sale_customer->getCustomer($customer_id);
                $listing_data[$customer_id] = $result['firstname'].' '.$result['lastname'];
            }
        }

        $response['text'] = $this->language->get('entry_customers');
        $response['fields'] = $this->form->getFieldHtml(
                array('type' => 'selectbox',
                       'name' => 'conditions[conditions]['.$this->request->post['idx'].'][operator]',
                       'options' => array(
                               'in' => $this->language->get('text_in'),
                               'notin' => $this->language->get('text_not_in'),
                       ),
                       'value' => !$value ? '' : $value['operator'],
                ));

        $response['fields'] .= $this->form->getFieldHtml(array(
                'type' => 'multiselectbox',
                'name' => 'conditions[conditions]['.$this->request->post['idx'].'][value][]',
                'value' => !$value ? '' : $value['value'],
                'options' => $listing_data,
                'style' => 'chosen',
                'ajax_url' => $this->html->getSecureURL('r/listing_grid/customer/customers'),
                'placeholder' => $this->language->get('text_select_from_lookup'),
        ));

        return $response;
    }

    private function _getFieldsForCustomerGroups($value = '')
    {
        $response['text'] = $this->language->get('entry_customer_groups');
        $response['fields'] = $this->form->getFieldHtml(
                array('type' => 'selectbox',
                       'name' => 'conditions[conditions]['.$this->request->post['idx'].'][operator]',
                       'options' => array(
                               'in' => $this->language->get('text_in'),
                               'notin' => $this->language->get('text_not_in'),
                       ),
                       'value' => $value['operator'],
                ));
        $this->loadModel('sale/customer_group');
        $results = $this->model_sale_customer_group->getCustomerGroups();
        foreach ($results as $r) {
            $customers[$r['customer_group_id']] = $r['name'].(($r['customer_group_id'] == $this->config->get('config_customer_group_id')) ? $this->language->get('text_default') : null);
        }

        $response['fields'] .= $this->form->getFieldHtml(array(
                'type' => 'checkboxgroup',
                'name' => 'conditions[conditions]['.$this->request->post['idx'].'][value][]',
                'value' => !$value ? '' : $value['value'],
                'options' => $customers,
                'scrollbox' => true,
        ));

        return $response;
    }

    private function _getFieldsForCustomerCountry($value = '')
    {
        $response['text'] = $this->language->get('entry_customer_country');
        $response['fields'] = $this->form->getFieldHtml(
                array('type' => 'selectbox',
                       'name' => 'conditions[conditions]['.$this->request->post['idx'].'][operator]',
                       'options' => array(
                               'in' => $this->language->get('text_in'),
                               'notin' => $this->language->get('text_not_in'),
                       ),
                       'value' => $value['operator'],
                ));
        $this->loadModel('localisation/country');
        $results = $this->model_localisation_country->getCountries();
        foreach ($results as $r) {
            $countries[$r['country_id']] = $r['name'];
        }

        $response['fields'] .= $this->form->getFieldHtml(array(
                'type' => 'checkboxgroup',
                'name' => 'conditions[conditions]['.$this->request->post['idx'].'][value][]',
                'value' => !$value ? '' : $value['value'],
                'options' => $countries,
                'scrollbox' => true,
        ));

        return $response;
    }

    private function _getFieldsForCustomerPostCode($value = '')
    {
        $response['text'] = $this->language->get('entry_customer_postcode');
        $response['fields'] = $this->form->getFieldHtml(
                array('type' => 'selectbox',
                       'name' => 'conditions[conditions]['.$this->request->post['idx'].'][operator]',
                       'options' => array(
                               'eq' => $this->language->get('text_equal'),
                               'neq' => $this->language->get('text_not_equal'),
                               'ctn' => $this->language->get('text_contain'),
                               'nctn' => $this->language->get('text_not_contain'),
                               'in' => $this->language->get('text_in_comma'),
                               'notin' => $this->language->get('text_not_in_comma'),
                       ),
                       'value' => $value['operator'],
                ));
        $response['fields'] .= $this->form->getFieldHtml(
                array('type' => 'input',
                       'name' => 'conditions[conditions]['.$this->request->post['idx'].'][value]',
                       'value' => (is_array($value['value']) ? implode(', ', $value['value']) : $value['value']),
                       'style' => 'medium-field',
                )
        );

        return $response;
    }

    private function _getFieldsForOrderSubtotal($value = '')
    {
        $response['text'] = $this->language->get('entry_order_subtotal');
        $response['fields'] = $this->form->getFieldHtml(
                array('type' => 'selectbox',
                       'name' => 'conditions[conditions]['.$this->request->post['idx'].'][operator]',
                       'options' => array(
                               'eq' => $this->language->get('text_equal'),
                               'neq' => $this->language->get('text_not_equal'),
                               'eqlt' => $this->language->get('text_equal_or_less'),
                               'eqgt' => $this->language->get('text_equal_or_greater'),
                               'lt' => $this->language->get('text_less'),
                               'gt' => $this->language->get('text_greater'),
                               'in' => $this->language->get('text_in_comma'),
                               'notin' => $this->language->get('text_not_in_comma'),
                       ),
                       'value' => !$value ? '' : $value['operator'],
                ));
        $response['fields'] .= $this->form->getFieldHtml(
                array('type' => 'input',
                       'name' => 'conditions[conditions]['.$this->request->post['idx'].'][value]',
                       'value' => !$value ? '' : $value['value'],
                       'style' => 'medium-field',
                )
        );
        $response['fields'] .= '('.$this->config->get('config_currency').')';

        return $response;
    }

    private function _getFieldsForOrderProductCount($value = '')
    {
        $response['text'] = $this->language->get('entry_order_product_count');
        $response['fields'] = $this->form->getFieldHtml(
                array('type' => 'selectbox',
                       'name' => 'conditions[conditions]['.$this->request->post['idx'].'][operator]',
                       'options' => array(
                               'eq' => $this->language->get('text_equal'),
                               'neq' => $this->language->get('text_not_equal'),
                               'eqlt' => $this->language->get('text_equal_or_less'),
                               'eqgt' => $this->language->get('text_equal_or_greater'),
                               'lt' => $this->language->get('text_less'),
                               'gt' => $this->language->get('text_greater'),
                               'in' => $this->language->get('text_in_comma'),
                               'notin' => $this->language->get('text_not_in_comma'),
                       ),
                       'value' => !$value ? '' : $value['operator'],
                ));
        $response['fields'] .= $this->form->getFieldHtml(
                array('type' => 'input',
                       'name' => 'conditions[conditions]['.$this->request->post['idx'].'][value]',
                       'value' => !$value ? '' : $value['value'],
                       'style' => 'medium-field',
                )
        );

        return $response;
    }

    private function _getFieldsForOrderProductWeight($value = '')
    {
        $response['text'] = $this->language->get('entry_order_product_weight');
        $response['fields'] = $this->form->getFieldHtml(
                array('type' => 'selectbox',
                       'name' => 'conditions[conditions]['.$this->request->post['idx'].'][operator]',
                       'options' => array(
                               'eq' => $this->language->get('text_equal'),
                               'neq' => $this->language->get('text_not_equal'),
                               'eqlt' => $this->language->get('text_equal_or_less'),
                               'eqgt' => $this->language->get('text_equal_or_greater'),
                               'lt' => $this->language->get('text_less'),
                               'gt' => $this->language->get('text_greater'),
                               'in' => $this->language->get('text_in_comma'),
                               'notin' => $this->language->get('text_not_in_comma'),
                       ),
                       'value' => $value['operator'],
                ));
        $response['fields'] .= $this->form->getFieldHtml(
                array('type' => 'input',
                       'name' => 'conditions[conditions]['.$this->request->post['idx'].'][value]',
                       'value' => (is_array($value['value']) ? implode(', ', $value['value']) : $value['value']),
                       'style' => 'medium-field',
                )
        );
        $response['fields'] .= '('.$this->config->get('config_weight_class').')';

        return $response;
    }

    private function _getFieldsForPaymentMethod($value = '')
    {
        $response['text'] = $this->language->get('entry_payment_method');
        $response['fields'] = $this->form->getFieldHtml(
                array('type' => 'selectbox',
                       'name' => 'conditions[conditions]['.$this->request->post['idx'].'][operator]',
                       'options' => array(
                               'in' => $this->language->get('text_in'),
                               'notin' => $this->language->get('text_not_in'),
                       ),
                       'value' => $value['operator'],
                ));
        $exts = new ExtensionsApi();
        $results = $exts->getInstalled('payment');
        foreach ($results as $r) {
            $options[$r] = $exts->getExtensionName($r);
        }

        $response['fields'] .= $this->form->getFieldHtml(array(
                'type' => 'checkboxgroup',
                'name' => 'conditions[conditions]['.$this->request->post['idx'].'][value][]',
                'value' => !$value ? '' : $value['value'],
                'options' => $options,
                'scrollbox' => true,
        ));

        return $response;
    }

    private function _getFieldsForShippingMethod($value = '')
    {
        $response['text'] = $this->language->get('entry_shipping_method');
        $response['fields'] = $this->form->getFieldHtml(
                array('type' => 'selectbox',
                       'name' => 'conditions[conditions]['.$this->request->post['idx'].'][operator]',
                       'options' => array(
                               'in' => $this->language->get('text_in'),
                               'notin' => $this->language->get('text_not_in'),
                       ),
                       'value' => !$value ? '' : $value['operator'],
                ));
        $exts = new ExtensionsApi();
        $results = $exts->getInstalled('shipping');
        foreach ($results as $r) {
            $options[$r] = $exts->getExtensionName($r);
        }

        $response['fields'] .= $this->form->getFieldHtml(array(
                'type' => 'checkboxgroup',
                'name' => 'conditions[conditions]['.$this->request->post['idx'].'][value][]',
                'value' => !$value ? '' : $value['value'],
                'options' => $options,
                'scrollbox' => true,
        ));

        return $response;
    }

    private function _getFieldsForCouponCode($value = '')
    {
        $response['text'] = $this->language->get('entry_coupon_code');
        $response['fields'] = $this->form->getFieldHtml(
                array('type' => 'selectbox',
                       'name' => 'conditions[conditions]['.$this->request->post['idx'].'][operator]',
                       'options' => array(
                               'in' => $this->language->get('text_in'),
                               'notin' => $this->language->get('text_not_in'),
                       ),
                       'value' => !$value ? '' : $value['operator'],
                ));
        $response['fields'] .= $this->form->getFieldHtml(
                array('type' => 'input',
                       'name' => 'conditions[conditions]['.$this->request->post['idx'].'][value]',
                       'value' => !$value ? '' : $value['value'],
                       'style' => 'large-field',
                )
        );

        return $response;
    }

    //bonus part

    /**
     * @param mixed $value
     *
     * @throws AException
     */
    public function getFieldsByBonusObject($value)
    {
        $this->loadLanguage('promotion/promotion');
        //init controller data
        $this->extensions->hk_InitData($this, __FUNCTION__);

        $promo = new APromotion();
        $bonus_objects = $promo->getBonusObjects();
        if (!in_array($this->request->post['bonus_object'], $bonus_objects)) {
            return null;
        }

        $this->form = new AForm('HT');
        $this->form->setForm(array(
                'form_name' => 'promotionFrm',
                'update' => $this->html->getSecureURL('listing_grid/promotion/update_field',
                        '&promotion_id='.$this->request->get['promotion_id']),
        ));
        $method = '_getBonusFieldsFor'.str_replace(' ', '', ucwords(str_replace('_', ' ', $this->request->post['bonus_object'])));
        if (method_exists($this, $method)) {
            $response = call_user_func(array($this, $method), $value);
        }
        if ($response['fields']) {
            $response['fields'] .= $this->form->getFieldHtml(
                    array('type' => 'hidden',
                           'name' => 'bonuses['.$this->request->post['idx'].'][object]',
                           'value' => $this->request->post['bonus_object'],
                    )
            );
        }

        //update controller data
        $this->extensions->hk_UpdateData($this, __FUNCTION__);
        $this->load->library('json');
        $this->response->setOutput(AJson::encode($response));
    }

    private function _getBonusFieldsForOrderDiscount($value = '')
    {
        $response['text'] = $this->language->get('entry_order_discount');
        $response['fields'] = $this->form->getFieldHtml(
                array('type' => 'selectbox',
                       'name' => 'bonuses['.$this->request->post['idx'].'][operator]',
                       'options' => array(
                               'by_prc' => $this->language->get('text_by_prc'),
                               'to_prc' => $this->language->get('text_to_prc'),
                               'by_fixed' => $this->language->get('text_by_fixed'),
                               'to_fixed' => $this->language->get('text_to_fixed'),
                       ),
                       'value' => !$value ? '' : $value['operator'],
                ));
        $response['fields'] .= $this->form->getFieldHtml(
                array('type' => 'input',
                       'name' => 'bonuses['.$this->request->post['idx'].'][value]',
                       'value' => !$value ? '' : $value['value'],
                       'style' => 'small-field',
                )
        );

        return $response;
    }

    private function _getBonusFieldsForFreeShipping($value = '')
    {
        $response['text'] = $this->language->get('entry_free_shipping');
        $exts = new ExtensionsApi();
        $results = $exts->getInstalled('shipping');
        foreach ($results as $r) {
            $options[$r] = $exts->getExtensionName($r);
        }

        $response['fields'] .= $this->form->getFieldHtml(array(
                'type' => 'checkboxgroup',
                'name' => 'bonuses['.$this->request->post['idx'].'][value][]',
                'value' => !$value ? '' : $value['value'],
                'options' => $options,
                'scrollbox' => true,
        ));

        return $response;
    }

    private function _getBonusFieldsForDiscountProducts($value = '')
    {
        $listing_data = array();
        if (is_array($value['products'])) {
            $this->loadModel('catalog/product');
            $ids = array();
            foreach ($value['products'] as $product) {
                $ids[] = $product['product_id'];
                $quantities[$product['product_id']] = $product['quantity'];
            }

            //prevent sql syntax error
            $ids = !$ids ? array(0) : $ids;

            $filter = array('subsql_filter' => 'p.product_id in ('.implode(',', $ids).')');

            $results = $this->model_catalog_product->getProducts($filter);
            if ($results) {
                $resource = new AResource('image');
                foreach ($results as $r) {
                    $product_id = $r['product_id'];
                    $thumbnail = $resource->getMainThumb(
                            'products',
                            $product_id,
                            (int) $this->config->get('config_image_grid_width'),
                            (int) $this->config->get('config_image_grid_height'),
                            true);
                    $listing_data[$product_id]['name'] = $r['name'].' ('.$r['model'].')';
                    $listing_data[$product_id]['image'] = $thumbnail['thumb_html']
                            .'&nbsp;'.trim($this->html->buildInput(
                                    array(
                                            'name' => 'discount_products_quantity['.$product_id.']',
                                            'value' => $quantities[$product_id],
                                            'style' => 'small-field',
                                            'placeholder' => 'Input Quantity',
                                    )));
                }
            }
        }

        $response['text'] = $this->language->get('entry_discount_products');

        $response['fields'] = $this->form->getFieldHtml(
                array('type' => 'selectbox',
                       'name' => 'bonuses['.$this->request->post['idx'].'][operator]',
                       'options' => array(
                               'by_prc' => $this->language->get('text_by_prc'),
                               'to_prc' => $this->language->get('text_to_prc'),
                               'by_fixed' => $this->language->get('text_by_fixed'),
                               'to_fixed' => $this->language->get('text_to_fixed'),
                       ),
                       'value' => $value['operator'],
                ));
        $response['fields'] .= $this->form->getFieldHtml(
                array('type' => 'input',
                       'name' => 'bonuses['.$this->request->post['idx'].'][value]',
                       'value' => !$value ? '' : $value['value'],
                       'style' => 'small-field',
                )
        );

        $response['fields'] .= trim($this->form->getFieldHtml(
                array(
                        'type' => 'multiselectbox',
                        'name' => 'bonuses['.$this->request->post['idx'].'][products][]',
                        'value' => $ids,
                        'options' => $listing_data,
                        'style' => 'chosen',
                        'ajax_url' => $this->html->getSecureURL('r/listing_grid/promotion/discount_products'),
                        'placeholder' => $this->language->get('text_select_from_lookup'),
                )));

        return $response;
    }

    public function discount_products($value = '')
    {
        $products = array();
        $products_data = array();

        //init controller data
        $this->extensions->hk_InitData($this, __FUNCTION__);
        $this->loadModel('catalog/product');
        if (isset($this->request->post['term'])) {
            $filter = array('limit' => 20,
                             'content_language_id' => $this->session->data['content_language_id'],
                             'filter' => array(
                                     'keyword' => $this->request->post['term'],
                                     'match' => 'begin',
                             ), );
            $products = $this->model_catalog_product->getProducts($filter);
            $resource = new AResource('image');
            foreach ($products as $pdata) {
                $thumbnail = $resource->getMainThumb('products',
                        $pdata['product_id'],
                        (int) $this->config->get('config_image_grid_width'),
                        (int) $this->config->get('config_image_grid_height'),
                        true);

                if ($this->request->get['currency_code']) {
                    $price = round($this->currency->convert($pdata['price'],
                            $this->config->get('config_currency'),
                            $this->request->get['currency_code']), 2);
                } else {
                    $price = $pdata['price'];
                }

                $frmt_price = $this->currency->format($price, ($this->request->get['currency_code'] ? $this->request->get['currency_code'] : $this->config->get('config_currency')));

                $products_data[] = array(
                        'image' => $thumbnail['thumb_html'].trim($this->html->buildInput(array(
                                        'name' => 'discount_products_quantity['.$pdata['product_id'].']',
                                        'value' => $pdata['quantity'],
                                        'style' => 'small-field',
                                        'placeholder' => 'quantity',
                                ))),
                        'id' => $pdata['product_id'],
                        'name' => $pdata['name'].' - '.$frmt_price,
                        'price' => $price,
                        'meta' => $pdata['model'],
                        'sort_order' => (int) $pdata['sort_order'],
                );
            }
        }

        $this->load->library('json');
        $this->response->addJSONHeader();
        $this->response->setOutput(AJson::encode($products_data));
    }

    private function _getBonusFieldsForFreeProducts($value = '')
    {
        $listing_data = array();
        if (is_array($value['products'])) {
            $this->loadModel('catalog/product');
            $ids = array();
            foreach ($value['products'] as $product) {
                $ids[] = $product['product_id'];
            }

            //prevent sql syntax error
            $ids = !$ids ? array(0) : $ids;

            $filter = array('subsql_filter' => 'p.product_id in ('.implode(',', $ids).')');

            $results = $this->model_catalog_product->getProducts($filter);
            if ($results) {
                $resource = new AResource('image');
                foreach ($results as $r) {
                    $product_id = $r['product_id'];
                    $thumbnail = $resource->getMainThumb(
                            'products',
                            $product_id,
                            (int) $this->config->get('config_image_grid_width'),
                            (int) $this->config->get('config_image_grid_height'),
                            true);
                    $listing_data[$product_id]['name'] = $r['name'].' ('.$r['model'].')';
                    $listing_data[$product_id]['image'] = $thumbnail['thumb_html'];
                }
            }
        }

        $response['text'] = $this->language->get('entry_free_products');
        $response['fields'] = $this->form->getFieldHtml(
                array(
                        'type' => 'multiselectbox',
                        'name' => 'bonuses['.$this->request->post['idx'].'][products][]',
                        'value' => $ids,
                        'options' => $listing_data,
                        'style' => 'chosen',
                        'ajax_url' => $this->html->getSecureURL('r/product/product/products'),
                        'placeholder' => $this->language->get('text_select_from_lookup'),
                ));

        return $response;
    }

    /**
     * update only one field.
     */
    public function update_field()
    {
        //init controller data
        $this->extensions->hk_InitData($this, __FUNCTION__);

        $this->loadLanguage('promotion/promotion');
        if (!$this->user->canModify('listing_grid/promotion')) {
            $error = new AError('');

            return $error->toJSONResponse('NO_PERMISSIONS_402',
                    array('error_text' => sprintf($this->language->get('error_permission_modify'), 'promotion/promotion'),
                           'reset_value' => true,
                    ));
        }

        $this->loadModel('sale/promotion');
        $fields_list = array('name', 'status', 'priority', 'description_short', 'stop', 'start_date', 'end_date');
        if (isset($this->request->get['promotion_id'])) {
            //request sent from edit form. ID in url
            foreach ($this->request->post as $field => $value) {
                if (!in_array($field, $fields_list)) {
                    continue;
                }
                $this->model_sale_promotion->editPromotion($this->request->get['promotion_id'], array($field => $value));
            }

            return;
        }

        //request sent from jGrid. ID is key of array
        foreach ($this->request->post as $field => $value) {
            if (!in_array($field, $fields_list)) {
                continue;
            }
            foreach ($value as $k => $v) {
                $this->model_sale_promotion->editPromotion($k, array($field => $v));
            }
        }

        //update controller data
        $this->extensions->hk_UpdateData($this, __FUNCTION__);
    }

    public function update()
    {
        //init controller data
        $this->extensions->hk_InitData($this, __FUNCTION__);

        $this->loadModel('sale/promotion');
        $this->loadLanguage('promotion/promotion');
        if (!$this->user->canModify('listing_grid/promotion')) {
            $error = new AError('');

            return $error->toJSONResponse('NO_PERMISSIONS_402',
                    array('error_text' => sprintf($this->language->get('error_permission_modify'), 'listing_grid/promotion'),
                           'reset_value' => true,
                    ));
        }

        switch ($this->request->post['oper']) {
            case 'del':
                $ids = explode(',', $this->request->post['id']);
                if (!empty($ids)) {
                    foreach ($ids as $id) {
                        $this->model_sale_promotion->deletePromotion($id);
                    }
                }
                break;
            case 'save':
                $allowedFields = array('priority');
                $ids = explode(',', $this->request->post['id']);
                if (!empty($ids)) {
                    foreach ($ids as $id) {
                        foreach ($allowedFields as $field) {
                            $this->model_sale_promotion->editPromotion($id, array($field => $this->request->post[$field][$id]));
                        }
                    }
                }
                break;

            default:
        }

        //update controller data
        $this->extensions->hk_UpdateData($this, __FUNCTION__);
    }
}
