<?php


if(!defined('DIR_CORE')){
	header('Location: static_pages/');
}

/**
 * @property ModelSalePromotion $model_sale_promotion
 */
class ControllerPagesSalePromotion extends AController{

	public $data = array();
	private $error = array();

	public function main(){

		//init controller data
		$this->extensions->hk_InitData($this, __FUNCTION__);

		$this->loadLanguage('promotion/promotion');

		$this->document->setTitle($this->language->get('promotion_name'));
		$this->view->assign('help_url', $this->gen_help_url('sale_promotion'));

		$this->document->initBreadcrumb(array(
				'href'      => $this->html->getSecureURL('index/home'),
				'text'      => $this->language->get('text_home'),
				'separator' => false
		));
		$this->document->addBreadcrumb(array(
				'href'      => $this->html->getSecureURL('sale/promotion'),
				'text'      => $this->language->get('promotion_name'),
				'separator' => ' :: ',
				'current'   => true
		));

		$this->view->assign('error_warning', $this->error['warning']);
		$this->view->assign('success', $this->session->data['success']);
		$this->view->assign('heading_title', $this->language->get('promotion_name'));
		if(isset($this->session->data['success'])){
			unset($this->session->data['success']);
		}

		$grid_settings = array(
				'table_id'     => 'promotion_grid',
				'url'          => $this->html->getSecureURL('listing_grid/promotion'),
				'editurl'      => $this->html->getSecureURL('listing_grid/promotion/update'),
				'update_field' => $this->html->getSecureURL('listing_grid/promotion/update_field'),
				'sortname'     => 'priority',
				'sortorder'    => 'asc',
				'actions'      => array(
						'edit'   => array(
								'text' => $this->language->get('text_edit'),
								'href' => $this->html->getSecureURL('sale/promotion/edit', '&promotion_id=%ID%')
						),
						'save'   => array(
								'text' => $this->language->get('button_save'),
						),
						'delete' => array(
								'text' => $this->language->get('button_delete'),
						)
				),
		);

		$grid_settings['colNames'] = array(
				$this->language->get('column_name'),
				$this->language->get('column_priority'),
				$this->language->get('column_daterange'),
				$this->language->get('column_status'),
		);
		$grid_settings['colModel'] = array(
				array(
						'name'  => 'name',
						'index' => 'name',
						'width' => 240,
						'align' => 'center',
				),
				array(
						'name'   => 'priority',
						'index'  => 'priority',
						'width'  => 90,
						'align'  => 'center',
						'search' => false,
				),
				array(
						'name'   => 'daterange',
						'index'  => 'daterange',
						'width'  => 150,
						'align'  => 'center',
						'search' => false,
				),
				array(
						'name'   => 'status',
						'index'  => 'status',
						'align'  => 'center',
						'search' => false)
		);


		$grid = $this->dispatch('common/listing_grid', array($grid_settings));
		$this->view->assign('listing_grid', $grid->dispatchGetOutput());
		$this->view->assign('grid_url', $this->html->getSecureURL('listing_grid/promotion'));

		$this->document->setTitle($this->language->get('promotion_name'));
		$this->view->assign('insert', $this->html->getSecureURL('sale/promotion/insert'));
		$this->view->assign('form_language_switch', $this->html->getContentLanguageSwitcher());

		$this->processTemplate('pages/sale/promotion.tpl');

		//update controller data
		$this->extensions->hk_UpdateData($this, __FUNCTION__);

	}

	public function insert(){

		//init controller data
		$this->extensions->hk_InitData($this, __FUNCTION__);
		$this->loadLanguage('promotion/promotion');

		//need to reset exclude list for multivalue list which can be set by other multivalue lists (for ex. form of downloads for products)
		$this->session->data['multivalue_excludes'] = array();

		$this->document->setTitle($this->language->get('promotion_name'));

		if($this->request->is_POST() && $this->_validateForm()){


			$this->loadModel('sale/promotion');
			$promotion_id = $this->model_sale_promotion->addPromotion($this->request->post);

			$this->session->data ['success'] = $this->language->get('text_success_create');
			$this->redirect($this->html->getSecureURL('sale/promotion/edit', '&tab=conditions&promotion_id=' . $promotion_id));

		}

		foreach($this->request->post as $k => $v){
			$this->data[$k] = $v;
		}
		$this->data['tabs'][] = array(
				'href'   => 'Javascript: void(0);',
				'text'   => $this->language->get('text_general'),
				'active' => true);

		$this->_getFormGeneral();

		//update controller data
		$this->extensions->hk_UpdateData($this, __FUNCTION__);
	}

	public function edit(){
		//init controller data
		$this->extensions->hk_InitData($this, __FUNCTION__);
		$this->loadLanguage('promotion/promotion');

		$this->document->setTitle($this->language->get('promotion_name'));
		$this->data['heading_title'] = $this->language->get('promotion_name');
		$promotion_id = (int)$this->request->get['promotion_id'];

		//need to reset exclude list for multivalue list which can be set by other multivalue lists (for ex. form of downloads for products)
		$this->session->data['multivalue_excludes'] = array();

		$this->loadModel('sale/promotion');
		// saving
		if($this->request->is_POST()){//&& $this->_validateForm() && $promotion_id) {
			if(isset($this->request->post['conditions']['conditions'])){
				foreach($this->request->post['conditions']['conditions'] as $k => $rule){

					if($rule['object'] == 'customer_postcode'){
						if(in_array($this->request->post['conditions']['conditions'][$k]['operator'], array('in', 'notin'))){
							$temp = explode(',', $this->request->post['conditions']['conditions'][$k]['value']);
							foreach($temp as &$postcode){
								$postcode = preg_replace("/[^0-9]/", '', $postcode);
							}
							$this->request->post['conditions']['conditions'][$k]['value'] = $temp;
							unset($temp);
						} else{
							$this->request->post['conditions']['conditions'][$k]['value'] = preg_replace("/[^0-9]/", '', $this->request->post['conditions']['conditions'][$k]['value']);
						}
					}
					if($rule['object'] == 'order_product_weight' || $rule['object'] == 'order_subtotal'){
						if(in_array($this->request->post['conditions']['conditions'][$k]['operator'], array('in', 'notin'))){
							$temp = explode(',', $this->request->post['conditions']['conditions'][$k]['value']);
							foreach($temp as &$float_value){
								$float_value = round((float)preg_replace("/[^0-9.]/", '', $float_value), 4);
							}
							$this->request->post['conditions']['conditions'][$k]['value'] = implode(',', $temp);
							unset($temp);
						} else{
							$this->request->post['conditions']['conditions'][$k]['value'] = round((float)preg_replace("/[^0-9.]/", '', $this->request->post['conditions']['conditions'][$k]['value']), 4);
						}
					}

				}
			}

			if(isset($this->request->post['bonuses'])){
				foreach($this->request->post['bonuses'] as $k => $rule){
					if($rule['object'] == 'free_products'){

						$values = array();
						foreach($this->request->post['bonuses'][$k]['products'] as $j => $product_id){
							$values[$product_id] = array(
													'product_id' => $product_id,
							                        'quantity'   => 1);
						}
						$this->request->post['bonuses'][$k]['products'] = $values;

					} elseif($rule['object'] == 'discount_products'){

						$values = array();
						foreach($this->request->post['bonuses'][$k]['products'] as $j => $product_id){

								$values[$product_id] = array(
													'product_id' => $product_id,
								                    'quantity'   => (isset($this->request->post['discount_products_quantity'][$product_id])
										                            ? (int)$this->request->post['discount_products_quantity'][$product_id]
										                            : 1));

						}
						$this->request->post['bonuses'][$k]['products'] = $values;
					}
				}
			}
			//if was try to save empty list of bonuses  - show error

			if($this->request->get['tab']=='bonuses' && !$this->request->post['bonuses']){
				$this->session->data['warning'] = $this->language->get('promotion_error_empty_bonuses');
			}elseif( $this->request->get['tab']=='conditions' && !has_value($this->request->post['conditions']['conditions']) ){
				$this->session->data['warning'] = $this->language->get('promotion_error_empty_conditions');
			}else{
				$this->model_sale_promotion->editPromotion($promotion_id, $this->request->post);
				$this->session->data ['success'] = $this->language->get('text_success_edit');
			}

			$this->redirect($this->html->getSecureURL('sale/promotion/edit', '&tab=' . $this->request->get['tab'] . '&promotion_id=' . $promotion_id));
		}


		$info = $this->model_sale_promotion->getPromotion($promotion_id);
		foreach($info as $k => $v){
			$this->data[$k] = $v;
		}

		$this->data['tabs']['general'] = array(
				'href'   => $this->html->getSecureURL('sale/promotion/edit', '&tab=general&promotion_id=' . $promotion_id),
				'text'   => $this->language->get('text_general'),
				'active' => '');
		$this->data['tabs']['conditions'] = array(
				'href'   => $this->html->getSecureURL('sale/promotion/edit', '&tab=conditions&promotion_id=' . $promotion_id),
				'text'   => $this->language->get('text_conditions'),
				'active' => '');
		$this->data['tabs']['bonuses'] = array(
				'href'   => $this->html->getSecureURL('sale/promotion/edit', '&tab=bonuses&promotion_id=' . $promotion_id),
				'text'   => $this->language->get('text_bonuses'),
				'active' => '');

		switch($this->request->get['tab']){
			case 'conditions':
				$this->data['tabs']['conditions']['active'] = true;
				$this->data['conditions'] = $this->data['conditions'] ? unserialize($this->data['conditions']) : array();
				$this->_getFormConditions();
				break;
			case 'bonuses':
				$this->data['bonuses'] = $this->data['bonuses'] ? unserialize($this->data['bonuses']) : array();
				$this->data['tabs']['bonuses']['active'] = true;
				$this->_getFormBonuses();
				break;
			default:
				$this->data['tabs']['general']['active'] = true;
				$this->_getFormGeneral();
				break;
		}

		//update controller data
		$this->extensions->hk_UpdateData($this, __FUNCTION__);
	}

	public function delete(){
		//init controller data
		$this->extensions->hk_InitData($this, __FUNCTION__);

		$promotion_id = (int)$this->request->get['promotion_id'];
		$this->loadModel('sale/promotion');
		$this->model_sale_promotion->deletePromotion($promotion_id);
		//update controller data
		$this->extensions->hk_UpdateData($this, __FUNCTION__);
		$this->redirect($this->html->getSecureURL('sale/promotion'));
	}

	private function _getFormGeneral(){
		if(isset ($this->session->data['warning'])){
			$this->data ['error_warning'] = $this->session->data['warning'];
			$this->session->data['warning'] = '';
		} else{
			$this->data ['error_warning'] = '';
		}

		$this->view->assign('success', $this->session->data['success']);
		if(isset($this->session->data['success'])){
			unset($this->session->data['success']);
		}

		$this->document->initBreadcrumb(array('href'      => $this->html->getSecureURL('index/home'),
		                                      'text'      => $this->language->get('text_home'),
		                                      'separator' => false));
		$this->document->addBreadcrumb(array('href'      => $this->html->getSecureURL('sale/promotion'),
		                                     'text'      => $this->language->get('promotion_name'),
		                                     'separator' => ' :: '));

		$this->data ['cancel_href'] = $this->html->getSecureURL('sale/promotion');
		//$this->data['js_date_format'] = format4Datepicker($this->language->get('date_format_short'));
		if(!isset ($this->request->get ['promotion_id'])){
			$this->data ['action'] = $this->html->getSecureURL('sale/promotion/insert', '&tab=general');
			$this->data ['form_title'] = $this->language->get('text_create');
			$this->data['heading_title'] = $this->language->get('text_create');
			$this->data ['update'] = '';
			$form = new AForm ('ST');
		} else{
			$this->data ['action'] = $this->html->getSecureURL('sale/promotion/edit', '&tab=general&promotion_id=' . $this->request->get ['promotion_id']);
			$this->data ['form_title'] = $this->language->get('text_edit') . ' ' . $this->data['name'];
			$this->data ['update'] = $this->html->getSecureURL('listing_grid/promotion/update_field', '&promotion_id=' . $this->request->get ['promotion_id']);
			$form = new AForm ('HS');
		}

		$this->document->addBreadcrumb(array('href'      => $this->data['action'],
		                                     'text'      => $this->data ['form_title'],
		                                     'separator' => ' :: ',
		                                     'current'   => true
		));

		$form->setForm(
				array(
						'form_name' => 'promotionFrm',
						'update'    => $this->data ['update']
				));

		$this->data['form']['form_open'] = $form->getFieldHtml(array('type'   => 'form',
		                                                             'name'   => 'promotionFrm',
		                                                             'action' => $this->data ['action'],
		                                                             'attr'   => 'data-confirm-exit="true" class="aform form-horizontal"')
		);
		$this->data['form']['submit'] = $form->getFieldHtml(
				array(
						'type' => 'button',
						'name' => 'submit',
						'text' => $this->language->get('button_save')
				));
		$this->data['form']['cancel'] = $form->getFieldHtml(
				array(
						'type' => 'button',
						'name' => 'cancel',
						'text' => $this->language->get('button_cancel')
				));
		$this->data['form_title'] = $this->language->get('text_general');
		$this->data['form']['fields']['status']['field'] = $form->getFieldHtml(
				array(
						'type'    => 'checkbox',
						'name'    => 'status',
						'value'   => 1,
						'checked' => (isset($this->data['status']) ? (bool)$this->data['status'] : true),
						'style'   => 'btn_switch')
		);
		$this->data['form']['fields']['status']['text'] = $this->language->get('promotion_status');

		$this->data['form']['fields']['name']['field'] = $form->getFieldHtml(
				array(
						'type'     => 'input',
						'name'     => 'name',
						'value'    => $this->data['name'],
						'required' => true));
		$this->data['form']['fields']['name']['text'] = $this->language->get('entry_promotion_name');

		$this->data['form']['fields']['priority']['field'] = $form->getFieldHtml(array('type'  => 'input',
		                                                                               'name'  => 'priority',
		                                                                               'value' => (isset($this->data['priority']) ? (int)$this->data['priority'] : 1),
		                                                                               'style' => 'small-field',
				''));
		$this->data['form']['fields']['priority']['text'] = $this->language->get('entry_promotion_priority');

		$this->data['form']['fields']['description_short']['field'] = $form->getFieldHtml(array('type'  => 'textarea',
		                                                                                        'name'  => 'description_short',
		                                                                                        'value' => $this->data['description_short']
		));
		$this->data['form']['fields']['description_short']['text'] = $this->language->get('entry_promotion_description_short');

		$this->data['form']['fields']['stop']['field'] = $form->getFieldHtml(
				array(
						'type'  => 'checkbox',
						'name'  => 'stop',
						'value' => $this->data['stop'],
						'style' => 'btn_switch'
				));
		$this->data['form']['fields']['stop']['text'] = $this->language->get('entry_promotion_stop');

		$this->data['form']['fields']['daterange']['field'] .= $form->getFieldHtml(array(
				'type'       => 'date',
				'name'       => 'start_date',
				'value'      => ($this->data['start_date'] ? dateISO2Display($this->data['start_date'], $this->language->get('date_format_short')) : null),
				'default'    => date($this->language->get('date_format_short')),
				'dateformat' => format4Datepicker($this->language->get('date_format_short')),
				'required'   => true));

		$this->data['form']['fields']['daterange']['field'] .= $form->getFieldHtml(array(
				'type'       => 'date',
				'name'       => 'end_date',
				'value'      => ($this->data['end_date'] ? dateISO2Display($this->data['end_date'], $this->language->get('date_format_short')) : null),
				'default'    => '',
				'dateformat' => format4Datepicker($this->language->get('date_format_short'))
		));
		$this->data['form']['fields']['daterange']['text'] = $this->language->get('entry_promotion_daterange');


		$this->data['promotion_id'] = $this->request->get['promotion_id'] ? $this->request->get['promotion_id'] : '-1';

		$this->data['subform_url'] = $this->html->getSecureURL('listing_grid/promotion/getsubform', '&promotion_id=' . $this->data['promotion_id']);


		$this->view->batchAssign($this->language->getASet());
		$this->view->batchAssign($this->data);
		$this->view->assign('form_language_switch', $this->html->getContentLanguageSwitcher());
		$this->view->assign('language_code', $this->session->data['language']);
		$this->view->assign('help_url', $this->gen_help_url('promotion_edit'));
		$this->view->assign('rl', $this->html->getSecureURL('common/resource_library', '&object_name=promotions&type=image&mode=url'));

		$this->processTemplate('pages/sale/promotion_form.tpl');
	}

	private function _getFormConditions(){
		if(isset ($this->session->data['warning'])){
			$this->data ['error_warning'] = $this->session->data['warning'];
			$this->session->data['warning'] = '';
		} else{
			$this->data ['error_warning'] = '';
		}

		$this->view->assign('success', $this->session->data['success']);
		if(isset($this->session->data['success'])){
			unset($this->session->data['success']);
		}
		$this->document->initBreadcrumb(array('href'      => $this->html->getSecureURL('index/home'),
		                                      'text'      => $this->language->get('text_home'),
		                                      'separator' => false));
		$this->document->addBreadcrumb(array('href'      => $this->html->getSecureURL('sale/promotion'),
		                                     'text'      => $this->language->get('promotion_name'),
		                                     'separator' => ' :: '));


		$this->document->addStyle(
				array(
						'href'  => HTTPS_EXT . 'promotion/admin/view/default/stylesheet/promotion.css',
						'rel'   => 'stylesheet',
						'media' => 'screen'));

		$this->data ['cancel_href'] = $this->html->getSecureURL('sale/promotion');

		$this->data ['action'] = $this->html->getSecureURL('sale/promotion/edit', '&tab=conditions&promotion_id=' . $this->request->get ['promotion_id']);
		$this->data ['form_title'] = $this->language->get('text_edit') . ' ' . $this->data['name'];
		$this->data ['update'] = $this->html->getSecureURL('listing_grid/promotion/update_field', '&promotion_id=' . $this->request->get ['promotion_id']);
		$form = new AForm ('HT');

		$this->document->addBreadcrumb(array('href'      => $this->data['action'],
		                                     'text'      => $this->data ['form_title'],
		                                     'separator' => ' :: ',
		                                     'current'   => true
		));

		$form->setForm(
				array(
						'form_name' => 'promotionFrm',
						'update'    => $this->data ['update']
				)
		);
		$this->data['form']['form_open'] = $form->getFieldHtml(
				array(
						'type'   => 'form',
						'name'   => 'promotionFrm',
						'action' => $this->data ['action'],
						'attr'   => 'data-confirm-exit="true" class="aform form-horizontal"'));
		$this->data['form']['submit'] = $form->getFieldHtml(
				array(
						'type' => 'button',
						'name' => 'submit',
						'text' => $this->language->get('button_save')
				));
		$this->data['form']['cancel'] = $form->getFieldHtml(
				array(
						'type' => 'button',
						'name' => 'cancel',
						'text' => $this->language->get('button_cancel')
				));
		$this->data['form_title'] = $this->language->get('text_conditions');
// relations between conditions
		$this->data['conditions_relation']['fields']['if'] = array(
				'text' => $this->language->get('text_if_1'),
				'field' => $form->getFieldHtml(
						array(
							'type'    => 'selectbox',
							'name'    => 'conditions[relation][if]',
							'options' => array(
									'all' => $this->language->get('text_all'),
									'any' => $this->language->get('text_any')
							),
							'value'   => (isset($this->data['conditions']['relation']['if']) ? $this->data['conditions']['relation']['if'] : '')
						)
				)
		);

		$this->data['conditions_relation']['fields']['value'] = array(
			'text' => $this->language->get('text_if_2'),
			'field'=> $form->getFieldHtml(
					array(
						'type'    => 'selectbox',
						'name'    => 'conditions[relation][value]',
						'options' => array('true'  => $this->language->get('text_true'),
						                   'false' => $this->language->get('text_false')
						),
						'value'   => (isset($this->data['conditions']['relation']['value']) ? $this->data['conditions']['relation']['value'] : '')
					)
			)
		);

// 	conditions
		$this->data['form']['fields'] = array();
		if(isset($this->data['conditions']['conditions'])){
			$i = 0;
			$this->load->library('json');

			foreach($this->data['conditions']['conditions'] as $rule){
				$this->request->post['idx'] = $i;
				$this->request->post['condition_object'] = $rule['object'];
				$args = array(
						array(
								'operator' => $rule['operator'],
								'value' => $rule['value']
						)
				);
				$fields = $this->dispatch('responses/listing_grid/promotion/getFieldsByConditionObject', $args);

				$fields = AJson::decode($fields->dispatchGetOutput(), true);
				$this->data['form']['fields'][$i]['id'] = $rule['object'];
				$this->data['form']['fields'][$i]['text'] = $fields['text'];
				$this->data['form']['fields'][$i]['field'] = $fields['fields'];
				$i++;
			}
		}

		// selectbox with condition's objects list
		$promo = new APromotion();
		$cond_objects = $promo->getConditionObjects();

		foreach($cond_objects as $obj){
			$this->data['condition_objects'][$obj] = $this->language->get('text_' . $obj);
		}
		array_unshift($this->data['condition_objects'], $this->language->get('text_select'));
		$this->data['condition_object']['field'] = $form->getFieldHtml(
				array(
					'type'    => 'selectbox',
				    'name'    => 'condition_object',
				    'options' => $this->data['condition_objects'],
				    'value'   => $this->data['promotion_type'],
				    ));
		$this->data['condition_object']['text'] = $this->language->get('entry_condition_object');

		$this->data['condition_url'] = $this->html->getSecureURL('listing_grid/promotion/getFieldsByConditionObject', '&promotion_id=' . $this->data['promotion_id']);

		$this->view->batchAssign($this->language->getASet());
		$this->view->batchAssign($this->data);
		//$this->view->assign('language_code', $this->session->data['language']);
		$this->view->assign('help_url', $this->gen_help_url('promotion_edit'));
		$this->view->assign('rl', $this->html->getSecureURL('common/resource_library', '&object_name=promotions&type=image&mode=url'));

		$this->processTemplate('pages/sale/promotion_form_conditions.tpl');

	}

	private function _getFormBonuses(){
		if(isset ($this->session->data['warning'])){
			$this->data ['error_warning'] = $this->session->data['warning'];
			$this->session->data['warning'] = '';
		} else{
			$this->data ['error_warning'] = '';
		}

		$this->view->assign('success', $this->session->data['success']);
		if(isset($this->session->data['success'])){
			unset($this->session->data['success']);
		}
		$this->document->initBreadcrumb(array('href'      => $this->html->getSecureURL('index/home'),
		                                      'text'      => $this->language->get('text_home'),
		                                      'separator' => false));
		$this->document->addBreadcrumb(array('href'      => $this->html->getSecureURL('sale/promotion'),
		                                     'text'      => $this->language->get('promotion_name'),
		                                     'separator' => ' :: '));


		$this->document->addStyle(
				array(
						'href'  => HTTPS_EXT . 'promotion/admin/view/default/stylesheet/promotion.css',
						'rel'   => 'stylesheet',
						'media' => 'screen'));

		$this->data ['cancel_href'] = $this->html->getSecureURL('sale/promotion');

		$this->data ['action'] = $this->html->getSecureURL('sale/promotion/edit', '&tab=bonuses&promotion_id=' . $this->request->get ['promotion_id']);
		$this->data ['form_title'] = $this->language->get('text_edit') . ' ' . $this->data['name'];
		$this->data ['update'] = $this->html->getSecureURL('listing_grid/promotion/update_field', '&promotion_id=' . $this->request->get ['promotion_id']);
		$form = new AForm ('HT');

		$this->document->addBreadcrumb(array('href'      => $this->data['action'],
		                                     'text'      => $this->data ['form_title'],
		                                     'separator' => ' :: ',
		                                     'current'   => true
		));
		$form->setForm(
				array(
						'form_name' => 'promotionFrm',
						'update' => $this->data ['update']
				)
		);
		$this->data['form']['form_open'] = $form->getFieldHtml(array('type'   => 'form',
		                                                     'name'   => 'promotionFrm',
		                                                     'action' => $this->data ['action'],
		                                                     'attr'   => 'data-confirm-exit="true"  class="aform form-horizontal"'));
		$this->data['form']['submit'] = $form->getFieldHtml(array('type' => 'button',
		                                                  'name' => 'submit',
		                                                  'text' => $this->language->get('button_save')
		));
		$this->data['form']['cancel'] = $form->getFieldHtml(array('type' => 'button',
		                                                  'name' => 'cancel',
		                                                  'text' => $this->language->get('button_cancel')
		));
		$this->data['form_title'] = $this->language->get('text_bonuses');

		$this->data['form']['fields'] = array();
		if(isset($this->data['bonuses'])){
			$i = 0;
			$this->load->library('json');
			foreach($this->data['bonuses'] as $rule){
				$this->request->post['idx'] = $i;
				$this->request->post['bonus_object'] = $rule['object'];
				$args = array(array('operator' => $rule['operator'], 'value' => $rule['value']));

				if(in_array($rule['object'], array('free_products', 'discount_products'))){
					$args[0]['products'] = $rule['products'];
				}

				$fields = $this->dispatch('responses/listing_grid/promotion/getFieldsByBonusObject', $args);

				$fields = AJson::decode($fields->dispatchGetOutput(), true);
				$this->data['form']['fields'][$i]['id'] = $rule['object'];
				$this->data['form']['fields'][$i]['text'] = $fields['text'];
				$this->data['form']['fields'][$i]['field'] = $fields['fields'];

				if($rule['object'] == 'discount_products'){
					$href = '';
					foreach($rule['products'] as $product){
						$href .= '&discount_products_quantity[' . $product['product_id'] . ']=' . $product['quantity'];
					}
				}
				$i++;
			}
		}

		$this->data['list_content_url'] = $this->html->getSecureUrl('listing_grid/promotion/discount_products', $href);
		// selectbox with condition's objects list
		$promo = new APromotion();
		$bonus_objects = $promo->getBonusObjects();

		foreach($bonus_objects as $obj){
			$this->data['bonus_objects'][$obj] = $this->language->get('text_' . $obj);
		}
		array_unshift($this->data['bonus_objects'], $this->language->get('text_select'));
		$this->data['bonus_object']['field'] = $form->getFieldHtml(
				array('type'    => 'selectbox',
				      'name'    => 'bonus_object',
				      'options' => $this->data['bonus_objects'],
				      'value'   => $this->data['promotion_type'],
				      ));
		$this->data['bonus_object']['text'] = $this->language->get('entry_bonus_object');


		$this->data['bonus_url'] = $this->html->getSecureURL('listing_grid/promotion/getFieldsByBonusObject', '&promotion_id=' . $this->data['promotion_id']);

		$this->view->batchAssign($this->language->getASet());
		$this->view->batchAssign($this->data);
		$this->view->assign('help_url', $this->gen_help_url('promotion_edit'));

		$this->processTemplate('pages/sale/promotion_form_bonuses.tpl');

	}

	private function _validateForm(){
		if(!$this->user->hasPermission('modify', 'sale/promotion')){
			$this->session->data['warning'] = $this->error ['warning'] = $this->language->get('error_permission');
		}

		if($this->request->post){
			$required = array('name', 'start_date');

			foreach($this->request->post as $name => $value){
				if(in_array($name, $required) && empty($value)){
					$this->error ['warning'] = $this->language->get('error_empty');
					$this->session->data['warning'] = $this->language->get('error_empty');
					break;
				}
			}
		}

		foreach($required as $name){
			if(!in_array($name, array_keys($this->request->post))){
				return false;
			}
		}
		if(!$this->error){
			return true;
		} else{
			return false;
		}
	}

}
