<?php

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

/**
 * @property ModelCatalogProduct $model_catalog_product
 * @property ModelCatalogManufacturer $model_catalog_manufacturer
 * @property ModelAccountAddress $model_account_address
 *
 */
class ModelTotalPromotionTotal extends Model
{

    private $total;
    private $total_data;
    private $taxes;

    public function getTotal(&$total_data, &$total, &$taxes)
    {

        $status = $this->config->get('promotion_total_status');

        if (!$this->config->get('promotion_cart')
            && in_array($this->request->get['rt'], array('checkout/cart', 'r/checkout/cart/recalc_totals'))) {
            $status = 0;
        }
        if (!$this->config->get('promotion_status')) {
            $status = 0;
        }

        if ($status) {
            $this->total_data = $total_data;
            $this->total = $total;
            $this->taxes = $taxes;
            $this->_apply();
            $total_data = $this->total_data;
            $total = $this->total;
            $taxes = $this->taxes;
        }

    }

    private function _apply()
    {
        $promotions = $this->cache->get('promotions');
        if (is_null($promotions)) {
            $sql = "SELECT p.*, COALESCE(`end_date`, '2200-00-00 00:00:00') as end_date,  COALESCE(pd.name,'promotion') as name
                    FROM ".$this->db->table('promotions')." p
                    LEFT JOIN ".$this->db->table('promotion_descriptions')." pd
                        ON pd.promotion_id=p.promotion_id AND pd.language_id = '".$this->language->getLanguageID()."'
                    WHERE `status` = '1'
                    ORDER BY priority;";

            $promotions = $this->db->query($sql);
            $promotions = $promotions->rows;

            foreach ($promotions as &$promo) {
                $promo['conditions'] = unserialize($promo['conditions']);
                $promo['conditions']['relation']['value'] = $promo['conditions']['relation']['value'] == 'false'
                                                            ? false
                                                            : true;
                $promo['bonuses'] = unserialize($promo['bonuses']);
            }
            unset($promo);
            $this->cache->set('promotions', $promotions);
        }

        foreach ($promotions as $promotion) {
            $start_date = strtotime($promotion['start_date']);
            $end_date = $promotion['end_date'] != '0000-00-00 00:00:00' ? strtotime($promotion['end_date']) : false;
            $end_date = $end_date === false ? (time() + 86400) : $end_date;
            if (time() < $start_date || time() > $end_date) {
                continue;
            }
            $result = $this->_check_conditions($promotion['conditions']);
            if ($result) {
                $res = $this->_apply_bonuses($promotion['name'], $promotion['bonuses']);
                if ($res && $promotion['stop']) {
                    break;
                }
            }
        }
    }

    /**
     * @param array $conditions
     *
     * @return bool|null
     * @throws AException
     */
    private function _check_conditions($conditions)
    {
        if (!is_array($conditions['conditions'])) {
            return null;
        }

        foreach ($conditions['conditions'] as $condition) {
            $result = $this->_check_condition($condition);
            if ($conditions['relation']['if'] == 'any'
                && $result === $conditions['relation']['value']
            ) {
                return true;
            } elseif ($conditions['relation']['if'] == 'all'
                && $result !== $conditions['relation']['value']
            ) {
                return false;
            }
        }

        // if still not returned
        return $conditions['relation']['if'] == 'any' ? false : true;
    }

    /**
     * @param array $condition
     *
     * @return bool|null
     * @throws AException
     */
    private function _check_condition($condition)
    {
        $result = null;

        if (!$condition['object']) {
            return null;
        }
        $products_ids = array();
        switch ($condition['object']) {
            case 'products':
                $products = $this->cart->getProducts();
                foreach ($products as $product) {
                    $products_ids[] = $product['product_id'];
                }
                return $this->_run_comparison($products_ids, $condition['value'], $condition['operator']);
                break;
            case 'product_price':
                $products = $this->cart->getProducts();
                foreach ($products as $product) {
                    if ($this->_run_comparison($product['price'], $condition['value'], $condition['operator'])) {
                        return true;
                    }
                }
                return false;
                break;
            case 'categories':
                $products = $this->cart->getProducts();
                $this->load->model('catalog/product');
                $cart_categories = array();
                foreach ($products as $product) {
                    $res = $this->model_catalog_product->getCategories($product['product_id']);
                    foreach ($res as $row) {
                        $cart_categories[] = $row['category_id'];
                    }
                }
                $cart_categories = array_unique($cart_categories);
                return $this->_run_comparison($cart_categories, $condition['value'], $condition['operator']);
                break;

            case 'brands':
                $products = $this->cart->getProducts();
                $this->load->model('catalog/manufacturer');
                $cart_brands = array();
                foreach ($products as $product) {
                    $res = $this->model_catalog_manufacturer->getManufacturerByProductId($product['product_id']);
                    foreach ($res as $row) {
                        $cart_brands[] = $row['manufacturer_id'];
                    }
                }
                $cart_brands = array_unique($cart_brands);
                return $this->_run_comparison($cart_brands, $condition['value'], $condition['operator']);
                break;

            case 'customers':
                $customer = $this->customer->getId();
                return $this->_run_comparison($customer, $condition['value'], $condition['operator']);
                break;

            case 'customer_groups':
                $customer_group = $this->customer->getCustomerGroupId();
                return $this->_run_comparison($customer_group, $condition['value'], $condition['operator']);
                break;

            case 'customer_country':
            case 'customer_postcode':
                $address_id = $this->session->data['shipping_address_id'];
                $address_id = !$address_id ? $this->customer->getAddressId() : $address_id;

                $this->load->model('account/address');
                $res = $this->model_account_address->getAddress($address_id);

                if ($condition['object'] == 'customer_country') {
                    $id = (int)$res['country_id'];
                } else {
                    $id = (int)$res['postcode'];
                }

                return $this->_run_comparison($id, $condition['value'], $condition['operator']);
                break;
            case 'order_subtotal':
                $subtotal = $this->cart->getSubtotal();
                if (!in_array($condition['operator'], array('in', 'notin'))) {
                    $condition['value'] = (float)$condition['value'];
                } else {
                    $condition['value'] = explode(',', $condition['value']);
                }
                return $this->_run_comparison($subtotal, $condition['value'], $condition['operator']);
                break;
            case 'order_product_count':

                $products_count = $this->cart->countProducts();
                if (!in_array($condition['operator'], array('in', 'notin'))) {
                    $condition['value'] = (int)$condition['value'];
                } else {
                    $condition['value'] = explode(',', $condition['value']);
                }
                return $this->_run_comparison($products_count, $condition['value'], $condition['operator']);
                break;
            case 'order_product_weight':
                $weight = round($this->cart->getWeight(), 2);
                if (!in_array($condition['operator'], array('in', 'notin'))) {
                    $condition['value'] = round((float)$condition['value'], 2);
                } else {
                    $condition['value'] = explode(',', $condition['value']);
                }
                return $this->_run_comparison($weight, $condition['value'], $condition['operator']);
                break;
            case 'payment_method':
                $payment_method = $this->session->data['payment_method']['id'];
                return $this->_run_comparison($payment_method, $condition['value'], $condition['operator']);
                break;
            case 'shipping_method':
                $shipping_method = $this->session->data['shipping_method']['id'];
                $shipping_method = explode('.', $shipping_method);
                $shipping_method = $shipping_method[0];
                return $this->_run_comparison($shipping_method, $condition['value'], $condition['operator']);
                break;
            case 'coupon_code':
                $coupon_code = $this->session->data['coupon'];
                return $this->_run_comparison($coupon_code, $condition['value'], $condition['operator']);
                break;
        }
        return $result;
    }

    /**
     * @param mixed $value1
     * @param mixed $value2
     * @param string $operator
     *
     * @return bool
     */
    private function _run_comparison($value1, $value2, $operator)
    {
        switch ($operator) {
            case 'eq':
                return ($value1 == $value2);
                break;
            case 'neq':
                return ($value1 != $value2);
                break;
            case 'eqlt':
                return ($value1 <= $value2);
                break;
            case 'eqgt':
                return ($value1 >= $value2);
                break;
            case 'lt':
                return ($value1 < $value2);
                break;
            case 'gt':
                return ($value1 > $value2);
                break;
            case 'in':
                $value2 = (array)$value2;
                if (!is_array($value1)) {
                    return in_array($value1, $value2);
                } else {
                    return array_intersect($value1, $value2) ? true : false;
                }
                break;
            case 'notin':
                $value2 = (array)$value2;
                if (!is_array($value1)) {
                    return !in_array($value1, $value2);
                } else {
                    return !array_intersect($value1, $value2) ? true : false;
                }
                break;
            case 'ctn':
                return is_int(strpos((string)$value1, (string)$value2)) ? true : false;
                break;
            case 'nctn':
                return !is_int(strpos((string)$value1, (string)$value2)) ? true : false;
                break;
            default:
                return false;
                break;
        }
    }

    /**
     * @param string $promotions_name
     * @param array $bonuses
     *
     * @return bool
     */
    private function _apply_bonuses($promotions_name, $bonuses)
    {

        $applied = array();
        $discount = 0;

        foreach ($bonuses as $bonus) {
            if (!in_array($bonus['object'], $applied)) {
                $bonus_discount = $this->_process_bonus($bonus);
                if (($discount + $bonus_discount) > $this->total) {
                    break; // prevent negative total
                }
                $discount += $bonus_discount;
            }
            $applied[] = $bonus['object'];
        }
        if ($discount) {
            $this->total_data[] = array(
                'id'         => 'promotion',
                'title'      => $promotions_name,
                'text'       => ' - '.$this->currency->format($discount),
                'value'      => -$discount,
                'sort_order' => $this->config->get('promotion_total_sort_order'),
                'total_type' => $this->config->get('promotion_total_total_type'),
            );
            $this->total -= $discount;
            foreach ($this->cart->getProducts() as $product) {
                if ($product['tax_class_id']) {
                    $this->taxes[$product['tax_class_id']]['total'] -= $discount;
                    $this->taxes[$product['tax_class_id']]['tax'] -= $this->tax->calcTotalTaxAmount($product['total'], $product['tax_class_id']) - $this->tax->calcTotalTaxAmount($product['total'] - $discount, $product['tax_class_id']);
                }
            }

            return true;
        }
        return false;
    }

    /**
     * @param array $bonus
     *
     * @return bool|float|int|null
     */
    private function _process_bonus($bonus)
    {
        $bonus['value'] = !isset($bonus['value']) ? array() : $bonus['value'];
        $discount = 0;
        switch ($bonus['object']) {
            case 'order_discount':
                $subtotal = false;
                foreach ($this->total_data as $item) {
                    if ($item['id'] == 'subtotal') {
                        $subtotal = $item['value'];
                        break;
                    }
                }
                if ($subtotal === false) {
                    return null;
                }

                $discount = $this->_get_discount($bonus['operator'], $subtotal, $bonus['value']);

                break;
            case 'free_shipping':
                $shipping_cost = false;
                foreach ($this->total_data as $item) {
                    if ($item['id'] == 'shipping') {
                        $shipping_method = $this->session->data['shipping_method']['id'];
                        $shipping_method = explode('.', $shipping_method);
                        $shipping_method = $shipping_method[0];

                        if (in_array($shipping_method, $bonus['value'])) {
                            $shipping_cost = $item['value'];
                            break;
                        }
                    }
                }
                if ($shipping_cost === false) {
                    return null;
                }
                $discount = $shipping_cost;
                break;
            case 'discount_products':
                $products = $this->cart->getProducts();
                foreach ($products as $product) {
                    if (in_array($product['product_id'], array_keys($bonus['products']))) {
                        $total = $product['price'] * $bonus['products'][$product['product_id']]['quantity'];
                        $discount += $this->_get_discount($bonus['operator'], $total, $bonus['value']);
                        unset($bonus['products'][$products['product_id']]); // prevent repetition of bonus
                    }
                }
                break;
            case 'free_products':
                $products = $this->cart->getProducts();
                foreach ($products as $product) {
                    if (in_array($product['product_id'], array_keys($bonus['products']))) {
                        $discount += $product['price'] * $bonus['products'][$product['product_id']]['quantity'];
                        unset($bonus['products'][$products['product_id']]); // prevent repetition of bonus
                    }
                }
                break;
        }
        return $discount;
    }

    private function _get_discount($operator, $price, $value)
    {
        $discount = 0;

        if ($operator == 'to_prc') {
            $discount = $price * (100 - $value) / 100;

        } elseif ($operator == 'by_prc') {
            $discount = $price * $value / 100;

        } elseif ($operator == 'to_fixed') {
            $discount = $price - $value;

        } elseif ($operator == 'by_fixed') {
            $discount = $value;
        }

        if ($discount < 0) {
            $discount = 0;
        }

        return $discount;
    }

}
