DROP TABLE IF EXISTS `ac_promotions`;
CREATE TABLE `ac_promotions` (
`promotion_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
`conditions` text NOT NULL,
`bonuses` text NOT NULL,
`start_date` datetime NOT NULL,
`end_date` datetime NOT NULL,
`priority` mediumint(8) unsigned NOT NULL DEFAULT '0',
`stop` char(1) NOT NULL DEFAULT 'N',
`promotion_type` enum('products','global') NOT NULL DEFAULT 'global',
`conditions_hash` text NOT NULL,
`status` char(1) NOT NULL DEFAULT 'A',
`number_of_usages` mediumint(8) NOT NULL DEFAULT '0',
`users_conditions_hash` text NOT NULL,
`date_added` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
`date_modified` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
PRIMARY KEY (`promotion_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `ac_promotion_descriptions`;
CREATE TABLE `ac_promotion_descriptions` (
`promotion_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
`language_id` mediumint(8) NOT NULL DEFAULT 1,
`name` varchar(255) NOT NULL DEFAULT '',
`description_short` text NOT NULL,
`description` mediumtext NOT NULL,
`date_added` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
`date_modified` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
PRIMARY KEY (`promotion_id`,`language_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;