<?php

if(!defined('DIR_CORE')){
	header('Location: static_pages/');
}

class ModelSalePromotion extends Model{
	public function addPromotion($data = array()){

		$data['start_date'] = $data['start_date'] ? dateDisplay2ISO($data['start_date'], $this->language->get('date_format_short')) : '';
		$data['end_date'] = $data['end_date'] ? dateDisplay2ISO($data['end_date'], $this->language->get('date_format_short')) : '';

		$data['promotion_type'] = !isset($data['promotion_type']) ? 'global' : $data['promotion_type'];


		$sql = "INSERT INTO `" . $this->db->table('promotions') . "`
				(`status`,`promotion_type`,`start_date`,`end_date`,`stop`,`priority`,`date_added`)
				VALUES ('" . (int)$data['status'] . "',
						'" . $this->db->escape($data['promotion_type']) . "',
						" . ($data['start_date'] ? "DATE('" . $this->db->escape($data['start_date']) . "')," : "'0000-00-00', ") . "
						" . ($data['end_date'] ? "DATE('" . $this->db->escape($data['end_date']) . "')," : "'0000-00-00', ") . "
						'" . (int)$data['stop'] . "',
						'" . (int)$data['priority'] . "',
						 'NOW()' )";
		$this->db->query($sql);
		$promotion_id = $this->db->getLastId();

		$this->language->replaceDescriptions('promotion_descriptions',
											 array('promotion_id' => (int)$promotion_id),
											 array($this->language->getContentLanguageID() => array(
												                        'name' => $data['name'],
												                        'description' => $data['description'],
												                        'description_short' => $data['description_short'],
												                        'date_added' => dateInt2ISO(time())
											 )) );
		$this->cache->delete('promotions');
		return $promotion_id;
	}

	public function editPromotion($promotion_id, $data){
		$promotion_id = (int)$promotion_id;
		$language_id = (int)$this->language->getContentLanguageID();

		if(isset($data['start_date'])){
			$data['start_date'] = $data['start_date'] ? dateDisplay2ISO($data['start_date'], $this->language->get('date_format_short')) : date('Y-m-d');
		}
		if(isset($data['end_date'])){
			$data['end_date'] = $data['end_date'] ? dateDisplay2ISO($data['end_date'], $this->language->get('date_format_short')) : '';
		}

		$data['promotion_type'] = !isset($data['promotion_type']) ? 'global' : $data['promotion_type'];


		$update_arr = array();
		$allowed_fields = array('name', 'description', 'description_short');
		foreach($allowed_fields as $field_name){
			if(isset($data[$field_name])){
				$update_arr[$field_name] = $data[$field_name];
			}
		}

		if($update_arr){
			$update_arr['date_added'] = dateInt2ISO(time());
			$this->language->replaceDescriptions('promotion_descriptions',
					array ('promotion_id' => (int)$promotion_id),
					array ($language_id => $update_arr));
		}

		$allowed_fields = array(
				'conditions'       => '',
				'bonuses'          => '',
				'start_date'       => '',
				'end_date'         => '',
				'priority'         => 'int',
				'stop'             => 'int',
				'promotion_type'   => '',
				'status'           => 'int',
				'number_of_usages' => 'int');
		$sql = "UPDATE `" . $this->db->table('promotions') . "`
				SET ";
		$tmp = array();
		foreach(array_keys($allowed_fields) as $field_name){
			if(isset($data[$field_name])){
				$data[$field_name] = in_array($field_name, array('bonuses', 'conditions')) ? serialize($data[$field_name]) : $data[$field_name];
				$tmp[] = "`" . $field_name . "` = '" . ($allowed_fields[$field_name] == 'int' ? (int)$data[$field_name] : $this->db->escape($data[$field_name])) . "'\n";
			}
		}
		$sql .= implode(', ', $tmp);
		$sql .= " WHERE promotion_id='" . $promotion_id . "'";
		if($tmp){
			$this->db->query($sql);
		}
		$this->cache->delete('promotions');
	}

	public function deletePromotion($promotion_id){
		$promotion_id = (int)$promotion_id;
		if(!$promotion_id) return false;

		$sql[] = "DELETE FROM `" . $this->db->table('promotions') . "` WHERE promotion_id = '" . $promotion_id . "'";
		$sql[] = "DELETE FROM `" . $this->db->table('promotion_descriptions') . "` WHERE promotion_id = '" . $promotion_id . "'";
		foreach($sql as $s){
			$this->db->query($s);
		}
		$this->cache->delete('promotions');
		return true;
	}


	public function getPromotions($filter, $mode = ''){
		if(!empty($data['language_id'])){
			$language_id = ( int )$data['language_id'];
		} else{
			$language_id = $this->language->getContentLanguageID();
		}


		if($mode == 'total_only'){
			$sql = "SELECT COUNT(*) as total
						FROM " . $this->db->table('promotions') . " p
						LEFT JOIN " . $this->db->table('promotion_descriptions') . " pd
							ON (p.promotion_id = pd.promotion_id AND pd.language_id = '" . $language_id . "')";
		} else{
			$sql = "SELECT pd.*, p.*
						FROM " . $this->db->table('promotions') . " p
						LEFT JOIN " . $this->db->table('promotion_descriptions') . " pd
							ON (p.promotion_id = pd.promotion_id AND pd.language_id = '" . $language_id . "')";

		}

		if(!empty($filter['subsql_filter'])){
			$sql .= " WHERE " . $filter['subsql_filter'];
		}


		$sort_data = array(
				'name'        => 'pd.name',
				'status'      => 'p.status',
				'priority'    => 'p.priority',
				'date_modified' => 'p.date_modified',
				'daterange'   => '(COALESCE(p.end_date,NOW()) - p.start_date) '
		);

		if(isset($filter['sort']) && in_array($filter['sort'], array_keys($sort_data))){
			$sql .= " ORDER BY " . $sort_data[$filter['sort']];
		} else{
			$sql .= " ORDER BY pd.name";
		}

		if(isset($filter['order']) && ($filter['order'] == 'DESC')){
			$sql .= " DESC";
		} else{
			$sql .= " ASC";
		}

		if(isset($filter['start']) || isset($filter['limit'])){
			if($filter['start'] < 0){
				$filter['start'] = 0;
			}

			if($filter['limit'] < 1){
				$filter['limit'] = 20;
			}

			$sql .= $mode != 'total_only' ? " LIMIT " . (int)$filter['start'] . "," . (int)$filter['limit'] : '';
		}


		$result = $this->db->query($sql);

		$output = '';
		if($mode == 'total_only'){
			$output = $result->row['total'];
		} else{
			$output = $result->rows;
		}
		return $output;
	}

	public function getPromotion($promotion_id, $language_id = ''){
		$promotion_id = (int)$promotion_id;
		$language_id = (int)$language_id;
		if(!$language_id){
			$language_id = (int)$this->language->getContentLanguageID();
		}

		$sql = "SELECT  pd.*, p.*
				FROM `" . $this->db->table('promotions') . "` p
				LEFT JOIN `" . $this->db->table('promotion_descriptions') . "` pd
					ON (pd.promotion_id = p.promotion_id AND pd.language_id = '" . $language_id . "')
				WHERE p.promotion_id='" . $promotion_id . "'";
		$result = $this->db->query($sql);
		return $result->row;
	}

}