<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2023 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}


require_once DIR_SYSTEM . "lib/vendor/autoload.php";
require_once DIR_SYSTEM . "lib/license.php";

/**
 * @property ModelCatalogProduct $model_catalog_product
 * @property ModelCatalogManufacturer $model_catalog_manufacturer
 * @property ModelAccountAddress $model_account_address
 * @property ModelSaleOrder $model_sale_order
 */
class ModelTotalPromoManagerTotal extends Model {

    protected $total;
    protected $total_data;
    protected $taxes;
    protected $exclude_product_price = [];
    protected $exclude_category_product_price = [];
    protected $exclude_brand_product_price = [];
    protected $exclude_products = [];
    protected $exclude_category_products = [];
    protected $exclude_brand_products = [];

    public function verify() {
        $this->load->model('extension/promo_manager_license_info');
        $license_key = $this->config->get('promo_manager_license_code');
        if ($license_key) {
            $exist = $this->db->query("SHOW TABLES LIKE '" . $this->db->table('promo_manager_license_info') . "'");
            if ($exist->num_rows === 1) {
                $store_id = $this->model_extension_promo_manager_license_info->getStoreId();
                $license_key = $this->model_extension_promo_manager_license_info->getLicenseCode($store_id);
                $license_info = $this->model_extension_promo_manager_license_info->getLicenseData($store_id);
                $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                $license = new License($path_to_phpseclib);
                $license_manager = $license->getManager();
                $license_manager->setKeys($license_key, $license_info['public_key'], 'promo_manager');
                $ttl = 1209600;
                $validate = $license_manager->validate($license_info['license_data'], $ttl);
                $store_status = $this->model_extension_promo_manager_license_info->getLicensedStoreStatus();
                if ($validate['status']==='expired') {
                    $this->load->model('extension/promo_manager_license_info');
                    $store_id = $this->model_extension_promo_manager_license_info->getStoreId();
                    $public_key = "";
                    $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                    $license_key = $this->model_extension_promo_manager_license_info->getLicenseCode($store_id);
                    $license = new License($path_to_phpseclib);
                    $license_manager = $license->getManager();
                    if (stripos($license_key,'mc-')!==false) {
                        $server_url = $this->mc_server_url;
                    } else {
                        $server_url = $this->diy_server_url;
                    }

                    $license_manager->setLicenseServerUrl($server_url);
                    $license_manager->setKeys($license_key, "", $this->shared_secret);
                    $public_key = $license_manager->requestKey();
                    $license_manager->setKeys($license_key, $public_key, $this->shared_secret);
                    $this->load->model('extension/promo_manager_license_info');
                    $current_version = $this->model_extension_promo_manager_license_info->getCurrentVersion();
                    $custom_data = ['version' => $current_version];
                    $license_data = $license_manager->requestData($custom_data);
                    if (!is_null($license_data)) {
                        $data['public_key'] = $public_key;
                        $data['license_data'] = $license_data;
                        $ttl = 1209600;
                        $validate = $license_manager->validate($license_data, $ttl);
                        if ($validate['status'] !== 'unknown' && $validate['status'] !== 'invalid_location') {
                            $data['public_key'] = $public_key;
                            $data['license_data'] = $license_data;
                            $data['store_id'] = $store_id;
                            $data['last_check'] = time();
                            $this->load->model('extension/promo_manager_license_info');
                            $this->model_extension_promo_manager_license_info->saveLicenseData($data);
                        } elseif ($validate['status'] === 'valid' && $store_status == 1) {
                            return true;
                        } else {
                            return false;
                        }
                    }
                } else {
                    if ($validate['status'] === 'valid' && $store_status == 1) {
                        return true;
                    } else {
                        return false;
                    }
                }
            } else {
                return false;
            }
        } else {
            return false;
        }
    }
    
    public function getTotal(&$total_data, &$total, &$taxes) {
        $status = $this->config->get('promo_manager_total_status');

        if (!$this->config->get('promo_manager_cart')
            && in_array($this->request->get['rt'], ['checkout/cart', 'r/checkout/cart/recalc_totals'])
        ) {
            $status = 0;
        }
        if (!$this->config->get('promo_manager_status')) {
            $status = 0;
        }
        if ($status && $this->verify()) {
            $this->total_data = $total_data;
            $this->total = $total;
            $this->taxes = $taxes;
            $this->_apply();
            $total_data = $this->total_data;
            $total = $this->total;
            $taxes = $this->taxes;
        }
    }

    private function _apply() {
        $sql = "SELECT p.*, COALESCE(`end_date`, '2200-00-00 00:00:00') as end_date,  COALESCE(pd.name,'promo_manager') as name
                    FROM " . $this->db->table('promo_manager') . " p
                    LEFT JOIN " . $this->db->table('promo_manager_descriptions') . " pd
                        ON pd.promo_manager_id=p.promo_manager_id AND pd.language_id = '" . $this->language->getLanguageID() . "'
                    WHERE `status` = '1'
                    ORDER BY priority;";

        $promo_managers = $this->db->query($sql);
        $promo_managers = $promo_managers->rows;
        foreach ($promo_managers as &$promo) {
            $promo['conditions'] = unserialize($promo['conditions']);
            $promo['conditions']['relation']['value'] = !($promo['conditions']['relation']['value'] == 'false');
            $promo['bonuses'] = unserialize($promo['bonuses']);
        }
        unset($promo);

        foreach ($promo_managers as $promo_manager) {
            $start_date = strtotime($promo_manager['start_date']);
            $end_date = $promo_manager['end_date'] != '0000-00-00 00:00:00' ? strtotime($promo_manager['end_date']) : false;
            $end_date = $end_date === false ? (time() + 86400) : $end_date;
            if (time() < $start_date || time() > $end_date) {
                continue;
            }

            $result = $this->_check_conditions($promo_manager['conditions']);
             if ($result) {
                 $res = $this->_apply_bonuses($promo_manager['name'], $promo_manager['bonuses']);
                 if ($res && $promo_manager['stop']) {
                     break;
                 }
            }
        }
    }

    /**
     * @param array $conditions
     *
     * @return bool|null
     * @throws AException
     */
    private function _check_conditions($conditions) {
        if (!is_array($conditions['conditions'])) {
            return null;
        }

        foreach ($conditions['conditions'] as $condition) {
            $result = $this->_check_condition($condition);
            if ($conditions['relation']['if'] == 'any'
                && $result === $conditions['relation']['value']
            ) {
                return true;
            } elseif ($conditions['relation']['if'] == 'all'
                && $result !== $conditions['relation']['value']
            ) {
                return false;
            }
        }

        // if still not returned
        return !($conditions['relation']['if'] == 'any');
    }

    /**
     * @param array $condition
     *
     * @return bool|null
     * @throws AException
     */
    private function _check_condition($condition) {
        if (!$condition['object']) {
            return null;
        }
        $products_ids = [];

        if (IS_ADMIN) {
            $this->load->model('sale/order');
            $order_id = $this->request->get['order_id'];
            $order_info = $this->model_sale_order->getOrder($order_id);
            $customer_id = $order_info['customer_id'];
            $customer_group_id = $order_info['customer_group_id'];
        } else {
            if ($this->customer->isLogged() || $this->customer->isUnauthCustomer()) {
                $customer_id = $this->customer->getId();
                $customer_group_id = $this->customer->getCustomerGroupId();
            } else {
                $customer_group_id = $this->config->get('config_customer_group_id');
            }
        }

        //$this->exclude_product_price = 0;
        //$this->exclude_category_product_price = 0;
        //$this->exclude_brand_product_price = 0;
        $this->exclude_products = [];

        switch ($condition['object']) {
            case 'products':
                $products = $this->cart->getProducts();
                foreach ($products as $product) {
                    if ($condition['operator']==='notin' && in_array($product['product_id'],(array)$condition['value'])) {
                        $this->exclude_product_price[] = ($product['price'] * $product['quantity']);
                        $this->exclude_products[] = $product['product_id'];
                        continue;
                    }
                    $products_ids[] = $product['product_id'];
                }
                if ($products_ids) {
                    return $this->_run_comparison($products_ids, $condition['value'], $condition['operator']);
                } else {
                    return false;
                }
            case 'product_price':
                $products = $this->cart->getProducts();
                foreach ($products as $product) {
                    if ($this->_run_comparison($product['price'], $condition['value'], $condition['operator'])) {
                        return true;
                    }
                }
                return false;
            case 'categories':
                $products = $this->cart->getProducts();
                $this->load->model('catalog/product');
                $cart_categories = [];
                foreach ($products as $product) {
                    $res = $this->model_catalog_product->getCategories($product['product_id']);
                    foreach ($res as $row) {
                        if ($condition['operator'] === 'notin' && in_array($row['category_id'], (array)$condition['value'])) {
                            $this->exclude_category_product_price[] = ($product['price'] * $product['quantity']);
                            $this->exclude_products[] = $product['product_id'];
                            continue;
                        }
                        $cart_categories[] = $row['category_id'];
                    }
                }
                $cart_categories = array_unique($cart_categories);
                if ($cart_categories) {
                    return $this->_run_comparison($cart_categories, $condition['value'], $condition['operator']);
                } else {
                    return false;
                }
            case 'brands':
                $products = $this->cart->getProducts();
                $this->load->model('catalog/manufacturer');
                $cart_brands = [];
                foreach ($products as $product) {
                    $res = $this->model_catalog_manufacturer->getManufacturerByProductId($product['product_id']);
                    foreach ($res as $row) {
                        if ($condition['operator']==='notin' && in_array($row['manufacturer_id'], (array)$condition['value'])) {
                            $this->exclude_brand_product_price[] = ($product['price'] * $product['quantity']);
                            $this->exclude_products[] = $product['product_id'];
                            continue;
                        }
                        $cart_brands[] = $row['manufacturer_id'];
                    }
                }
                $cart_brands = array_unique($cart_brands);
                if ($cart_brands) {
                    return $this->_run_comparison($cart_brands, $condition['value'], $condition['operator']);
                } else {
                    return false;
                }
            case 'customers':
                $customer = $customer_id;
                return $this->_run_comparison($customer, $condition['value'], $condition['operator']);
            case 'customer_groups':
                $customer_group = $customer_group_id;
                return $this->_run_comparison($customer_group, $condition['value'], $condition['operator']);
            case 'customer_country':
            case 'customer_postcode':
                $address_id = $this->session->data['shipping_address_id']?? $this->session->data['fc']['shipping_address_id'];
                $address_id = !$address_id ? $this->customer->getAddressId() : $address_id;

                $this->load->model('account/address');
                $res = $this->model_account_address->getAddress($address_id);

                if ($condition['object'] == 'customer_country') {
                    $id = (int) $res['country_id'];
                } else {
                    $id = (int) $res['postcode'];
                }
                return $this->_run_comparison($id, $condition['value'], $condition['operator']);
            case 'order_subtotal':
                $subtotal = $this->cart->getSubtotal();
                if (!in_array($condition['operator'], ['in', 'notin'])) {
                    $condition['value'] = (float) $condition['value'];
                } else {
                    $condition['value'] = explode(',', $condition['value']);
                }
                return $this->_run_comparison($subtotal, $condition['value'], $condition['operator']);
            case 'order_product_count':
                $products_count = $this->cart->countProducts();
                if (!in_array($condition['operator'], ['in', 'notin'])) {
                    $condition['value'] = (int) $condition['value'];
                } else {
                    $condition['value'] = explode(',', $condition['value']);
                }
                return $this->_run_comparison($products_count, $condition['value'], $condition['operator']);
            case 'order_product_weight':
                $weight = round($this->cart->getWeight(), 2);
                if (!in_array($condition['operator'], ['in', 'notin'])) {
                    $condition['value'] = round((float) $condition['value'], 2);
                } else {
                    $condition['value'] = explode(',', $condition['value']);
                }
                return $this->_run_comparison($weight, $condition['value'], $condition['operator']);
            case 'payment_method':
                $payment_method = $this->session->data['payment_method']['id'] ?? $this->session->data['fc']['payment_method']['id'];
                return $this->_run_comparison($payment_method, $condition['value'], $condition['operator']);
            case 'shipping_method':
                $shipping_method = $this->session->data['shipping_method']['id'] ?? $this->session->data['fc']['shipping_method']['id'];
                $shipping_method = explode('.', $shipping_method);
                $shipping_method = $shipping_method[0];
                return $this->_run_comparison($shipping_method, $condition['value'], $condition['operator']);
            case 'coupon_code':
                $coupon_code = $this->session->data['coupon'] ?? $this->session->data['fc']['coupon'];
                return $this->_run_comparison($coupon_code, $condition['value'], $condition['operator']);
        }
        return null;
    }

    /**
     * @param mixed $value1
     * @param mixed $value2
     * @param string $operator
     *
     * @return bool
     */
    protected function _run_comparison($value1, $value2, $operator) {
        switch ($operator) {
            case 'eq':
                return ($value1 == $value2);
            case 'neq':
                return ($value1 != $value2);
            case 'eqlt':
                return ($value1 <= $value2);
            case 'eqgt':
                return ($value1 >= $value2);
            case 'lt':
                return ($value1 < $value2);
            case 'gt':
                return ($value1 > $value2);
            case 'in':
                $value2 = (array) $value2;
                if (!is_array($value1)) {
                    return in_array($value1, $value2);
                } else {
                    return (bool) array_intersect($value1, $value2);
                }
            case 'notin':
                $value2 = (array) $value2;
                if (!is_array($value1)) {
                    return !in_array($value1, $value2);
                } else {
                    return !array_intersect($value1, $value2);
                }
            case 'ctn':
                return is_int(strpos((string) $value1, (string) $value2));
            case 'nctn':
                return !is_int(strpos((string) $value1, (string) $value2));
            default:
                return false;
        }
    }

    /**
     * @param string $promo_managers_name
     * @param array $bonuses
     *
     * @return bool
     * @throws AException
     */
    private function _apply_bonuses($promo_managers_name, $bonuses) {
        $applied = [];
        $discount = 0;

        foreach ($bonuses as $bonus) {
            if (!in_array($bonus['object'], $applied)) {
                $bonus_discount = $this->_process_bonus($bonus);
                if (($discount + $bonus_discount) > $this->total) {
                    break; // prevent negative total
                }
                $discount += $bonus_discount;
            }
            $applied[] = $bonus['object'];
        }

        if ($discount) {
            $this->total_data[] = [
                'id'         => 'promo_manager_total',
                'title'      => $promo_managers_name,
                'text'       => ' - '.$this->currency->format($discount),
                'value'      => -$discount,
                'sort_order' => $this->config->get('promo_manager_total_sort_order'),
                'total_type' => $this->config->get('promo_manager_total_total_type'),
            ];
            $this->total -= $discount;
            foreach ($this->cart->getProducts() as $product) {
                if ($product['tax_class_id']) {
                    $this->taxes[$product['tax_class_id']]['total'] -= $discount;
                    $this->taxes[$product['tax_class_id']]['tax'] -= $this->tax->calcTotalTaxAmount(
                            $product['total'], $product['tax_class_id']
                        ) - $this->tax->calcTotalTaxAmount($product['total'] - $discount, $product['tax_class_id']);
                }
            }
            return true;
        }
        return false;
    }

    /**
     * @param array $bonus
     *
     * @return bool|float|int|null
     * @throws AException
     */
    private function _process_bonus($bonus) {
        $bonus['value'] = !isset($bonus['value']) ? [] : $bonus['value'];
        $discount = 0;
        $exclude_product_price = $exclude_category_product_price = $exclude_brand_product_price = 0;
        switch ($bonus['object']) {
            case 'order_discount':
                $subtotal = false;
                  foreach ($this->total_data as $item) {
                    if ($item['id'] == 'subtotal') {
                        foreach ($this->exclude_product_price as $exc_prod_price) {
                            $exclude_product_price += (float)$exc_prod_price;
                        }

                        foreach ($this->exclude_category_product_price as $exc_cat_prod_price) {
                            $exclude_product_price += (float)$exc_cat_prod_price;
                        }

                        foreach ($this->exclude_brand_product_price as $exc_brand_prod_price) {
                            $exclude_brand_product_price += (float)$exc_brand_prod_price;
                        }

                        $subtotal = $item['value'] - $exclude_product_price - $exclude_category_product_price - $exclude_brand_product_price;
                        break;
                    }
                }
                if ($subtotal === false) {
                    return null;
                }

                $discount = $this->_get_discount($bonus['operator'], $subtotal, $bonus['value']);
                break;
            case 'free_shipping':
                $shipping_cost = false;
                foreach ($this->total_data as $item) {
                    if ($item['id'] == 'shipping') {
                        $shipping_method = $this->session->data['shipping_method']['id'] ?? $this->session->data['fc']['shipping_method']['id'];
                        $shipping_method = explode('.', $shipping_method);
                        $shipping_method = $shipping_method[0];

                        if (in_array($shipping_method, $bonus['value'])) {
                            $shipping_cost = $item['value'];
                            break;
                        }
                    }
                }
                if ($shipping_cost === false) {
                    return null;
                }
                $discount = $shipping_cost;
                break;
            case 'discount_products':
                $products = $this->cart->getProducts();
                foreach ($products as $product) {
                    if (sizeof((array)$this->exclude_products) > 0 && in_array($product['product_id'],$this->exclude_products)) {
                        continue;
                    }
                    if (in_array($product['product_id'], array_keys($bonus['products']))) {
                        $total = $product['price'] * $bonus['products'][$product['product_id']]['quantity'];
                        $discount += $this->_get_discount($bonus['operator'], $total, $bonus['value']);
                        unset($bonus['products'][$products['product_id']]); // prevent repetition of bonus
                    }
                }
                break;
            case 'free_products':
                $products = $this->cart->getProducts();
                foreach ($products as $product) {
                    if (sizeof((array)$this->exclude_products) > 0 && in_array($product['product_id'],$this->exclude_products)) {
                        continue;
                    }
                    if (in_array($product['product_id'], array_keys($bonus['products']))) {
                        $discount += $product['price'] * $bonus['products'][$product['product_id']]['quantity'];
                        unset($bonus['products'][$products['product_id']]); // prevent repetition of bonus
                    }
                }
                break;
        }
        return $discount;
    }

    private function _get_discount($operator, $price, $value) {
        $discount = 0;

        if ($operator == 'to_prc') {
            $discount = $price * (100 - $value) / 100;
        } elseif ($operator == 'by_prc') {
            $discount = $price * $value / 100;
        } elseif ($operator == 'to_fixed') {
            $discount = $price - $value;
        } elseif ($operator == 'by_fixed') {
            $discount = $value;
        }

        if ($discount < 0) {
            $discount = 0;
        }

        return $discount;
    }

}