<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2023 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

class ModelExtensionPromoManager extends Model {

    protected $total;
    protected $total_data;
    protected $taxes;
    protected $exclude_product_price = [];
    protected $exclude_category_product_price = [];
    protected $exclude_brand_product_price = [];
    protected $exclude_products = [];
    protected $exclude_category_products = [];
    protected $exclude_brand_products = [];

    /**
     * @param $promo_manager_id
     * @return mixed
     * @throws AException
     */
    public function getInfoBannerId($promo_manager_id) {
        $sql = "SELECT `info_banner_id` FROM ".$this->db->table("promo_manager_info_banner_related")." WHERE `promo_manager_id`='".$promo_manager_id."'";
        $query = $this->db->query($sql);
        return $query->row['info_banner_id'];
    }

    /**
     * @param $info_banner_id
     * @return mixed
     * @throws AException
     */
    public function getPromoManagerId($info_banner_id) {
        $sql = "SELECT `promo_manager_id` FROM ".$this->db->table("promo_manager_info_banner_related")." WHERE `info_banner_id`='".$info_banner_id."'";
        $query = $this->db->query($sql);
        return $query->row['promo_manager_id'];
    }

    public function getPromo() {
        $sql = "SELECT p.*, COALESCE(`end_date`, '2200-00-00 00:00:00') as end_date,  COALESCE(pd.name,'promo_manager') as name
                    FROM " . $this->db->table('promo_manager') . " p
                    LEFT JOIN " . $this->db->table('promo_manager_descriptions') . " pd
                        ON pd.promo_manager_id=p.promo_manager_id AND pd.language_id = '" . $this->language->getLanguageID() . "'
                    WHERE `status` = '1'
                    ORDER BY priority;";

        $promo_managers = $this->db->query($sql);
        $promo_managers = $promo_managers->rows;
        foreach ($promo_managers as &$promo) {
            $promo['conditions'] = unserialize($promo['conditions']);
            $promo['conditions']['relation']['value'] = !($promo['conditions']['relation']['value'] == 'false');
            $promo['bonuses'] = unserialize($promo['bonuses']);
        }
        unset($promo);
        $info_banner_id = [];
        foreach ($promo_managers as $promo_manager) {
            $start_date = strtotime($promo_manager['start_date']);
            $end_date = $promo_manager['end_date'] != '0000-00-00 00:00:00' ? strtotime($promo_manager['end_date']) : false;
            $end_date = $end_date === false ? (time() + 86400) : $end_date;
            if (time() < $start_date || time() > $end_date) {
                continue;
            }

            $result = $this->_check_conditions($promo_manager['conditions']);
            if ($result) {
                $res = $this->_apply_bonuses($promo_manager['name'], $promo_manager['bonuses']);
                if ($res && $promo_manager['stop']) {
                    $info_banner_id[] = $this->getInfoBannerId($promo_manager['promo_manager_id']);
                    break;
                } else {
                    $info_banner_id[] = $this->getInfoBannerId($promo_manager['promo_manager_id']);
                }
            }
        }
        return $info_banner_id;
    }

    public function isValid() {
        $sql = "SELECT p.*, COALESCE(`end_date`, '2200-00-00 00:00:00') as end_date,  COALESCE(pd.name,'promo_manager') as name
                    FROM " . $this->db->table('promo_manager') . " p
                    LEFT JOIN " . $this->db->table('promo_manager_descriptions') . " pd
                        ON pd.promo_manager_id=p.promo_manager_id AND pd.language_id = '" . $this->language->getLanguageID() . "'
                    WHERE `status` = '1'
                    ORDER BY priority;";

        $promo_managers = $this->db->query($sql);
        $promo_managers = $promo_managers->rows;
        foreach ($promo_managers as &$promo) {
            $promo['conditions'] = unserialize($promo['conditions']);
            $promo['conditions']['relation']['value'] = !($promo['conditions']['relation']['value'] == 'false');
            $promo['bonuses'] = unserialize($promo['bonuses']);
        }
        unset($promo);
        $valid = '0';
        foreach ($promo_managers as $promo_manager) {
            $start_date = strtotime($promo_manager['start_date']);
            $end_date = $promo_manager['end_date'] != '0000-00-00 00:00:00' ? strtotime($promo_manager['end_date']) : false;
            $end_date = $end_date === false ? (time() + 86400) : $end_date;
            if (time() < $start_date || time() > $end_date) {
                continue;
            }

            $result = $this->_check_conditions($promo_manager['conditions']);
            if ($result) {
                $valid = '1';
            }
        }
        return $valid;
    }

    /**
     * @param array $conditions
     *
     * @return bool|null
     * @throws AException
     */
    private function _check_conditions($conditions) {
        if (!is_array($conditions['conditions'])) {
            return null;
        }

        foreach ($conditions['conditions'] as $condition) {
            $result = $this->_check_condition($condition);
            if ($conditions['relation']['if'] == 'any'
                && $result === $conditions['relation']['value']
            ) {
                return true;
            } elseif ($conditions['relation']['if'] == 'all'
                && $result !== $conditions['relation']['value']
            ) {
                return false;
            }
        }

        // if still not returned
        return !($conditions['relation']['if'] == 'any');
    }

    /**
     * @param array $condition
     *
     * @return bool|null
     * @throws AException
     */
    private function _check_condition($condition) {
        if (!$condition['object']) {
            return null;
        }
        $products_ids = [];

        if (IS_ADMIN) {
            $this->load->model('sale/order');
            $order_id = $this->request->get['order_id'];
            $order_info = $this->model_sale_order->getOrder($order_id);
            $customer_id = $order_info['customer_id'];
            $customer_group_id = $order_info['customer_group_id'];
        } else {
             if ($this->customer->isLogged() || $this->customer->isUnauthCustomer()) {
                $customer_id = $this->customer->getId();
                $customer_group_id = $this->customer->getCustomerGroupId();
            } else {
                 $customer_group_id = $this->config->get('config_customer_group_id');
            }
        }

        $this->exclude_products = [];

        switch ($condition['object']) {
            case 'products':
                $products = $this->cart->getProducts();
                foreach ($products as $product) {
                    if ($condition['operator'] === 'notin' && in_array($product['product_id'], (array)$condition['value'])) {
                        $this->exclude_product_price[] = ($product['price'] * $product['quantity']);
                        $this->exclude_products[] = $product['product_id'];
                        continue;
                    }
                    $products_ids[] = $product['product_id'];
                }
                if ($products_ids) {
                    return $this->_run_comparison($products_ids, $condition['value'], $condition['operator']);
                } else {
                    return false;
                }
            case 'product_price':
                $products = $this->cart->getProducts();
                foreach ($products as $product) {
                    if ($this->_run_comparison($product['price'], $condition['value'], $condition['operator'])) {
                        return true;
                    }
                }
                return false;
            case 'categories':
                $products = $this->cart->getProducts();
                $this->load->model('catalog/product');
                $cart_categories = [];
                foreach ($products as $product) {
                    $res = $this->model_catalog_product->getCategories($product['product_id']);
                    foreach ($res as $row) {
                        if ($condition['operator'] === 'notin' && in_array($row['category_id'], (array)$condition['value'])) {
                            $this->exclude_category_product_price[] = $product['price'] * $product['quantity'];
                            $this->exclude_products[] = $product['product_id'];
                            continue;
                        }
                        $cart_categories[] = $row['category_id'];
                    }
                }
                $cart_categories = array_unique($cart_categories);
                if ($cart_categories) {
                    return $this->_run_comparison($cart_categories, $condition['value'], $condition['operator']);
                } else {
                    return false;
                }
            case 'brands':
                $products = $this->cart->getProducts();
                $this->load->model('catalog/manufacturer');
                $cart_brands = [];
                foreach ($products as $product) {
                    $res = $this->model_catalog_manufacturer->getManufacturerByProductId($product['product_id']);
                    foreach ($res as $row) {
                        if ($condition['operator'] === 'notin' && in_array($row['manufacturer_id'], (array)$condition['value'])) {
                            $this->exclude_brand_product_price[] = ($product['price'] * $product['quantity']);
                            $this->exclude_products[] = $product['product_id'];
                            continue;
                        }
                        $cart_brands[] = $row['manufacturer_id'];
                    }
                }
                $cart_brands = array_unique($cart_brands);
                if ($cart_brands) {
                    return $this->_run_comparison($cart_brands, $condition['value'], $condition['operator']);
                } else {
                    return false;
                }
            case 'customers':
                $customer = $customer_id;
                return $this->_run_comparison($customer, $condition['value'], $condition['operator']);
            case 'customer_groups':
                $customer_group = $customer_group_id;
                return $this->_run_comparison($customer_group, $condition['value'], $condition['operator']);
            case 'customer_country':
            case 'customer_postcode':
                $address_id = $this->session->data['shipping_address_id'] ?? $this->session->data['fc']['shipping_address_id'];
                $address_id = !$address_id ? $this->customer->getAddressId() : $address_id;

                $this->load->model('account/address');
                $res = $this->model_account_address->getAddress($address_id);

                if ($condition['object'] == 'customer_country') {
                $id = (int)$res['country_id'];
            } else {
                $id = (int)$res['postcode'];
            }
            return $this->_run_comparison($id, $condition['value'], $condition['operator']);
            case 'order_subtotal':
                $subtotal = $this->cart->getSubtotal();
                if (!in_array($condition['operator'], ['in', 'notin'])) {
                    $condition['value'] = (float)$condition['value'];
                } else {
                    $condition['value'] = explode(',', $condition['value']);
                }
                return $this->_run_comparison($subtotal, $condition['value'], $condition['operator']);
            case 'order_product_count':
                $products_count = $this->cart->countProducts();
                if (!in_array($condition['operator'], ['in', 'notin'])) {
                    $condition['value'] = (int)$condition['value'];
                } else {
                    $condition['value'] = explode(',', $condition['value']);
                }
                return $this->_run_comparison($products_count, $condition['value'], $condition['operator']);

            case 'order_product_weight':
                $weight = round($this->cart->getWeight(), 2);
                if (!in_array($condition['operator'], ['in', 'notin'])) {
                    $condition['value'] = round((float)$condition['value'], 2);
                } else {
                    $condition['value'] = explode(',', $condition['value']);
                }
                return $this->_run_comparison($weight, $condition['value'], $condition['operator']);
            case 'payment_method':
                $payment_method = $this->session->data['payment_method']['id'] ?? $this->session->data['fc']['payment_method']['id'];
                return $this->_run_comparison($payment_method, $condition['value'], $condition['operator']);
            case 'shipping_method':
                $shipping_method = $this->session->data['shipping_method']['id'] ?? $this->session->data['fc']['shipping_method']['id'];
                $shipping_method = explode('.', $shipping_method);
                $shipping_method = $shipping_method[0];
                return $this->_run_comparison($shipping_method, $condition['value'], $condition['operator']);
            case 'coupon_code':
                $coupon_code = $this->request->post['coupon'] ?? $this->request->get['coupon_code'];
                return $this->_run_comparison($coupon_code, $condition['value'], $condition['operator']);
        }
        return null;
    }

    /**
     * @param mixed $value1
     * @param mixed $value2
     * @param string $operator
     *
     * @return bool
     */
    protected function _run_comparison($value1, $value2, $operator) {
        switch ($operator) {
            case 'eq':
                return ($value1 == $value2);
            case 'neq':
                return ($value1 != $value2);
            case 'eqlt':
                return ($value1 <= $value2);
            case 'eqgt':
                return ($value1 >= $value2);
            case 'lt':
                return ($value1 < $value2);
            case 'gt':
                return ($value1 > $value2);
            case 'in':
                $value2 = (array) $value2;
                if (!is_array($value1)) {
                    return in_array($value1, $value2);
                } else {
                    return (bool) array_intersect($value1, $value2);
                }
            case 'notin':
                $value2 = (array) $value2;
                if (!is_array($value1)) {
                    return !in_array($value1, $value2);
                } else {
                    return !array_intersect($value1, $value2);
                }
            case 'ctn':
                return is_int(strpos((string) $value1, (string) $value2));
            case 'nctn':
                return !is_int(strpos((string) $value1, (string) $value2));
            default:
                return false;
        }
    }

    /**
     * @param string $promo_managers_name
     * @param array $bonuses
     *
     * @return bool
     * @throws AException
     */
    private function _apply_bonuses($promo_managers_name, $bonuses) {
        $applied = [];
        $discount = 0;

        foreach ($bonuses as $bonus) {
            if (!in_array($bonus['object'], $applied)) {
                $bonus_discount = $this->_process_bonus($bonus);
                if (($discount + $bonus_discount) > $this->cart->getTotal()) {
                    break; // prevent negative total
                }
                $discount += $bonus_discount;
            }
        }

        if ($discount) {
            return true;
        }
        return false;
    }

    /**
     * @param array $bonus
     *
     * @return bool|float|int|null
     * @throws AException
     */
    private function _process_bonus($bonus) {
        $bonus['value'] = !isset($bonus['value']) ? [] : $bonus['value'];
        $discount = 0;
        $exclude_product_price = $exclude_category_product_price = $exclude_brand_product_price = 0;
        switch ($bonus['object']) {
            case 'order_discount':
                $subtotal = false;
                foreach ($this->cart->getFinalTotalData() as $item) {
                    if ($item['id'] == 'subtotal') {
                        foreach ($this->exclude_product_price as $exc_prod_price) {
                            $exclude_product_price += (float)$exc_prod_price;
                        }

                        foreach ($this->exclude_category_product_price as $exc_cat_prod_price) {
                            $exclude_product_price += (float)$exc_cat_prod_price;
                        }

                        foreach ($this->exclude_brand_product_price as $exc_brand_prod_price) {
                            $exclude_brand_product_price += (float)$exc_brand_prod_price;
                        }

                        $subtotal = $item['value'] - $exclude_product_price - $exclude_category_product_price - $exclude_brand_product_price;
                        break;
                    }
                }
                if ($subtotal === false) {
                    return null;
                }

                $discount = $this->_get_discount($bonus['operator'], $subtotal, $bonus['value']);
                break;
            case 'free_shipping':
                $shipping_cost = false;
                foreach ($this->cart->getFinalTotalData() as $item) {
                    if ($item['id'] == 'shipping') {
                        $shipping_method = $this->session->data['shipping_method']['id'] ?? $this->session->data['fc']['shipping_method']['id'];
                        $shipping_method = explode('.', $shipping_method);
                        $shipping_method = $shipping_method[0];

                        if (in_array($shipping_method, $bonus['value'])) {
                            $shipping_cost = $item['value'];
                            break;
                        }
                    }
                }
                if ($shipping_cost === false) {
                    return null;
                }
                $discount = $shipping_cost;
                break;
            case 'discount_products':
                $products = $this->cart->getProducts();
                foreach ($products as $product) {
                    if (sizeof((array)$this->exclude_products) > 0 && in_array($product['product_id'],$this->exclude_products)) {
                        continue;
                    }
                    if (in_array($product['product_id'], array_keys($bonus['products']))) {
                        $total = $product['price'] * $bonus['products'][$product['product_id']]['quantity'];
                        $discount += $this->_get_discount($bonus['operator'], $total, $bonus['value']);
                        unset($bonus['products'][$products['product_id']]); // prevent repetition of bonus
                    }
                }
                break;
            case 'free_products':
                $products = $this->cart->getProducts();
                foreach ($products as $product) {
                    if (sizeof((array)$this->exclude_products) > 0 && in_array($product['product_id'],$this->exclude_products)) {
                        continue;
                    }
                    if (in_array($product['product_id'], array_keys($bonus['products']))) {
                        $discount += $product['price'] * $bonus['products'][$product['product_id']]['quantity'];
                        unset($bonus['products'][$products['product_id']]); // prevent repetition of bonus
                    }
                }
                break;
        }
        return $discount;
    }

    private function _get_discount($operator, $price, $value) {
        $discount = 0;

        if ($operator == 'to_prc') {
            $discount = $price * (100 - $value) / 100;
        } elseif ($operator == 'by_prc') {
            $discount = $price * $value / 100;
        } elseif ($operator == 'to_fixed') {
            $discount = $price - $value;
        } elseif ($operator == 'by_fixed') {
            $discount = $value;
        }

        if ($discount < 0) {
            $discount = 0;
        }

        return $discount;
    }
}