<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2023 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

//add promo_manager total
/**
 * @var AController $this
 */
$child_extension_id = $this->extension_manager->add(
    [
        'type'     => 'total',
        'key'      => 'promo_manager_total',
        'status'   => 1,
        'priority' => 10,
        'version'  => '1.0',
    ]
);
// edit settings
$this->load->model('setting/setting');
//insert promo_manager_total before total
$sort = $this->config->get('total_sort_order');
$calc = $this->config->get('total_calculation_order');

$this->model_setting_setting->editSetting(
    'promo_manager_total',
    [
        'promo_manager_total_status'            => 1,
        'promo_manager_total_sort_order'        => ($sort - 2),
        'promo_manager_total_calculation_order' => ($calc - 2),
        'promo_manager_total_total_type'        => 'promo_manager_total',
    ]
);

$this->extension_manager->addDependant('promo_manager_total', $name);

// add new menu item
$rm = new AResourceManager();
$rm->setType('image');

$language_id = $this->language->getContentLanguageID();
$data = [];
$data['resource_code'] = '<i class="fa fa-rocket"></i>&nbsp;';
$data['name'] = [$language_id => 'Menu Icon Promo Manager'];
$data['title'] = [$language_id => ''];
$data['description'] = [$language_id => ''];
$resource_id = $rm->addResource($data);

// add new menu item
$menu = new AMenu ("admin");
$menu->insertMenuItem(
    [
        "item_id"         => "promo_manager",
        "parent_id"       => "sale",
        "item_text"       => "promo_manager_name",
        "item_url"        => "sale/promo_manager",
        "item_icon_rl_id" => $resource_id,
        "item_type"       => "extension",
        "sort_order"      => "7",
    ]
);

$sql = "CREATE TABLE IF NOT EXISTS ".$this->db->table('promo_manager')." (
`promo_manager_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
`conditions` text NOT NULL,
`bonuses` text NOT NULL,
`start_date` datetime NOT NULL,
`end_date` datetime NOT NULL,
`priority` mediumint(8) unsigned NOT NULL DEFAULT '0',
`stop` char(1) NOT NULL DEFAULT 'N',
`promo_manager_type` enum('products','global') NOT NULL DEFAULT 'global',
`conditions_hash` text NOT NULL,
`status` char(1) NOT NULL DEFAULT 'A',
`number_of_usages` mediumint(8) NOT NULL DEFAULT '0',
`users_conditions_hash` text NOT NULL,
`date_added` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
`date_modified` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
PRIMARY KEY (`promo_manager_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;";
$this->db->query($sql);

$sql1 = "CREATE TABLE IF NOT EXISTS ".$this->db->table('promo_manager_descriptions')." (
`promo_manager_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
`language_id` mediumint(8) NOT NULL DEFAULT 1,
`name` varchar(255) NOT NULL DEFAULT '',
`description_short` text NOT NULL,
`description` mediumtext NOT NULL,
`date_added` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
`date_modified` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
PRIMARY KEY (`promo_manager_id`,`language_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;";
$this->db->query($sql1);

$sql1 = "CREATE TABLE IF NOT EXISTS ".$this->db->table('promo_manager_info_banner_related')." (
`promo_manager_id` mediumint(8) NOT NULL DEFAULT '0',
`info_banner_id` mediumint(8) NOT NULL DEFAULT '0',
PRIMARY KEY (`promo_manager_id`,`info_banner_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;";
$this->db->query($sql1);

$sql3 = "CREATE TABLE IF NOT EXISTS ".$this->db->table("promo_manager_license_info") ."(
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `public_key` TEXT NOT NULL,
  `license_data` TEXT NOT NULL,
  `license_key` TEXT NOT NULL,
  `store_id` int(11) NOT NULL,
  `last_check` int(11),
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci";

$this->db->query($sql3);

$sql4 = "CREATE TABLE IF NOT EXISTS ".$this->db->table("promo_manager_updater_notification") ."(
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `msg_id` int(11) NOT NULL,
  `cart_version` VARCHAR(10),
  `extension_version` VARCHAR(10),
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci";

$this->db->query($sql4);

if (!file_exists(DIR_SYSTEM.'lib/license.php')) {
    /**
     *  Function to Copy folders and files
     * @param $src
     * @param $dst
     * @return array
     */
    function custom_copy($src, $dst) {
        $error = array();
        // open the source directory
        $dir = opendir($src);
        if (!is_dir($dst)) {
            @mkdir($dst);
        }
        // Loop through the files in source directory
        foreach (scandir($src) as $file) {
            if (($file != '.') && ($file != '..')) {
                if (is_dir($src . '/' . $file)) {
                    // Recursively calling custom copy function
                    // for sub directory
                    custom_copy($src . '/' . $file, $dst . '/' . $file);
                } else {
                    if (!copy($src . '/' . $file, $dst . '/' . $file)) {
                        $error['error_copy'][] = "Failed to copy $file";
                    }
                }
            }
        }
        if (sizeof($error)>0) {
            $log=new ALog(DIR_SYSTEM.'logs/error.txt');
            $log->write(var_export($error,true));
        }
        closedir($dir);
        return $error;
    }

    $copy = custom_copy(DIR_EXT . 'promo_manager' . DIR_EXT_CORE . 'lib', DIR_SYSTEM.'lib');
}