<?php

/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2023 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

class ModelSalePromoManager extends Model {

    /**
     * @param $data
     * @return int
     * @throws AException
     */
    public function addpromotion($data = []) {
        $data['start_date'] = $data['start_date']
            ? dateDisplay2ISO($data['start_date'], $this->language->get('date_format_short'))
            : '';
        $data['end_date'] = $data['end_date']
            ? dateDisplay2ISO($data['end_date'], $this->language->get('date_format_short'))
            : '';

        $data['promo_manager_type'] = !isset($data['promo_manager_type']) ? 'global' : $data['promo_manager_type'];
        $sql = "INSERT INTO `".$this->db->table('promo_manager')."`
                (`status`,`promo_manager_type`,`start_date`,`end_date`,`stop`,`priority`,`date_added`)
                VALUES ('".(int) $data['status']."',
                        '".$this->db->escape($data['promo_manager_type'])."',
                        ".($data['start_date']
                            ? "DATE('".$this->db->escape($data['start_date'])."'),"
                            : "'0000-00-00', ")."
                        ".($data['end_date'] ? "DATE('".$this->db->escape($data['end_date'])."')," : "'0000-00-00', ")."
                        '".(int) $data['stop']."',
                        '".(int) $data['priority']."',
                         'NOW()' )";
        $this->db->query($sql);
        $promo_manager_id = $this->db->getLastId();

        $this->language->replaceDescriptions(
            'promo_manager_descriptions',
            ['promo_manager_id' => (int) $promo_manager_id],
            [
                $this->language->getContentLanguageID() => [
                    'name'              => $data['name'],
                    'description'       => $data['description'],
                    'description_short' => $data['description_short'],
                    'date_added'        => dateInt2ISO(time()),
                ],
            ]
        );
        $this->cache->remove('promo_manager');
        return $promo_manager_id;
    }

    /**
     * @param $promo_manager_id
     * @param $data
     * @return void
     * @throws AException
     */
    public function editpromotion($promo_manager_id, $data) {
        $promo_manager_id = (int) $promo_manager_id;
        $language_id = (int) $this->language->getContentLanguageID();

        if (isset($data['start_date'])) {
            $data['start_date'] = $data['start_date']
                ? dateDisplay2ISO($data['start_date'], $this->language->get('date_format_short'))
                : date('Y-m-d');
        }
        if (isset($data['end_date'])) {
            $data['end_date'] = $data['end_date']
                ? dateDisplay2ISO($data['end_date'], $this->language->get('date_format_short'))
                : '';
        }

        $data['promo_manager_type'] = !isset($data['promo_manager_type']) ? 'global' : $data['promo_manager_type'];

        $update_arr = [];
        $allowed_fields = ['name', 'description', 'description_short'];
        foreach ($allowed_fields as $field_name) {
            if (isset($data[$field_name])) {
                $update_arr[$field_name] = $data[$field_name];
            }
        }

        if ($update_arr) {
            $update_arr['date_added'] = dateInt2ISO(time());
            $this->language->replaceDescriptions(
                'promo_manager_descriptions',
                ['promo_manager_id' => (int) $promo_manager_id],
                [$language_id => $update_arr]
            );
        }

        $allowed_fields = [
            'conditions'       => '',
            'bonuses'          => '',
            'start_date'       => '',
            'end_date'         => '',
            'priority'         => 'int',
            'stop'             => 'int',
            'promo_manager_type'   => '',
            'status'           => 'int',
            'number_of_usages' => 'int',
        ];
        $sql = "UPDATE `".$this->db->table('promo_manager')."`
                SET ";
        $tmp = [];
        foreach (array_keys($allowed_fields) as $field_name) {
            if (isset($data[$field_name])) {
                $data[$field_name] = in_array($field_name, ['bonuses', 'conditions'])
                    ? serialize($data[$field_name])
                    : $data[$field_name];
                $tmp[] = "`".$field_name."` = '"
                    .($allowed_fields[$field_name] == 'int'
                        ? (int) $data[$field_name]
                        : $this->db->escape($data[$field_name]))."'\n";
            }
        }
        $sql .= implode(', ', $tmp);
        $sql .= " WHERE promo_manager_id='".$promo_manager_id."'";
        if ($tmp) {
            $this->db->query($sql);
        }

        if (isset($data['info_banner_related'])) {
            $this->db->query(
                "DELETE FROM ".$this->db->table("promo_manager_info_banner_related")." 
                WHERE `promo_manager_id` = '".(int) $promo_manager_id."'"
            );
            $this->db->query(
                "INSERT INTO ".$this->db->table("promo_manager_info_banner_related")." 
                        SET `promo_manager_id` = '".(int) $promo_manager_id."', `info_banner_id` = '".(int) $data['info_banner_related']."'"
            );
        }

        $this->cache->remove('promo_manager');
    }

    public function deleteInfoBannerRelation($promo_manager_id) {

    }

    /**
     * @param $promo_manager_id
     * @return bool
     * @throws AException
     */
    public function deletepromotion($promo_manager_id) {
        $promo_manager_id = (int) $promo_manager_id;
        if (!$promo_manager_id) {
            return false;
        }

        $sql[] = "DELETE FROM `".$this->db->table('promo_manager')."` 
                WHERE promo_manager_id = '".$promo_manager_id."'";
        $sql[] = "DELETE FROM `".$this->db->table('promo_manager_descriptions')."` 
                WHERE promo_manager_id = '".$promo_manager_id."'";
        foreach ($sql as $s) {
            $this->db->query($s);
        }
        $this->cache->remove('promo_manager');
        return true;
    }

    /**
     * @param $filter
     * @param $mode
     * @return mixed
     * @throws AException
     */
    public function getpromotions($filter, $mode = '') {
        if (!empty($data['language_id'])) {
            $language_id = ( int ) $data['language_id'];
        } else {
            $language_id = $this->language->getContentLanguageID();
        }

        if ($mode == 'total_only') {
            $sql = "SELECT COUNT(*) as total
                    FROM ".$this->db->table('promo_manager')." p
                    LEFT JOIN ".$this->db->table('promo_manager_descriptions')." pd
                        ON (p.promo_manager_id = pd.promo_manager_id AND pd.language_id = '".$language_id."')";
        } else {
            $sql = "SELECT pd.*, p.*
                    FROM ".$this->db->table('promo_manager')." p
                    LEFT JOIN ".$this->db->table('promo_manager_descriptions')." pd
                        ON (p.promo_manager_id = pd.promo_manager_id AND pd.language_id = '".$language_id."')";
        }

        if (!empty($filter['subsql_filter'])) {
            $sql .= " WHERE ".$filter['subsql_filter'];
        }

        $sort_data = [
            'name'          => 'pd.name',
            'status'        => 'p.status',
            'priority'      => 'p.priority',
            'date_modified' => 'p.date_modified',
            'daterange'     => '(COALESCE(p.end_date,NOW()) - p.start_date) ',
        ];

        if (isset($filter['sort']) && in_array($filter['sort'], array_keys($sort_data))) {
            $sql .= " ORDER BY ".$sort_data[$filter['sort']];
        } else {
            $sql .= " ORDER BY pd.name";
        }

        if (isset($filter['order']) && ($filter['order'] == 'DESC')) {
            $sql .= " DESC";
        } else {
            $sql .= " ASC";
        }

        if (isset($filter['start']) || isset($filter['limit'])) {
            if ($filter['start'] < 0) {
                $filter['start'] = 0;
            }

            if ($filter['limit'] < 1) {
                $filter['limit'] = 20;
            }

            $sql .= $mode != 'total_only' ? " LIMIT ".(int) $filter['start'].",".(int) $filter['limit'] : '';
        }

        $result = $this->db->query($sql);

        $output = '';
        if ($mode == 'total_only') {
            $output = $result->row['total'];
        } else {
            $output = $result->rows;
        }
        return $output;
    }

    /**
     * @param $promo_manager_id
     * @param $language_id
     * @return mixed
     * @throws AException
     */
    public function getpromotion($promo_manager_id, $language_id = '') {
        $promo_manager_id = (int) $promo_manager_id;
        $language_id = (int) $language_id;
        if (!$language_id) {
            $language_id = (int) $this->language->getContentLanguageID();
        }

        $sql = "SELECT  pd.*, p.*
                FROM `".$this->db->table('promo_manager')."` p
                LEFT JOIN `".$this->db->table('promo_manager_descriptions')."` pd
                    ON (pd.promo_manager_id = p.promo_manager_id AND pd.language_id = '".$language_id."')
                WHERE p.promo_manager_id='".$promo_manager_id."'";
        $result = $this->db->query($sql);
        return $result->row;
    }

}