<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2023 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

require_once DIR_SYSTEM . "lib/vendor/autoload.php";
require_once DIR_SYSTEM . "lib/license.php";

/**
 * @property ModelSalePromoManager $model_sale_promo_manager
 * @property ModelExtensionPromoManagerLicenseInfo $model_extension_promo_manager_license_info
 * @property Aform $form
 */
class ControllerResponsesListingGridPromoManager extends AController {

    protected $form;

    public function verify() {
        if ($this->config->get('promo_manager_status') === '1') {
            $this->load->model('extension/promo_manager_license_info');
            $license_key = $this->config->get('promo_manager_license_code');
            if ($license_key) {
                $exist = $this->db->query("SHOW TABLES LIKE '" . $this->db->table('promo_manager_license_info') . "'");
                if ($exist->num_rows === 1) {
                    $store_id = $this->model_extension_promo_manager_license_info->getStoreId();
                    $license_key = $this->model_extension_promo_manager_license_info->getLicenseCode($store_id);
                    $license_info = $this->model_extension_promo_manager_license_info->getLicenseData($store_id);
                    $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                    $license = new License($path_to_phpseclib);
                    $license_manager = $license->getManager();
                    $license_manager->setKeys($license_key, $license_info['public_key'], 'promo_manager');
                    $ttl = 1209600;
                    $validate = $license_manager->validate($license_info['license_data'], $ttl);
                    $store_status = $this->model_extension_promo_manager_license_info->getLicensedStoreStatus();
                    if ($validate['status'] === 'valid' && $store_status == 1) {
                        return true;
                    } else {
                        return false;
                    }
                }
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

    public function main() {
        //init controller data
        $this->extensions->hk_InitData($this, __FUNCTION__);

        $this->loadLanguage('promo_manager/promo_manager');
        $this->loadModel('sale/promo_manager');

        //Prepare filter config
        $grid_filter_params = ['name'];
        $filter = new AFilter(['method' => 'post', 'grid_filter_params' => $grid_filter_params]);
        $filter_data = $filter->getFilterData();

        $total = $this->model_sale_promo_manager->getPromotions($filter_data, 'total_only');
        $response = new stdClass();
        $response->page = $filter->getParam('page');
        $response->total = $filter->calcTotalPages($total);
        $response->records = $total;
        $response->userdata = (object) [''];
        $results = $this->model_sale_promo_manager->getPromotions($filter_data);

        $results = !$results ? [] : $results;

        $i = 0;
        foreach ($results as $result) {
            $daterange = dateISO2Display($result['start_date'], $this->language->get('date_format_short'));
            if ($result['end_date'] != '0000-00-00 00:00:00') {
                $daterange .= ' - '.dateISO2Display($result['end_date'], $this->language->get('date_format_short'));
            } else {
                $daterange .= ' - '.$this->language->get('promo_manager_no_expiration');
            }

            $response->rows[$i]['id'] = $result['promo_manager_id'];
            $response->rows[$i]['cell'] = [
                $result['name'],
                $this->html->buildInput(
                    [
                        'name'  => 'priority['.$result['promo_manager_id'].']',
                        'value' => $result['priority'],
                    ]
                ),
                $daterange,
                $this->html->buildCheckbox(
                    [
                        'name'  => 'status['.$result['promo_manager_id'].']',
                        'value' => $result['status'],
                        'style' => 'btn_switch',
                    ]
                ),

            ];
            $i++;
        }
        //update controller data
        $this->extensions->hk_UpdateData($this, __FUNCTION__);

        $this->load->library('json');
        $this->response->setOutput(AJson::encode($response));
    }

    public function getFieldsByConditionObject($value = null) {
        $this->loadLanguage('promo_manager/promo_manager');

        $promo = new APromotion();
        $cond_objects = $promo->getConditionObjects();
        if (!in_array($this->request->post['condition_object'], $cond_objects)) {
            return;
        }

        $this->form = new AForm ('HT');
        $this->form->setForm(
            [
                'form_name' => 'promoManagerFrm',
                'update'    => $this->html->getSecureURL(
                    'listing_grid/promo_manager/update_field',
                    '&promo_manager_id='.$this->request->get['promo_manager_id']
                ),
            ]
        );
        $method = '_getFieldsFor'.str_replace(
                ' ',
                '',
                ucwords(str_replace('_', ' ', $this->request->post['condition_object']))
            );
        $response = [];
        if (method_exists($this, $method)) {
            $response = call_user_func([$this, $method], $value);
        }
        if ($response['fields']) {
            $value = $this->request->post['condition_object'];
            $response['fields'] .= $this->form->getFieldHtml(
                [
                    'type'  => 'hidden',
                    'name'  => 'conditions[conditions]['.$this->request->post['idx'].'][object]',
                    'value' => $value,
                ]
            );
        }

        $this->load->library('json');
        $this->response->setOutput(AJson::encode($response));
    }

    protected function _getFieldsForProducts($value = '') {
        $listing_data = [];
        if (is_array($value['value']) && $value['value']) {
            $this->loadModel('catalog/product');
            $filter = ['subsql_filter' => 'p.product_id in ('.implode(',', $value['value']).')'];
            $results = $this->model_catalog_product->getProducts($filter);
            if ($results) {
                $resource = new AResource('image');
                foreach ($results as $r) {
                    $product_id = $r['product_id'];
                    $thumbnail = $resource->getMainThumb(
                        'products',
                        $product_id,
                        (int) $this->config->get('config_image_grid_width'),
                        (int) $this->config->get('config_image_grid_height'),
                        true
                    );
                    $listing_data[$product_id]['name'] = $r['name']." (".$r['model'].")";
                    $listing_data[$product_id]['image'] = $thumbnail['thumb_html'];
                }
            }
        }

        $response['text'] = $this->language->get('entry_products');
        $response['fields'] = $this->form->getFieldHtml(
            [
                'type'    => 'selectbox',
                'name'    => 'conditions[conditions]['.$this->request->post['idx'].'][operator]',
                'options' => [
                    'in'    => $this->language->get('text_in'),
                    'notin' => $this->language->get('text_not_in'),
                ],
                'value'   => $value['operator'],
            ]
        );

        $response['fields'] .= $this->form->getFieldHtml(
            [
                'type'        => 'multiselectbox',
                'name'        => 'conditions[conditions]['.$this->request->post['idx'].'][value][]',
                'value'       => !$value ? '' : $value['value'],
                'options'     => $listing_data,
                'style'       => 'chosen',
                'ajax_url'    => $this->html->getSecureURL('r/product/product/products'),
                'placeholder' => $this->language->get('text_select_from_lookup'),
            ]
        );

        return $response;
    }

    protected function _getFieldsForProductPrice($value = []) {
        $response['text'] = $this->language->get('entry_product_price');
        $response['fields'] = $this->form->getFieldHtml(
            [
                'type'    => 'selectbox',
                'name'    => 'conditions[conditions]['.$this->request->post['idx'].'][operator]',
                'options' => [
                    'eq'   => $this->language->get('text_equal'),
                    'neq'  => $this->language->get('text_not_equal'),
                    'eqlt' => $this->language->get('text_equal_or_less'),
                    'eqgt' => $this->language->get('text_equal_or_greater'),
                    'lt'   => $this->language->get('text_less'),
                    'gt'   => $this->language->get('text_greater'),
                ],
                'value'   => $value['operator'],
            ]
        );
        $response['fields'] .= $this->form->getFieldHtml(
            [
                'type'  => 'input',
                'name'  => 'conditions[conditions]['.$this->request->post['idx'].'][value]',
                'value' => !$value ? '' : $value['value'],
                'style' => 'small-field',
            ]
        );
        $response['fields'] .= '('.$this->config->get('config_currency').')';
        return $response;
    }

    protected function _getFieldsForCategories($value = '') {
        $response['text'] = $this->language->get('entry_categories');
        $response['fields'] = $this->form->getFieldHtml(
            [
                'type'    => 'selectbox',
                'name'    => 'conditions[conditions]['.$this->request->post['idx'].'][operator]',
                'options' => [
                    'in'    => $this->language->get('text_in'),
                    'notin' => $this->language->get('text_not_in'),
                ],
                'value'   => !$value ? '' : $value['operator'],
            ]
        );
        $this->loadModel('catalog/category');
        $results = $this->model_catalog_category->getCategories(0);
        $categories = array_column($results, 'name', 'category_id');

        $response['fields'] .= $this->form->getFieldHtml(
            [
                'type'        => 'checkboxgroup',
                'name'        => 'conditions[conditions]['.$this->request->post['idx'].'][value][]',
                'value'       => !$value ? '' : $value['value'],
                'options'     => $categories,
                'style'       => 'chosen',
                'placeholder' => $this->language->get('text_select_category'),
            ]
        );
        return $response;
    }

    protected function _getFieldsForBrands($value = '') {
        $response['text'] = $this->language->get('entry_brands');
        $response['fields'] = $this->form->getFieldHtml(
            [
                'type'    => 'selectbox',
                'name'    => 'conditions[conditions]['.$this->request->post['idx'].'][operator]',
                'options' => [
                    'in'    => $this->language->get('text_in'),
                    'notin' => $this->language->get('text_not_in'),
                ],
                'value'   => !$value ? '' : $value['operator'],
            ]
        );
        $this->loadModel('catalog/manufacturer');
        $results = $this->model_catalog_manufacturer->getManufacturers();
        $manufacturers = array_column($results,'name', 'manufacturer_id');
        $response['fields'] .= $this->form->getFieldHtml(
            [
                'type'        => 'checkboxgroup',
                'name'        => 'conditions[conditions]['.$this->request->post['idx'].'][value][]',
                'value'       => !$value ? '' : $value['value'],
                'options'     => $manufacturers,
                'style'       => 'chosen',
                'placeholder' => $this->language->get('text_select_manufacturer'),
            ]
        );
        return $response;
    }

    protected function _getFieldsForCustomers($value = '') {
        $listing_data = [];
        if (is_array($value['value'])) {
            $this->loadModel('sale/customer');
            foreach ($value['value'] as $customer_id) {
                $result = $this->model_sale_customer->getCustomer($customer_id);
                $listing_data[$customer_id] = $result['firstname'].' '.$result['lastname'];
            }
        }

        $response['text'] = $this->language->get('entry_customers');
        $response['fields'] = $this->form->getFieldHtml(
            [
                'type'    => 'selectbox',
                'name'    => 'conditions[conditions]['.$this->request->post['idx'].'][operator]',
                'options' => [
                    'in'    => $this->language->get('text_in'),
                    'notin' => $this->language->get('text_not_in'),
                ],
                'value'   => !$value ? '' : $value['operator'],
            ]
        );

        $response['fields'] .= $this->form->getFieldHtml(
            [
                'type'        => 'multiselectbox',
                'name'        => 'conditions[conditions]['.$this->request->post['idx'].'][value][]',
                'value'       => !$value ? '' : $value['value'],
                'options'     => $listing_data,
                'style'       => 'chosen',
                'ajax_url'    => $this->html->getSecureURL('r/listing_grid/customer/customers'),
                'placeholder' => $this->language->get('text_select_from_lookup'),
            ]
        );

        return $response;
    }

    protected function _getFieldsForCustomerGroups($value = '') {
        $response['text'] = $this->language->get('entry_customer_groups');
        $response['fields'] = $this->form->getFieldHtml(
            [
                'type'    => 'selectbox',
                'name'    => 'conditions[conditions]['.$this->request->post['idx'].'][operator]',
                'options' => [
                    'in'    => $this->language->get('text_in'),
                    'notin' => $this->language->get('text_not_in'),
                ],
                'value'   => $value['operator'],
            ]
        );
        $this->loadModel('sale/customer_group');
        $results = $this->model_sale_customer_group->getCustomerGroups();
        $customers = [];
        foreach ($results as $r) {
            $customers[$r['customer_group_id']] =
                $r['name'].(($r['customer_group_id'] == $this->config->get('config_customer_group_id'))
                    ? $this->language->get('text_default') : null);
        }

        $response['fields'] .= $this->form->getFieldHtml(
            [
                'type'      => 'checkboxgroup',
                'name'      => 'conditions[conditions]['.$this->request->post['idx'].'][value][]',
                'value'     => !$value ? '' : $value['value'],
                'options'   => $customers,
                'scrollbox' => true,
            ]
        );
        return $response;
    }

    protected function _getFieldsForCustomerCountry($value = '') {
        $response['text'] = $this->language->get('entry_customer_country');
        $response['fields'] = $this->form->getFieldHtml(
            [
                'type'    => 'selectbox',
                'name'    => 'conditions[conditions]['.$this->request->post['idx'].'][operator]',
                'options' => [
                    'in'    => $this->language->get('text_in'),
                    'notin' => $this->language->get('text_not_in'),
                ],
                'value'   => $value['operator'],
            ]
        );
        $this->loadModel('localisation/country');
        $results = $this->model_localisation_country->getCountries();
        $countries = array_column( $results, 'name', 'country_id');
        $response['fields'] .= $this->form->getFieldHtml(
            [
                'type'      => 'checkboxgroup',
                'name'      => 'conditions[conditions]['.$this->request->post['idx'].'][value][]',
                'value'     => !$value ? '' : $value['value'],
                'options'   => $countries,
                'scrollbox' => true,
            ]
        );
        return $response;
    }

    protected function _getFieldsForCustomerPostCode($value = '') {
        $response['text'] = $this->language->get('entry_customer_postcode');
        $response['fields'] = $this->form->getFieldHtml(
            [
                'type'    => 'selectbox',
                'name'    => 'conditions[conditions]['.$this->request->post['idx'].'][operator]',
                'options' => [
                    'eq'    => $this->language->get('text_equal'),
                    'neq'   => $this->language->get('text_not_equal'),
                    'ctn'   => $this->language->get('text_contain'),
                    'nctn'  => $this->language->get('text_not_contain'),
                    'in'    => $this->language->get('text_in_comma'),
                    'notin' => $this->language->get('text_not_in_comma'),
                ],
                'value'   => $value['operator'],
            ]
        );
        $response['fields'] .= $this->form->getFieldHtml(
            [
                'type'  => 'input',
                'name'  => 'conditions[conditions]['.$this->request->post['idx'].'][value]',
                'value' => (is_array($value['value']) ? implode(', ', $value['value']) : $value['value']),
                'style' => 'medium-field',
            ]
        );
        return $response;
    }

    protected function _getFieldsForOrderSubtotal($value = '')
    {
        $response['text'] = $this->language->get('entry_order_subtotal');
        $response['fields'] = $this->form->getFieldHtml(
            [
                'type'    => 'selectbox',
                'name'    => 'conditions[conditions]['.$this->request->post['idx'].'][operator]',
                'options' => [
                    'eq'    => $this->language->get('text_equal'),
                    'neq'   => $this->language->get('text_not_equal'),
                    'eqlt'  => $this->language->get('text_equal_or_less'),
                    'eqgt'  => $this->language->get('text_equal_or_greater'),
                    'lt'    => $this->language->get('text_less'),
                    'gt'    => $this->language->get('text_greater'),
                    'in'    => $this->language->get('text_in_comma'),
                    'notin' => $this->language->get('text_not_in_comma'),
                ],
                'value'   => !$value ? '' : $value['operator'],
            ]
        );
        $response['fields'] .= $this->form->getFieldHtml(
            [
                'type'  => 'input',
                'name'  => 'conditions[conditions]['.$this->request->post['idx'].'][value]',
                'value' => !$value ? '' : $value['value'],
                'style' => 'medium-field',
            ]
        );
        $response['fields'] .= '('.$this->config->get('config_currency').')';
        return $response;
    }

    protected function _getFieldsForOrderProductCount($value = '')
    {
        $response['text'] = $this->language->get('entry_order_product_count');
        $response['fields'] = $this->form->getFieldHtml(
            [
                'type'    => 'selectbox',
                'name'    => 'conditions[conditions]['.$this->request->post['idx'].'][operator]',
                'options' => [
                    'eq'    => $this->language->get('text_equal'),
                    'neq'   => $this->language->get('text_not_equal'),
                    'eqlt'  => $this->language->get('text_equal_or_less'),
                    'eqgt'  => $this->language->get('text_equal_or_greater'),
                    'lt'    => $this->language->get('text_less'),
                    'gt'    => $this->language->get('text_greater'),
                    'in'    => $this->language->get('text_in_comma'),
                    'notin' => $this->language->get('text_not_in_comma'),
                ],
                'value'   => !$value ? '' : $value['operator'],
            ]
        );
        $response['fields'] .= $this->form->getFieldHtml(
            [
                'type'  => 'input',
                'name'  => 'conditions[conditions]['.$this->request->post['idx'].'][value]',
                'value' => !$value ? '' : $value['value'],
                'style' => 'medium-field',
            ]
        );
        return $response;
    }

    protected function _getFieldsForOrderProductWeight($value = '')
    {
        $response['text'] = $this->language->get('entry_order_product_weight');
        $response['fields'] = $this->form->getFieldHtml(
            [
                'type'    => 'selectbox',
                'name'    => 'conditions[conditions]['.$this->request->post['idx'].'][operator]',
                'options' => [
                    'eq'    => $this->language->get('text_equal'),
                    'neq'   => $this->language->get('text_not_equal'),
                    'eqlt'  => $this->language->get('text_equal_or_less'),
                    'eqgt'  => $this->language->get('text_equal_or_greater'),
                    'lt'    => $this->language->get('text_less'),
                    'gt'    => $this->language->get('text_greater'),
                    'in'    => $this->language->get('text_in_comma'),
                    'notin' => $this->language->get('text_not_in_comma'),
                ],
                'value'   => $value['operator'],
            ]
        );
        $response['fields'] .= $this->form->getFieldHtml(
            [
                'type'  => 'input',
                'name'  => 'conditions[conditions]['.$this->request->post['idx'].'][value]',
                'value' => (is_array($value['value']) ? implode(', ', $value['value']) : $value['value']),
                'style' => 'medium-field',
            ]
        );
        $response['fields'] .= '('.$this->config->get('config_weight_class').')';
        return $response;
    }

    protected function _getFieldsForPaymentMethod($value = '')
    {
        $response['text'] = $this->language->get('entry_payment_method');
        $response['fields'] = $this->form->getFieldHtml(
            [
                'type'    => 'selectbox',
                'name'    => 'conditions[conditions]['.$this->request->post['idx'].'][operator]',
                'options' => [
                    'in'    => $this->language->get('text_in'),
                    'notin' => $this->language->get('text_not_in'),
                ],
                'value'   => $value['operator'],
            ]
        );
        $exts = new ExtensionsApi();
        $results = $exts->getInstalled('payment');
        $options = [];
        foreach ($results as $r) {
            $options[$r] = $exts->getExtensionName($r);
        }

        $response['fields'] .= $this->form->getFieldHtml(
            [
                'type'      => 'checkboxgroup',
                'name'      => 'conditions[conditions]['.$this->request->post['idx'].'][value][]',
                'value'     => !$value ? '' : $value['value'],
                'options'   => $options,
                'scrollbox' => true,
            ]
        );
        return $response;
    }

    protected function _getFieldsForShippingMethod($value = '')
    {
        $response['text'] = $this->language->get('entry_shipping_method');
        $response['fields'] = $this->form->getFieldHtml(
            [
                'type'    => 'selectbox',
                'name'    => 'conditions[conditions]['.$this->request->post['idx'].'][operator]',
                'options' => [
                    'in'    => $this->language->get('text_in'),
                    'notin' => $this->language->get('text_not_in'),
                ],
                'value'   => !$value ? '' : $value['operator'],
            ]
        );
        $exts = new ExtensionsApi();
        $results = $exts->getInstalled('shipping');
        $options = [];
        foreach ($results as $r) {
            $options[$r] = $exts->getExtensionName($r);
        }

        $response['fields'] .= $this->form->getFieldHtml(
            [
                'type'      => 'checkboxgroup',
                'name'      => 'conditions[conditions]['.$this->request->post['idx'].'][value][]',
                'value'     => !$value ? '' : $value['value'],
                'options'   => $options,
                'scrollbox' => true,
            ]
        );
        return $response;
    }

    protected function _getFieldsForCouponCode($value = '')
    {
        $response['text'] = $this->language->get('entry_coupon_code');
        $response['fields'] = $this->form->getFieldHtml(
            [
                'type'    => 'selectbox',
                'name'    => 'conditions[conditions]['.$this->request->post['idx'].'][operator]',
                'options' => [
                    'in'    => $this->language->get('text_in'),
                    'notin' => $this->language->get('text_not_in'),
                ],
                'value'   => !$value ? '' : $value['operator'],
            ]
        );
        $response['fields'] .= $this->form->getFieldHtml(
            [
                'type'  => 'input',
                'name'  => 'conditions[conditions]['.$this->request->post['idx'].'][value]',
                'value' => !$value ? '' : $value['value'],
                'style' => 'large-field',
            ]
        );
        return $response;
    }


    //bonus part

    /**
     * @param mixed $value
     *
     * @throws AException
     */
    public function getFieldsByBonusObject($value = null)
    {
        $this->loadLanguage('promo_manager/promo_manager');
        //init controller data
        $this->extensions->hk_InitData($this, __FUNCTION__);

        $promo = new APromotion();
        $bonus_objects = $promo->getBonusObjects();
        if (!in_array($this->request->post['bonus_object'], $bonus_objects)) {
            return null;
        }

        $this->form = new AForm ('HT');
        $this->form->setForm(
            [
                'form_name' => 'promoManagerFrm',
                'update'    => $this->html->getSecureURL(
                    'listing_grid/promo_manager/update_field',
                    '&promo_manager_id='.$this->request->get['promo_manager_id']
                ),
            ]
        );
        $method = '_getBonusFieldsFor'.str_replace(
                ' ', '', ucwords(str_replace('_', ' ', $this->request->post['bonus_object']))
            );
        $response = [];
        if (method_exists($this, $method)) {
            $response = call_user_func([$this, $method], $value);
        }
        if ($response['fields']) {
            $response['fields'] .= $this->form->getFieldHtml(
                [
                    'type'  => 'hidden',
                    'name'  => 'bonuses['.$this->request->post['idx'].'][object]',
                    'value' => $this->request->post['bonus_object'],
                ]
            );
        }

        //update controller data
        $this->extensions->hk_UpdateData($this, __FUNCTION__);
        $this->load->library('json');
        $this->response->setOutput(AJson::encode($response));
    }

    protected function _getBonusFieldsForOrderDiscount($value = '')
    {
        $response['text'] = $this->language->get('entry_order_discount');
        $response['fields'] = $this->form->getFieldHtml(
            [
                'type'    => 'selectbox',
                'name'    => 'bonuses['.$this->request->post['idx'].'][operator]',
                'options' => [
                    'by_prc'   => $this->language->get('text_by_prc'),
                    'to_prc'   => $this->language->get('text_to_prc'),
                    'by_fixed' => $this->language->get('text_by_fixed'),
                    'to_fixed' => $this->language->get('text_to_fixed'),
                ],
                'value'   => !$value ? '' : $value['operator'],
            ]
        );
        $response['fields'] .= $this->form->getFieldHtml(
            [
                'type'  => 'input',
                'name'  => 'bonuses['.$this->request->post['idx'].'][value]',
                'value' => !$value ? '' : $value['value'],
                'style' => 'small-field',
            ]
        );
        return $response;
    }

    protected function _getBonusFieldsForFreeShipping($value = '')
    {
        $response['text'] = $this->language->get('entry_free_shipping');
        $exts = new ExtensionsApi();
        $results = $exts->getInstalled('shipping');
        $options = [];
        foreach ($results as $r) {
            $options[$r] = $exts->getExtensionName($r);
        }

        $response['fields'] .= $this->form->getFieldHtml(
            [
                'type'      => 'checkboxgroup',
                'name'      => 'bonuses['.$this->request->post['idx'].'][value][]',
                'value'     => !$value ? '' : $value['value'],
                'options'   => $options,
                'scrollbox' => true,
            ]
        );

        return $response;
    }

    protected function _getBonusFieldsForDiscountProducts($value = '')
    {
        $quantities = $ids = $listing_data = [];
        if (is_array($value['products'])) {
            $this->loadModel('catalog/product');
            foreach ($value['products'] as $product) {
                $ids[] = $product['product_id'];
                $quantities[$product['product_id']] = $product['quantity'];
            }

            //prevent sql syntax error
            $ids = !$ids ? [0] : $ids;
            $filter = ['subsql_filter' => 'p.product_id in ('.implode(',', $ids).')'];
            $results = $this->model_catalog_product->getProducts($filter);
            if ($results) {
                $resource = new AResource('image');
                foreach ($results as $r) {
                    $product_id = $r['product_id'];
                    $thumbnail = $resource->getMainThumb(
                        'products',
                        $product_id,
                        (int) $this->config->get('config_image_grid_width'),
                        (int) $this->config->get('config_image_grid_height'),
                        true
                    );
                    $listing_data[$product_id]['name'] = $r['name']." (".$r['model'].")";
                    $listing_data[$product_id]['image'] = $thumbnail['thumb_html']
                        .'&nbsp;'.trim(
                            $this->html->buildInput(
                                [
                                    'name'        => 'discount_products_quantity['.$product_id.']',
                                    'value'       => $quantities[$product_id],
                                    'style'       => 'small-field',
                                    'placeholder' => 'Input Quantity',
                                ]
                            )
                        );
                }
            }
        }

        $response['text'] = $this->language->get('entry_discount_products');

        $response['fields'] = $this->form->getFieldHtml(
            [
                'type'    => 'selectbox',
                'name'    => 'bonuses['.$this->request->post['idx'].'][operator]',
                'options' => [
                    'by_prc'   => $this->language->get('text_by_prc'),
                    'to_prc'   => $this->language->get('text_to_prc'),
                    'by_fixed' => $this->language->get('text_by_fixed'),
                    'to_fixed' => $this->language->get('text_to_fixed'),
                ],
                'value'   => $value['operator'],
            ]
        );
        $response['fields'] .= $this->form->getFieldHtml(
            [
                'type'  => 'input',
                'name'  => 'bonuses['.$this->request->post['idx'].'][value]',
                'value' => !$value ? '' : $value['value'],
                'style' => 'small-field',
            ]
        );

        $response['fields'] .= trim(
            $this->form->getFieldHtml(
                [
                    'type'        => 'multiselectbox',
                    'name'        => 'bonuses['.$this->request->post['idx'].'][products][]',
                    'value'       => $ids,
                    'options'     => $listing_data,
                    'style'       => 'chosen',
                    'ajax_url'    => $this->html->getSecureURL('r/listing_grid/promo_manager/discount_products'),
                    'placeholder' => $this->language->get('text_select_from_lookup'),
                ]
            )
        );

        return $response;
    }

    public function discount_products($value = '')
    {
        $products_data = [];

        //init controller data
        $this->extensions->hk_InitData($this, __FUNCTION__);
        $this->loadModel('catalog/product');
        if (isset($this->request->post['term'])) {
            $filter = [
                'limit'               => 20,
                'content_language_id' => $this->language->getContentLanguageID(),
                'filter'              => [
                    'keyword' => $this->request->post['term'],
                    'match'   => 'begin',
                ],
            ];
            $products = $this->model_catalog_product->getProducts($filter);
            $resource = new AResource('image');
            foreach ($products as $productData) {
                $thumbnail = $resource->getMainThumb(
                    'products',
                    $productData['product_id'],
                    (int) $this->config->get('config_image_grid_width'),
                    (int) $this->config->get('config_image_grid_height'),
                    true
                );

                if ($this->request->get['currency_code']) {
                    $price = round(
                        $this->currency->convert(
                            $productData['price'],
                            $this->config->get('config_currency'),
                            $this->request->get['currency_code']
                        ), 2
                    );
                } else {
                    $price = $productData['price'];
                }

                $formattedPrice = $this->currency->format(
                    $price,
                    ($this->request->get['currency_code'] ? : $this->config->get('config_currency'))
                );

                $products_data[] = [
                    'image'      => $thumbnail['thumb_html'].trim(
                            $this->html->buildInput(
                                [
                                    'name'        => 'discount_products_quantity['.$productData['product_id'].']',
                                    'value'       => $productData['quantity'],
                                    'style'       => 'small-field',
                                    'placeholder' => 'quantity',
                                ]
                            )
                        ),
                    'id'         => $productData['product_id'],
                    'name'       => $productData['name'].' - '.$formattedPrice,
                    'price'      => $price,
                    'meta'       => $productData['model'],
                    'sort_order' => (int) $productData['sort_order'],
                ];
            }
        }

        $this->load->library('json');
        $this->response->addJSONHeader();
        $this->response->setOutput(AJson::encode($products_data));
    }

    protected function _getBonusFieldsForFreeProducts($value = '')
    {
        $ids = $listing_data = [];
        if (is_array($value['products'])) {
            $this->loadModel('catalog/product');
            $ids = [];
            foreach ($value['products'] as $product) {
                $ids[] = $product['product_id'];
            }

            //prevent sql syntax error
            $ids = !$ids ? [0] : $ids;
            $filter = ['subsql_filter' => 'p.product_id in ('.implode(',', $ids).')'];
            $results = $this->model_catalog_product->getProducts($filter);
            if ($results) {
                $resource = new AResource('image');
                foreach ($results as $r) {
                    $product_id = $r['product_id'];
                    $thumbnail = $resource->getMainThumb(
                        'products',
                        $product_id,
                        (int) $this->config->get('config_image_grid_width'),
                        (int) $this->config->get('config_image_grid_height'),
                        true
                    );
                    $listing_data[$product_id]['name'] = $r['name']." (".$r['model'].")";
                    $listing_data[$product_id]['image'] = $thumbnail['thumb_html'];
                }
            }
        }

        $response['text'] = $this->language->get('entry_free_products');
        $response['fields'] = $this->form->getFieldHtml(
            [
                'type'        => 'multiselectbox',
                'name'        => 'bonuses['.$this->request->post['idx'].'][products][]',
                'value'       => $ids,
                'options'     => $listing_data,
                'style'       => 'chosen',
                'ajax_url'    => $this->html->getSecureURL('r/product/product/products'),
                'placeholder' => $this->language->get('text_select_from_lookup'),
            ]
        );

        return $response;
    }

    /**
     * update only one field
     *
     * @return void
     * @throws AException
     */
    public function update_field() {
        //init controller data
        $this->extensions->hk_InitData($this, __FUNCTION__);

        $this->loadLanguage('promo_manager/promo_manager');
        if (!$this->user->canModify('listing_grid/promo_manager')) {
            $error = new AError('');
            $error->toJSONResponse(
                'NO_PERMISSIONS_402',
                [
                    'error_text'  => sprintf($this->language->get('error_permission_modify'), 'promo_manager/promo_manager'),
                    'reset_value' => true,
                ]
            );
            return;
        }

        $this->loadModel('sale/promo_manager');
        $fields_list = ['name', 'status', 'priority', 'description_short', 'stop', 'start_date', 'end_date','info_banner_related'];
        if (isset($this->request->get['promo_manager_id'])) {
            //request sent from edit form. ID in url
            foreach ($this->request->post as $field => $value) {
                if (!in_array($field, $fields_list)) {
                    continue;
                }
                $this->model_sale_promo_manager->editPromotion($this->request->get['promo_manager_id'], [$field => $value]);
            }
            return;
        }

        //request sent from jGrid. ID is key of array
        foreach ($this->request->post as $field => $value) {
            if (!in_array($field, $fields_list)) {
                continue;
            }
            foreach ($value as $k => $v) {
                $this->model_sale_promo_manager->editPromotion($k, [$field => $v]);
            }
        }

        //update controller data
        $this->extensions->hk_UpdateData($this, __FUNCTION__);
    }

    public function update() {
        //init controller data
        $this->extensions->hk_InitData($this, __FUNCTION__);

        $this->loadModel('sale/promo_manager');
        $this->loadLanguage('promo_manager/promo_manager');
        if (!$this->user->canModify('listing_grid/promo_manager')) {
            $error = new AError('');
            $error->toJSONResponse(
                'NO_PERMISSIONS_402',
                [
                    'error_text'  => sprintf($this->language->get('error_permission_modify'), 'listing_grid/promo_manager'),
                    'reset_value' => true,
                ]
            );
            return;
        }

        switch ($this->request->post['oper']) {
            case 'del':
                $ids = explode(',', $this->request->post['id']);
                if (!empty($ids)) {
                    foreach ($ids as $id) {
                        $this->model_sale_promo_manager->deletePromotion($id);
                    }
                }
                break;
            case 'save':
                $allowedFields = ['priority'];
                $ids = explode(',', $this->request->post['id']);
                if (!empty($ids)) {
                    foreach ($ids as $id) {
                        foreach ($allowedFields as $field) {
                            $this->model_sale_promo_manager->editPromotion(
                                $id, [$field => $this->request->post[$field][$id]]
                            );
                        }
                    }
                }
                break;

            default:
        }

        //update controller data
        $this->extensions->hk_UpdateData($this, __FUNCTION__);
    }

}
