<?php

/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2023 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

class ControllerPagesTotalPromoManagerTotal extends AController
{
    public $error = [];
    public $fields = [
        'promo_manager_total_status',
        'promo_manager_total_sort_order',
        'promo_manager_total_calculation_order',
        'promo_manager_total_total_type',
    ];

    public function main()
    {
        $this->loadModel('setting/setting');
        $this->loadLanguage('extension/total');
        $this->loadLanguage('promo_manager/promo_manager');

        if ($this->request->is_POST() && ($this->_validate())) {
            $this->model_setting_setting->editSetting('promo_manager_total', $this->request->post);
            $this->session->data['success'] = $this->language->get('promo_manager_total_text_success');
            redirect($this->html->getSecureURL('total/promo_manager_total'));
        }

        $this->document->setTitle($this->language->get('total_name'));

        $this->data['error_warning'] = $this->error['warning'] ?? '';
        $this->data['success'] = $this->session->data['success'];
        if (isset($this->session->data['success'])) {
            unset($this->session->data['success']);
        }

        $this->document->initBreadcrumb(
            [
                'href'      => $this->html->getSecureURL('index/home'),
                'text'      => $this->language->get('text_home'),
                'separator' => false,
            ]
        );
        $this->document->addBreadcrumb(
            [
                'href'      => $this->html->getSecureURL('extension/total'),
                'text'      => $this->language->get('heading_title'),
                'separator' => ' :: ',
            ]
        );
        $this->document->addBreadcrumb(
            [
                'href'      => $this->html->getSecureURL('total/promo_manager_total'),
                'text'      => $this->language->get('total_name'),
                'separator' => ' :: ',
                'current'   => true,
            ]
        );

        foreach ($this->fields as $f) {
            $this->data[$f] = $this->request->post[$f] ?? $this->config->get($f);
        }

        $this->data ['action'] = $this->html->getSecureURL('total/promo_manager_total');
        $this->data['cancel'] = $this->html->getSecureURL('extension/total');
        $this->data ['heading_title'] = $this->language->get('text_edit').$this->language->get('total_name');
        $this->data ['form_title'] = $this->language->get('heading_title');
        $this->data ['update'] = $this->html->getSecureURL(
            'listing_grid/total/update_field',
            '&id=promo_manager_total'
        );

        $form = new AForm ('HS');
        $form->setForm(
            [
                'form_name' => 'editFrm',
                'update'    => $this->data ['update'],
            ]
        );

        $this->data['form']['form_open'] = $form->getFieldHtml(
            [
                'type'   => 'form',
                'name'   => 'editFrm',
                'action' => $this->data ['action'],
                'attr'   => 'confirm-exit="true" class="aform form-horizontal"',
            ]
        );
        $this->data['form']['submit'] = $form->getFieldHtml(
            [
                'type' => 'button',
                'name' => 'submit',
                'text' => $this->language->get('button_save'),
            ]
        );
        $this->data['form']['cancel'] = $form->getFieldHtml(
            [
                'type' => 'button',
                'name' => 'cancel',
                'text' => $this->language->get('button_cancel'),
            ]
        );

        $this->data['form']['fields']['status'] = $form->getFieldHtml(
            [
                'type'  => 'checkbox',
                'name'  => 'promo_manager_total_status',
                'value' => $this->data['promo_manager_total_status'],
                'style' => 'btn_switch',
            ]
        );

        $this->data['form']['fields']['total_type'] = $form->getFieldHtml(
            [
                'type'  => 'hidden',
                'name'  => 'promo_manager_total_total_type',
                'value' => 'promo_manager',
            ]
        );
        $this->data['form']['fields']['sort_order'] = $form->getFieldHtml(
            [
                'type'  => 'input',
                'name'  => 'promo_manager_total_sort_order',
                'value' => $this->data['promo_manager_total_sort_order'],
            ]
        );
        $this->data['form']['fields']['calculation_order'] = $form->getFieldHtml(
            [
                'type'  => 'input',
                'name'  => 'promo_manager_total_calculation_order',
                'value' => $this->data['promo_manager_total_calculation_order'],
            ]
        );
        $this->view->assign('help_url', $this->gen_help_url('edit_promo_manager_total'));
        $this->view->batchAssign($this->data);
        $this->processTemplate('pages/total/form.tpl');
    }

    protected function _validate()
    {
        if (!$this->user->canModify('total/promo_manager_total')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }
        $this->extensions->hk_ValidateData($this);
        return (!$this->error);
    }
}
