<?php

/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2023 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

require_once DIR_SYSTEM . "lib/vendor/autoload.php";
require_once DIR_SYSTEM . "lib/license.php";

/**
 * @property ModelSalePromoManager $model_sale_promo_manager
 * @property ModelExtensionPromoManagerLicenseInfo $model_extension_promo_manager_license_info
 * @property ModelExtensionInfoBannerLicenseInfo $model_extension_info_banner_license_info
 * @property ModelExtensionInfoBanner $model_extension_info_banner
 */
class ControllerPagesSalePromoManager extends AController {

    public $error = [];

    public function verify() {
        if ($this->config->get('promo_manager_status') === '1') {
            $this->load->model('extension/promo_manager_license_info');
            $license_key = $this->config->get('promo_manager_license_code');
            if ($license_key) {
                $exist = $this->db->query("SHOW TABLES LIKE '" . $this->db->table('promo_manager_license_info') . "'");
                if ($exist->num_rows === 1) {
                    $store_id = $this->model_extension_promo_manager_license_info->getStoreId();
                    $license_key = $this->model_extension_promo_manager_license_info->getLicenseCode($store_id);
                    $license_info = $this->model_extension_promo_manager_license_info->getLicenseData($store_id);
                    $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                    $license = new License($path_to_phpseclib);
                    $license_manager = $license->getManager();
                    $license_manager->setKeys($license_key, $license_info['public_key'], 'promo_manager');
                    $ttl = 1209600;
                    $validate = $license_manager->validate($license_info['license_data'], $ttl);
                    $store_status = $this->model_extension_promo_manager_license_info->getLicensedStoreStatus();
                    if ($validate['status'] === 'valid' && $store_status == 1) {
                        return true;
                    } else {
                        return false;
                    }
                }
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

    public function verifyInfoBanner() {
        if ($this->config->get('info_banner_status')==='1') {
            $this->load->model('extension/info_banner_license_info');
            $license_key = $this->config->get('info_banner_license_code');
            $shared_secret = 'info_banner';
            if ($license_key) {
                $exist = $this->db->query("SHOW TABLES LIKE '" . $this->db->table('info_banner_license_info') . "'");
                if ($exist->num_rows === 1) {
                    $store_id = $this->model_extension_info_banner_license_info->getStoreId();
                    $license_key = $this->model_extension_info_banner_license_info->getLicenseCode($store_id);
                    $license_info = $this->model_extension_info_banner_license_info->getLicenseData($store_id);
                    $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                    $license = new License($path_to_phpseclib);
                    $license_manager = $license->getManager();
                    $license_manager->setKeys($license_key, $license_info['public_key'], $shared_secret);
                    $ttl = 1209600;
                    $validate = $license_manager->validate($license_info['license_data'], $ttl);
                    $store_status = $this->model_extension_info_banner_license_info->getLicensedStoreStatus();
                    if ($validate['status'] === 'valid' && $store_status == 1) {
                        return true;
                    } else {
                        return false;
                    }
                }
            }
        } else {
            return false;
        }
    }
    
    public function main() {
        //init controller data
        $this->extensions->hk_InitData($this, __FUNCTION__);

        $this->loadLanguage('promo_manager/promo_manager');

        $this->document->setTitle($this->language->get('promo_manager_name'));
        $this->view->assign('help_url', $this->gen_help_url('sale_promo_manager'));

        $this->document->initBreadcrumb(
            [
                'href'      => $this->html->getSecureURL('index/home'),
                'text'      => $this->language->get('text_home'),
                'separator' => false,
            ]
        );
        $this->document->addBreadcrumb(
            [
                'href'      => $this->html->getSecureURL('sale/promo_manager'),
                'text'      => $this->language->get('promo_manager_name'),
                'separator' => ' :: ',
                'current'   => true,
            ]
        );

        $this->view->assign('error_warning', $this->error['warning']);
        $this->view->assign('success', $this->session->data['success']);
        $this->view->assign('heading_title', $this->language->get('promo_manager_name'));
        if (isset($this->session->data['success'])) {
            unset($this->session->data['success']);
        }

        $grid_settings = [
            'table_id'     => 'promo_manager_grid',
            'url'          => $this->html->getSecureURL('listing_grid/promo_manager'),
            'editurl'      => $this->html->getSecureURL('listing_grid/promo_manager/update'),
            'update_field' => $this->html->getSecureURL('listing_grid/promo_manager/update_field'),
            'sortname'     => 'priority',
            'sortorder'    => 'asc',
            'actions'      => [
                'edit'   => [
                    'text' => $this->language->get('text_edit'),
                    'href' => $this->html->getSecureURL('sale/promo_manager/edit', '&promo_manager_id=%ID%'),
                ],
                'save'   => [
                    'text' => $this->language->get('button_save'),
                ],
                'delete' => [
                    'text' => $this->language->get('button_delete'),
                ],
            ],
        ];

        $grid_settings['colNames'] = [
            $this->language->get('column_name'),
            $this->language->get('column_priority'),
            $this->language->get('column_daterange'),
            $this->language->get('column_status'),
        ];
        $grid_settings['colModel'] = [
            [
                'name'  => 'name',
                'index' => 'name',
                'width' => 240,
                'align' => 'center',
            ],
            [
                'name'   => 'priority',
                'index'  => 'priority',
                'width'  => 90,
                'align'  => 'center',
                'search' => false,
            ],
            [
                'name'   => 'daterange',
                'index'  => 'daterange',
                'width'  => 150,
                'align'  => 'center',
                'search' => false,
            ],
            [
                'name'   => 'status',
                'index'  => 'status',
                'align'  => 'center',
                'search' => false,
            ],
        ];

        $grid = $this->dispatch('common/listing_grid', [$grid_settings]);
        $this->view->assign('listing_grid', $grid->dispatchGetOutput());
        $this->view->assign('grid_url', $this->html->getSecureURL('listing_grid/promo_manager'));

        $this->document->setTitle($this->language->get('promo_manager_name'));
        $this->view->assign('insert', $this->html->getSecureURL('sale/promo_manager/insert'));
        $this->view->assign('form_language_switch', $this->html->getContentLanguageSwitcher());

        $this->data['license_status'] = $this->verify();
        $this->data['text_unauthorized'] = $this->language->get( 'text_promo_manager_unauthorized' );
        $this->view->assign('form_store_switch', $this->html->getStoreSwitcher());

        $this->view->batchAssign($this->data);

        $this->processTemplate('pages/sale/promo_manager.tpl');

        //update controller data
        $this->extensions->hk_UpdateData($this, __FUNCTION__);
    }

    public function insert() {
        //init controller data
        $this->extensions->hk_InitData($this, __FUNCTION__);
        $this->loadLanguage('promo_manager/promo_manager');

        //need to reset exclude list for multivalue list which can be set by other multivalue lists (for ex. form of downloads for products)
        $this->session->data['multivalue_excludes'] = [];

        $this->document->setTitle($this->language->get('promo_manager_name'));

        if ($this->request->is_POST() && $this->_validateForm()) {
            $this->loadModel('sale/promo_manager');
            $promo_manager_id = $this->model_sale_promo_manager->addpromotion($this->request->post);

            $this->session->data ['success'] = $this->language->get('text_success_create');
            redirect(
                $this->html->getSecureURL(
                    'sale/promo_manager/edit',
                    '&tab=conditions&promo_manager_id='.$promo_manager_id
                )
            );
        }

        foreach ($this->request->post as $k => $v) {
            $this->data[$k] = $v;
        }
        $this->data['tabs'][] = [
            'href'   => 'Javascript: void(0);',
            'text'   => $this->language->get('text_general'),
            'active' => true,
        ];

        $this->_getFormGeneral();

        //update controller data
        $this->extensions->hk_UpdateData($this, __FUNCTION__);
    }

    public function edit() {
        //init controller data
        $this->extensions->hk_InitData($this, __FUNCTION__);
        $this->loadLanguage('promo_manager/promo_manager');

        $this->document->setTitle($this->language->get('promo_manager_name'));
        $this->data['heading_title'] = $this->language->get('promo_manager_name');
        $promo_manager_id = (int) $this->request->get['promo_manager_id'];

        //need to reset exclude list for multivalue list which can be set by other multivalue lists (for ex. form of downloads for products)
        $this->session->data['multivalue_excludes'] = [];

        $this->loadModel('sale/promo_manager');
        // saving
        if ($this->request->is_POST()) {//&& $this->_validateForm() && $promo_manager_id) {
            if (isset($this->request->post['conditions']['conditions'])) {
                foreach ($this->request->post['conditions']['conditions'] as $k => $rule) {
                    if ($rule['object'] == 'customer_postcode') {
                        if (in_array(
                            $this->request->post['conditions']['conditions'][$k]['operator'], ['in', 'notin']
                        )) {
                            $temp = explode(',', $this->request->post['conditions']['conditions'][$k]['value']);
                            foreach ($temp as &$postcode) {
                                $postcode = preg_replace("/[^0-9]/", '', $postcode);
                            }
                            $this->request->post['conditions']['conditions'][$k]['value'] = $temp;
                            unset($temp);
                        } else {
                            $this->request->post['conditions']['conditions'][$k]['value'] = preg_replace(
                                "/[^0-9]/", '', $this->request->post['conditions']['conditions'][$k]['value']
                            );
                        }
                    }
                    if ($rule['object'] == 'order_product_weight' || $rule['object'] == 'order_subtotal') {
                        if (in_array(
                            $this->request->post['conditions']['conditions'][$k]['operator'], ['in', 'notin']
                        )) {
                            $temp = explode(',', $this->request->post['conditions']['conditions'][$k]['value']);
                            foreach ($temp as &$float_value) {
                                $float_value = round((float) preg_replace("/[^0-9.]/", '', $float_value), 4);
                            }
                            $this->request->post['conditions']['conditions'][$k]['value'] = implode(',', $temp);
                            unset($temp);
                        } else {
                            $this->request->post['conditions']['conditions'][$k]['value'] = round(
                                (float) preg_replace(
                                    "/[^0-9.]/",
                                    '',
                                    $this->request->post['conditions']['conditions'][$k]['value']),
                                4);
                        }
                    }
                }
            }

            if (isset($this->request->post['bonuses'])) {
                foreach ($this->request->post['bonuses'] as $k => $rule) {
                    if ($rule['object'] == 'free_products') {
                        $values = [];
                        foreach ($this->request->post['bonuses'][$k]['products'] as $product_id) {
                            $values[$product_id] = [
                                'product_id' => $product_id,
                                'quantity'   => 1,
                            ];
                        }
                        $this->request->post['bonuses'][$k]['products'] = $values;
                    } elseif ($rule['object'] == 'discount_products') {
                        $values = [];
                        foreach ($this->request->post['bonuses'][$k]['products'] as $product_id) {
                            $values[$product_id] = [
                                'product_id' => $product_id,
                                'quantity'   => (isset($this->request->post['discount_products_quantity'][$product_id])
                                    ? (int) $this->request->post['discount_products_quantity'][$product_id]
                                    : 1),
                            ];
                        }
                        $this->request->post['bonuses'][$k]['products'] = $values;
                    }
                }
            }
            //if was try to save empty list of bonuses  - show error

            if ($this->request->get['tab'] == 'bonuses' && !$this->request->post['bonuses']) {
                $this->session->data['warning'] = $this->language->get('promo_manager_error_empty_bonuses');
            } elseif ($this->request->get['tab'] == 'conditions'
                        && !has_value($this->request->post['conditions']['conditions'])
            ) {
                $this->session->data['warning'] = $this->language->get('promo_manager_error_empty_conditions');
            } else {
                $this->model_sale_promo_manager->editpromotion($promo_manager_id, $this->request->post);
                $this->session->data ['success'] = $this->language->get('text_success_edit');
            }

            redirect(
                $this->html->getSecureURL(
                    'sale/promo_manager/edit', '&tab='.$this->request->get['tab'].'&promo_manager_id='.$promo_manager_id
                )
            );
        }

        $info = $this->model_sale_promo_manager->getpromotion($promo_manager_id);
        foreach ($info as $k => $v) {
            $this->data[$k] = $v;
        }

        $this->data['tabs']['general'] = [
            'href'   => $this->html->getSecureURL('sale/promo_manager/edit', '&tab=general&promo_manager_id='.$promo_manager_id),
            'text'   => $this->language->get('text_general'),
            'active' => '',
        ];
        $this->data['tabs']['conditions'] = [
            'href'   => $this->html->getSecureURL('sale/promo_manager/edit', '&tab=conditions&promo_manager_id='.$promo_manager_id),
            'text'   => $this->language->get('text_conditions'),
            'active' => '',
        ];
        $this->data['tabs']['bonuses'] = [
            'href'   => $this->html->getSecureURL('sale/promo_manager/edit', '&tab=bonuses&promo_manager_id='.$promo_manager_id),
            'text'   => $this->language->get('text_bonuses'),
            'active' => '',
        ];

        switch ($this->request->get['tab']) {
            case 'conditions':
                $this->data['tabs']['conditions']['active'] = true;
                $this->data['conditions'] = $this->data['conditions'] ? unserialize($this->data['conditions']) : [];
                $this->_getFormConditions();
                break;
            case 'bonuses':
                $this->data['bonuses'] = $this->data['bonuses'] ? unserialize($this->data['bonuses']) : [];
                $this->data['tabs']['bonuses']['active'] = true;
                $this->_getFormBonuses();
                break;
            default:
                $this->data['tabs']['general']['active'] = true;
                $this->_getFormGeneral();
                break;
        }

        //update controller data
        $this->extensions->hk_UpdateData($this, __FUNCTION__);
    }

    public function delete() {
        //init controller data
        $this->extensions->hk_InitData($this, __FUNCTION__);

        $promo_manager_id = (int) $this->request->get['promo_manager_id'];
        $this->loadModel('sale/promo_manager');
        $this->model_sale_promo_manager->deletepromotion($promo_manager_id);
        //update controller data
        $this->extensions->hk_UpdateData($this, __FUNCTION__);
        redirect($this->html->getSecureURL('sale/promo_manager'));
    }

    protected function _getFormGeneral() {
        if (isset ($this->session->data['warning'])) {
            $this->data ['error_warning'] = $this->session->data['warning'];
            $this->session->data['warning'] = '';
        } else {
            $this->data ['error_warning'] = '';
        }

        $this->view->assign('success', $this->session->data['success']);
        if (isset($this->session->data['success'])) {
            unset($this->session->data['success']);
        }

        $this->document->initBreadcrumb(
            [
                'href'      => $this->html->getSecureURL('index/home'),
                'text'      => $this->language->get('text_home'),
                'separator' => false,
            ]
        );
        $this->document->addBreadcrumb(
            [
                'href'      => $this->html->getSecureURL('sale/promo_manager'),
                'text'      => $this->language->get('promo_manager_name'),
                'separator' => ' :: ',
            ]
        );

        $this->data ['cancel_href'] = $this->html->getSecureURL('sale/promo_manager');
        //$this->data['js_date_format'] = format4Datepicker($this->language->get('date_format_short'));
        if (!isset ($this->request->get ['promo_manager_id'])) {
            $this->data ['action'] = $this->html->getSecureURL('sale/promo_manager/insert', '&tab=general');
            $this->data ['form_title'] = $this->language->get('text_create');
            $this->data['heading_title'] = $this->language->get('text_create');
            $this->data ['update'] = '';
            $form = new AForm ('ST');
        } else {
            $this->data ['action'] = $this->html->getSecureURL(
                'sale/promo_manager/edit',
                '&tab=general&promo_manager_id='.$this->request->get ['promo_manager_id']
            );
            $this->data ['form_title'] = $this->language->get('text_edit').' '.$this->data['name'];
            $this->data ['update'] = $this->html->getSecureURL(
                'listing_grid/promo_manager/update_field',
                '&promo_manager_id='.$this->request->get ['promo_manager_id']
            );
            $form = new AForm ('HS');
        }

        $this->document->addBreadcrumb(
            [
                'href'      => $this->data['action'],
                'text'      => $this->data ['form_title'],
                'separator' => ' :: ',
                'current'   => true,
            ]
        );

        $form->setForm(
            [
                'form_name' => 'promoManagerFrm',
                'update'    => $this->data ['update'],
            ]
        );

        $this->data['form']['form_open'] = $form->getFieldHtml(
            [
                'type'   => 'form',
                'name'   => 'promoManagerFrm',
                'action' => $this->data ['action'],
                'attr'   => 'data-confirm-exit="true" class="aform form-horizontal"',
            ]
        );
        $this->data['form']['submit'] = $form->getFieldHtml(
            [
                'type' => 'button',
                'name' => 'submit',
                'text' => $this->language->get('button_save'),
            ]
        );
        $this->data['form']['cancel'] = $form->getFieldHtml(
            [
                'type' => 'button',
                'name' => 'cancel',
                'text' => $this->language->get('button_cancel'),
            ]
        );
        $this->data['form_title'] = $this->language->get('text_general');
        $this->data['form']['fields']['status']['field'] = $form->getFieldHtml(
            [
                'type'    => 'checkbox',
                'name'    => 'status',
                'value'   => 1,
                'checked' => (isset($this->data['status']) ? (bool) $this->data['status'] : true),
                'style'   => 'btn_switch',
            ]
        );
        $this->data['form']['fields']['status']['text'] = $this->language->get('promo_manager_status');

        $this->data['form']['fields']['name']['field'] = $form->getFieldHtml(
            [
                'type'     => 'input',
                'name'     => 'name',
                'value'    => $this->data['name'],
                'required' => true,
            ]
        );
        $this->data['form']['fields']['name']['text'] = $this->language->get('entry_promo_manager_name');

        if ($this->verifyInfoBanner()) {
            $this->load->model('extension/info_banner');
            $this->data['info_banner_relation'] = $this->model_extension_info_banner->getInfoBannerRelated($this->request->get ['promo_manager_id']);

            $results = $this->model_extension_info_banner->getInfoBannerList();
            $this->data['info_banners']['none'] = $this->language->get('text_select_info_banner');
            foreach ($results as $r) {
                $this->data['info_banners'][$r['info_banner_id']] = $r['title'];
            }

            $this->data['form']['fields']['info_banner_related']['field'] = $form->getFieldHtml(
                [
                    'type'        => 'selectbox',
                    'name'        => 'info_banner_related',
                    'value'       => $this->data['info_banner_relation'],
                    'options'     => $this->data['info_banners'],
                    'style'       => 'chosen',
                ]
            );

            $this->data['form']['fields']['info_banner_related']['text'] = $this->language->get('entry_promo_manager_info_banner_related');
        }

        $this->data['form']['fields']['priority']['field'] = $form->getFieldHtml(
            [
                'type'  => 'input',
                'name'  => 'priority',
                'value' => (isset($this->data['priority']) ? (int) $this->data['priority'] : 1),
                'style' => 'small-field',
                '',
            ]
        );
        $this->data['form']['fields']['priority']['text'] = $this->language->get('entry_promo_manager_priority');

        $this->data['form']['fields']['description_short']['field'] = $form->getFieldHtml(
            [
                'type'  => 'textarea',
                'name'  => 'description_short',
                'value' => $this->data['description_short'],
            ]
        );
        $this->data['form']['fields']['description_short']['text'] =
            $this->language->get('entry_promo_manager_description_short');

        $this->data['form']['fields']['stop']['field'] = $form->getFieldHtml(
            [
                'type'  => 'checkbox',
                'name'  => 'stop',
                'value' => $this->data['stop'],
                'style' => 'btn_switch',
            ]
        );
        $this->data['form']['fields']['stop']['text'] = $this->language->get('entry_promo_manager_stop');

        $this->data['form']['fields']['daterange']['field'] .= $form->getFieldHtml(
            [
                'type'       => 'date',
                'name'       => 'start_date',
                'value'      => ($this->data['start_date']
                    ? dateISO2Display( $this->data['start_date'], $this->language->get('date_format_short'))
                    : null),
                'default'    => date($this->language->get('date_format_short')),
                'dateformat' => format4Datepicker($this->language->get('date_format_short')),
                'required'   => true,
            ]
        );

        $this->data['form']['fields']['daterange']['field'] .= $form->getFieldHtml(
            [
                'type'       => 'date',
                'name'       => 'end_date',
                'value'      => ($this->data['end_date']
                    ? dateISO2Display($this->data['end_date'], $this->language->get('date_format_short'))
                    : null),
                'default'    => '',
                'dateformat' => format4Datepicker($this->language->get('date_format_short')),
            ]
        );
        $this->data['form']['fields']['daterange']['text'] = $this->language->get('entry_promo_manager_daterange');

        $this->data['promo_manager_id'] = $this->request->get['promo_manager_id'] ? : '-1';

        $this->data['subform_url'] = $this->html->getSecureURL(
            'listing_grid/promo_manager/getsubform',
            '&promo_manager_id='.$this->data['promo_manager_id']
        );

        $this->view->batchAssign($this->language->getASet());
        $this->view->batchAssign($this->data);
        $this->view->assign('form_language_switch', $this->html->getContentLanguageSwitcher());
        $this->view->assign('language_code', $this->session->data['language']);
        $this->view->assign('help_url', $this->gen_help_url('promo_manager_edit'));
        $this->view->assign(
            'rl',
            $this->html->getSecureURL(
                'common/resource_library',
                '&object_name=promo_managers&type=image&mode=url'
        )
        );

        $this->processTemplate('pages/sale/promo_manager_form.tpl');
    }

    protected function _getFormConditions() {
        if (isset ($this->session->data['warning'])) {
            $this->data ['error_warning'] = $this->session->data['warning'];
            $this->session->data['warning'] = '';
        } else {
            $this->data ['error_warning'] = '';
        }

        $this->view->assign('success', $this->session->data['success']);
        if (isset($this->session->data['success'])) {
            unset($this->session->data['success']);
        }
        $this->document->initBreadcrumb(
            [
                'href'      => $this->html->getSecureURL('index/home'),
                'text'      => $this->language->get('text_home'),
                'separator' => false,
            ]
        );
        $this->document->addBreadcrumb(
            [
                'href'      => $this->html->getSecureURL('sale/promo_manager'),
                'text'      => $this->language->get('promo_manager_name'),
                'separator' => ' :: ',
            ]
        );

        $this->document->addStyle(
            [
                'href'  => HTTPS_EXT.'promo_manager/admin/view/default/stylesheet/promo_manager.css',
                'rel'   => 'stylesheet',
                'media' => 'screen',
            ]
        );

        $this->data ['cancel_href'] = $this->html->getSecureURL('sale/promo_manager');

        $this->data ['action'] = $this->html->getSecureURL(
            'sale/promo_manager/edit',
            '&tab=conditions&promo_manager_id='.$this->request->get ['promo_manager_id']
        );
        $this->data ['form_title'] = $this->language->get('text_edit').' '.$this->data['name'];
        $this->data ['update'] = $this->html->getSecureURL(
            'listing_grid/promo_manager/update_field',
            '&promo_manager_id='.$this->request->get ['promo_manager_id']
        );
        $form = new AForm ('HT');

        $this->document->addBreadcrumb(
            [
                'href'      => $this->data['action'],
                'text'      => $this->data ['form_title'],
                'separator' => ' :: ',
                'current'   => true,
            ]
        );

        $form->setForm(
            [
                'form_name' => 'promoManagerFrm',
                'update'    => $this->data ['update'],
            ]
        );
        $this->data['form']['form_open'] = $form->getFieldHtml(
            [
                'type'   => 'form',
                'name'   => 'promoManagerFrm',
                'action' => $this->data ['action'],
                'attr'   => 'data-confirm-exit="true" class="aform form-horizontal"',
            ]
        );
        $this->data['form']['submit'] = $form->getFieldHtml(
            [
                'type' => 'button',
                'name' => 'submit',
                'text' => $this->language->get('button_save'),
            ]
        );
        $this->data['form']['cancel'] = $form->getFieldHtml(
            [
                'type' => 'button',
                'name' => 'cancel',
                'text' => $this->language->get('button_cancel'),
            ]
        );
        $this->data['form_title'] = $this->language->get('text_conditions');
        // relations between conditions
        $this->data['conditions_relation']['fields']['if'] = [
            'text'  => $this->language->get('text_if_1'),
            'field' => $form->getFieldHtml(
                [
                    'type'    => 'selectbox',
                    'name'    => 'conditions[relation][if]',
                    'options' => [
                        'all' => $this->language->get('text_all'),
                        'any' => $this->language->get('text_any'),
                    ],
                    'value'   => $this->data['conditions']['relation']['if'] ?? '',
                ]
            ),
        ];

        $this->data['conditions_relation']['fields']['value'] = [
            'text'  => $this->language->get('text_if_2'),
            'field' => $form->getFieldHtml(
                [
                    'type'    => 'selectbox',
                    'name'    => 'conditions[relation][value]',
                    'options' => [
                        'true'  => $this->language->get('text_true'),
                        'false' => $this->language->get('text_false'),
                    ],
                    'value'   => $this->data['conditions']['relation']['value'] ?? '',
                ]
            ),
        ];

// 	conditions
        $this->data['form']['fields'] = [];
        if (isset($this->data['conditions']['conditions'])) {
            $i = 0;
            $this->load->library('json');

            foreach ($this->data['conditions']['conditions'] as $rule) {
                $this->request->post['idx'] = $i;
                $this->request->post['condition_object'] = $rule['object'];
                $args = [
                    [
                        'operator' => $rule['operator'],
                        'value'    => $rule['value'],
                    ],
                ];
                $fields = $this->dispatch('responses/listing_grid/promo_manager/getFieldsByConditionObject', $args);

                $fields = AJson::decode($fields->dispatchGetOutput(), true);
                $this->data['form']['fields'][$i]['id'] = $rule['object'];
                $this->data['form']['fields'][$i]['text'] = $fields['text'];
                $this->data['form']['fields'][$i]['field'] = $fields['fields'];
                $i++;
            }
        }

        // selectbox with condition's objects list
        $promo = new Apromotion();
        $cond_objects = $promo->getConditionObjects();

        foreach ($cond_objects as $obj) {
            $this->data['condition_objects'][$obj] = $this->language->get('text_'.$obj);
        }
        array_unshift($this->data['condition_objects'], $this->language->get('text_select'));
        $this->data['condition_object']['field'] = $form->getFieldHtml(
            [
                'type'    => 'selectbox',
                'name'    => 'condition_object',
                'options' => $this->data['condition_objects'],
                'value'   => $this->data['promo_manager_type'],
            ]
        );
        $this->data['condition_object']['text'] = $this->language->get('entry_condition_object');

        $this->data['condition_url'] = $this->html->getSecureURL(
            'listing_grid/promo_manager/getFieldsByConditionObject', '&promo_manager_id='.$this->data['promo_manager_id']
        );

        $this->view->batchAssign($this->language->getASet());
        $this->view->batchAssign($this->data);
        //$this->view->assign('language_code', $this->session->data['language']);
        $this->view->assign('help_url', $this->gen_help_url('promo_manager_edit'));
        $this->view->assign(
            'rl',
            $this->html->getSecureURL(
                'common/resource_library',
                '&object_name=promo_managers&type=image&mode=url'
            )
        );

        $this->processTemplate('pages/sale/promo_manager_form_conditions.tpl');
    }

    protected function _getFormBonuses() {
        if (isset ($this->session->data['warning'])) {
            $this->data ['error_warning'] = $this->session->data['warning'];
            $this->session->data['warning'] = '';
        } else {
            $this->data ['error_warning'] = '';
        }

        $this->view->assign('success', $this->session->data['success']);
        if (isset($this->session->data['success'])) {
            unset($this->session->data['success']);
        }
        $this->document->initBreadcrumb(
            [
                'href'      => $this->html->getSecureURL('index/home'),
                'text'      => $this->language->get('text_home'),
                'separator' => false,
            ]
        );
        $this->document->addBreadcrumb(
            [
                'href'      => $this->html->getSecureURL('sale/promo_manager'),
                'text'      => $this->language->get('promo_manager_name'),
                'separator' => ' :: ',
            ]
        );

        $this->document->addStyle(
            [
                'href'  => HTTPS_EXT.'promo_manager/admin/view/default/stylesheet/promo_manager.css',
                'rel'   => 'stylesheet',
                'media' => 'screen',
            ]
        );

        $this->data ['cancel_href'] = $this->html->getSecureURL('sale/promo_manager');

        $this->data ['action'] = $this->html->getSecureURL(
            'sale/promo_manager/edit',
            '&tab=bonuses&promo_manager_id='.$this->request->get ['promo_manager_id']
        );
        $this->data ['form_title'] = $this->language->get('text_edit').' '.$this->data['name'];
        $this->data ['update'] = $this->html->getSecureURL(
            'listing_grid/promo_manager/update_field',
            '&promo_manager_id='.$this->request->get ['promo_manager_id']
        );
        $form = new AForm ('HT');

        $this->document->addBreadcrumb(
            [
                'href'      => $this->data['action'],
                'text'      => $this->data ['form_title'],
                'separator' => ' :: ',
                'current'   => true,
            ]
        );
        $form->setForm(
            [
                'form_name' => 'promoManagerFrm',
                'update'    => $this->data ['update'],
            ]
        );
        $this->data['form']['form_open'] = $form->getFieldHtml(
            [
                'type'   => 'form',
                'name'   => 'promoManagerFrm',
                'action' => $this->data ['action'],
                'attr'   => 'data-confirm-exit="true"  class="aform form-horizontal"',
            ]
        );
        $this->data['form']['submit'] = $form->getFieldHtml(
            [
                'type' => 'button',
                'name' => 'submit',
                'text' => $this->language->get('button_save'),
            ]
        );
        $this->data['form']['cancel'] = $form->getFieldHtml(
            [
                'type' => 'button',
                'name' => 'cancel',
                'text' => $this->language->get('button_cancel'),
            ]
        );
        $this->data['form_title'] = $this->language->get('text_bonuses');

        $this->data['form']['fields'] = [];
        $href = '';
        if (isset($this->data['bonuses'])) {
            $i = 0;
            $this->load->library('json');
            foreach ($this->data['bonuses'] as $rule) {
                $this->request->post['idx'] = $i;
                $this->request->post['bonus_object'] = $rule['object'];
                $args = [['operator' => $rule['operator'], 'value' => $rule['value']]];

                if (in_array($rule['object'], ['free_products', 'discount_products'])) {
                    $args[0]['products'] = $rule['products'];
                }

                $fields = $this->dispatch('responses/listing_grid/promo_manager/getFieldsByBonusObject', $args);
                $fields = AJson::decode($fields->dispatchGetOutput(), true);
                $this->data['form']['fields'][$i]['id'] = $rule['object'];
                $this->data['form']['fields'][$i]['text'] = $fields['text'];
                $this->data['form']['fields'][$i]['field'] = $fields['fields'];

                if ($rule['object'] == 'discount_products') {
                    foreach ($rule['products'] as $product) {
                        $href .= '&discount_products_quantity['.$product['product_id'].']='.$product['quantity'];
                    }
                }
                $i++;
            }
        }

        $this->data['list_content_url'] = $this->html->getSecureUrl(
            'listing_grid/promo_manager/discount_products',
            $href
        );

        // selectbox with condition's objects list
        $promo = new Apromotion();
        $bonus_objects = $promo->getBonusObjects();

        foreach ($bonus_objects as $obj) {
            $this->data['bonus_objects'][$obj] = $this->language->get('text_'.$obj);
        }
        array_unshift($this->data['bonus_objects'], $this->language->get('text_select'));
        $this->data['bonus_object']['field'] = $form->getFieldHtml(
            [
                'type'    => 'selectbox',
                'name'    => 'bonus_object',
                'options' => $this->data['bonus_objects'],
                'value'   => $this->data['promo_manager_type'],
            ]
        );
        $this->data['bonus_object']['text'] = $this->language->get('entry_bonus_object');

        $this->data['bonus_url'] = $this->html->getSecureURL(
            'listing_grid/promo_manager/getFieldsByBonusObject',
            '&promo_manager_id='.$this->data['promo_manager_id']
        );

        $this->view->assign('help_url', $this->gen_help_url('promo_manager_edit'));


        $this->view->batchAssign($this->language->getASet());
        $this->view->batchAssign($this->data);

        $this->processTemplate('pages/sale/promo_manager_form_bonuses.tpl');
    }

    protected function _validateForm() {
        if (!$this->user->hasPermission('modify', 'sale/promo_manager')) {
            $this->session->data['warning'] = $this->error ['warning'] = $this->language->get('error_permission');
        }

        $required = ['name', 'start_date'];
        if ($this->request->post) {
            foreach ($this->request->post as $name => $value) {
                if (in_array($name, $required) && empty($value)) {
                    $this->error ['warning'] = $this->language->get('error_empty');
                    $this->session->data['warning'] = $this->language->get('error_empty');
                    break;
                }
            }
        }

        foreach ($required as $name) {
            if (!in_array($name, array_keys($this->request->post))) {
                return false;
            }
        }
        $this->extensions->hk_ValidateData($this);
        return (!$this->error);
    }

}
