<?php

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

/**
 * Class ControllerPagesProductRefinedSearch
 *
 * @property ModelProductRefinedSearch $model_product_refined_search
 */
class ControllerPagesProductRefinedSearch extends AController
{
    public function main()
    {
        // unload model
        $this->registry->set('model_product_refined_search', null);
        // init controller data
        $this->extensions->hk_InitData($this, __FUNCTION__);

        $this->loadLanguage('product/search');
        $this->document->setTitle($this->language->get('heading_title'));
        $this->document->resetBreadcrumbs();
        $this->document->addBreadcrumb(
            [
                'href' => $this->html->getURL('index/home'),
                'text' => $this->language->get('text_home'),
                'separator' => false,
            ]
        );
        
        if (has_value($this->request->get['__e']) && $this->config->get('products_refined_search_encrypt_url')) {
            $decoded = base64_decode($this->request->get['__e']);
            $decoded = urldecode($decoded);
            parse_str($decoded, $uri_array);
            $this->request->get = array_merge($this->request->get, $uri_array);
        }

        if (isset($this->request->get['category_id'])) {
            $category_id = $this->request->get['category_id'];
            if (!is_array($category_id)) {
                $category_id = explode(',', $this->request->get['category_id']);
            }
            end($category_id);
            $this->request->get['category_id'] = current($category_id);

            // skip if all categories
            if ($this->request->get['category_id'] == 0) {
                unset($this->request->get['category_id']);
            }
        }

        $limit = $this->config->get('config_catalog_limit');
        if (isset($this->request->get['limit']) && (int) $this->request->get['limit'] > 0) {
            $limit = (int) $this->request->get['limit'];
            // protection from overloading with big limits
            //if ($limit > 50) {
            //    $limit = 50;
            //}
        }

        $this->loadModel('product/refined_search');
        // get filter class from the model
        $filter = $this->model_product_refined_search->filter;
        $uri = $this->model_product_refined_search->buildFilterURI() . '&limit=' . $limit;

        if (method_exists($this->html, 'encryptURI')
           && $this->config->get('products_refined_search_encrypt_url')
        ) {
            $enc_uri = $this->html->encryptURI($uri);
        } else {
            $enc_uri = $uri;
        }
        $enc_uri = $uri;

        $this->document->addBreadcrumb(
            [
                'href' => $this->html->getURL('product/refined_search', '&' . $enc_uri),
                'text' => $this->language->get('heading_title'),
                'separator' => $this->language->get('text_separator'),
            ]
        );

        $promotion = new APromotion();

        $product_total = $this->model_product_refined_search->getTotalProducts();

        if ($product_total > 0) {
            $total_pages = ceil($product_total / $filter->getParam('rows'));
        } else {
            $total_pages = 0;
        }

        // Preserved jqGrid JSON interface
        $response = new stdClass();
        $response->page = $filter->getParam('page');
        $response->total = $total_pages;
        $response->records = $product_total;

        if ($product_total) {
            $this->loadModel('catalog/product');
            $this->loadModel('catalog/review');
            $this->loadModel('tool/seo_url');

            $products = [];

            if (isset($this->request->get['sidx'])) {
                $sort = $this->request->get['sidx'];
                $order = $this->request->get['sord'];
            } else {
                list($sort, $order) = explode('-', $this->config->get('products_refined_search_result_sorting'));
            }

            $results = $this->model_product_refined_search->getProducts(
                [
                    'limit' => $limit,
                    'sort' => $sort,
                    'order' => $order,
                ]
            );

        $this->loadLanguage('availability_listing/availability_listing');
        $this->loadLanguage('product/product');
        $this->loadModel('catalog/product');
        
        $data['language_id'] = $this->config->get('storefront_language_id');
        $data['availability_tab'] = $this->language->get('availability_listing_name');
        $data['availability_listing_nastock_text'] = $this->language->get('text_instock');
        $data['availability_text'] = $this->config->get('availability_text');
        if ('1' == $this->config->get('availability_listing_nastock')) {
            $data['availability_listing_nastock'] = 1;
        } elseif ('0' == $this->config->get('availability_listing_nastock')) {
            $data['availability_listing_nastock'] = 0;
        }

        /* display data selector */
        if ('0' == $this->config->get('display_type')) {
            $data['data_to_display'] = 0;
        } elseif ('1' == $this->config->get('display_type')) {
            $data['data_to_display'] = 1;
        } elseif ('2' == $this->config->get('display_type')) {
            $data['data_to_display'] = 2;
        }

            $resource = new AResource('image');
            foreach ($results as $result) {
                $product_id = (int) $result['product_id'];
                $thumbnail = $resource->getMainThumb(
                    'products',
                    $product_id,
                    $this->config->get('config_image_product_width'),
                    $this->config->get('config_image_product_height')
                );

                if ($this->config->get('enable_reviews')) {
                    $rating = $this->model_catalog_review->getAverageRating($product_id);
                } else {
                    $rating = false;
                }
                $special = false;
                $discount = $promotion->getProductDiscount($product_id);
                if ($discount) {
                    $price = $this->currency->format(
                        $this->tax->calculate(
                            $discount, $result['tax_class_id'],
                            $this->config->get('config_tax')
                        )
                    );
                } else {
                    $price = $this->currency->format(
                        $this->tax->calculate(
                            $result['price'], $result['tax_class_id'],
                            $this->config->get('config_tax')
                        )
                    );
                    $special = (float) $promotion->getProductSpecial($product_id);
                    if ($special) {
                        $special = $this->currency->format(
                            $this->tax->calculate(
                                $special, $result['tax_class_id'],
                                $this->config->get('config_tax')
                            )
                        );
                    }
                }

                $options = $this->model_catalog_product->getProductOptions($product_id);
                if ($options) {
                    $add = $this->html->getSEOURL(
                        'product/product',
                        '&product_id=' . $product_id,
                        '&encode'
                    );
                } else {
                    if ($this->config->get('config_cart_ajax')) {
                        $add = '#';
                    } else {
                        $add = $this->html->getSecureURL(
                            'checkout/cart',
                            '&product_id=' . $product_id,
                            '&encode'
                        );
                    }
                }

                $stock_info = $this->model_catalog_product->getProductsStockInfo([0 => $product_id]);

               
                $track_stock = false;
                $in_stock = false;
                $no_stock_text = $this->language->get('text_out_of_stock');
                $total_quantity = 0;
                $stock_checkout = $result['stock_checkout'] === ''
                    ? $this->config->get('config_stock_checkout')
                    : $result['stock_checkout'];
                if ($stock_info[$product_id]['subtract']) {
                    $track_stock = true;
                    $total_quantity = $this->model_catalog_product->hasAnyStock($product_id);
                    // we have stock or out of stock checkout is allowed
                    if ($total_quantity > 0 || $stock_checkout) {
                        $in_stock = true;
                    }
                }

                $products[] = [
                    'product_id' => $product_id,
                    'name' => $result['name'],
                    'model' => $result['model'],
                    'blurb' => $result['blurb'],
                    'rating' => $rating,
                    'stars' => sprintf($this->language->get('text_stars'), $rating),
                    'thumb' => $thumbnail,
                    'price' => $price,
                    'raw_price' => $result['price'],
                    'call_to_order' => $result['call_to_order'],
                    'options' => $options,
                    'special' => $special,
                    'href' => $this->html->getSEOURL(
                        'product/product',
                        '&product_id=' . $product_id,
                        '&encode'
                    ),
                    'add' => $add,
                    'description' => html_entity_decode($result['description'], ENT_QUOTES, 'UTF-8'),
                    'track_stock' => $track_stock,
                    'in_stock' => $in_stock,
                    'no_stock_text' => $no_stock_text,
                    'total_quantity' => $total_quantity,
                    'tax_class_id' => $result['tax_class_id'],
                ];
                $data['tplvar']['stock'] = $this->GetStock($product_id);
                $this->view->batchAssign($data);
                $hooks = (string) ('product_listing_details0_' . (int) $product_id);
                $this->view->addHookVar($hooks, $this->view->fetch('pages/availability_listing/availability_listing_list.tpl'));
            }

            $this->data['products'] = $products;

            if ($this->config->get('config_customer_price')) {
                $display_price = true;
            } elseif ($this->customer->isLogged()) {
                $display_price = true;
            } else {
                $display_price = false;
            }
            $this->data['display_price'] = $display_price;
            $this->data['uri'] = $enc_uri;

            $sorts = [];
            $sorts[] = [
                'text' => $this->language->get('text_default'),
                'value' => 'sidx=sort_order&sord=ASC',
            ];
            $sorts[] = [
                'text' => $this->language->get('text_sorting_name_asc'),
                'value' => 'sidx=name&sord=ASC',
            ];
            $sorts[] = [
                'text' => $this->language->get('text_sorting_name_desc'),
                'value' => 'sidx=name&sord=DESC',
            ];
            $sorts[] = [
                'text' => $this->language->get('text_sorting_price_asc'),
                'value' => 'sidx=price&sord=ASC',
            ];
            $sorts[] = [
                'text' => $this->language->get('text_sorting_price_desc'),
                'value' => 'sidx=price&sord=DESC',
            ];
            $sorts[] = [
                'text' => $this->language->get('text_sorting_rating_desc'),
                'value' => 'sidx=rating&sord=DESC',
            ];
            $sorts[] = [
                'text' => $this->language->get('text_sorting_rating_asc'),
                'value' => 'sidx=rating&sord=ASC',
            ];
            $sorts[] = [
                'text' => $this->language->get('text_sorting_date_desc'),
                'value' => 'sidx=date_modified&sord=DESC',
            ];
            $sorts[] = [
                'text' => $this->language->get('text_sorting_date_asc'),
                'value' => 'sidx=date_modified&sord=ASC',
            ];
            //MOD
            $sorts[] = [
                'text' => $this->language->get('SKU'),
                'value' => 'sidx=sku&sord=ASC',
            ];

            //sort=p.sku-ASC

            $this->data['sorts'] = $sorts;
            $options = [];
            foreach ($sorts as $item) {
                $options[$item['value']] = $item['text'];
            }

            // preparing data for pagination
            $page = $this->request->get['page'] ?? 1;

            $sorting = $this->html->buildSelectbox(
                [
                    'name' => 'sort',
                    'options' => $options,
                    'value' => 'sidx=' . $sort . '&sord=' . strtoupper($order),
                ]
            );

            $this->data['sorting'] = $sorting;

            if ($sort == 'name') {
                $sort = 'pd.' . $sort;
            } elseif (in_array($sort, ['sort_order', 'price'])) {
                $sort = 'p.' . $sort;
            }

            $this->data['pagination_bootstrap'] = HtmlElementFactory::create(
                [
                    'type' => 'Pagination',
                    'name' => 'pagination',
                    'text' => $this->language->get('text_pagination'),
                    'text_limit' => $this->language->get('text_per_page'),
                    'total' => $product_total,
                    'page' => $page,
                    'limit' => $limit,
                    'url' => $this->html->getURL(
                        'product/refined_search',
                        '&' . $enc_uri . '&page={page}',
                        '&encode'
                    ),
                    'style' => 'pagination',
                ]
            );
            $this->data['sort'] = $sort;
            $this->data['order'] = $order;
            $this->data['limit'] = $limit;
        }
        $this->data['review_status'] = $this->config->get('enable_reviews');

        $this->view->batchAssign($this->data);

        $this->processTemplate('pages/product/refined_search.tpl');

        // init controller data
        $this->extensions->hk_UpdateData($this, __FUNCTION__);
    }

    public function GetStock($product_id)
    {
        // if (107 == $product_id) {
        $this->loadLanguage('availability_listing/availability_listing');
        $this->loadLanguage('product/product');
        $this->loadModel('catalog/product');
        // handle stock messages
        // if track stock is off. no messages needed.
        $product_info = $this->model_catalog_product->getProduct($product_id); 
        if (!has_value($product_info['stock_checkout'])) {
            $product_info['stock_checkout'] = $this->config->get('config_stock_checkout');
        }
        if ($this->model_catalog_product->isStockTrackable($product_id)) {
            $total_quantity = $this->model_catalog_product->hasAnyStock($product_id);
            $this->data['track_stock'] = true;
            $this->data['can_buy'] = true;
            // out of stock if no quantity and no stock checkout is disabled
            if ($total_quantity <= 0 && !$product_info['stock_checkout']) {
                $this->data['can_buy'] = false;
                $this->data['in_stock'] = false;
                // show out of stock message
                $this->data['stock'] = $this->language->get('text_out_of_stock');
            } else {
                $this->data['can_buy'] = true;
                $this->data['in_stock'] = true;
                $this->data['stock'] = '';
                if ($this->config->get('config_stock_display') && $product_info['quantity'] > 0 && $product_info['subtract']) {
                    if ($total_quantity < 999999) {
                        $this->data['stock'] = $total_quantity . ' '; // $product_info['quantity'].' ';
                    } else {
                        $this->data['stock'] = $product_info['quantity'] . ' ';
                    }
                }
                if ($product_info['quantity'] <= 0) {
                    $this->data['stock'] = $product_info['stock_status'];
                } else {
                    $this->data['stock'] .= $this->language->get('text_instock');
                }
            }

            // check if we need to disable product for no stock
            if ($this->config->get('config_nostock_autodisable') && $total_quantity <= 0) {
                // set available data
            }
        } else {
            $this->data['can_buy'] = true;
            if ($product_info['quantity'] <= 0) {
                $this->data['stock'] = $product_info['stock_status'];
            } else {
                $this->data['stock'] = $this->language->get('text_instock');
            }
        }

        return $this->data['stock'];
        // }
    }
}
