<?php
if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

class ControllerBlocksRefinedSearch extends AController
{
    public function main()
    {
        //init controller data
        $this->extensions->hk_InitData($this, __FUNCTION__);

        $this->loadLanguage('blocks/search');
        $this->loadLanguage('refined_search/refined_search');

        $this->data['heading_title'] = $this->language->get('heading_title');
        $this->data['text_advanced'] = $this->language->get('text_advanced');
        $this->data['entry_search'] = $this->language->get('entry_search');
        $this->data['search'] = $this->html->buildElement(
            [
                'type'        => 'input',
                'name'        => 'filter_keyword',
                'value'       => ($this->request->get['keyword'] ?? ''),
                'placeholder' => $this->language->get('text_keyword'),

            ]
        );
        $this->data['button_go'] = $this->language->get('button_go');
        $this->view->assign('block_framed', true);
        $this->view->assign('encrypt_refine_params', $this->config->get('products_refined_search_encrypt_url'));
        $this->view->assign('refine_url', $this->html->getSecureURL('product/refined_search'));

        $this->view->batchAssign($this->data);
        $this->processTemplate();
        $this->extensions->hk_UpdateData($this, __FUNCTION__);
    }
}
