<?php

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

/**
 * Class ControllerBlocksRefineTag
 *
 * @property ModelProductRefinedSearch $model_product_refined_search
 */
class ControllerBlocksRefineTag extends AController
{
    public function main()
    {
        //init controller data
        $this->extensions->hk_InitData($this, __FUNCTION__);

        $this->loadLanguage('refined_search/refined_search');
        $this->view->assign('heading_title', $this->language->get('heading_block_tag'));

        $tag = $this->request->get_or_post('tag');
        $this->loadModel('product/refined_search');

        $uri = $this->model_product_refined_search->buildFilterURI();
        $tags = $this->model_product_refined_search->getTags();
        //check what tags are selected
        for ($i = 0; $i < count($tags); $i++) {
            //encode URL
            $full_uri = $uri.'&tag='.$tags[$i]['name'];
            if (method_exists($this->html, 'encryptURI') && $this->config->get('products_refined_search_encrypt_url')) {
                $full_uri = $this->html->encryptURI($full_uri);
            }

            $tags[$i]['href'] = $this->html->getURL('product/refined_search', '&'.$full_uri, '&encode');

            if (is_array($tag) && in_array($tags[$i]['name'], $tag)) {
                $tags[$i]['checked'] = 'checked';
            } else {
                if ($tag == $tags[$i]['name']) {
                    $tags[$i]['checked'] = 'checked';
                }
            }
        }

        $this->view->assign('tags', $tags);

        // framed needs to show frames for generic block.
        //If tpl used by listing block framed was set by listing block settings
        $this->view->assign('block_framed', true);
        $this->view->assign('encrypt_refine_params', $this->config->get('products_refined_search_encrypt_url'));
        $this->view->assign('refine_url', $this->html->getSecureURL('product/refined_search'));
        $this->view->assign('refine_items_limit', $this->config->get('products_refined_items_limit'));

        $this->processTemplate();

        //init controller data
        $this->extensions->hk_UpdateData($this, __FUNCTION__);
    }

}
