<?php

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

/**
 * Class ControllerBlocksRefinePrice
 *
 * @property ModelProductRefinedSearch $model_product_refined_search
 */
class ControllerBlocksRefinePrice extends AController
{
    public function main()
    {
        $use_price_range = false;
        //unload model
        $this->registry->set('model_product_refined_search', null);

        //init controller data
        $this->extensions->hk_InitData($this, __FUNCTION__);

        $this->loadLanguage('refined_search/refined_search');
        // add jquery stuff for price slider
        $this->document->addStyle(
            [
                'rel' => 'stylesheet',
                'href' => '//ajax.googleapis.com/ajax/libs/jqueryui/1.10.4/themes/cupertino/jquery-ui.css',
            ]
        );
        $this->document->addScriptBottom('//ajax.googleapis.com/ajax/libs/jqueryui/1.8.22/jquery-ui.js');

        $this->view->assign('heading_title', $this->language->get('heading_block_price'));

        $this->loadModel('product/refined_search');

        if (has_value($this->request->get['__e']) && $this->config->get('products_refined_search_encrypt_url')) {
            $decoded = base64_decode($this->request->get['__e']);
            $decoded = urldecode($decoded);
            parse_str($decoded, $uri_array);

            $this->request->get = array_merge($this->request->get, $uri_array);
        }

        $price_range = $this->model_product_refined_search->getPriceRange();
        $max_price = ceil($this->model_product_refined_search->getMaxPrice());
        if (has_value($this->request->get['pfrom'])) {
            $use_price_range = true;
            $min = floor($this->request->get['pfrom']);
        } else {
            $min = floor($price_range['min_price']);
        }
        if (has_value($this->request->get['pto'])) {
            $use_price_range = true;
            $max = ceil($this->request->get['pto']);
        } else {
            $max = ceil($price_range['max_price']);
        }

        $curr = $this->currency->getCurrency();
        $this->view->assign(
            'text_price_range', sprintf(
            $this->language->get('text_price_range'), $curr['symbol_left'].$curr['symbol_right']
        )
        );
        $this->view->assign('use_price_range', $use_price_range);
        $this->view->assign('max_price', $max_price);
        $this->view->assign('pto', $max);
        $this->view->assign('pfrom', $min);
        $this->view->assign('text_apply', $this->language->get('text_apply'));

        // framed needs to show frames for generic block.
        //If tpl used by listing block framed was set by listing block settings
        $this->view->assign('block_framed', true);
        $this->view->assign('encrypt_refine_params', $this->config->get('products_refined_search_encrypt_url'));
        $this->view->assign('refine_url', $this->html->getSecureURL('product/refined_search'));

        $this->processTemplate();

        //init controller data
        $this->extensions->hk_UpdateData($this, __FUNCTION__);
    }

}
