<?php

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

/**
 * Class ControllerBlocksRefineManufacturer
 *
 * @property ModelProductRefinedSearch $model_product_refined_search
 */
class ControllerBlocksRefineManufacturer extends AController
{
    public function main()
    {
        //init controller data
        $this->extensions->hk_InitData($this, __FUNCTION__);

        $this->loadLanguage('refined_search/refined_search');
        $this->view->assign('heading_title', $this->language->get('heading_block_manufacturers'));

        $manufacturer_id = $this->request->get_or_post('manufacturer_id');

        $this->loadModel('product/refined_search');

        //get all eligible (for product list categories
        $uri = $this->model_product_refined_search->buildFilterURI();

        $manufacturers = $this->model_product_refined_search->getManufacturers(['sort' => 'name']);
        //check what categories are selected
        for ($i = 0; $i < count($manufacturers); $i++) {
            //encode URL
            $full_uri = $uri.'&manufacturer_id='.$manufacturers[$i]['manufacturer_id'];
            if (method_exists($this->html, 'encryptURI') && $this->config->get('products_refined_search_encrypt_url')) {
                $full_uri = $this->html->encryptURI($full_uri);
            }

            $manufacturers[$i]['href'] = $this->html->getURL('product/refined_search', '&'.$full_uri, '&encode');

            if (is_array($manufacturer_id) && in_array($manufacturers[$i]['manufacturer_id'], $manufacturer_id)) {
                $manufacturers[$i]['checked'] = 'checked';
            } else {
                if ($manufacturer_id == $manufacturers[$i]['manufacturer_id']) {
                    $manufacturers[$i]['checked'] = 'checked';
                }
            }
        }

        $this->view->assign('manufacturers', $manufacturers);

        // framed needs to show frames for generic block.
        //If tpl used by listing block framed was set by listing block settings
        $this->view->assign('block_framed', true);
        $this->view->assign('encrypt_refine_params', $this->config->get('products_refined_search_encrypt_url'));
        $this->view->assign('refine_url', $this->html->getSecureURL('product/refined_search'));
        $this->view->assign('refine_items_limit', $this->config->get('products_refined_items_limit'));

        $this->processTemplate();

        //init controller data
        $this->extensions->hk_UpdateData($this, __FUNCTION__);
    }

}
