<?php

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

/**
 * Class ControllerBlocksRefineCategory
 *
 * @property ModelProductRefinedSearch $model_product_refined_search
 */
class ControllerBlocksRefineCategory extends AController
{
    protected $category_id = 0;
    protected $path = [];

    public function main()
    {
        //init controller data
        $this->extensions->hk_InitData($this, __FUNCTION__);

        $this->loadLanguage('refined_search/refined_search');
        $this->view->assign('heading_title', $this->language->get('heading_block_categories'));

        if (isset($this->request->get['path'])) {
            $this->path = explode(',', $this->request->get['path']);
            $this->category_id = end($this->path);
        } else {
            $this->category_id = $this->request->get_or_post('category_id');
        }
        //skip if all categories
        if ($this->request->get['category_id'] == 0) {
            unset($this->request->get['category_id']);
        }

        $this->loadModel('product/refined_search');

        //get all eligible (for product list categories
        $uri = $this->model_product_refined_search->buildFilterURI();

        $categories = $this->model_product_refined_search->getCategories();
        //check what categories are selected
        for ($i = 0; $i < count($categories); $i++) {
            //encode URL
            $full_uri = $uri.'&category_id='.$categories[$i]['category_id'];
            if (method_exists($this->html, 'encryptURI')
                && $this->config->get('products_refined_search_encrypt_url')
            ) {
                $full_uri = $this->html->encryptURI($full_uri);
            }

            $categories[$i]['href'] = $this->html->getURL('product/refined_search', '&'.$full_uri, '&encode');

            if (is_array($this->category_id) && in_array($categories[$i]['category_id'], $this->category_id)) {
                $categories[$i]['checked'] = 'checked';
            } else {
                if ($this->category_id == $categories[$i]['category_id']) {
                    $categories[$i]['checked'] = 'checked';
                }
            }
        }

        $this->view->assign('categories', $categories);

        // framed needs to show frames for generic block.
        //If tpl used by listing block framed was set by listing block settings
        $this->view->assign('block_framed', true);
        $this->view->assign('refine_items_limit', $this->config->get('products_refined_items_limit'));

        $this->view->assign('encrypt_refine_params', $this->config->get('products_refined_search_encrypt_url'));
        $this->view->assign('refine_url', $this->html->getSecureURL('product/refined_search'));

        $this->processTemplate();

        //init controller data
        $this->extensions->hk_UpdateData($this, __FUNCTION__);
    }
}
