<?php
if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

$registry = Registry::getInstance();
$language_list = $this->model_localisation_language->getLanguages();

$sql = "SELECT layout_id 
        FROM ".$this->db->table('layouts')." 
        WHERE layout_name='Products Refined Search Page'";
$result = $this->db->query($sql);
foreach ($result->rows as $row) {
    $layout_id = $row['layout_id'];
    $lm = new ALayoutManager();
    $lm->deleteLayoutBlocks($layout_id);
    $page = $lm->getPageByController('pages/product/refined_search');
    $lm->deletePageLayoutByID($page['page_id'], $layout_id);
    $lm->deleteBlock('refined_search');
    $lm->deleteBlock('refine_category');
    $lm->deleteBlock('refine_manufacturer');
    $lm->deleteBlock('refine_tag');
    $lm->deleteBlock('refine_price');
}

$lm = new ALayoutManager();
$layout_ids = [];
$templates = ['default'];
if ($this->config->get('config_storefront_template') != 'default') {
    $templates[] = $this->config->get('config_storefront_template');
}

foreach ($templates as $k => $template) {
    $layout_ids[$k] = $lm->saveLayout(
        [
            'template_id' => $template,
            'store_id'    => 0,
            'layout_name' => 'Products Refined Search Page',
            'layout_type' => 1,
        ]
    );
}

$block_ids = [];

// block with button
$block_data = [
    'block_txt_id' => 'refined_search',
    'controller'   => 'blocks/refined_search',
    'templates'    => [
        [
            'parent_block_txt_id' => 'header_bottom',
            'template'            => 'blocks/refined_search.tpl',
        ],
        [
            'parent_block_txt_id' => 'column_left',
            'template'            => 'blocks/refined_search.tpl',
        ],
        [
            'parent_block_txt_id' => 'column_right',
            'template'            => 'blocks/refined_search.tpl',
        ],
        [
            'parent_block_txt_id' => 'content_top',
            'template'            => 'blocks/refined_search.tpl',
        ],
        [
            'parent_block_txt_id' => 'content_bottom',
            'template'            => 'blocks/refined_search.tpl',
        ],
        [
            'parent_block_txt_id' => 'footer_top',
            'template'            => 'blocks/refined_search.tpl',
        ],
    ],
];
$block_ids[] = $lm->saveBlock($block_data);

$block_data = [
    'block_txt_id' => 'refine_category',
    'controller'   => 'blocks/refine_category',
    'templates'    => [
        [
            'parent_block_txt_id' => 'header_bottom',
            'template'            => 'blocks/refine_category.tpl',
        ],
        [
            'parent_block_txt_id' => 'column_left',
            'template'            => 'blocks/refine_category.tpl',
        ],
        [
            'parent_block_txt_id' => 'column_right',
            'template'            => 'blocks/refine_category.tpl',
        ],
        [
            'parent_block_txt_id' => 'content_top',
            'template'            => 'blocks/refine_category.tpl',
        ],
        [
            'parent_block_txt_id' => 'content_bottom',
            'template'            => 'blocks/refine_category.tpl',
        ],
        [
            'parent_block_txt_id' => 'footer_top',
            'template'            => 'blocks/refine_category.tpl',
        ],
    ],
];
$block_ids[] = $lm->saveBlock($block_data);
$block_data = [
    'block_txt_id' => 'refine_manufacturer',
    'controller'   => 'blocks/refine_manufacturer',
    'templates'    => [
        [
            'parent_block_txt_id' => 'header_bottom',
            'template'            => 'blocks/refine_manufacturer.tpl',
        ],
        [
            'parent_block_txt_id' => 'column_left',
            'template'            => 'blocks/refine_manufacturer.tpl',
        ],
        [
            'parent_block_txt_id' => 'column_right',
            'template'            => 'blocks/refine_manufacturer.tpl',
        ],
        [
            'parent_block_txt_id' => 'content_top',
            'template'            => 'blocks/refine_manufacturer.tpl',
        ],
        [
            'parent_block_txt_id' => 'content_bottom',
            'template'            => 'blocks/refine_manufacturer.tpl',
        ],
        [
            'parent_block_txt_id' => 'footer_top',
            'template'            => 'blocks/refine_manufacturer.tpl',
        ],
    ],
];
$block_ids[] = $lm->saveBlock($block_data);
$block_data = [
    'block_txt_id' => 'refine_tag',
    'controller'   => 'blocks/refine_tag',
    'templates'    => [
        [
            'parent_block_txt_id' => 'header_bottom',
            'template'            => 'blocks/refine_tag.tpl',
        ],
        [
            'parent_block_txt_id' => 'column_left',
            'template'            => 'blocks/refine_tag.tpl',
        ],
        [
            'parent_block_txt_id' => 'column_right',
            'template'            => 'blocks/refine_tag.tpl',
        ],
        [
            'parent_block_txt_id' => 'content_top',
            'template'            => 'blocks/refine_tag.tpl',
        ],
        [
            'parent_block_txt_id' => 'content_bottom',
            'template'            => 'blocks/refine_tag.tpl',
        ],
        [
            'parent_block_txt_id' => 'footer_top',
            'template'            => 'blocks/refine_tag.tpl',
        ],
    ],
];
$block_ids[] = $lm->saveBlock($block_data);

$block_data = [
    'block_txt_id' => 'refine_price',
    'controller'   => 'blocks/refine_price',
    'templates'    => [
        [
            'parent_block_txt_id' => 'header_bottom',
            'template'            => 'blocks/refine_price.tpl',
        ],
        [
            'parent_block_txt_id' => 'column_left',
            'template'            => 'blocks/refine_price.tpl',
        ],
        [
            'parent_block_txt_id' => 'column_right',
            'template'            => 'blocks/refine_price.tpl',
        ],
        [
            'parent_block_txt_id' => 'content_top',
            'template'            => 'blocks/refine_price.tpl',
        ],
        [
            'parent_block_txt_id' => 'content_bottom',
            'template'            => 'blocks/refine_price.tpl',
        ],
        [
            'parent_block_txt_id' => 'footer_top',
            'template'            => 'blocks/refine_price.tpl',
        ],
    ],
];

$block_ids[] = $lm->saveBlock($block_data);
$page_id = $lm->savePage(
    [
        'controller'        => 'pages/product/refined_search',
        'page_descriptions' => [$this->language->getDefaultLanguageID() => ['name' => 'Products Refined Search']],
    ]
);

foreach ($templates as $i => $template) {
    $sql = "SELECT *
            FROM ".$this->db->table('layouts')."
            WHERE layout_name = 'Default Page Layout' AND template_id='".$template."'";
    $result = $this->db->query($sql);
    if (!$result->num_rows) {
        continue;
    }

    $lm->clonePageLayout($result->row['layout_id'], $layout_ids[$i]);
    $this->db->query(
        "INSERT INTO ".$this->db->table('pages_layouts')." 
            (`layout_id`, `page_id`) 
        VALUES (".$layout_ids[$i].", ".$page_id.");"
    );

    //remove all blocks from "left column" placeholder
    $sql = "SELECT instance_id 
            FROM ".$this->db->table('block_layouts')." 
            WHERE layout_id = ".$layout_ids[$i]." AND block_id = 3";
    $result = $this->db->query($sql);

    $parent_instance_id = (int) $result->row['instance_id'];
    if ($parent_instance_id) {
        $lm->deleteLayoutBlocks($layout_ids[$i], $parent_instance_id);
    }
    // then insert block into placeholder
    $position = 0;
    foreach ($block_ids as $block_id) {
        $position += 10;
        $sql = "INSERT INTO ".$this->db->table('block_layouts')."
            (layout_id,
            block_id,
            parent_instance_id,
            position,
            status,
            date_added,
            date_modified)
        VALUES ('".( int ) $layout_ids[$i]."',
                '".( int ) $block_id."',
                '".( int ) $parent_instance_id."',
                '".( int ) $position."',
                '". 1 ."',
                NOW(),
                NOW())";
        $this->db->query($sql);
    }
}


