<?php

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

class ExtensionProductsRefinedSearch extends Extension
{

    public function onControllerCommonFooter_InitData()
    {
        $that = $this->baseObject;
        $that->document->addStyle(
            [
                'rel'  => 'stylesheet',
                'href' => $that->view->templateResource('/stylesheet/refined_search.css'),
            ]
        );
        $that->document->addScriptBottom($that->view->templateResource('/javascript/refine_search.js'));

        if ($that->config->get('products_refined_search_encrypt_url')) {
            $that->document->addScriptBottom($that->view->templateResource('/javascript/jquery.base64.min.js'));
        }
    }

    public function onControllerPagesProductCategory_InitData()
    {
        $that = $this->baseObject;
        //redirect to refine search if feature enabled
        if ($that->config->get('products_refined_search_force')) {
            if (has_value($that->request->get['path'])) {
                $parts = explode('_', $that->request->get['path']);
                if (count($parts) == 1) {
                    $category_id = $parts[0];
                } else {
                    $category_id = array_pop($parts);
                }
            } else {
                if (has_value($that->request->get['category_id'])) {
                    $category_id = $that->request->get['category_id'];
                } else {
                    //something odd
                    return;
                }
            }
            redirect($that->html->getURL('product/refined_search', '&category_id='.$category_id));
        }
    }

    public function onControllerPagesProductManufacturer_InitData()
    {
        $that = $this->baseObject;
        //redirect to refine search if feature enabled
        if ($that->config->get('products_refined_search_force')) {
            $manufacturer_id = $that->request->get['manufacturer_id'];
            redirect($that->html->getURL('product/refined_search', '&manufacturer_id='.$manufacturer_id));
        }
    }

    public function onControllerPagesProductSearch_InitData()
    {
        $that = $this->baseObject;
        //redirect to refine search if feature enabled
        if ($that->config->get('products_refined_search_force')) {
            $keyword = $that->request->get['keyword'];
            redirect($that->html->getURL('product/refined_search', '&keyword='.$keyword));
        }
    }

}