<?php

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

/**
 * Class ControllerPagesProductFeaturesProductFeatures
 *
 * @property ModelProductFeaturesProductFeatures $model_product_features_product_features
 */
class ControllerPagesProductFeaturesProductFeatures extends AController
{

    public function main()
    {
        if (isset($this->request->get['feature_id'])) {
            $this->loadModel('product_features/product_features');
            $feature = $this->model_product_features_product_features->getAttribute(
                $this->request->get['feature_id']
            );

            $this->document->setTitle($feature['name']);
            $this->data['heading_title'] = $feature['name'];

            $this->document->resetBreadcrumbs();

            $this->document->addBreadcrumb(
                [
                    'href'      => $this->html->getURL('index/home'),
                    'text'      => $this->language->get('text_home'),
                    'separator' => false,
                ]
            );

            $baseURL = '&feature_id='.$this->request->get['feature_id'];

            if (isset($this->request->get['feature_value_id'])) {
                $baseURL .= '&feature_value_id='.$this->request->get['feature_value_id'];
                $feature_value = $this->model_product_features_product_features->getFeatureValue(
                    $this->request->get['feature_value_id']
                );
                $this->data['heading_title'] .= ' - '.$feature_value['name'];
            }

            if (isset($this->request->get['keyword'])) {
                $baseURL .= '&keyword='.$this->request->get['keyword'];
            }

            $category_id = $this->request->get['category_id'];

            $URL = '';
            $baseURL .= '&category_id='.$category_id;
            if (isset($this->request->get['sort'])) {
                $URL .= '&sort='.$this->request->get['sort'];
            }

            if (isset($this->request->get['order'])) {
                $URL .= '&order='.$this->request->get['order'];
            }

            if (isset($this->request->get['page'])) {
                $URL .= '&page='.$this->request->get['page'];
            }
            if (isset($this->request->get['limit'])) {
                $URL .= '&limit='.$this->request->get['limit'];
            }

            $this->data['url'] = $this->html->getURL('product_features/product_features', $baseURL.$URL);
            $this->document->addBreadcrumb(
                [
                    'href'      => $this->data['url'],
                    'text'      => $feature['name'],
                    'separator' => '::',
                ]
            );

            if (isset($this->request->get['page'])) {
                $page = $this->request->get['page'];
            } else {
                $page = 1;
            }

            if (isset($this->request->get['sort'])) {
                list($sort, $order) = explode("-", $this->request->get['sort']);
            } else {
                $sort = 'p.sort_order';
                $order = 'ASC';
            }

            $product_total = $this->model_product_features_product_features->getTotalProducts(
                $this->request->get['keyword'],
                $this->request->get['feature_id'],
                $this->request->get['feature_value_id'],
                $category_id
            );

            if ($product_total) {
                $limit = $this->config->get('config_catalog_limit');
                if (isset($this->request->get['limit']) && intval($this->request->get['limit']) > 0) {
                    $limit = intval($this->request->get['limit']);
                    if ($limit > 50) {
                        $limit = 50;
                    }
                }

                $this->loadModel('catalog/review');
                $this->loadModel('tool/seo_url');

                $products = [];
                $results = $this->model_product_features_product_features->getProducts(
                    [
                        'keyword'          => $this->request->get['keyword'],
                        'feature_id'       => $this->request->get['feature_id'],
                        'feature_value_id' => $this->request->get['feature_value_id'],
                        'category_id'      => $category_id,
                        'sort'             => $sort,
                        'order'            => $order,
                        'start'            => ($page - 1) * $limit,
                        'limit'            => $limit,
                    ]
                );

                $resource = new AResource('image');
                $this->loadModel('catalog/product');
                $promotion = new APromotion();
                $this->data['review_status'] = $this->config->get('display_reviews');
                foreach ($results as $result) {
                    $thumbnail = $resource->getMainThumb(
                        'products',
                        $result['product_id'],
                        $this->config->get('config_image_product_width'),
                        $this->config->get('config_image_product_height'), true
                    );

                    if ($this->data['review_status']) {
                        $rating = $this->model_catalog_review->getAverageRating($result['product_id']);
                    } else {
                        $rating = false;
                    }

                    $special = false;

                    $discount = $promotion->getProductDiscount($result['product_id']);

                    if ($discount) {
                        $price = $this->currency->format(
                            $this->tax->calculate(
                                $discount,
                                $result['tax_class_id'],
                                $this->config->get('config_tax')
                            )
                        );
                    } else {
                        $price = $this->currency->format(
                            $this->tax->calculate(
                                $result['price'],
                                $result['tax_class_id'],
                                $this->config->get('config_tax')
                            )
                        );
                        $special = $promotion->getProductSpecial($result['product_id']);
                        if ($special) {
                            $special = $this->currency->format(
                                $this->tax->calculate(
                                    $special,
                                    $result['tax_class_id'],
                                    $this->config->get('config_tax')
                                )
                            );
                        }
                    }

                    $options = $this->model_catalog_product->getProductOptions(
                        $result['product_id']
                    );
                    $add = $this->html->getSEOURL(
                        $options ? 'product/product' : 'checkout/cart',
                        '&product_id='.$result['product_id'],
                        '&encode'
                    );

                    $products[] = [
                        'product_id' => $result['product_id'],
                        'name'       => $result['name'],
                        'model'      => $result['model'],
                        'rating'     => $rating,
                        'stars'      => sprintf($this->language->get('text_stars'), $rating),
                        'thumb'      => $thumbnail,
                        'price'      => $price,
                        'options'    => $options,
                        'special'    => $special,
                        'href'       => $this->html->getSEOURL(
                            'product/product',
                            '&keyword='.$this->request->get['keyword']
                            .$baseURL
                            .'&product_id='.$result['product_id'],
                            '&encode'
                        ),
                        'add'        => $add,
                    ];
                }

                $this->data['products'] = $products;

                if ($this->config->get('config_customer_price')) {
                    $display_price = true;
                } elseif ($this->customer->isLogged()) {
                    $display_price = true;
                } else {
                    $display_price = false;
                }
                $this->data['display_price'] = $display_price;

                $URL = $baseURL;

                if (isset($this->request->get['page'])) {
                    $URL .= '&page='.$this->request->get['page'];
                }

                $this->loadLanguage('product/search');

                $sorts = [];
                $sorts[] = [
                    'text'  => $this->language->get('text_default'),
                    'value' => 'p.sort_order-ASC',
                    'href'  => $this->html->getURL(
                        'product/search',
                        $URL.'&sort=p.sort_order&order=ASC',
                        '&encode'
                    ),
                ];

                $sorts[] = [
                    'text'  => $this->language->get('text_name_asc'),
                    'value' => 'pd.name-ASC',
                    'href'  => $this->html->getURL(
                        'product/search',
                        $URL.'&sort=pd.name&order=ASC',
                        '&encode'
                    ),
                ];

                $sorts[] = [
                    'text'  => $this->language->get('text_name_desc'),
                    'value' => 'pd.name-DESC',
                    'href'  => $this->html->getURL(
                        'product/search',
                        $URL.'&sort=pd.name&order=DESC',
                        '&encode'
                    ),
                ];

                $sorts[] = [
                    'text'  => $this->language->get('text_price_asc'),
                    'value' => 'p.price-ASC',
                    'href'  => $this->html->getURL(
                        'product/search',
                        $URL.'&sort=p.price&order=ASC',
                        '&encode'
                    ),
                ];

                $sorts[] = [
                    'text'  => $this->language->get('text_price_desc'),
                    'value' => 'p.price-DESC',
                    'href'  => $this->html->getURL(
                        'product/search',
                        $URL.'&sort=p.price&order=DESC',
                        '&encode'
                    ),
                ];

                $sorts[] = [
                    'text'  => $this->language->get('text_rating_desc'),
                    'value' => 'rating-DESC',
                    'href'  => $this->html->getURL(
                        'product/search',
                        $URL.'&sort=rating&order=DESC',
                        '&encode'
                    ),
                ];

                $sorts[] = [
                    'text'  => $this->language->get('text_rating_asc'),
                    'value' => 'rating-ASC',
                    'href'  => $this->html->getURL(
                        'product/search',
                        $URL.'&sort=rating&order=ASC',
                        '&encode'
                    ),
                ];
                $this->data['sorts'] = $sorts;
                $options = [];
                foreach ($sorts as $item) {
                    $options[$item['value']] = $item['text'];
                }

                $sorting = $this->html->buildSelectbox(
                    [
                        'name'    => 'sort',
                        'options' => $options,
                        'value'   => $this->request->get['sort'],
                    ]
                );

                $this->data['sorting'] = $sorting;

                $url = $baseURL;
                if (isset($this->request->get['sort'])) {
                    $url .= '&sort='.$this->request->get['sort'];
                }

                if (isset($this->request->get['order'])) {
                    $url .= '&order='.$this->request->get['order'];
                }

                if (isset($this->request->get['limit'])) {
                    $url .= '&limit='.$this->request->get['limit'];
                }

                $pagination = new APagination();
                $pagination->total = $product_total;
                $pagination->page = $page;
                $pagination->limit = $limit;
                $pagination->text = $this->language->get('text_pagination');
                $pagination->text_limit = $this->language->get('text_per_page');
                $pagination->url = $this->html->getURL(
                    'product_features/product_features',
                    $url.'&page={page}',
                    '&encode'
                );

                $this->data['pagination'] = $pagination->render();

                $this->data['sort'] = $sort;
                $this->data['order'] = $order;
                $this->data['limit'] = $limit;
                $this->data['url'] = $this->html->getURL('product_features/product_features', $url);
            }

            $this->view->batchAssign($this->data);
            $this->processTemplate('pages/product_features/search.tpl');
        }
    }
}
