<?php
/** @noinspection PhpMultipleClassDeclarationsInspection */

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

/**
 * Class ControllerPagesProductFeaturesProductFeatures
 *
 * @property ModelProductFeaturesProductFeatures $model_product_features_product_features
 */
class ControllerBlocksProductFeaturesProductFeatures extends AController
{

    public function main()
    {
        $this->loadModel('product_features/product_features');
        $category_id = $this->request->get['path'] ?? $this->request->get['category_id'] ?? 0;
        $manufacturer_id = $this->request->get['manufacturer_id'] ?? 0;

        $keyword = $this->request->get['keyword'] ?? '';

        $filter = [
            'category_id'     => $category_id,
            'manufacturer_id' => $manufacturer_id,
            'keyword'         => $keyword,
            'description'     => (int) $this->request->get_or_post('description'),
        ];

        $features = $this->model_product_features_product_features->getProductFeatures($filter);

        if (!empty($features)) {
            //limiting of list
            $feature_limit = (int) $this->config->get('product_features_list_amount');
            if ($feature_limit && sizeof($features) > $feature_limit) {
                $features = array_slice($features, 0, $feature_limit);
            }

            $this->loadLanguage('product_features/product_features');

            $this->view->assign('heading_title', $this->language->get('product_features_name'));
            $this->view->assign('features', $features);

            $url_params = '';
            if ($category_id) {
                $url_params .= '&category_id='.$category_id;
            }
            if ($manufacturer_id) {
                $url_params .= '&manufacturer_id='.$manufacturer_id;
            }
            if ($keyword) {
                $url_params .= '&keyword='.$keyword;
            }

            $this->view->assign('url', $this->html->getSecureURL('product_features/product_features', $url_params));

            if (file_exists($this->view->templateResource('/stylesheet/product_features.css'))) {
                $this->document->addStyle(
                    [
                        'href' => $this->view->templateResource('/stylesheet/product_features.css'),
                        'rel'  => 'stylesheet',
                    ]
                );
            }
            $this->processTemplate();
        }
    }
}
