DROP TABLE IF EXISTS `ac_product_features`;
CREATE TABLE IF NOT EXISTS `ac_product_features` (
	`product_feature_id` int(11) NOT NULL AUTO_INCREMENT,
	`global_attribute_id` int(11) NOT NULL DEFAULT '0',
	`product_id` int(11) NOT NULL,
	`sort_order` int(11) NOT NULL,
	`status` smallint(1) NOT NULL DEFAULT '1',
	`element_type` char(1) NOT NULL,
	`required` smallint(1) NOT NULL DEFAULT '0',
	PRIMARY KEY (`product_feature_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

DROP TABLE IF EXISTS `ac_product_feature_descriptions`;
CREATE TABLE IF NOT EXISTS `ac_product_feature_descriptions` (
	`product_feature_id` int(11) NOT NULL,
	`language_id` int(11) NOT NULL,
	`product_id` int(11) NOT NULL,
	`name` varchar(255) COLLATE utf8_general_ci NOT NULL COMMENT 'translatable'
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

DROP TABLE IF EXISTS `ac_product_feature_values`;
CREATE TABLE IF NOT EXISTS `ac_product_feature_values` (
	`product_feature_value_id` int(11) NOT NULL AUTO_INCREMENT,
	`product_feature_id` int(11) NOT NULL,
	`product_id` int(11) NOT NULL,
	`sort_order` int(11) NOT NULL,
	PRIMARY KEY (`product_feature_value_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

DROP TABLE IF EXISTS `ac_product_feature_value_descriptions`;
CREATE TABLE IF NOT EXISTS `ac_product_feature_value_descriptions` (
	`product_feature_value_id` int(11) NOT NULL,
	`language_id` int(11) NOT NULL,
	`product_id` int(11) NOT NULL,
	`name` text COLLATE utf8_general_ci NOT NULL COMMENT 'translatable'
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;