<?php

/** @noinspection PhpMultipleClassDeclarationsInspection */
if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

class ExtensionProductFeatures extends Extension
{
    public $errors = [];
    public $data = [];

    public function onControllerCommonListingGrid_InitData()
    {
        $that =& $this->baseObject;
        if ($that->data['table_id'] == 'product_grid') {
            $that->loadLanguage('product_features/product_features');
                $that->data['actions']['dropdown']['children']['product_features'] = [
                            'text' => $that->language->get('product_features_name'),
                            'href' => $that->html->getSecureURL('catalog/product_features', '&product_id=%ID%'),
                ];
        }
    }

    public function onControllerPagesCatalogProductTabs_InitData()
    {
        $that =& $this->baseObject;
        $that->loadLanguage('product_features/product_features');

        $this->data = [];
        $this->data['tabs'][] = [
            'href' => $that->html->getSecureURL(
                'catalog/product_features',
                '&product_id='.$that->request->get['product_id']
            ),
            'text' => $that->language->get('product_features_name'),
            'active' => $that->data['active'] == 'product_features',
        ];

        $view = new AView(Registry::getInstance(), 0);
        $view->batchAssign($this->data);
        $that->view->addHookVar('extension_tabs', $view->fetch('pages/product_features/tabs.tpl'));
    }

    /*
     * STOREFRONT HOOKS
     */

    public function onControllerPagesProductProduct_InitData()
    {
        $that =& $this->baseObject;
        if ($that->config->get('product_features_show_at_product_details')) {
            $that->loadLanguage('product_features/product_features');
            /** @var ModelProductFeaturesProductFeatures $mdl */
            $mdl = $that->loadModel('product_features/product_features');

            $data = [];

            $data['features'] = $mdl->getProductFeaturesOfProduct($that->request->get['product_id']);
            $data['language_id'] = $that->config->get('storefront_language_id');
            $data['tab_features'] = $that->language->get('product_features_name');
            $view = new AView(Registry::getInstance(), 0);
            $view->batchAssign($data);
            $that->view->addHookVar(
                'product_features_tab',
                $view->fetch('pages/product_features/product_features_tab.tpl')
            );
            $that->view->addHookVar(
                'product_features',
                $view->fetch('pages/product_features/product_features_list.tpl')
            );
        }
    }

    public function onControllerPagesProductSearch_UpdateData()
    {
        $that =& $this->baseObject;
        if (isset($that->request->get['keyword'])) {
            $product_ids = [];
            if (is_array($that->data['products'])) {
                foreach ($that->data['products'] as $product) {
                    $product_ids[] = $product['product_id'];
                }
            }
            $that->session->data['product_ids'] = $product_ids;
        }
    }

    public function onControllerPagesProductCategory_UpdateData()
    {
        $that =& $this->baseObject;
        $that->loadModel('product_features/product_features');
        $that->session->data['product_ids'] = is_array($that->data['products'])
            ? array_column($that->data['products'], 'product_id')
            : [];
    }

    public function onControllerPagesProductManufacturer_UpdateData()
    {
        //see above
        $this->onControllerPagesProductCategory_UpdateData();
    }

    public function onControllerPagesProductSpecial_UpdateData()
    {
        //see above
        $this->onControllerPagesProductCategory_UpdateData();
    }

    public function onControllerPagesCatalogAttribute_InitData()
    {
        $that =& $this->baseObject;
        if ($that->request->is_POST() && $this->_validateGlobalAttributeForm()) {
            $that->session->data['product_features_global_attribute_update_data'] = $that->request->post;
        }
    }

    public function onControllerPagesCatalogAttribute_UpdateData()
    {
        $that =& $this->baseObject;
        $am = new AAttribute_Manager('product_feature');
        $type_id = $am->getAttributeTypeID('product_feature');

        $that->data['tabs'][$type_id] = [
            'text' => 'dddd',
        ];

        if ((int) $that->request->get['attribute_type_id']
            && $that->request->get['attribute_type_id'] != $type_id
        ) {
            return;
        } elseif ((int) $that->request->get['attribute_id']) {
            $attr_info = $am->getAttribute((int) $that->request->get['attribute_id']);
            if ($attr_info['attribute_type_id'] != $type_id) {
                return;
            }
        } elseif (!(int) $that->request->get['attribute_id'] && !(int) $that->request->get['attribute_type_id']) {
            return;
        }

        if (isset($that->session->data['product_features_global_attribute_update_data'])) {
            /** @var ModelProductFeaturesProductFeatures $mdl */
            $mdl = $that->loadModel('product_features/product_features');
            $post = $that->session->data['product_features_global_attribute_update_data'];

            $type_info = $mdl->getGlobalAttributeTypeInfo();

            if ($type_info['attribute_type_id'] == $post['attribute_type_id']) {
                //update
                $mdl->updateGlobalProductFeature($that->request->get['attribute_id'], $post);
            } else {
                //remove
                $mdl->deleteProductFeatureByGlobalAttributeId($that->request->get['attribute_id']);
            }

            unset($that->session->data['product_features_global_attribute_update_data']);
        }

        $form = $that->data['form'];
        unset($form['fields']['attribute_parent']);
        $that->view->assign('form', $form);
    }

    protected function _validateGlobalAttributeForm()
    {
        $that =& $this->baseObject;
        if (!$that->user->canModify('catalog/attribute')) {
            return false;
        }

        if (mb_strlen($that->request->post['name']) < 2 || mb_strlen($that->request->post['name']) > 32) {
            return false;
        }

        if (!$that->request->post['attribute_type_id']) {
            return false;
        }
        if (!$that->request->post['element_type']) {
            return false;
        }

        if (!$that->request->post['required']) {
            $that->request->post['required'] = 0;
        }

        return true;
    }
}
