<?php
/** @noinspection PhpMultipleClassDeclarationsInspection */

if (!defined('DIR_CORE') || !IS_ADMIN) {
    header('Location: static_pages/');
}

/**
 * Class ControllerResponsesProductFeaturesFeatures
 *
 * @property ModelProductFeaturesProductFeatures $model_product_features_product_features
 */
class ControllerResponsesProductFeaturesFeatures extends AController
{

    /** @var AAttribute_Manager */
    protected $attribute_manager;

    public function get_features_list()
    {
        //init controller data
        $this->extensions->hk_InitData($this, __FUNCTION__);

        $this->loadModel('product_features/product_features');

        $features = $this->model_product_features_product_features->getProductFeatures(
            $this->request->get['product_id']
        );

        //update controller data
        $this->extensions->hk_UpdateData($this, __FUNCTION__);

        $this->load->library('json');
        $this->response->setOutput(AJson::encode($features));
    }

    public function remove_feature()
    {
        $this->loadLanguage('product_features/product_features');
        $this->loadModel('product_features/product_features');
        $this->model_product_features_product_features->deleteProductFeature(
            $this->request->get['feature_id']
        );
        $this->response->setOutput($this->language->get('text_feature_removed'));
    }

    public function update_feature()
    {
        $this->loadLanguage('product_features/product_features');
        $this->loadModel('product_features/product_features');
        $this->model_product_features_product_features->updateProductFeature(
            $this->request->get
        );

        $this->response->setOutput($this->language->get('text_success_feature'));
    }

    public function update_feature_values()
    {
        $this->loadLanguage('product_features/product_features');
        $this->loadModel('product_features/product_features');

        if (!($errors = $this->_validateProductFeatureValues($this->request->post))) {
            $this->model_product_features_product_features->updateProductFeatureValues(
                $this->request->get['product_id'],
                $this->request->get['feature_id'],
                $this->request->post
            );
        } else {
            $error = new AError('');
            $err_data = ['error_text' => implode('<br>', $errors)];
            $error->toJSONResponse('VALIDATION_ERROR_406', $err_data);
            return;
        }

        redirect(
            $this->html->getSecureURL(
                'product_features/features/load_feature',
                '&product_id='.$this->request->get['product_id'].
                '&feature_id='.$this->request->get['feature_id']
            )
        );
    }

    public function load_feature()
    {
        $this->loadLanguage('product_features/product_features');
        $this->loadModel('product_features/product_features');
        $feature_id = $this->request->get['feature_id'];

        $this->view->assign('success', $this->session->data['success']);
        unset($this->session->data['success']);

        $this->view->assign('warning', $this->session->data['warning']);
        unset($this->session->data['warning']);

        $this->data['language_id'] = $this->session->data['content_language_id'];

        $this->data['feature_data'] = $this->model_product_features_product_features->getProductFeature(
            $this->request->get['product_id'],
            $feature_id
        );

        $this->data['element_types'] = ['T', 'S'];
        $this->data['elements_with_options'] = HtmlElementFactory::getElementsWithOptions();
        $this->data['selectable'] =
            in_array($this->data['feature_data']['element_type'], $this->data['elements_with_options']) ? 1 : 0;

        $this->data['feature_type'] =
            $this->language->get('text_feature_type_'.$this->data['feature_data']['element_type']);

        $this->attribute_manager = new AAttribute_Manager();

        $this->data['update_attribute'] = $this->html->getSecureURL(
            'product_features/features/update_feature',
            '&product_id='.$this->request->get['product_id'].
            '&feature_id='.$feature_id
        );

        $this->data['feature_name'] = $this->html->buildElement(
            [
                'type'  => 'input',
                'name'  => 'name',
                'value' => $this->data['feature_data']['name'],
                'style' => 'medium-field',
            ]
        );
        $this->data['status'] = $this->html->buildElement(
            [
                'type'  => 'checkbox',
                'name'  => 'status',
                'value' => $this->data['feature_data']['status'],
                'style' => 'btn_switch btn-group-xs',
            ]
        );
        $this->data['feature_sort_order'] = $this->html->buildElement(
            [
                'type'  => 'input',
                'name'  => 'sort_order',
                'value' => $this->data['feature_data']['sort_order'],
                'style' => 'tiny-field',
            ]
        );

        $this->data['hidden_element_type'] = $this->html->buildElement(
            [
                'type'  => 'hidden',
                'name'  => 'element_type',
                'value' => $this->data['feature_data']['element_type'],
            ]
        );

        $this->data['button_remove_feature'] = $this->html->buildElement(
            [
                'type' => 'button',
                'href' => $this->html->getSecureURL(
                    'r/product_features/features/remove_feature', '&feature_id='.$feature_id
                ),
                'text' => $this->language->get('button_remove_feature'),
            ]
        );
        $this->data['button_save'] = $this->html->buildElement(
            [
                'type' => 'button',
                'text' => $this->language->get('button_save'),
            ]
        );
        $this->data['button_reset'] = $this->html->buildElement(
            [
                'type' => 'button',
                'text' => $this->language->get('button_reset'),
            ]
        );

        $this->data['update_feature_values'] = $this->html->getSecureURL(
            'product_features/features/update_feature_values',
            '&product_id='.$this->request->get['product_id']
            .'&feature_id='.$feature_id
        );

        $this->data['remove_feature_link'] = $this->html->getSecureURL(
            'product_features/features/remove_feature',
            '&product_id='.$this->request->get['product_id']
            .'&feature_id='.$feature_id
        );

        // form of option values list
        $form = new AForm('HT');
        $form->setForm(['form_name' => 'update_feature_values']);
        $this->data['form']['id'] = 'update_feature_values';
        $this->data['update_feature_values_form']['open'] = $form->getFieldHtml(
            [
                'type'   => 'form',
                'name'   => 'update_feature_values',
                'action' => $this->data['update_feature_values'],
            ]
        );

        //form of option
        $form = new AForm('HT');
        $form->setForm(
            [
                'form_name' => 'feature_value_form',
            ]
        );

        $this->data['form']['id'] = 'feature_value_form';
        $this->data['form']['form_open'] = $form->getFieldHtml(
            [
                'type'   => 'form',
                'name'   => 'feature_value_form',
                'action' => $this->data['update_feature_values'],
            ]
        );

        //Load option values rows
        $this->data['feature_values'] =
            $this->model_product_features_product_features->getProductFeatureValues($feature_id);

        foreach ($this->data['feature_values'] as $key => $item) {
            $this->data['feature_values'][$key]['row'] = $this->_feature_value_form($item, $form);
        }

        $this->data['new_feature_row'] = $this->_feature_value_form([], $form);

        $this->view->batchAssign($this->data);
        $this->processTemplate('responses/product_features/feature_values.tpl');
    }

    /**
     * @param array $item
     * @param AForm $form
     *
     * @return string
     * @throws AException
     */
    private function _feature_value_form($item, $form)
    {
        if (isset($item['product_feature_value_id'])) {
            $product_feature_value_id = $item['product_feature_value_id'];
            $this->data['row_id'] = 'row'.$product_feature_value_id;
            $this->data['product_feature_value_id'] = $product_feature_value_id;
        } else {
            $this->data['row_id'] = 'new_row';
        }

        $this->data['form']['fields']['product_feature_value_id'] = $form->getFieldHtml(
            [
                'type'  => 'hidden',
                'name'  => 'product_feature_value_id['.$product_feature_value_id.']',
                'value' => $product_feature_value_id,
            ]
        );

        $this->data['form']['fields']['product_feature_value'] = $form->getFieldHtml(
            [
                'type'     => 'input',
                'name'     => 'name['.$product_feature_value_id.']',
                'value'    => $item['language'][$this->language->getContentLanguageID()],
                'style'    => 'large-field',
                'required' => true,
            ]
        );

        if ($this->data['feature_data']['element_type'] == 'G') {
            $this->data['form']['fields']['sort_order'] = $form->getFieldHtml(
                [
                    'type'  => 'input',
                    'name'  => 'sort_order['.$product_feature_value_id.']',
                    'value' => $item['sort_order'],
                    'style' => 'small-field',
                ]
            );
        }

        $this->view->batchAssign($this->data);
        return $this->view->fetch('responses/product_features/feature_value_row.tpl');
    }

    protected function _validateProductFeatureValues($data = [])
    {
        $error = [];
        foreach ($data['product_feature_value_id'] as $f_val_id => $status) {
            if ($data['name'][$f_val_id] === '' || !has_value($data['name'][$f_val_id])) {
                $error[] = $this->language->get('text_value_name_required_error');
            }
        }
        return $error;
    }

    /**
     * method that return part of global attribute form
     *
     * @param array $params
     *
     * @throws AException
     * @internal param array $param
     */
    public function getProductFeatureSubform($params = [])
    {
        //init controller data
        $this->extensions->hk_InitData($this, __FUNCTION__);
        $this->loadLanguage('catalog/attribute');
        $this->loadLanguage('product_features/product_features');

        $this->data = array_merge($this->data, $params['data']);

        unset($this->data['form']['fields']); // remove form fields that do not needed here

        $this->data['elements_with_options'] = HtmlElementFactory::getElementsWithOptions();

        //$results = HtmlElementFactory::getAvailableElements();
        $element_types = ['' => $this->language->get('text_select')];
        $element_types['I'] = $this->language->get('text_feature_type_I');
        $element_types['G'] = $this->language->get('text_feature_type_G');

        /**
         * @var $form AForm
         */
        $form = $params['aform'];
        /**
         * @var $attribute_manager AAttribute_Manager
         */
        $attribute_manager = $params['attribute_manager'];
        $attributes_fields = [];

        $this->data['form']['fields']['element_type'] = $form->getFieldHtml(
            [
                'type'     => 'selectbox',
                'name'     => 'element_type',
                'value'    => $this->data['element_type'],
                'required' => true,
                'options'  => $element_types,
            ]
        );
        $this->data['form']['fields']['sort_order'] = $form->getFieldHtml(
            [
                'type'  => 'input',
                'name'  => 'sort_order',
                'value' => $this->data['sort_order'],
                'style' => 'small-field',
            ]
        );

        //Build attribute values part of the form
        if ($this->request->get['attribute_id']) {
            $this->data['child_count'] = $attribute_manager->totalChildren($this->request->get['attribute_id']);
            if ($this->data['child_count'] > 0) {
                $children_attr = $attribute_manager->getAttributes([], 0, $this->request->get['attribute_id']);
                foreach ($children_attr as $attr) {
                    $this->data['children'][] = [
                        'name' => $attr['name'],
                        'link' => $this->html->getSecureURL(
                            'catalog/attribute/update', '&attribute_id='.$attr['attribute_id']
                        ),
                    ];
                }
            }

            $attribute_values = $attribute_manager->getAttributeValues($this->request->get['attribute_id']);
            foreach ($attribute_values as $atr_val) {
                $atr_val_id = $atr_val['attribute_value_id'];
                $attributes_fields[$atr_val_id]['sort_order'] = $form->getFieldHtml(
                    [
                        'type'  => 'input',
                        'name'  => 'sort_orders['.$atr_val_id.']',
                        'value' => $atr_val['sort_order'],
                        'style' => 'small-field',
                    ]
                );
                $attributes_fields[$atr_val_id]['values'] = $form->getFieldHtml(
                    [
                        'type'  => 'input',
                        'name'  => 'values['.$atr_val_id.']',
                        'value' => $atr_val['value'],
                        'style' => 'medium-field',
                    ]
                );
                $attributes_fields[$atr_val_id]['attribute_value_ids'] = $form->getFieldHtml(
                    [
                        'type'  => 'hidden',
                        'name'  => 'attribute_value_ids['.$atr_val_id.']',
                        'value' => $atr_val_id,
                        'style' => 'medium-field',
                    ]
                );
            }
        }

        if (!$attributes_fields) {
            $attributes_fields[0]['sort_order'] = $form->getFieldHtml(
                [
                    'type'  => 'input',
                    'name'  => 'sort_orders[]',
                    'value' => '',
                    'style' => 'small-field no-save',
                ]
            );
            $attributes_fields[0]['values'] = $form->getFieldHtml(
                [
                    'type'  => 'input',
                    'name'  => 'values[]',
                    'value' => '',
                    'style' => 'medium-field no-save',
                ]
            );
            $attributes_fields[0]['attribute_value_ids'] = $form->getFieldHtml(
                [
                    'type'  => 'hidden',
                    'name'  => 'attribute_value_ids['.$atr_val_id.']',
                    'value' => 'new',
                    'style' => 'medium-field',
                ]
            );
        }

        $this->data['form']['attribute_values'] = $attributes_fields;

        $this->view->batchAssign($this->data);

        //update controller data
        $this->extensions->hk_UpdateData($this, __FUNCTION__);

        $this->processTemplate('responses/product_features/global_attribute_product_feature_subform.tpl');
    }
}