<?php

/** @noinspection PhpMultipleClassDeclarationsInspection */
if (!defined('DIR_CORE') || !IS_ADMIN) {
    header('Location: static_pages/');
}

/**
 * Class ControllerPagesCatalogProductFeatures
 *
 * @property ModelProductFeaturesProductFeatures $model_product_features_product_features
 */
class ControllerPagesCatalogProductFeatures extends AController
{
    /** @var AAttribute_Manager */
    protected $attribute_manager;
    public $error = [];

    public function __construct($registry, $instance_id, $controller, $parent_controller = '')
    {
        parent::__construct($registry, $instance_id, $controller, $parent_controller);
        $this->attribute_manager = new AAttribute_Manager();
    }

    public function main()
    {
        $this->loadLanguage('product_features/product_features');
        $this->loadLanguage('catalog/product');
        $this->loadModel('product_features/product_features');
        $this->loadModel('catalog/product');

        if ($this->request->is_POST() && $this->_validateForm()) {
            $this->model_product_features_product_features->addProductFeature(
                $this->request->get['product_id'],
                $this->request->post
            );
            $this->session->data['success'] = $this->language->get('text_success');
            redirect(
                $this->html->getSecureURL(
                    'catalog/product_features',
                    '&product_id='.$this->request->get['product_id']
                )
            );
        }

        $this->document->setTitle($this->language->get('heading_title'));
        $this->data['product_description'] = $this->model_catalog_product->getProductDescriptions(
            $this->request->get['product_id']
        );
        $this->data['heading_title'] = $this->language->get('text_edit').'&nbsp;'.$this->language->get('text_product');

        $this->view->assign('error', $this->error);
        $this->view->assign('success', $this->session->data['success']);
        if (isset($this->session->data['success'])) {
            unset($this->session->data['success']);
        }

        $this->document->initBreadcrumb(
            [
                'href'      => $this->html->getSecureURL('index/home'),
                'text'      => $this->language->get('text_home'),
                'separator' => false,
            ]
        );
        $this->document->addBreadcrumb(
            [
                'href'      => $this->html->getSecureURL('catalog/product'),
                'text'      => $this->language->get('heading_title'),
                'separator' => ' :: ',
            ]
        );
        $this->document->addBreadcrumb(
            [
                'href'      => $this->html->getSecureURL(
                    'catalog/product/update',
                    '&product_id='.$this->request->get['product_id']
                ),
                'text'      => $this->language->get('text_edit')
                    .'&nbsp;'.$this->language->get('text_product')
                    .' - '.$this->data['product_description'][$this->language->getContentLanguageID()]['name'],
                'separator' => ' :: ',
            ]
        );
        $this->document->addBreadcrumb(
            [
                'href'      => $this->html->getSecureURL(
                    'catalog/product_features',
                    '&product_id='.$this->request->get['product_id']
                ),
                'text'      => $this->language->get('product_features_name'),
                'separator' => ' :: ',
                'current'   => true,
            ]
        );

        $this->data['language_id'] = $this->session->data['content_language_id'];

        //load tabs controller
        $this->data['active'] = 'product_features';
        $tabs_obj = $this->dispatch('pages/catalog/product_tabs', [$this->data]);
        $this->data['product_tabs'] = $tabs_obj->dispatchGetOutput();
        unset($tabs_obj);

        $element_types = ['' => $this->language->get('text_select')];
        $element_types['I'] = $this->language->get('text_feature_type_I');
        $element_types['G'] = $this->language->get('text_feature_type_G');

        $this->data['features'] = [
            'new' => $this->language->get('text_add_new_feature'),
        ];

        $results = $this->attribute_manager->getAttributes(
            [
                'attribute_type_id' => $this->attribute_manager->getAttributeTypeID('product_feature'),
                'search'            => "ga.status = 1 AND ga.attribute_parent_id = 0 ",
                'limit'             => 100,
            ],
            $this->session->data['content_language_id']
        );

        foreach ($results as $type) {
            $this->data['features'][$type['attribute_id']] = $type['name'];
        }

        $this->data['product_features'] = $this->model_product_features_product_features->getProductFeatures(
            $this->request->get['product_id']
        );

        $this->data['button_add_option'] = $this->html->buildButton(
            [
                'text'  => $this->language->get('button_add_feature'),
                'style' => 'button1',
            ]
        );
        $this->data['button_add_option_value'] = $this->html->buildButton(
            [
                'text'  => $this->language->get('button_add_feature_value'),
                'style' => 'button1',
            ]
        );
        $this->data['button_remove'] = $this->html->buildButton(
            [
                'text'  => $this->language->get('button_remove'),
                'style' => 'button1',
            ]
        );
        $this->data['button_reset'] = $this->html->buildButton(
            [
                'text'  => $this->language->get('button_reset'),
                'style' => 'button2',
            ]
        );

        $form = new AForm('HT');

        $form->setForm(
            [
                'form_name' => 'new_feature_form',
                'update'    => '',
            ]
        );
        $this->data['attributes'] = $form->getFieldHtml(
            [
                'type'    => 'selectbox',
                'name'    => 'attribute_id',
                'options' => $this->data['features'],
                'style'   => 'chosen',
            ]
        );
        $this->data['feature_name'] = $form->getFieldHtml(
            [
                'type'     => 'input',
                'name'     => 'name',
                'required' => true,
            ]
        );
        $this->data['status'] = $form->getFieldHtml(
            [
                'type'  => 'checkbox',
                'name'  => 'status',
                'value' => 1,
                'style' => 'btn_switch',
            ]
        );
        $this->data['sort_order'] = $form->getFieldHtml(
            [
                'type'  => 'input',
                'name'  => 'sort_order',
                'style' => 'small-field',
            ]
        );
        $this->data['element_type'] = $form->getFieldHtml(
            [
                'type'     => 'selectbox',
                'name'     => 'element_type',
                'required' => true,
                'options'  => $element_types,
            ]
        );

        $product_feat = [];
        foreach ($this->data['product_features'] as $feature) {
            $product_feat[$feature['product_feature_id']] = $feature['name'];
        }

        $this->data['features_select'] = $form->getFieldHtml(
            [
                'type'    => 'selectbox',
                'name'    => 'feature',
                'value'   => $this->data['product_feature_id'],
                'options' => $product_feat,
            ]
        );

        $this->data['action'] = $this->html->getSecureURL(
            'catalog/product_features',
            '&product_id='.$this->request->get['product_id']
        );

        $this->data['form_title'] = $this->language->get('text_edit').'&nbsp;'.$this->language->get('text_product');
        $this->data['update'] = '';
        $form = new AForm('HT');

        $form->setForm(
            [
                'form_name' => 'feature_form',
                'update'    => $this->data['update'],
            ]
        );

        $this->data['form']['id'] = 'feature_form';
        $this->data['form']['form_open'] = $form->getFieldHtml(
            [
                'type'   => 'form',
                'name'   => 'feature_form',
                'action' => $this->data['action'],
            ]
        );
        $this->data['form']['submit'] = $form->getFieldHtml(
            [
                'type'  => 'button',
                'name'  => 'submit',
                'text'  => $this->language->get('button_add_feature'),
                'style' => 'button1',
            ]
        );
        $this->data['form']['cancel'] = $form->getFieldHtml(
            [
                'type'  => 'button',
                'name'  => 'cancel',
                'text'  => $this->language->get('button_cancel'),
                'style' => 'button2',
            ]
        );

        $this->data['urls']['get_features_list'] = $this->html->getSecureURL(
            'product_features/features/get_features_list',
            '&product_id='.$this->request->get['product_id']
        );
        $this->data['urls']['load_feature'] = $this->html->getSecureURL(
            'product_features/features/load_feature',
            '&product_id='.$this->request->get['product_id']
        );
        $this->data['urls']['update_feature'] = $this->html->getSecureURL(
            'product_features/features/update_feature',
            '&product_id='.$this->request->get['product_id']
        );

        $this->addChild('pages/catalog/product_summary', 'summary_form', 'pages/catalog/product_summary.tpl');

        $this->view->assign('form_language_switch', $this->html->getContentLanguageSwitcher());
        $this->view->batchAssign($this->data);
        $this->processTemplate('pages/product_features/product_features_form.tpl');
    }

    protected function _validateForm()
    {
        if (!$this->user->hasPermission('modify', 'catalog/product_features')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }
        $this->extensions->hk_ValidateData($this);
        return (!$this->error);
    }

}