<?php

/* Hooks */
if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

if (!IS_ADMIN) {
    class ExtensionProductBadges extends Extension
    {
        public $data = array();

        private $registry;

        public function __construct()
        {
            $this->registry = Registry::getInstance();
        }

        public function __get($key)
        {
            return $this->registry->get($key);
        }

        public function superclass($data)
        {
            $this->baseObject->load->model('catalog/product');
            //do something with data update
            //$this->baseObject->log->write(print_r($data['products'],true).'====$data[products]');

            if (is_array($data['products']) and count($data['products'])) {
                foreach ($data['products'] as $key => $result) {
                    $alldata = $this->baseObject->model_catalog_product->getProductDataForCart($result['product_id']);
                    $product_info = $this->baseObject->model_catalog_product->getProduct($result['product_id']);
                    //$this->baseObject->log->write(print_r($alldata, true).'+++++$alldata');
                    //$this->baseObject->log->write(print_r($result, true).'+++++$alldata');
                    $rating = $data['products'][$key]['rating'];
                    $model = $data['products'][$key]['model'];
                    $special = $data['products'][$key]['special']; //$9.57 for number        $allproductsdata[$result['product_id']]['special']  9.57
                    $track_stock = $data['products'][$key]['track_stock']; // 1
                    $in_stock = $data['products'][$key]['in_stock']; // 1

                    $stock_statuses = unserialize($this->baseObject->config->get('product_badges_badge_stock_status_id'));
                    if ($alldata['stock_status_id'] > 0) {
                        //and (in_array($alldata['stock_status_id'], (array) $stock_statuses) || empty($stock_statuses))
                        //pre-order
                        $no_stock_text = $product_info['stock_status'];
                    } else {
                        $no_stock_text = $data['products'][$key]['no_stock_text']; // generic text
                    }

                    $total_quantity = $data['products'][$key]['total_quantity']; // 12
                    $allproductsdata = $this->baseObject->model_catalog_product->getProductsAllInfo(array($result['product_id']));

                    /*NEW BADGE*/
                    if ('1' == $this->baseObject->config->get('product_badges_badge_new')) {
                        $now = time();
                        if ('1' == $this->baseObject->config->get('product_badges_badge_new_type')) {
                            $your_date = strtotime($alldata['date_added']);
                            $datediff = $now - $your_date;
                            $diffdays = floor($datediff / (60 * 60 * 24));
                        } else {
                            $your_date = strtotime($alldata['date_modified']);
                            $datediff = $now - $your_date;
                            $diffdays = floor($datediff / (60 * 60 * 24));
                        }
                        if ($diffdays <= (int) $this->baseObject->config->get('product_badges_badge_new_days')) {
                            $data['products'][$key]['newproduct'] = '1';
                        }
                    }

                    /*SPECIAL BADGE*/
                    if ($special and '1' == $this->baseObject->config->get('product_badges_badge_special')) {
                        $percent = round((100 * $allproductsdata[$result['product_id']]['special']) / $alldata['price']) - 100;
                        if ('1' == $this->baseObject->config->get('product_badges_badge_special_percent')) {
                            if ('1' == $this->baseObject->config->get('product_badges_badge_special_percentandtext')) {
                                $data['products'][$key]['specialpercent'] = ''.$percent.'% '.html_entity_decode($this->baseObject->config->get('product_badges_badge_special_text'));
                            } else {
                                $data['products'][$key]['specialpercent'] = ''.$percent.'%';
                            }
                        } else {
                            $data['products'][$key]['specialpercent'] = html_entity_decode($this->baseObject->config->get('product_badges_badge_special_text'));
                        }
                    }
                    /*OPTIONS AVAILABLE BADGE*/
                    if (is_array($allproductsdata[$result['product_id']]['options'])) {
                        $data['products'][$key]['attributes'] = '1';
                    }

                    /*PREORDER BADGE*/
                    //$this->baseObject->log->write(print_r($this->baseObject->config->get('product_badges_badge_stock_status_id'), true).' $paramName');

                    //$this->baseObject->log->write(print_r($stock_statuses, true).' $stock_statuses');
                    //$this->baseObject->log->write(print_r($alldata['stock_status_id'], true).' alldata stock id');
                    if ($track_stock and $total_quantity <= 0 and (in_array($alldata['stock_status_id'], (array) $stock_statuses) || empty($stock_statuses))) {
                        $data['products'][$key]['stockpreorder'] = '1';
                    }

                    /*LOW STOCK BADGE*/
                    if ($track_stock and $in_stock and $total_quantity <= $this->baseObject->config->get('product_badges_badge_lowstock_number')) {
                        if ('1' == $this->baseObject->config->get('product_badges_badge_lowstock_show')) {
                            $data['products'][$key]['lowinstock'] = $total_quantity.' '.html_entity_decode($this->baseObject->config->get('product_badges_badge_lowstock_text'));
                        } else {
                            //$data['products'][$key]['lowinstock'] = html_entity_decode($this->baseObject->config->get('product_badges_badge_lowstock_text'));
                        }
                    }

                    /*NEW PRODUCT BADGE*/
                    $class = '<ul class="product-flags">';
                    if ('1' == $this->baseObject->config->get('product_badges_badge_new') and $data['products'][$key]['newproduct']) {
                        $class .= '<li class="nova">'.html_entity_decode($this->baseObject->config->get('product_badges_badge_new_text')).'</li>';
                    }
                    /*SPECIALS BADGE*/
                    if ($allproductsdata[$result['product_id']]['special'] and '1' == $this->baseObject->config->get('product_badges_badge_special')) {
                        $class .= '<li class="discount-percentage">'.$data['products'][$key]['specialpercent'].'</li>';
                    }

                    /*OPTIONS AVAILABLE BADGE*/
                    if ($data['products'][$key]['attributes'] and '1' == $this->baseObject->config->get('product_badges_badge_attributes')) {
                        $class .= '<li class="optionsbadge">'.html_entity_decode($this->baseObject->config->get('product_badges_badge_attributes_text')).'</li>';
                    }

                    /*PREORDER BADGE*/
                    if ($data['products'][$key]['stockpreorder'] and '1' == $this->baseObject->config->get('product_badges_badge_preorder')) {
                        $class .= '<li class="preorder">'.html_entity_decode($no_stock_text).'</li>';
                    }

                    /*LOW STOCK BADGE*/
                    if ($data['products'][$key]['lowinstock']) {
                        $class .= '<li class="lowinstock">'.$data['products'][$key]['lowinstock'].'</li>';
                    }

                    /*FREE SHIPPING BADGE*/
                    if ($alldata['free_shipping'] and $alldata['shipping']) {
                        $class .= '<li class="freeshipping">'.html_entity_decode($this->baseObject->config->get('product_badges_badge_freeshipping_text')).'</li>';
                    }

                    /*MODEL BADGE*/
                    if ($alldata['model'] and '1' == $this->baseObject->config->get('product_badges_badge_modelskulocation')) {
                        if (!empty($alldata['model'])) {
                            $datamodel = $alldata['model'];
                        }

                        if (strlen($datamodel) > 1 and strlen($this->baseObject->config->get('product_badges_badge_modelskulocation_matchtext')) < 1) {
                            if (strlen($this->baseObject->config->get('product_badges_badge_modelskulocation_customtext')) > 1) {
                                $class .= '<li class="model">'.html_entity_decode($this->baseObject->config->get('product_badges_badge_modelskulocation_customtext')).'</li>';
                            } else {
                                $class .= '<li class="model">'.html_entity_decode($datamodel).'</li>';
                            }
                        } elseif (strlen($datamodel) > 1 and strlen($this->baseObject->config->get('product_badges_badge_modelskulocation_matchtext')) > 1
              and (false !== strpos($datamodel, $this->baseObject->config->get('product_badges_badge_modelskulocation_matchtext')))) {
                            if (strlen($this->baseObject->config->get('product_badges_badge_modelskulocation_customtext')) > 1) {
                                $class .= '<li class="model">'.html_entity_decode($this->baseObject->config->get('product_badges_badge_modelskulocation_customtext')).'</li>';
                            } else {
                                $class .= '<li class="model">'.html_entity_decode($datamodel).'</li>';
                            }
                        }
                    }

                    /*SKU BADGE*/
                    $conf_data_sku = unserialize($this->baseObject->config->get('product_badges_badge_sku_location_multiconfig_sku'));
                    $sku_type_count = 0;
                    if ($conf_data_sku) {
                        foreach ($conf_data_sku as $v) {
                            if (array_key_exists('on', $v) and $v['on'] > 0) {
                                ++$sku_type_count;
                            }
                        }
                    }
                    //$this->baseObject->log->write(print_r($conf_data_sku, true).'data');
                    //$this->baseObject->log->write(print_r($sku_type_count, true).'output');

                    if (($alldata['sku']) and '1' == $this->baseObject->config->get('product_badges_badge_modelskulocation_sku')) {
                        if (!empty($alldata['sku'])) {
                            $datamodelsku = $alldata['sku'];
                        }

                        if (strlen($datamodelsku) > 1 and $sku_type_count < 1) {
                            $class .= '<li class="sku">'.html_entity_decode($datamodelsku).'</li>';
                        } elseif (strlen($datamodelsku) > 1 and $sku_type_count > 0) {
                            foreach ($conf_data_sku as $value) {
                                if ($value['on'] > 0 and $value['match']) {
                                    if (false !== strpos($datamodelsku, $value['match'])) {
                                        if (strlen($value['custom']) > 1) {
                                            $class .= '<li class="sku" style="background-color:#'.$value['color'].'">'.html_entity_decode($value['custom']).'</li>';
                                        } else {
                                            $class .= '<li class="sku" style="background-color:#'.$value['color'].'">'.html_entity_decode($datamodelsku).'</li>';
                                        }
                                    }
                                }
                            }
                        }
                    }

                    /*LOCATION BADGE*/
                    $conf_data_location = unserialize($this->baseObject->config->get('product_badges_badge_sku_location_multiconfig_location'));
                    $location_type_count = 0;
                    if ($conf_data_location) {
                        foreach ($conf_data_location as $v) {
                            if (array_key_exists('on', $v) and $v['on'] > 0) {
                                ++$location_type_count;
                            }
                        }
                    }
                    //$this->baseObject->log->write(print_r($conf_data_location, true).'data');
                    //$this->baseObject->log->write(print_r($sku_type_count, true).'output');

                    if (($alldata['location']) and '1' == $this->baseObject->config->get('product_badges_badge_modelskulocation_location')) {
                        if (!empty($alldata['location'])) {
                            $datamodellocat = $alldata['location'];
                        }

                        if (strlen($datamodellocat) > 1 and $location_type_count < 1) {
                            $class .= '<li class="location">'.html_entity_decode($datamodellocat).'</li>';
                        } elseif (strlen($datamodellocat) > 1 and $location_type_count > 0) {
                            foreach ($conf_data_location as $value) {
                                if ($value['on'] > 0 and $value['match']) {
                                    if (false !== strpos($datamodellocat, $value['match'])) {
                                        if (strlen($value['custom']) > 1) {
                                            $class .= '<li class="location" style="background-color:#'.$value['color'].'">'.html_entity_decode($value['custom']).'</li>';
                                        } else {
                                            $class .= '<li class="location" style="background-color:#'.$value['color'].'">'.html_entity_decode($datamodellocat).'</li>';
                                        }
                                    }
                                }
                            }
                        }
                    }

                    $class .= '</ul>';
                    if ('1' == $this->baseObject->config->get('product_badges_hook_mode') and is_array($data['products'])) {
                    } else {
                        $class .= '<img class="product'.$result['product_id'].'" src';
                        $new_img_html = preg_replace('/<img src/', $class, $result['thumb']['thumb_html'], 1);
                        $data['products'][$key]['thumb']['thumb_html'] = $new_img_html;
                    }

                    $data['products'][$key]['badges'] = $class;
                    //$this->baseObject->log->write(print_r($data['products'][$key],true).'====$result[thumb]');
                }
            }

            return $data;
        }

        public function onControllerBlocksListingBlock_UpdateData()   //data block work only HOOKMODE OFF
        {
            //$this->baseObject->log->write('run0listin');
            if ('1' == $this->baseObject->config->get('product_badges_listing_status_blocklist')) {
                $view = new AView($this->registry, 0);
                // get all data from the Controller
                $data = $this->baseObject->view->getData();
                $data = $this->superclass($data);

                if ('1' == $this->baseObject->config->get('product_badges_hook_mode') and is_array($data['products'])) {
                    foreach ($data['products'] as $key => $result) {
                        //attach to listing by product id
                        $this->baseObject->view->addHookVar('product_listing_details0_'.$result['product_id'], $result['badges']);
                        //$this->baseObject->view->addHookVar('product_listing_details11_'.$result['product_id'], '<div style="position: absolute; top: 0px; left: -60px;">'.$result['badges'].'</div>');
                    }
                } else {
                    //put in controller new $data['products'] array
                    $this->baseObject->view->assign('products', $data['products']);
                }
            }
        }

        public function onControllerPagesProductManufacturer_UpdateData()   //manufacturers
        {
            if ('1' == $this->baseObject->config->get('product_badges_listing_status_manufacturer')) {
                $view = new AView($this->registry, 0);
                // get all data from the Controller
                $data = $this->baseObject->view->getData();
                $data = $this->superclass($data);

                if ('1' == $this->baseObject->config->get('product_badges_hook_mode') and is_array($data['products'])) {
                    foreach ($data['products'] as $key => $result) {
                        //attach to listing by product id
                        $this->baseObject->view->addHookVar('product_listing_details0_'.$result['product_id'], $result['badges']);
                        //$this->baseObject->view->addHookVar('product_listing_details11_'.$result['product_id'], '<div style="position: absolute; top: 0px; left: -60px;">'.$result['badges'].'</div>');
                    }
                } else {
                    //put in controller new $data['products'] array
                    $this->baseObject->view->assign('products', $data['products']);
                }
            }
        }

        public function onControllerPagesProductCategory_UpdateData()
        {
            if ('1' == $this->baseObject->config->get('product_badges_listing_status_category')) {
                $view = new AView($this->registry, 0);
                // get all data from the Controller
                $data = $this->baseObject->view->getData();
                $data = $this->superclass($data);
                if ('1' == $this->baseObject->config->get('product_badges_hook_mode') and is_array($data['products'])) {
                    foreach ($data['products'] as $key => $result) {
                        //attach to listing by product id
                        $this->baseObject->view->addHookVar('product_listing_details0_'.$result['product_id'], $result['badges']);
                        //$this->baseObject->view->addHookVar('product_listing_details11_'.$result['product_id'], '<div style="position: absolute; top: 0px; left: -60px;">'.$result['badges'].'</div>');
                    }
                } else {
                    //put in controller new $data['products'] array
                    $this->baseObject->view->assign('products', $data['products']);
                }
            }
        }

        public function onControllerPagesProductSearch_UpdateData()   //BlocksFeatured
        {
            if ('1' == $this->baseObject->config->get('product_badges_listing_status_search')) {
                $view = new AView($this->registry, 0);
                // get all data from the Controller
                $data = $this->baseObject->view->getData();
                $data = $this->superclass($data);
                if ('1' == $this->baseObject->config->get('product_badges_hook_mode') and is_array($data['products'])) {
                    foreach ($data['products'] as $key => $result) {
                        //attach to listing by product id
                        $this->baseObject->view->addHookVar('product_listing_details0_'.$result['product_id'], $result['badges']);
                        //$this->baseObject->view->addHookVar('product_listing_details11_'.$result['product_id'], '<div style="position: absolute; top: 0px; left: -60px;">'.$result['badges'].'</div>');
                    }
                } else {
                    //put in controller new $data['products'] array
                    $this->baseObject->view->assign('products', $data['products']);
                }
            }
        }

        public function onControllerPagesProductSpecial_UpdateData()   // special
        {
            if ('1' == $this->baseObject->config->get('product_badges_listing_status_special')) {
                $view = new AView($this->registry, 0);
                // get all data from the Controller
                $data = $this->baseObject->view->getData();
                $data = $this->superclass($data);
                if ('1' == $this->baseObject->config->get('product_badges_hook_mode') and is_array($data['products'])) {
                    foreach ($data['products'] as $key => $result) {
                        //attach to listing by product id
                        $this->baseObject->view->addHookVar('product_listing_details0_'.$result['product_id'], $result['badges']);
                        //$this->baseObject->view->addHookVar('product_listing_details11_'.$result['product_id'], '<div style="position: absolute; top: 0px; left: -60px;">'.$result['badges'].'</div>');
                    }
                } else {
                    //put in controller new $data['products'] array
                    $this->baseObject->view->assign('products', $data['products']);
                }
            }
        }

        public function onControllerBlocksfeatured_UpdateData()   // special
        {
            if ('1' == $this->baseObject->config->get('product_badges_listing_status_featured')) {
                $view = new AView($this->registry, 0);
                // get all data from the Controller
                $data = $this->baseObject->view->getData();
                $data = $this->superclass($data);
                if ('1' == $this->baseObject->config->get('product_badges_hook_mode') and is_array($data['products'])) {
                    foreach ($data['products'] as $key => $result) {
                        //attach to listing by product id
                        $this->baseObject->view->addHookVar('product_price_hook_var_'.$result['product_id'], $result['badges']);
                        //$this->baseObject->view->addHookVar('product_listing_details0_'.$result['product_id'], $result['badges']);
                    }
                } else {
                    //put in controller new $data['products'] array
                    $this->baseObject->view->assign('products', $data['products']);
                }
            }
        }

        public function onControllerBlocksBestSeller_UpdateData()   // special
        {
            if ('1' == $this->baseObject->config->get('product_badges_listing_status_bestsellers')) {
                $view = new AView($this->registry, 0);
                // get all data from the Controller
                $data = $this->baseObject->view->getData();
                $data = $this->superclass($data);
                if ('1' == $this->baseObject->config->get('product_badges_hook_mode') and is_array($data['products'])) {
                    foreach ($data['products'] as $key => $result) {
                        //attach to listing by product id
                        $this->baseObject->view->addHookVar('product_price_hook_var_'.$result['product_id'], $result['badges']);
                        //$this->baseObject->view->addHookVar('product_listing_details0_'.$result['product_id'], $result['badges']);
                    }
                } else {
                    //put in controller new $data['products'] array
                    $this->baseObject->view->assign('products', $data['products']);
                }
            }
        }

        public function onControllerBlocksSpecial_UpdateData()   // special
        {
            if ('1' == $this->baseObject->config->get('product_badges_listing_status_special2')) {
                $view = new AView($this->registry, 0);
                // get all data from the Controller
                $data = $this->baseObject->view->getData();
                $data = $this->superclass($data);
                if ('1' == $this->baseObject->config->get('product_badges_hook_mode') and is_array($data['products'])) {
                    foreach ($data['products'] as $key => $result) {
                        //attach to listing by product id
                        $this->baseObject->view->addHookVar('product_price_hook_var_'.$result['product_id'], $result['badges']);
                        //$this->baseObject->view->addHookVar('product_listing_details0_'.$result['product_id'], $result['badges']);
                    }
                } else {
                    //put in controller new $data['products'] array
                    $this->baseObject->view->assign('products', $data['products']);
                }
            }
        }

        public function onControllerBlocksLatest_UpdateData()   // special
        {
            if ('1' == $this->baseObject->config->get('product_badges_listing_status_featured')) {
                $view = new AView($this->registry, 0);
                // get all data from the Controller
                $data = $this->baseObject->view->getData();
                $data = $this->superclass($data);
                if ('1' == $this->baseObject->config->get('product_badges_hook_mode') and is_array($data['products'])) {
                    foreach ($data['products'] as $key => $result) {
                        //attach to listing by product id
                        $this->baseObject->view->addHookVar('product_price_hook_var_'.$result['product_id'], $result['badges']);
                        //$this->baseObject->view->addHookVar('product_listing_details0_'.$result['product_id'], $result['badges']);
                    }
                } else {
                    //put in controller new $data['products'] array
                    $this->baseObject->view->assign('products', $data['products']);
                }
            }
        }

        // themes support
    //if($this->config->get('config_storefront_template') == 'monnika_template'){
      public function onControllerHomeTripleFeaturedHomeTripleFeatured_UpdateData()   // special
      {
          if ('1' == $this->baseObject->config->get('product_badges_listing_status_featured')) {
              $view = new AView($this->registry, 0);
              // get all data from the Controller
              $data = $this->baseObject->view->getData();
              $data = $this->superclass($data);
              if ('1' == $this->baseObject->config->get('product_badges_hook_mode') and is_array($data['products'])) {
                  foreach ($data['products'] as $key => $result) {
                      //attach to listing by product id
                      $this->baseObject->view->addHookVar('product_price_hook_var_'.$result['product_id'], $result['badges']);
                      //$this->baseObject->view->addHookVar('product_listing_details0_'.$result['product_id'], $result['badges']);
                  }
              } else {
                  //put in controller new $data['products'] array
                  $this->baseObject->view->assign('products', $data['products']);
              }
          }
      }

        //}

        //also purchased extension
    //onControllerBlocksListingBlock_UpdateData
    public function onControllerAlsoPurchasedAlsoPurchased_UpdateData()   // also purchased
    {
        //$this->baseObject->log->write('run1');
        if ('1' == $this->baseObject->config->get('product_badges_listing_status_featured')) {
            $view = new AView($this->registry, 0);
            // get all data from the Controller
            $data = $this->baseObject->view->getData();
            $data = $this->superclass($data);
            if ('1' == $this->baseObject->config->get('product_badges_hook_mode') and is_array($data['products'])) {
                foreach ($data['products'] as $key => $result) {
                    //attach to listing by product id
                    $this->baseObject->view->addHookVar('product_price_hook_var_'.$result['product_id'], $result['badges']);
                    //$this->baseObject->view->addHookVar('product_listing_details0_'.$result['product_id'], $result['badges']);
                }
            } else {
                //put in controller new $data['products'] array
                $this->baseObject->view->assign('products', $data['products']);
            }
            //$this->baseObject->log->write(print_r($data['products'], true).'data after');
        }
    }

        public function onControllerTopSellingTopSelling_UpdateData()   // also purchased
        {
            //$this->baseObject->log->write('run1');
            if ('1' == $this->baseObject->config->get('product_badges_listing_status_featured')) {
                $view = new AView($this->registry, 0);
                // get all data from the Controller
                $data = $this->baseObject->view->getData();
                $data = $this->superclass($data);
                if ('1' == $this->baseObject->config->get('product_badges_hook_mode') and is_array($data['products'])) {
                    foreach ($data['products'] as $key => $result) {
                        //attach to listing by product id
                        $this->baseObject->view->addHookVar('product_price_hook_var_'.$result['product_id'], $result['badges']);
                        //$this->baseObject->view->addHookVar('product_listing_details0_'.$result['product_id'], $result['badges']);
                    }
                } else {
                    //put in controller new $data['products'] array
                    $this->baseObject->view->assign('products', $data['products']);
                }
                //$this->baseObject->log->write(print_r($data['products'], true).'data after');
            }
        }

        /*public function onControllerCommonFooter_UpdateData()
        {
            //$this->baseObject->view->addHookVar($hooks, $view->fetch('common/footer.pre.tpl'));
            $this->processTemplate('common/footer.pre.tpl');
        }*/
    }
} //end is admin
