<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2023 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

/**
 * Class ControllerResponsesListingGridPirateShipIntegrationExport
 * @property ModelExtensionPirateShipIntegration $model_extension_pirateship_integration
 * @property ModelLocalisationOrderStatus $model_localisation_order_status
 * @property ModelLocalisationZone $model_localisation_zone
 */

class ControllerResponsesListingGridPirateShipIntegrationExport extends AController {
    public $error = [];
    public $data = [];

    public function main() {
        //init controller data
        $this->extensions->hk_InitData($this, __FUNCTION__);

        $this->loadLanguage('pirateship_integration/pirateship_integration');
        $this->loadModel('extension/pirateship_integration');
        $this->loadModel('localisation/order_status');
        $this->loadModel('localisation/zone');
        $this->loadModel('localisation/country');
        $this->loadModel('extension/pirateship_integration');
        $this->loadModel('sale/order');

        //Prepare filter config
        $filter_params = ['order_status_id','order_from','order_to','shipped_status'];
        $grid_filter_params = ['order_id','order_from','order_to'];

        $filter_form = new AFilter(['method' => 'get', 'filter_params' => $filter_params]);
        $filter_grid = new AFilter(['method' => 'post', 'grid_filter_params' => $grid_filter_params]);
        $data = array_merge($filter_form->getFilterData(), $filter_grid->getFilterData());

        $total = $this->model_extension_pirateship_integration->getTotalOrders($data);
        $response = new stdClass();
        $response->page = $filter_grid->getParam('page');
        $response->total = $filter_grid->calcTotalPages($total);
        $response->records = $total;
        $response->userdata = new stdClass();
        $response->userdata->classes = [];
        $results = $this->model_extension_pirateship_integration->getOrders($data);

        $i = 0;
        foreach ($results as $result) {
            $shipped_status = empty($result['shipped']) ? '0' : $result['shipped'];
            if (isset($data['filter']['shipped_status']) && $shipped_status !== $data['filter']['shipped_status'] && $data['filter']['shipped_status']!=='all') {
                continue;
            }
            $zone_id = $result['shipping_zone_id'];
            $zones= $this->model_localisation_zone->getZone($zone_id);
            $zone = $zones['code'];

            $country_id = $result['shipping_country_id'];
            $countries= $this->model_localisation_country->getCountry($country_id);
            $country = $countries['iso_code_2'];

            if ($result['shipping_address_2']) {
                $address = $result['shipping_address_1'].'<br>'.$result['shipping_address_2'].'<br>'.$result['shipping_city'].'<br>'.$zone.'<br>'.$result['shipping_postcode'].'<br>'.$country;
            } else {
                $address = $result['shipping_address_1'].'<br>'.$result['shipping_city'].'<br>'.$zone.'<br>'.$result['shipping_postcode'].'<br>'.$country;
            }

            $response->rows[$i]['cell'] = [
                $result['order_id'],
                date_format(date_create($result['date_added']),'m/d/Y'),
                $result['name'],
                $result['email'],
                $result['shipping_company'],
                $address,
                $result['shipping_method'],
                $result['status'],
                $result['shipped'] === '1' ? $this->language->get('text_yes'): $this->language->get('text_no'),
                $result['tracking_number'],
            ];
            $i++;
        }

        $this->data['response'] = $response;
        //update controller data
        $this->extensions->hk_UpdateData($this, __FUNCTION__);
        $this->load->library('json');
        $this->response->setOutput(AJson::encode($this->data['response']));
    }

}