<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2023 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

require_once DIR_EXT.'pirateship_integration'.DIR_EXT_CORE.'lib/vendor/autoload.php';

use PhpOffice\PhpSpreadsheet\Spreadsheet;

/**
 * ControllerResponsesExtensionPirateShipIntegrationExport
 * @property ModelSaleOrder $model_sale_order
 * @property ModelExtensionPirateShipIntegration $model_extension_pirateship_integration
 */

class ControllerResponsesExtensionPirateShipIntegrationExport extends AController {
    private $error = [];

    public function main() {
        $this->load->model('extension/pirateship_integration');
        $this->load->model('sale/order');
        $this->load->model('localisation/country');
        $this->load->model('localisation/zone');

        $data = $this->request->get;
        if ($data['order_from']) {
            $data['filter']['order_from'] = $data['order_from'];
        }

        if ($data['order_to']) {
            $data['filter']['order_to'] = $data['order_to'];
        }

        if ($data['order_status_id']) {
            $data['filter']['order_status_id'] = $data['order_status_id'];
        }

        $spreadsheet = new Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();

        $headerColName = [
            'Order ID',
            'Order Date',
            'Full Name',
            'Email',
            'Company',
            'Address 1',
            'Address 2',
            'City',
            'State',
            'Zipcode',
            'Country',
            'Weight',
            'Length',
            'Width',
            'Height',
            'Shipping Method'
        ];

        $styleArray = [
            'borders' => [
                'top'    => [
                    'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                ],
                'left'   => [
                    'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                ],
                'right'  => [
                    'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                ],
                'bottom' => [
                    'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                ],
            ]
        ];

        $column = 'A';
        foreach($headerColName as $headerName) {
            $sheet->setCellValue($column.'1' , $headerName);
            $spreadsheet->getActiveSheet()->getColumnDimension( $column )->setAutoSize( true );
            $spreadsheet->getActiveSheet()->getStyle( $column.'1' )->applyFromArray( $styleArray );
            $column++;
        }

        $index=2;

        $results = $this->model_extension_pirateship_integration->getOrders($data);
        $weight = new AWeight($this->registry);
        $pound = 0;

        foreach ($results as $result) {
            $shipped_status = empty($result['shipped']) ? '0' : $result['shipped'];
            $shipped_status_filter = empty($data['shipped_status']) ? '0' : $data['shipped_status'];
            if ($shipped_status_filter!=='all') {
                if ($shipped_status !== $shipped_status_filter) {
                    continue;
                }
            }

            $order_products = $this->model_sale_order->getOrderProducts($result['order_id']);

            foreach ($order_products as $products) {
                $pound += (float)$weight->convert($products['weight'], $products['weight_iso_code'], $this->config->get('config_weight_class'));
            }

            $sheet->setCellValue('A' . $index, $result['order_id']);
            $spreadsheet->getActiveSheet()->getStyle('A' . $index)->applyFromArray($styleArray);
            $sheet->setCellValue('B' . $index, date_format(date_create($result['date_added']),'m/d/Y'));
            $spreadsheet->getActiveSheet()->getStyle('B' . $index)->applyFromArray($styleArray);
            $sheet->setCellValue('C' . $index, $result['name']);
            $spreadsheet->getActiveSheet()->getStyle('C' . $index)->applyFromArray($styleArray);
            $sheet->setCellValue('D' . $index, $result['email']);
            $spreadsheet->getActiveSheet()->getStyle('D' . $index)->applyFromArray($styleArray);
            $sheet->setCellValue('E' . $index, $result['shipping_company']);
            $spreadsheet->getActiveSheet()->getStyle('E' . $index)->applyFromArray($styleArray);
            $sheet->setCellValue('F' . $index, $result['shipping_address_1']);
            $spreadsheet->getActiveSheet()->getStyle('F' . $index)->applyFromArray($styleArray);
            $sheet->setCellValue('G' . $index, $result['shipping_address_2']);
            $spreadsheet->getActiveSheet()->getStyle('G' . $index)->applyFromArray($styleArray);
            $sheet->setCellValue('H' . $index, $result['shipping_city']);
            $spreadsheet->getActiveSheet()->getStyle('H' . $index)->applyFromArray($styleArray);

            $zone_id = $result['shipping_zone_id'];
            $zones= $this->model_localisation_zone->getZone($zone_id);
            $zone = $zones['code'];

            $sheet->setCellValue('I' . $index, $zone);
            $spreadsheet->getActiveSheet()->getStyle('I' . $index)->applyFromArray($styleArray);

            $sheet->setCellValue('J' . $index, $result['shipping_postcode']);
            $spreadsheet->getActiveSheet()->getStyle('J' . $index)->applyFromArray($styleArray);

            $country_id = $result['shipping_country_id'];
            $countries= $this->model_localisation_country->getCountry($country_id);
            $country = $countries['iso_code_2'];

            $sheet->setCellValue('K' . $index, $country);
            $spreadsheet->getActiveSheet()->getStyle('K' . $index)->applyFromArray($styleArray);

            $sheet->setCellValue('L' . $index, round($pound,3));
            $spreadsheet->getActiveSheet()->getStyle('L' . $index)->applyFromArray($styleArray);

            $sheet->setCellValue('M' . $index, $this->config->get('pirateship_integration_package_length'));
            $spreadsheet->getActiveSheet()->getStyle('M' . $index)->applyFromArray($styleArray);

            $sheet->setCellValue('N' . $index, $this->config->get('pirateship_integration_package_width'));
            $spreadsheet->getActiveSheet()->getStyle('N' . $index)->applyFromArray($styleArray);

            $sheet->setCellValue('O' . $index, $this->config->get('pirateship_integration_package_height'));
            $spreadsheet->getActiveSheet()->getStyle('O' . $index)->applyFromArray($styleArray);

            $sheet->setCellValue('P' . $index, $result['shipping_method']);
            $spreadsheet->getActiveSheet()->getStyle('P' . $index)->applyFromArray($styleArray);

            $index++;
        }
        $format = $data['export_type'];
        header( 'Content-type: application/vnd.ms-excel' );
        // It will be called order.xls
        header( "Content-Disposition: attachment; filename=order.".strtolower($format));
        $writer = \PhpOffice\PhpSpreadsheet\IOFactory::createWriter( $spreadsheet, ucfirst($format) );
        ob_end_clean();
        // Write file to the browser
        $writer->save( 'php://output' );
        die();
    }
}