<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2023 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

require_once DIR_SYSTEM . "lib/vendor/autoload.php";
require_once DIR_SYSTEM . "lib/license.php";
require_once DIR_EXT.'pirateship_integration'.DIR_EXT_CORE.'lib/vendor/autoload.php';

use PhpOffice\PhpSpreadsheet\Spreadsheet;

/**
 * Class ControllerPagesExtensionPirateShipIntegrationImport
 * @property ModelExtensionPirateShipIntegration $model_extension_pirateship_integration
 * @property ModelSaleOrder $model_sale_order
 * @property ModelExtensionPirateShipIntegrationLicenseInfo $model_extension_pirateship_integration_license_info
 * @property ModelExtensionEmailOrder $model_extension_email_order
 */

class ControllerPagesExtensionPirateShipIntegrationImport extends AController {
	public $data=[];
	public $error=[];

    public function verify() {
        $this->load->model('extension/pirateship_integration_license_info');
        $license_key = $this->config->get('pirateship_integration_license_code');
        if ($license_key) {
            $exist = $this->db->query("SHOW TABLES LIKE '" . $this->db->table('pirateship_integration_license_info') . "'");
            if ($exist->num_rows === 1) {
                $store_id = $this->model_extension_pirateship_integration_license_info->getStoreId();
                $license_key = $this->model_extension_pirateship_integration_license_info->getLicenseCode($store_id);
                $license_info = $this->model_extension_pirateship_integration_license_info->getLicenseData($store_id);
                $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                $license = new License($path_to_phpseclib);
                $license_manager = $license->getManager();
                $license_manager->setKeys($license_key, $license_info['public_key'], 'pirateship_integration');
                $ttl = 1209600;
                $validate = $license_manager->validate($license_info['license_data'], $ttl);
                $store_status = $this->model_extension_pirateship_integration_license_info->getLicensedStoreStatus();
                if ($validate['status'] === 'valid' && $store_status == 1) {
                    return true;
                } else {
                    return false;
                }
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

    public function verifyEmailEditor() {
        if ($this->config->get('email_editor_status')) {
            $this->load->model('extension/email_editor_license_info');
            $license_key = $this->config->get('email_editor_license_code');
            if ($license_key) {
                $exist = $this->db->query("SHOW TABLES LIKE '" . $this->db->table('email_editor_license_info') . "'");
                if ($exist->num_rows === 1) {
                    $store_id = $this->model_extension_email_editor_license_info->getStoreId();
                    $license_key = $this->model_extension_email_editor_license_info->getLicenseCode($store_id);
                    $license_info = $this->model_extension_email_editor_license_info->getLicenseData($store_id);
                    $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                    $license = new License($path_to_phpseclib);
                    $license_manager = $license->getManager();
                    $license_manager->setKeys($license_key, $license_info['public_key'], 'email_editor');
                    $ttl = 1209600;
                    $validate = $license_manager->validate($license_info['license_data'], $ttl);
                    $store_status = $this->model_extension_email_editor_license_info->getLicensedStoreStatus();
                    if ($validate['status'] === 'valid' && $store_status == 1) {
                        return true;
                    } else {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                return false;
            }
        }
    }

	public function main() {
		//init controller data
		$this->extensions->hk_InitData($this, __FUNCTION__);
		$this->load->language('pirateship_integration/pirateship_integration');
        $this->load->model('sale/order');
        $this->load->model('extension/pirateship_integration');

		$this->document->setTitle( $this->language->get('heading_order_import') );

		$this->document->initBreadcrumb( [
			'href'      => $this->html->getSecureURL('index/home'),
			'text'      => $this->language->get('text_home'),
			'separator' => FALSE
		]);

		$this->document->addBreadcrumb( [
			'href'      => $this->html->getSecureURL('pirateship_integration/import'),
			'text'      => $this->language->get('heading_order_import'),
			'separator' => ' :: ',
			'current' => true,
		]);

        if ($this->request->is_POST()) {
            $accept = ["application/vnd.ms-excel", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"];
            $upmime = strtolower($_FILES["file"]["type"]);

            if (in_array($upmime, $accept)) {
                $filename = $_FILES['file']['name'];
                $temp_name = $_FILES['file']['tmp_name'];
                if ($filename) {
                    if (!file_exists(DIR_EXT . 'pirateship_integration/files/')) {
                        mkdir(DIR_EXT . 'pirateship_integration/files/');
                    }

                    $upload_dir = DIR_EXT . 'pirateship_integration/files/';

                    // move file
                    move_uploaded_file($temp_name, $upload_dir . $filename);

                    $reader = new \PhpOffice\PhpSpreadsheet\Reader\Xlsx();
                    $spreadsheet = $reader->load($upload_dir.'/'.$filename);
                    $d=$spreadsheet->getSheet(0)->toArray();
                    $sheetData = $spreadsheet->getActiveSheet()->toArray();

                    $i=1;
                    unset($sheetData[0]);

                    $track_number = '';
                    foreach ($sheetData as $v) {
                        $tracking_number= $v[4];
                        $order_id = $v[30];
                        $carrier = $v[28];
                        $exist = $this->model_extension_pirateship_integration->getStatus($order_id);
                        if ($exist==='0') {
                            $msg = $this->config->get('pirateship_integration_order_history_message');
                            if ($carrier==='USPS') {
                               $track_number= '<a href="https://tools.usps.com/go/TrackConfirmAction?tRef=fullpage&tLc=2&text28777=&tLabels='.$tracking_number.'" target="_blank">'.$tracking_number.'</a>';
                            } elseif ($carrier==='UPS') {
                                $track_number = '<a href="https://www.ups.com/track?tracknum='.$tracking_number.'" target="_blank">'.$tracking_number.'</a>';
                            }

                            $message = html_entity_decode(str_replace('{tracking_number}', $track_number, $msg));
                            if ($this->verifyEmailEditor()) {
                                $this->load->model('extension/email_order');
                                $this->model_extension_email_order->addOrderHistory($order_id, [
                                    'order_status_id' => $this->config->get('pirateship_integration_order_status_id'),
                                    'notify' => 1,
                                    'append' => 1,
                                    'comment' => $message,
                                ]);
                            } else {
                                $this->model_extension_pirateship_integration->addOrderHistory($order_id, [
                                    'order_status_id' => $this->config->get('pirateship_integration_order_status_id'),
                                    'notify' => 1,
                                    'append' => 1,
                                    'comment' => $message,
                                ]);
                            }

                            $data['tracking_number'] = $tracking_number;
                            $data['order_id'] = $order_id;
                            $this->model_extension_pirateship_integration->updateStatus($data);
                        }
                    }

                    unlink($upload_dir . $filename);
                    $this->session->data['success'] = $this->language->get('text_success');
                    redirect($this->html->getSecureURL('extension/pirateship_integration_import'));
                }
            }
        }

		$form = new AForm ();
		$form->setForm(['form_name' => 'importFrm']);

        $this->data['action'] = $this->html->getSecureURL('extension/pirateship_integration_import');
        $this->data['cancel'] = $this->html->getSecureURL('extension/pirateship_integration_import');
        $this->data['form']['id'] = 'importFrm';
        $this->data['form']['form_open'] = $form->getFieldHtml(
            [
                'type'   => 'form',
                'name'   => 'importFrm',
                'action' => $this->data['action'],
                'attr'   => 'data-confirm-exit="true" class="aform form-horizontal"',
            ]
        );

        $this->data['form']['submit'] = $form->getFieldHtml ( [
            'type' => 'button',
            'name' => 'submit',
            'text' => $this->language->get ( 'button_start_import' )
        ] );
        $this->data['form']['cancel'] = $form->getFieldHtml ( [
            'type' => 'button',
            'name' => 'cancel',
            'text' => $this->language->get ( 'button_cancel_import' )
        ] );

        $this->data['form']['fields']['file'] = $form->getFieldHtml(
            [
                'type' => 'file',
                'name' => 'file',
                'attr' => 'accept=".xls, .xlsx"',
            ]);

        $this->data['license_status'] = $this->verify();
        $this->data['text_unauthorized'] = $this->language->get('text_pirateship_integration_unauthorized');
        $this->view->assign('form_store_switch', $this->html->getStoreSwitcher());

		if (isset ($this->session->data['warning'])) {
			$this->data['error_warning'] = $this->session->data['warning'];
			$this->session->data['warning'] = '';
		} else {
			$this->data ['error_warning'] = '';
		}

		if (isset ($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
			$this->session->data['success'] = '';
		} else {
			$this->data ['success'] = '';
		}

		$this->view->batchAssign($this->language->getASet('pirateship_integration/pirateship_integration'));
		$this->view->batchAssign($this->data);
		//update controller data
		$this->extensions->hk_UpdateData($this, __FUNCTION__);
		$this->processTemplate('pages/extension/pirateship_integration_import.tpl');
	}

    public function getStoreId() {
        $store_id = (int)$this->config->get('config_store_id');
        if (has_value($this->request->get_or_post('store_id'))) {
            $store_id = (int)$this->request->get_or_post('store_id');
        } else {
            if ($this->session->data['current_store_id']) {
                $store_id = (int)$this->session->data['current_store_id'];
            }
        }
        return $store_id;
    }
}