<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2023 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

require_once DIR_SYSTEM . "lib/vendor/autoload.php";
require_once DIR_SYSTEM . "lib/license.php";

/**
 * Class ControllerPagesExtensionExtensionPirateShipIntegrationExport
 * @property ModelExtensionPirateShipIntegration $model_extension_pirateship_integration
 * @property ModelSaleOrder $model_sale_order
 */

class ControllerPagesExtensionPirateShipIntegrationExport extends AController {
	public $data=[];
	public $error=[];

    public function verify() {
        $this->load->model('extension/pirateship_integration_license_info');
        $license_key = $this->config->get('pirateship_integration_license_code');
        if ($license_key) {
            $exist = $this->db->query("SHOW TABLES LIKE '" . $this->db->table('pirateship_integration_license_info') . "'");
            if ($exist->num_rows === 1) {
                $store_id = $this->model_extension_pirateship_integration_license_info->getStoreId();
                $license_key = $this->model_extension_pirateship_integration_license_info->getLicenseCode($store_id);
                $license_info = $this->model_extension_pirateship_integration_license_info->getLicenseData($store_id);
                $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                $license = new License($path_to_phpseclib);
                $license_manager = $license->getManager();
                $license_manager->setKeys($license_key, $license_info['public_key'], 'pirateship_integration');
                $ttl = 1209600;
                $validate = $license_manager->validate($license_info['license_data'], $ttl);
                $store_status = $this->model_extension_pirateship_integration_license_info->getLicensedStoreStatus();
                if ($validate['status'] === 'valid' && $store_status == 1) {
                    return true;
                } else {
                    return false;
                }
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

	public function main() {
		//init controller data
		$this->extensions->hk_InitData($this, __FUNCTION__);
		$this->load->language('pirateship_integration/pirateship_integration');

		$this->document->setTitle( $this->language->get('heading_order_export') );

		$this->document->initBreadcrumb( [
			'href'      => $this->html->getSecureURL('index/home'),
			'text'      => $this->language->get('text_home'),
			'separator' => FALSE
		]);

		$this->document->addBreadcrumb( [
			'href'      => $this->html->getSecureURL('pirateship_integration/export'),
			'text'      => $this->language->get('heading_order_export'),
			'separator' => ' :: ',
			'current' => true,
		]);

        $grid_settings = ['table_id' => 'export_grid',
            'url' => $this->html->getSecureURL('listing_grid/pirateship_integration_export'),
            'editurl' => '',
            'update_field' => '',
            'sortname' => 'order_id',
            'sortorder' => 'desc',
            'actions' => [
                'view' => [
                    'text' => $this->language->get('text_view'),
                    'href' => $this->html->getSecureURL('sale/order/details', '&order_id=%ID%')
                ],
            ],
        ];

        $this->loadModel('localisation/order_status');
        $results = $this->model_localisation_order_status->getOrderStatuses();
        $statuses = [
            ''    => $this->language->get('text_select_status'),
            'all' => $this->language->get('text_all_orders'),
        ];
        foreach ($results as $item) {
            $statuses[$item['order_status_id']] = $item['name'];
        }

		$form = new AForm ();
		$form->setForm(['form_name' => 'export_grid_search']);

        $search_params = [];
        if ($this->request->get['saved_list']) {
            $grid_search_form = json_decode(html_entity_decode($this->request->cookie['grid_search_form']));
            if ($grid_search_form->table_id == $grid_settings['table_id']) {
                parse_str($grid_search_form->params, $search_params);
            }
        }

        $grid_search_form = [];
        $grid_search_form['id'] = 'export_grid_search';
        $grid_search_form['form_open'] = $form->getFieldHtml([
            'type'   => 'form',
            'name'   => 'export_grid_search',
            'action' => '',
        ]);
        $grid_search_form['submit'] = $form->getFieldHtml([
            'type'  => 'button',
            'name'  => 'submit',
            'text'  => $this->language->get('button_go'),
            'style' => 'button1',
        ]);
        $grid_search_form['reset'] = $form->getFieldHtml([
            'type'  => 'button',
            'name'  => 'reset',
            'text'  => $this->language->get('button_reset'),
            'style' => 'button2',
        ]);

        $grid_search_form['export'] = $form->getFieldHtml([
            'type'  => 'button',
            'name'  => 'export',
            'text'  => $this->language->get('button_export'),
            'style' => 'button2',
        ]);

        $grid_search_form['fields']['order_from'] = $form->getFieldHtml(
            [
                'type'       => 'date',
                'name'       => 'order_from',
                'value'      => dateISO2Display(
                    $search_params['order_from'],
                    $this->language->get('date_format_short')
                ),
                'default'    => '',
                'dateformat' => format4Datepicker(
                    $this->language->get('date_format_short')
                ),
                'highlight'  => 'future',
                'style'      => 'small-field',
                'placeholder' => $this->language->get('filter_order_from'),
            ]
        );

        $grid_search_form['fields']['order_to'] = $form->getFieldHtml(
            [
                'type'       => 'date',
                'name'       => 'order_to',
                'value'      => dateISO2Display(
                    $search_params['order_to'],
                    $this->language->get('date_format_short')
                ),
                'default'    => '',
                'dateformat' => format4Datepicker(
                    $this->language->get('date_format_short')
                ),
                'highlight'  => 'future',
                'style'      => 'small-field',
                'placeholder' => $this->language->get('filter_order_to'),
            ]
        );

        $grid_search_form['fields']['order_status_id'] = $form->getFieldHtml([
            'type'    => 'selectbox',
            'name'    => 'order_status_id',
            'options' => $statuses,
            'value'   => $search_params['order_status_id'],
        ]);

        $shipped_statuses = [
          'all'  => $this->language->get('text_select_shipped_status'),
          '0'  => $this->language->get('text_no'),
          '1' => $this->language->get('text_yes'),
        ];

        $grid_search_form['fields']['shipped_status'] = $form->getFieldHtml([
            'type'    => 'selectbox',
            'name'    => 'shipped_status',
            'options' => $shipped_statuses,
            'value'   => $search_params['shipped_status'],
        ]);

        $grid_settings['multiselect']         = "false";
        $grid_settings['multiaction']         = "false";
        $grid_settings['multiaction_class'] = 'hidden';
        $grid_settings['multiaction_options'] = [''];
        $grid_settings['search_form'] = true;

        $grid_settings['colNames'] = [
            $this->language->get('column_order_id'),
            $this->language->get('column_order_date'),
            $this->language->get('column_customer_name'),
            $this->language->get('column_customer_email'),
            $this->language->get('column_customer_company'),
            $this->language->get('column_customer_address'),
            $this->language->get('column_shipping_method'),
            $this->language->get('column_order_status'),
            $this->language->get('column_order_shipped'),
            $this->language->get('column_tracking_number'),
        ];

        $grid_settings['colModel'] = [
            ['name' => 'order_id',
                'index' => 'order_id',
                'width' => 50,
                'align' => 'center',
                'search' => false],
            ['name' => 'order_date',
                'index' => 'order_date',
                'width' => 75,
                'align' => 'center',
                'sortable' => false,
                'search' => false],
            ['name' => 'customer_name',
                'index' => 'customer_name',
                'width' => 70,
                'align' => 'center',
                'sortable' => false,
                'search' => false],
            ['name' => 'customer_email',
                'index' => 'customer_email',
                'width' => 100,
                'align' => 'center',
                'sortable' => false,
                'search' => false],
            ['name' => 'customer_company',
                'index' => 'customer_company',
                'width' => 70,
                'align' => 'center',
                'sortable' => false,
                'search' => false],
            ['name' => 'customer_address',
                'index' => 'customer_address',
                'width' => 200,
                'align' => 'center',
                'sortable' => false,
                'search' => false],
            ['name' => 'shippping_method',
                'index' => 'shippping_method',
                'width' => 100,
                'align' => 'center',
                'sortable' => false,
                'search' => false],
            ['name' => 'order_status',
                'index' => 'order_status',
                'width' => 60,
                'align' => 'center',
                'sortable' => false,
                'search' => false],
            ['name' => 'shipped_status',
                'index' => 'shipped_status',
                'width' => 80,
                'align' => 'center',
                'sortable' => false,
                'search' => false],
            ['name' => 'tracking_number',
                'index' => 'tracking_number',
                'width' => 105,
                'align' => 'center',
                'sortable' => false,
                'search' => false],
        ];

		$grid = $this->dispatch('common/listing_grid', [$grid_settings]);
		$this->data['listing_grid'] = $grid->dispatchGetOutput();
        $this->data['search_form'] = $grid_search_form;

        $this->data['license_status'] = $this->verify();
        $this->data['text_unauthorized'] = $this->language->get('text_pirateship_integration_unauthorized');
        $this->view->assign('form_store_switch', $this->html->getStoreSwitcher());

		if (isset ($this->session->data['warning'])) {
			$this->data['error_warning'] = $this->session->data['warning'];
			$this->session->data['warning'] = '';
		} else {
			$this->data ['error_warning'] = '';
		}

		if (isset ($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
			$this->session->data['success'] = '';
		} else {
			$this->data ['success'] = '';
		}

        $this->data['export_orders_url'] = $this->html->getSecureURL("r/extension/pirateship_integration_export");

		$this->view->batchAssign($this->language->getASet('pirateship_integration/pirateship_integration'));
		$this->view->batchAssign($this->data);
		//update controller data
		$this->extensions->hk_UpdateData($this, __FUNCTION__);
		$this->processTemplate('pages/extension/pirateship_integration_export.tpl');
	}

    public function getStoreId() {
        $store_id = (int)$this->config->get('config_store_id');
        if (has_value($this->request->get_or_post('store_id'))) {
            $store_id = (int)$this->request->get_or_post('store_id');
        } else {
            if ($this->session->data['current_store_id']) {
                $store_id = (int)$this->session->data['current_store_id'];
            }
        }
        return $store_id;
    }
}