<div id="order_attributes_table" class="row">
    <div id="hidden_attributes" class="hidden">
    <?php
    // add hidden attributes
    foreach($attributes as $val){
        if(in_array($val['html']->type, ['hidden', 'IPaddress'])){
            echo $val['html'];
        }
    }
    ?>
    </div>
    <div class="registerbox">
        <table class="table table-striped table-shipments">
            <tbody>
                <tr>
                    <td colspan="2"><b><?php echo $text_additional_attributes; ?></b></td>
                </tr>
                <?php
                    foreach($attributes as $val){
                        $key = $val['id'];
                        if(in_array($val['html']->type, ['hidden', 'IPaddress'])){
                            continue;
                        }
                    ?>
                    <tr>
                        <td style="vertical-align: middle;">
                            <label class="control-label col-sm-8 pull-right"><?php echo $val['name']; ?></label>
                        </td>
                        <td id="td_<?php echo $val['html']->element_id?>" style="vertical-align: middle;">
                            <div class="form-group <?php echo $errors[$key] ? 'has-error' : ''; ?>">
                                <div class="input-group col-sm-8">
                                    <?php
                                    echo $val['html']; ?>
                                </div>
                                <span class="help-block"><?php echo $errors[$key]; ?></span>
                            </div>
                        </td>
                    </tr>
                <?php
                    } ?>
                <tr>
                    <td></td>
                    <td style="vertical-align: middle;">
                        <div class="pull-right">
                            <button id="order_attribute_apply" class="btn btn-default btn-lg" type="button">
                               <i class="fa fa-check fa-fw"></i>
                               <span class="hidden-xxs"><?php echo $this->language->get('fast_checkout_text_apply')?></span>
                              </button>
                        </div>
                    </td>
                </tr>
            </tbody>
        </table>
    </div>
</div>
<script type="application/javascript">
    $(document).ready(
        function(){
            var wrapper = $('#order_attributes_table');
            wrapper.find('input:radio, input:checkbox')
                .css('display','table-cell');
            wrapper.find('button').css('min-height','auto');
            wrapper.find('span.btn-file')
                .css('min-width','400px')
                .css('display','table-cell');
        }
    );

    $.fn.serializeObject = function() {
        var o = {};
        var a = this.serializeArray();
        $.each(a, function() {
            if (o[this.name]) {
                if (!o[this.name].push) {
                    o[this.name] = [o[this.name]];
                }
                o[this.name].push(this.value || '');
            } else {
                o[this.name] = this.value || '';
            }
        });
        return o;
    };

    function reloadCaptchaImage()
    {
        var wrapper = $('#order_attributes_table').find('.captcha-addon');
        var img = wrapper.find('img');
        if(img) {
            img.attr('src', img.attr('src') + '&t=' + Date.now());
            wrapper.next().val('');
        }
    }

    var attrs = $('#order_attributes_table').find('input, select, textarea');
    var fileinputs = $('#order_attributes_table').find('input:file');

    if(fileinputs.length > 0) {
        fileinputs.fileinput(
            {
                uploadUrl: '<?php echo $this->html->getSecureUrl('extension/order_attributes'); ?>',
                overwriteInitial: true,
                browseClass: 'btn btn-default',
                showUpload: false,
                showCaption: true,
                showPreview: false,
                browseIcon: '<i class="fa fa-folder-open fa-fw"></i> ',
                // browseLabel: <?php js_echo($this->language->get('text_browse')); ?>,
                initialCaption: <?php js_echo($this->language->get('text_click_browse_file')); ?>,
                uploadExtraData: function() {
                    return attrs.serializeObject();
                }


            }
        ).on('filepreupload', function(event, data){

            }
        ).on('filebatchuploadsuccess', function(event, data) {
            $('#order_attributes_table').find('div.alert-danger').remove();
            var res = data.jqXHR.responseJSON;
            if(!res.result){
                $.each(res.errors, function(key, msg){
                    $('#td_attributes'+key).append('<div class="alert alert-danger">'+msg + '</div>')
                });
                reloadCaptchaImage();
            }else{
                $('#order_attribute_apply').parent().html('<div class="alert alert-success">'+res.message + '</div>')
            }
        }).on('fileuploaded', function(event, data) {
            $('#order_attributes_table').find('div.alert-danger').remove();
            var res = data.jqXHR.responseJSON;
            if(!res.result){
                $.each(res.errors, function(key, msg){
                    $('#td_attributes'+key).append('<div class="alert alert-danger">'+msg + '</div>');
                });
                reloadCaptchaImage();
            }else{
                $('#order_attribute_apply').parent().html('<div class="alert alert-success">'+res.message + '</div>');
                loadPage();
            }
        });
        $('#order_attribute_apply').on(
            'click',
            function (){
                fileinputs.fileinput('upload');
                $('#payment_details, div.payment-select-container').slideDown();
            }
        );
    }
    else if(attrs.length > 0){
        attrs.on('keyup', function(){
            if($(this).val().length){
                $('#payment_details, div.payment-select-container').slideUp();
                for(let i=0;i<3;i++) {
                    $('#order_attribute_apply').fadeTo('fast', 0.2).fadeTo('fast', 1.0);
                }
            }
        });
        $('#order_attribute_apply').on(
            'click',
            function () {
                $.ajax(
                    {
                        url: '<?php echo $this->html->getSecureUrl('extension/order_attributes'); ?>',
                        type: 'POST',
                        dataType: 'json',
                        data: attrs.serializeObject(),
                        success: function (res) {
                            $('#order_attributes_table').find('div.alert-danger').remove();
                            if(!res.result){
                                $.each(res.errors, function(key, msg){
                                    $('#td_attributes'+key).append('<div class="alert alert-danger">'+msg + '</div>');
                                });
                                reloadCaptchaImage();
                            }else{
                                $('#order_attribute_apply').parent().html('<div class="alert alert-success">'+res.message + '</div>');
                                loadPage();
                            }
                        }
                    }
                );
                $('#payment_details, div.payment-select-container').slideDown();
            }
        );
    }

</script>