<?php

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

if (!class_exists('ExtensionOrderAttributes')) {
    include('core/order_attributes.php');
}

$controllers = [
    'storefront' => [
        'responses/extension/order_attributes',
    ],
    'admin'      => [
        'pages/sale/order_attributes',
        'responses/order_attributes/attributes',
    ],
];

$models = [
    'storefront' => ['order/order_attributes'],
    'admin'      => ['sale/order_attributes'],
];

$languages = [
    'storefront' => ['order_attributes/order_attributes'],
    'admin'      => ['order_attributes/order_attributes', 'extension/order_attributes'],
];

$templates = [
    'storefront' => [
        'pages/checkout/order_attributes.tpl',
        'pages/checkout/order_attributes_confirm.tpl',
        'pages/checkout/order_attributes_fc .tpl',
        'pages/checkout/order_attributes_invoice.tpl',
    ],
    'admin'      => [
        'pages/blocks/tabs.tpl',
        'pages/order_attributes/attributes_form.tpl',
        'pages/order_attributes/attributes_details.tpl',
        'responses/order_attributes/attribute_values.tpl',
        'responses/order_attributes/attribute_value_row.tpl',
        'responses/order_attributes/file_upload_settings.tpl',
        'responses/order_attributes/global_attribute_order_attribute_subform.tpl',
    ],
];