<?php

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}
/**
 * Class ExtensionOrderAttributes.
 */
class ExtensionOrderAttributes extends Extension
{
    public $errors = [];
    public $data = [];
    protected $registry;

    public function __construct()
    {
        $this->registry = Registry::getInstance();
    }

    public function onControllerResponsesCommonTabs_InitData()
    {
        if ('sale/customer_group' != $this->baseObject->parent_controller) {
            return null;
        }
        $that = &$this->baseObject;
        if (!isset($that->request->get['customer_group_id'])) {
            return null;
        }

        $that->loadLanguage('extension/order_attributes');

        $that->data['tabs']['order_attributes'] = [
            'name' => 'order_attributes',
            'text' => $that->language->get('order_attributes_name'),
            'href' => $that->html->getSecureURL('sale/order_attributes/update', '&customer_group_id=' . $that->request->get['customer_group_id']),
            'active' => 'sale/order_attributes/update' == $that->request->get['rt'] ? true : false,
            'sort_order' => 2,
        ];
    }

    public function onControllerPagesSaleOrder_InitData()
    {
        $this->baseObject->loadLanguage('extension/order_attributes');
    }

    public function onControllerPagesSaleOrderTabs_UpdateData()
    {
        $that = &$this->baseObject;
        $groups = $that->view->getData('groups');
        $groups[] = 'order_attributes';
        $that->view->assign('groups', $groups);
        $that->view->assign('link_order_attributes', $that->html->getSecureURL('sale/order_attributes/details', '&order_id=' . $that->request->get['order_id']));
        $that->view->assign('tab_order_attributes', $that->language->get('order_attributes_name'));
        if ('sale/order_attributes/details' == $that->data['parent_controller']) {
            $that->view->assign('active', 'order_attributes');
        }
    }

    public function onControllerPagesCheckoutShipping_InitData()
    {
        $that = &$this->baseObject;

        $that->loadLanguage('extension/order_attributes');
        $that->loadModel('order/order_attributes');

        if ($that->request->is_POST()) {
            if (has_value($that->request->files['attributes']['name'])) {
                $this->_process_file_upload();
            }
            if ($this->_validate('shipping') && empty($this->errors)) {
                foreach ((array) $that->request->post['attributes'] as $key => $val) {
                    $that->session->data['order_attributes'][$key] = $val;
                }
            } else {
                $that->session->data['order_attributes_errors'] = $this->errors;
                header('Location: ' . $that->html->getSecureURL('checkout/shipping', '&mode=edit'));
                exit;
            }
        } else {
            if ($this->_is_attributes_presents('shipping') && 'edit' != $that->request->get['mode']) {
                header('Location: ' . $that->html->getSecureURL('checkout/shipping', '&mode=edit'));
                exit; // forbid skipping of shipping page
            }
        }
    }

    public function onControllerPagesCheckoutShipping_UpdateData()
    {
        $that = &$this->baseObject;
        $data = [];

        if (has_value($that->session->data['order_attributes_errors'])) {
            $data['errors'] = $that->session->data['order_attributes_errors'];
            unset($that->session->data['order_attributes_errors']);
        }

        $selected = [];
        if (isset($that->session->data['order_attributes'])) {
            $selected = $that->session->data['order_attributes'];
        }

        $data['text_additional_attributes'] = $that->language->get('text_additional_attributes');
        $attributes = $that->model_order_order_attributes->getAttributesForGroup(
            $that->customer->getCustomerGroupId(),
            'shipping'
        );

        $elements = HtmlElementFactory::getAvailableElements();
        $html_multivalue_elements = HtmlElementFactory::getMultivalueElements();
        $elements_with_options = HtmlElementFactory::getElementsWithOptions();

        foreach ($attributes as $attribute) {
            $values = [];
            $value = (!empty($selected)) ? $selected[$attribute['attribute_id']] : '';
            $val_name = '';

            foreach ($attribute['values'] as $val) {
                $val_name = $val['value'];
                $values[$val['attribute_value_id']] = $val['value'];
            }

            if (!in_array($attribute['element_type'], $elements_with_options) && empty($value)) {
                $value = $val_name;
            }

            $html_type = $elements[$attribute['element_type']]['type'];

            $option_data = [
                'type' => $html_type,
                'name' => !in_array($attribute['element_type'], $html_multivalue_elements) ? 'attributes[' . $attribute['global_attribute_id'] . ']' : 'attributes[' . $attribute['global_attribute_id'] . '][]',
                'value' => $value,
                'options' => $values,
                'required' => $attribute['required'],
            ];

            if ('checkbox' == $html_type) {
                if ('' == $value) {
                    $value = 1;
                    $option_data['value'] = $value;
                }
                if (!in_array($value, ['0', '1'])) {
                    $option_data['label_text'] = $value;
                }
                // ???
                $option_data['checked'] = $preset_value ? true : false;
            } elseif ('checkboxgroup' == $html_type) {
                $option_data['scrollbox'] = true;
            } elseif ('radio' == $html_type && !empty($selected)) {
                $option_data['value'] = $selected[$attribute['attribute_id']][0];
            } elseif ('date' == $html_type) {
                $option_data['dateformat'] = format4Datepicker($that->language->get('date_format_short'));
            }

            $data['attributes'][] = [
                'id' => $attribute['global_attribute_id'],
                'name' => $attribute['name'],
                'type' => $html_type,
                'html' => $that->html->buildElement($option_data),
            ];
        }

        $view = new AView($this->registry, 0);
        $view->batchAssign($data);
        $that->view->addHookVar('order_attributes', $view->fetch('pages/checkout/order_attributes.tpl'));
    }

    public function onControllerPagesCheckoutPayment_InitData()
    {
        $this->baseObject->loadLanguage('extension/order_attributes');
    }

    public function onControllerPagesCheckoutPayment_processData()
    {
        $that = &$this->baseObject;
        $that->loadModel('order/order_attributes');

        if ($that->request->is_POST()) {
            if (has_value($that->request->files['attributes']['name'])) {
                $this->_process_file_upload();
            }

            if ($this->_validate('payment') && empty($this->errors)) {
                foreach ((array) $that->request->post['attributes'] as $key => $val) {
                    $that->session->data['order_attributes'][$key] = $val;
                }
            } else {
                $that->session->data['order_attributes_errors'] = $this->errors;
                header('Location: ' . $that->html->getSecureURL('checkout/payment', '&mode=edit'));
                exit;
            }
        } else {
            if ($this->_is_attributes_presents('payment') && 'edit' != $that->request->get['mode']) {
                header('Location: ' . $that->html->getSecureURL('checkout/payment', '&mode=edit'));
                exit; // forbid skipping of payment page
            }
        }
    }

    // / MOD
    public function startsWith($string, $startString)
    {
        $len = strlen($startString);

        return substr($string, 0, $len) === $startString;
    }

    // / MOD
    public function str_replace_first($from, $to, $content)
    {
        $from = '/' . preg_quote($from, '/') . '/';

        return preg_replace($from, $to, $content, 1);
    }

    public function onControllerPagesCheckoutPayment_UpdateData()
    {
        $that = &$this->baseObject;
        $data = [];

        $that->loadModel('order/order_attributes');

        if (has_value($that->session->data['order_attributes_errors'])) {
            $data['errors'] = $that->session->data['order_attributes_errors'];
            unset($that->session->data['order_attributes_errors']);
        }

        $selected = [];
        if (isset($that->session->data['order_attributes'])) {
            $selected = $that->session->data['order_attributes'];
        }
        $data['text_additional_attributes'] = $that->language->get('text_additional_attributes');
        $data['error_match_ba'] = $that->language->get('error_match_ba');
        $data['error_match_br'] = $that->language->get('error_match_br');
        $data['order_attributes_title_2'] = $that->language->get('order_attributes_title_2');

        $attributes = $that->model_order_order_attributes->getAttributesForGroup(
            $that->customer->getCustomerGroupId(),
            'payment'
        );

        $elements = HtmlElementFactory::getAvailableElements();
        $html_multivalue_elements = HtmlElementFactory::getMultivalueElements();
        $elements_with_options = HtmlElementFactory::getElementsWithOptions();

        foreach ($attributes as $attribute) {
            // $this->baseObject->log->write(print_r($attribute, true).' $attribute in foreach');

            $values = [];
            $value = (!empty($selected)) ? $selected[$attribute['attribute_id']] : '';
            $val_name = '';

            foreach ($attribute['values'] as $val) {
                $val_name = $val['value'];

                $values[$val['attribute_value_id']] = $val['value'];
            }

            if (!in_array($attribute['element_type'], $elements_with_options) && empty($value)) {
                $value = $val_name;
            }

            $html_type = $elements[$attribute['element_type']]['type'];
            if ($this->startsWith($attribute['name'], 'Payment:')) {
                $required = false; // allow to skip
                $dataid = ' data-id="default_cheque" ';
                if ($this->startsWith($attribute['name'], 'Payment:Re-enter Bank routing')) {
                    $oninput = ' oninput="checkBR()" onkeyup="checkBRfocus()" data-match="bankrout" ';
                    $html_type = 'password';
                } elseif ($this->startsWith($attribute['name'], 'Payment:Re-enter Bank Account')) {
                    $oninput = ' oninput="checkBA()" onkeyup="checkBAfocus()" data-match="bankacc" ';
                    $html_type = 'password';
                } elseif ($this->startsWith($attribute['name'], 'Payment:Bank routing')) {
                    $oninput = ' oninput="checkBA()"  data-match="bankrout-source" ';
                } elseif ($this->startsWith($attribute['name'], 'Payment:Bank Account')) {
                    $oninput = ' oninput="checkBA()"  data-match="bankacc-source" ';
                } else {
                    $oninput = '';
                }
                $attribute['name'] = $this->str_replace_first('Payment:', '', $attribute['name']);
            } else {
                $required = $attribute['required'];
                $dataid = ' data-id="" ';
            }
            $option_data = [
                'type' => $html_type,
                'name' => !in_array($attribute['element_type'], $html_multivalue_elements) ? 'attributes[' . $attribute['global_attribute_id'] . ']' : 'attributes[' . $attribute['global_attribute_id'] . '][]',
                'value' => $value,
                'options' => $values,
                'required' => $required,
                'attr' => $dataid . ' style="mdisplay:none;" data-name="' . $attribute['name'] . '" ' . $oninput,
            ];

            if ('checkbox' == $html_type) {
                $option_data['label_text'] = $value;
                if (!empty($option_data['value']) && !empty($selected)) {
                    $option_data['checked'] = true;
                }
            } elseif ('checkboxgroup' == $html_type) {
                $option_data['scrollbox'] = true;
            } elseif ('radio' == $html_type && !empty($selected)) {
                $option_data['value'] = $selected[$attribute['attribute_id']][0];
            } elseif ('date' == $html_type) {
                $option_data['dateformat'] = format4Datepicker($that->language->get('date_format_short'));
            }

            $data['attributes'][] = [
                'id' => $attribute['global_attribute_id'],
                'name' => $attribute['name'],
                'type' => $html_type,
                'html' => $that->html->buildElement($option_data),
            ];
        }

        $view = new AView($this->registry, 0);
        $view->batchAssign($data);
        $that->view->addHookVar('order_attributes', $view->fetch('pages/checkout/order_attributes.tpl'));
    }

    public function onControllerPagesCheckoutConfirm_InitData()
    {
        $this->baseObject->loadLanguage('extension/order_attributes');
    }

    public function onControllerPagesCheckoutConfirm_UpdateData()
    {
        $that = &$this->baseObject;
        $data = [];
        $that->loadModel('order/order_attributes');

        $data['text_additional_attributes'] = $that->language->get('text_additional_attributes');
        // MOD
        // $this->baseObject->log->write(print_r($that->session->data, true).' session info');
        if ('default_cheque' == $that->session->data['payment_method']['id']) {
            $selected = $that->session->data['order_attributes'];
        } else {
            // remove Payment: inputs from all other payments
            /*$that->session->data[order_attributes] => Array
            (
                [9] => my text
                [10] =>
                [11] =>
                [12] =>
                [13] =>
                [14] =>
                [15] =>
                [16] =>
                    check ids.
                    get names and remove if starts with Payment:
            )*/
            $selected = $that->session->data['order_attributes'];
        }

        $attributes = $newselected = [];
        if (is_array($selected) && has_value($selected)) {
            foreach ($selected as $id => $item) {
                // MOD
                /*$info = $that->model_order_order_attributes->getAttributeInfo($id);
                if ($this->startsWith($info['name'], 'Payment:') and $that->session->data['payment_method']['id'] != 'default_cheque') {
                    //skip
                } else {
                    $attributes[] = $that->model_order_order_attributes->getAttributeInfo($id);
                }*/
                $attributes[] = $that->model_order_order_attributes->getAttributeInfo($id);
            }
        }

        uasort($attributes, ['self', 'sort_attributes']);

        $elements = HtmlElementFactory::getAvailableElements();
        $elements_with_options = HtmlElementFactory::getElementsWithOptions();

        foreach ($attributes as $attribute) {
            if (!isset($attribute['attribute_id'])) {
                continue;
            }
            $values = [];
            $value = $selected[$attribute['attribute_id']];
            $val_name = '';

            foreach ($attribute['values'] as $val) {
                $val_name = $val['value'];

                $values[$val['attribute_value_id']] = $val['value'];
            }

            $html_type = $elements[$attribute['element_type']]['type'];
            if ('K' == $attribute['element_type']) {
                continue;
            }
            $selected_vals = [];

            if (in_array($attribute['element_type'], $elements_with_options)) {
                if (is_array($value)) {
                    if (in_array($attribute['element_type'], ['O', 'Z'])) { // for countries and zones
                        $selected_vals[] = $value;
                    } else {
                        foreach ($value as $val) {
                            $selected_vals[] = $values[$val];
                        }
                    }
                } else {
                    if (in_array($attribute['element_type'], ['O', 'Z'])) { // for countries and zones
                        $selected_vals[] = $value;
                    } else {
                        $selected_vals[] = $attribute['values'][$value]['value'];
                    }
                }
            } else {
                $selected_vals[] = $value;
            }

            // MOD
            if ($this->startsWith($attribute['name'], 'Payment:') and 'default_cheque' == $that->session->data['payment_method']['id']) {
                if ($this->startsWith($attribute['name'], 'Payment:Re-enter')) {
                } else {
                    $data['attributes'][] = [
                        'id' => $attribute['attribute_id'],
                        'name' => $attribute['name'],
                        'type' => $html_type,
                        'values' => $selected_vals,
                    ];
                }
            } elseif (!$this->startsWith($attribute['name'], 'Payment:')) {
                $data['attributes'][] = [
                    'id' => $attribute['attribute_id'],
                    'name' => $attribute['name'],
                    'type' => $html_type,
                    'values' => $selected_vals,
                ];
            }
            // MOD END
        }

        $view = new AView($this->registry, 0);
        $view->batchAssign($data);
        $that->view->addHookVar('order_attributes', $view->fetch('pages/checkout/order_attributes_confirm.tpl'));
    }

    public function onControllerPagesCheckoutGuestStep2_InitData()
    {
        $that = &$this->baseObject;
        $that->loadLanguage('extension/order_attributes');
        $that->loadModel('order/order_attributes');

        if (($this->_is_attributes_presents('shipping') || $this->_is_attributes_presents('payment')) && 'edit' != $that->request->get['mode']) {
            header('Location: ' . $that->html->getSecureURL('checkout/guest_step_2', '&mode=edit'));
            exit; // forbid skipping of shipping page
        }
        if ($that->request->is_POST() && !has_value($that->request->post['coupon'])) {
            if (has_value($that->request->files['attributes']['name'])) {
                $this->_process_file_upload();
            }
            if ($this->_validate('guest_checkout') && empty($this->errors)) {
                foreach ((array) $that->request->post['attributes'] as $key => $val) {
                    $that->session->data['order_attributes'][$key] = $val;
                }
            } else {
                unset($that->request->server['REQUEST_METHOD']);
                $that->session->data['order_attributes_errors'] = $this->errors;
            }
        }
    }

    public function onControllerPagesCheckoutGuestStep2_UpdateData()
    {
        $that = &$this->baseObject;
        $data = [];
        $that->loadModel('order/order_attributes');

        if (has_value($that->session->data['order_attributes_errors'])) {
            $data['errors'] = $that->session->data['order_attributes_errors'];
            unset($that->session->data['order_attributes_errors']);
        }

        $selected = [];
        if (isset($that->session->data['order_attributes'])) {
            $selected = $that->session->data['order_attributes'];
        }
        $data['text_additional_attributes'] = $that->language->get('text_additional_attributes');
        $customer_group_id = $that->customer->getCustomerGroupId();
        $customer_group_id = !$customer_group_id ? $that->config->get('config_customer_group_id') : $customer_group_id;

        $attributes = $that->model_order_order_attributes->getAttributesForGroup($customer_group_id, 'guest_checkout');

        $elements = HtmlElementFactory::getAvailableElements();
        $html_multivalue_elements = HtmlElementFactory::getMultivalueElements();
        $elements_with_options = HtmlElementFactory::getElementsWithOptions();

        foreach ($attributes as $attribute) {
            $values = [];
            $value = (!empty($selected)) ? $selected[$attribute['attribute_id']] : '';

            $val_name = '';

            foreach ($attribute['values'] as $val) {
                $val_name = $val['value'];
                $values[$val['attribute_value_id']] = $val['value'];
            }

            if (!in_array($attribute['element_type'], $elements_with_options)) {
                $value = $val_name;
            }

            $html_type = $elements[$attribute['element_type']]['type'];

            $option_data = [
                'type' => $html_type,
                'name' => !in_array($attribute['element_type'], $html_multivalue_elements) ? 'attributes[' . $attribute['global_attribute_id'] . ']' : 'attributes[' . $attribute['global_attribute_id'] . '][]',
                'value' => $value,
                'options' => $values,
                'required' => $attribute['required'],
            ];

            if ('countries' == $html_type || 'zones' == $html_type) {
                $that->loadModel('localisation/country');
                $country_info = $that->model_localisation_country->getCountry((int) $that->config->get('config_country_id'));
                $option_data['value'] = $country_info['name'];
            }

            if ('checkbox' == $html_type) {
                $option_data['label_text'] = $value;
                if (!empty($option_data['value']) && !empty($selected)) {
                    $option_data['checked'] = true;
                }
            } elseif ('checkboxgroup' == $html_type) {
                $option_data['scrollbox'] = true;
            } elseif ('date' == $html_type) {
                $option_data['dateformat'] = format4Datepicker($that->language->get('date_format_short'));
            } elseif ('radio' == $html_type && !empty($selected)) {
                $option_data['value'] = $selected[$attribute['attribute_id']][0];
            }

            $data['attributes'][] = [
                'id' => $attribute['global_attribute_id'],
                'name' => $attribute['name'],
                'type' => $html_type,
                'html' => $that->html->buildElement($option_data),
            ];
        }

        $view = new AView($this->registry, 0);
        $view->batchAssign($data);
        $that->view->addHookVar('order_attributes', $view->fetch('pages/checkout/order_attributes.tpl'));
    }

    public function onControllerPagesCheckoutGuestStep3_InitData()
    {
        $this->baseObject->loadLanguage('extension/order_attributes');
    }

    public function onControllerPagesCheckoutGuestStep3_UpdateData()
    {
        $that = &$this->baseObject;
        $data = [];
        $that->loadModel('order/order_attributes');

        $data['text_additional_attributes'] = $that->language->get('text_additional_attributes');

        $selected = (array) $that->session->data['order_attributes'];

        $attributes = [];
        foreach ($selected as $id => $item) {
            $attributes[] = $that->model_order_order_attributes->getAttributeInfo($id);
        }

        uasort($attributes, ['self', 'sort_attributes']);

        $elements = HtmlElementFactory::getAvailableElements();
        $elements_with_options = HtmlElementFactory::getElementsWithOptions();

        foreach ($attributes as $attribute) {
            if (!isset($attribute['attribute_id'])) {
                continue;
            }
            $values = [];
            $value = $selected[$attribute['attribute_id']];
            $val_name = '';

            foreach ($attribute['values'] as $val) {
                $val_name = $val['value'];

                $values[$val['attribute_value_id']] = $val['value'];
            }

            $html_type = $elements[$attribute['element_type']]['type'];

            $selected_vals = [];
            if (in_array($attribute['element_type'], $elements_with_options)) {
                if (is_array($value)) {
                    if (in_array($attribute['element_type'], ['O', 'Z'])) { // for countries and zones
                        $selected_vals = $value;
                    } else {
                        foreach ($value as $val) {
                            $selected_vals[] = $values[$val];
                        }
                    }
                } else {
                    if (in_array($attribute['element_type'], ['O', 'Z'])) { // for countries and zones
                        $selected_vals[] = $value;
                    } else {
                        $selected_vals[] = $attribute['values'][$value]['value'];
                    }
                }
            } else {
                $selected_vals[] = $value;
            }

            $data['attributes'][] = [
                'id' => $attribute['attribute_id'],
                'name' => $attribute['name'],
                'type' => $html_type,
                // 'html' => $that->html->buildElement($option_data),
                'values' => $selected_vals,
            ];
        }

        $view = new AView($this->registry, 0);
        $view->batchAssign($data);
        $that->view->addHookVar('order_attributes', $view->fetch('pages/checkout/order_attributes_confirm.tpl'));
    }

    public function onControllerPagesCheckoutSuccess_InitData()
    {
        $that = &$this->baseObject;
        if (isset($that->session->data['order_id'])) {
            /** @var ModelOrderOrderAttributes $mdl */
            $mdl = $that->loadModel('order/order_attributes');
            $mdl->addAttributesToOrder(
                $that->session->data['order_id'],
                $that->session->data['order_attributes']
            );

            unset($that->session->data['order_attributes']);
        }
    }

    public function onControllerPagesAccountInvoice_InitData()
    {
        $that =& $this->baseObject;
        $data = [];

        $that->loadLanguage('extension/order_attributes');
	//$that->loadLanguage('order_attributes/order_attributes');
        /** @var ModelOrderOrderAttributes $mdl */
        $mdl = $that->loadModel('order/order_attributes');
        $that->loadModel('account/order');

        $data['text_additional_attributes'] = $that->language->get('text_additional_attributes');

        if (isset($that->request->get['order_id'])) {
            $order_id = (int) $that->request->get['order_id'];
        } else {
            $order_id = 0;
        }

        $order_info = $that->model_account_order->getOrder($order_id, '', 'view');

        $guest = false;
        $enc = new AEncryption($that->config->get('encryption_key'));
        if (isset($that->request->get['ot']) && $that->config->get('config_guest_checkout')) {
            // try to decrypt order token
            $ot = $that->request->get['ot'];
            $decrypted = $enc->decrypt($ot);
            list($order_id, $email) = explode('::', $decrypted);

            $order_id = (int) $order_id;
            if (!$decrypted || !$order_id || !$email) {
                return null;
            }
            // $order_info = $that->model_account_order->getOrder($order_id, '', 'view');

            // compare emails
            if ($order_info['email'] != $email) {
                return null;
            }
            $guest = true;
        }

        $attributes = $mdl->getCustomerVisibleAttributes($order_id);
        // $this->baseObject->log->write(print_r($order_info, true).' $order_info info');
        // $this->baseObject->log->write(print_r($attributes, true).' $attributes in Invocie info');

        if ('default_cheque' == $order_info['payment_method_key']) {
        }

        $elements = HtmlElementFactory::getAvailableElements();
        $elements_with_options = HtmlElementFactory::getElementsWithOptions();

        // $this->baseObject->log->write($order_info['payment_method_key'].' INIT INVOICEZ');
        foreach ($attributes as $attribute) {
            if (!isset($attribute['element_type'])) {
                continue;
            }

            // hide only if
            /*if ($this->startsWith($attribute['name'], 'Payment:') and 'default_cheque' != $order_info['payment_method_key']) {
                continue;
            }*/

            // always hide
            if ($this->startsWith($attribute['name'], 'Payment:')) {
                continue;
            }

            $values = [];
            $value = [];
            if (count($attribute['selected_values']) > 1) {
                foreach ($attribute['selected_values'] as $val) {
                    $value[$val['order_attribute_value']] = $val['order_attribute_value'];
                }
            } else {
                $value = $attribute['selected_values'][0]['order_attribute_value'];
            }

            foreach ($attribute['values'] as $val) {
                $values[$val['attribute_value_id']] = $val['value'];
            }

            $selected_vals = [];
            if (in_array($attribute['element_type'], $elements_with_options)) {
                if (is_array($value)) {
                    if (in_array($attribute['element_type'], ['O', 'Z'])) { // for countries and zones
                        $selected_vals = $value;
                    } else {
                        foreach ($value as $val) {
                            $selected_vals[] = $values[$val];
                        }
                    }
                } else {
                    if (in_array($attribute['element_type'], ['O', 'Z'])) { // for countries and zones
                        $selected_vals[] = $value;
                    } else {
                        $selected_vals[] = $attribute['values'][$value]['value'];
                    }
                }
            } else {
                $selected_vals[] = $value;
            }

            $html_type = $elements[$attribute['element_type']]['type'];
            $data['attributes'][] = [
                'id' => $attribute['attribute_id'],
                'name' => $attribute['name'],
                'type' => $html_type,
                'values' => $selected_vals,
            ];
        }

        $view = new AView($this->registry, 0);
        $view->batchAssign($data);
        $that->view->addHookVar('order_attributes', $view->fetch('pages/checkout/order_attributes_invoice.tpl'));
    }

    protected function _validate($showIn = '')
    {
        $that = &$this->baseObject;
        /** @var ModelOrderOrderAttributes $mdl */
        $mdl = $that->model_order_order_attributes;
        $customer_group_id = $that->customer->getCustomerGroupId() ? : $that->config->get('config_customer_group_id');
        $errors = $mdl->validateAttributesForCreate(
            $customer_group_id,
            $that->request->post['attributes'],
            $showIn
        );

        if (!empty($errors)) {
            foreach ($errors as $id => $error) {
                $this->errors[$id] = $error;
            }

            return false;
        }

        return true;
    }

    protected function _is_attributes_presents($show_in)
    {
        $that = &$this->baseObject;
        /** @var ModelOrderOrderAttributes $mdl */
        $mdl = $that->model_order_order_attributes;
        $customer_group_id = $that->customer->getCustomerGroupId() ? : $that->config->get('config_customer_group_id');
        $attributes = $mdl->getAttributesForGroup($customer_group_id, $show_in);

        $is_visible = false;
        foreach ($attributes as $attribute) {
            if ($attribute['visible_by_customer']) {
                $is_visible = true;
                break;
            }
        }

        return $is_visible;
    }

    protected function sort_attributes($a, $b)
    {
        if ($a['sort_order'] == $b['sort_order']) {
            return 0;
        }

        return ($a['sort_order'] < $b['sort_order']) ? -1 : 1;
    }

    protected function _process_file_upload()
    {
        $that = &$this->baseObject;
        /** @var ModelOrderOrderAttributes $mdl */
        $mdl = $that->model_order_order_attributes;
        $fm = new AFile();

        foreach ($that->request->files['attributes']['name'] as $id => $name) {
            $attribute_data = $mdl->getAttributeInfo($id);

            if ($attribute_data['required'] && !has_value($name)) {
                $this->errors[$id] = $that->language->get('error_required');
            } else {
                if (!has_value($name)) {
                    continue;
                }

                $file_path_info = $fm->getUploadFilePath($attribute_data['settings']['directory'], $name);
                $that->request->post['attributes'][$id] = $file_path_info['name'];

                $file_data = [
                    'option_id' => $id,
                    'name' => $file_path_info['name'],
                    'path' => $file_path_info['path'],
                    'type' => $that->request->files['attributes']['type'][$id],
                    'tmp_name' => $that->request->files['attributes']['tmp_name'][$id],
                    'error' => $that->request->files['attributes']['error'][$id],
                    'size' => $that->request->files['attributes']['size'][$id],
                ];

                $file_errors = $fm->validateFileOption($attribute_data['settings'], $file_data);

                if (has_value($file_errors)) {
                    $this->errors[$id] = $file_errors[0];
                }

                if (!has_value($this->errors)) {
                    if (move_uploaded_file($file_data['tmp_name'], $file_path_info['path'])) {

                    $dataset = new ADataset('file_uploads', 'admin');
                    $dataset->addRows(
                        [
                                'date_added' => date("Y-m-d H:i:s", time()),
                            'name' => $file_path_info['name'],
                            'type' => $file_data['type'],
                            'section' => 'order_attribute',
                            'section_id' => $attribute_data['attribute_id'],
                                'path'       => $file_path_info['path'],
                            ]
                        );
                    } else {
                        $err = new AError(
                            'Cannot move file from '.$file_data['tmp_name'].' to '.$file_path_info['path']
                        );
                        $err->toLog()->toDebug()->toMessages();
                        $this->errors[$id] .= 'Cannot move file. Unexpected error.';
                    }
                }
            }
        }
    }

    public function onControllerPagesCatalogAttribute_UpdateData()
    {
        $form = $this->baseObject->data['form'];
        unset($form['fields']['attribute_parent']);
        $this->baseObject->view->assign('form', $form);
    }

    public function onControllerCommonListingGrid_InitData()
    {
        /** @var ControllerPagesSaleCustomerGroup $that */
        $that =& $this->baseObject;
        if (!in_array($that->data['table_id'], ['cg_grid', 'order_grid'])) {
            return;
        }

        if ($that->data['table_id'] == 'cg_grid') {
            $editUrl = $that->html->getSecureURL('sale/customer_group/update', '&customer_group_id=%ID%');
            $attrUrl = $that->html->getSecureURL('sale/order_attributes/update', '&customer_group_id=%ID%');
        } else {
            $editUrl = $that->html->getSecureURL('sale/order/details', '&order_id=%ID%');
            $attrUrl = $that->html->getSecureURL('sale/order_attributes/details', '&order_id=%ID%');
        }

        $that->loadLanguage('order_attributes/order_attributes');

        if (!$that->data['actions']['dropdown']) {
            $that->data['actions']['dropdown'] = [
                'text'     => $that->language->get('text_choose_action'),
                'href'     => $editUrl,
                'children' => [
                    'general' => [
                        'text' => $that->language->get('tab_general'),
                        'href' => $editUrl,
                    ],
                ],
            ];
        }
        $that->data['actions']['dropdown']['children']['order_attributes'] =
            [
                'text' => $that->language->get('order_attributes_name'),
                'href' => $attrUrl,
            ];
    }

    /** FAST CHECKOUT HOOKS */
    public function onControllerPagesCheckoutFastCheckout_InitData()
    {
        $that = $this->baseObject;
        $that->document->addStyle(
            [
                'rel' => 'stylesheet',
                'href'=> $that->view->templateResource('/javascript/jquery-ui/css/ui-lightness/jquery-ui-1.10.4.custom.css')
            ]
        );
        $that->document->addScript($that->view->templateResource('/javascript/jquery-ui/js/jquery-ui-1.10.4.custom.min.js'));
        $that->document->addScript($that->view->templateResource('/javascript/jquery/ui/jquery.ui.datepicker.js'));
        $that->document->addScript($that->view->templateResource('/javascript/jquery/ui/jquery.ui.datepicker.js'));
        $that->document->addScript($that->view->templateResource('/javascript/intl-tel-input/js/intlTelInput.min.js'));
        $that->document->addStyle(
            [
            'href' => $that->view->templateResource('/javascript/intl-tel-input/css/intlTelInput.css'),
            'rel'  => 'stylesheet',
            ]
        );
    }

    public function onControllerResponsesCheckoutPay_InitData()
    {
        $that = $this->baseObject;
        $that->loadLanguage('order_attributes/order_attributes');
    }

    public function onControllerResponsesCheckoutPay_UpdateData()
    {
        $that =& $this->baseObject;
        $that->view->addHookVar(
            'customer_additional_attributes',
            $this->fetchOrderAttributes(
                'pages/checkout/order_attributes_fc.tpl',
                false
            )
        );

        //validate attributes. If
        $that->request->post['attributes'] = $that->session->data['order_attributes'];
        $this->_validate('');
        //if some of attributes are required and have no values - hide payment methods selection
        if($this->errors){
            $that->data['show_payment'] = false;
            $that->data['payment_form'] = false;
        }

        $footer = $that->view->getData('footer');
        $footer .= "<script type=\"application/javascript\"> 
            $(document).ready( 
            function(){ 
                $('#order_attributes_table').find('input[type=radio], input[type=checkbox]')
                    .unbind('change')
                    .unbind('keypress'); 
                }
            );</script>";
        $that->view->assign('footer', $footer);

    }

    protected function fetchOrderAttributes( $tpl, $showIn = '' )
    {
        $that =& $this->baseObject;
        $data = [];

        /** @var ModelOrderOrderAttributes $mdl */
        $mdl = $that->loadModel('order/order_attributes');

        if (has_value($that->session->data['order_attributes_errors'])) {
            $data['errors'] = $that->session->data['order_attributes_errors'];
            unset($that->session->data['order_attributes_errors']);
        }

        $selected = [];
        if (isset($that->session->data['order_attributes'])) {
            $selected = $that->session->data['order_attributes'];
        }
        $data['text_additional_attributes'] = $that->language->get('text_additional_attributes');

        $attributes = $mdl->getAttributesForGroup(
            $that->customer->getCustomerGroupId(),
            $showIn
        );

        $elements = HtmlElementFactory::getAvailableElements();
        $html_multivalue_elements = HtmlElementFactory::getMultivalueElements();
        $elements_with_options = HtmlElementFactory::getElementsWithOptions();
        $allHiddens = true;
        $hiddens = [];
        foreach ($attributes as $attribute) {
            if(!$that->customer->isLogged()){
                if(!$attribute['show_guest_checkout']){
                    continue;
                }
            }
            $values = [];
            $value = (!empty($selected)) ? $selected[$attribute['attribute_id']] : '';
            $val_name = '';

            foreach ($attribute['values'] as $val) {
                $val_name = $val['value'];
                $values[$val['attribute_value_id']] = $val['value'];
            }

            if (!in_array($attribute['element_type'], $elements_with_options) && empty($value)) {
                $value = $val_name;
            }

            $html_type = $elements[$attribute['element_type']]['type'];

            $option_data = [
                'type'     => $html_type,
                'name'     => !in_array($attribute['element_type'], $html_multivalue_elements)
                    ? 'attributes['.$attribute['global_attribute_id'].']'
                    : 'attributes['.$attribute['global_attribute_id'].'][]',
                'value'    => $value,
                'options'  => $values,
                'required' => $attribute['required'],
            ];
            if ($html_type == 'checkbox') {
                $option_data['label_text'] = $value;
                if (!empty($option_data['value']) && !empty($selected)) {
                    $option_data['checked'] = true;
                }
            } elseif ($html_type == 'checkboxgroup') {
                $option_data['scrollbox'] = true;
            } elseif ($html_type == 'radio' && !empty($selected)) {
                $option_data['value'] = $selected[$attribute['attribute_id']][0];
            } elseif ($html_type == 'date') {
                $option_data['dateformat'] = format4Datepicker($that->language->get('date_format_short'));
            }
            $data['attributes'][] = [
                'id'   => $attribute['global_attribute_id'],
                'name' => $attribute['name'],
                'type' => $html_type,
                'html' => $that->html->buildElement($option_data),
            ];
            if($html_type != 'hidden'){
                $allHiddens = false;
            }else{
                $hiddens[$attribute['global_attribute_id']] = $option_data['value'];
            }
        }
        if(!$data['attributes']){
            return '';
        }
        //if all attributes are hidden - save it values into session and do not show attribute form on fastCheckout Form
        if ($allHiddens && $showIn === false) {
            $that->session->data['order_attributes'] = array_merge(
                (array) $that->session->data['order_attributes'],
                $hiddens
            );
            return '';
        }
        $view = new AView($this->registry, 0);
        $view->batchAssign($data);
        return $view->fetch( $tpl );
    }
    public function onControllerResponsesExtensionOrderAttributes_InitData()
    {
        $this->baseObject->loadLanguage('order_attributes/order_attributes');
    }
    public function onControllerResponsesExtensionOrderAttributes_UpdateData()
    {
        $that = $this->baseObject;
        if(!$that->request->is_POST()){
            return;
        }
        $that->loadModel('order/order_attributes');
        if (has_value($that->request->files['attributes']['name'])) {
            $this->_process_file_upload();
        }
        $this->_validate('');
        if (empty($this->errors)) {
            foreach ((array) $that->request->post['attributes'] as $key => $val) {
                $that->session->data['order_attributes'][$key] = $val;
            }
        }
        if($this->errors) {
            $that->data['output']['result'] = false;
            $that->data['output']['errors'] = $this->errors;
        }else{
            $that->data['output']['result'] = true;
            $that->data['output']['message'] = $that->language->get('order_attributes_success_applied');
        }
    }
    public function onControllerPagesCheckoutFastCheckout_UpdateData()
    {
        $that = $this->baseObject;
        $that->document->addScript($that->view->templateResource('/third_party/bootstrap-fileinput/js/fileinput.js'));
        $that->document->addStyle(
            [
                'href'  => $that->view->templateResource('/third_party/bootstrap-fileinput/css/fileinput.min.css'),
                'rel'   => 'stylesheet',
                'media' => 'screen',
            ]
        );
    }
    public function onControllerPagesAccountLogout_InitData()
    {
        unset($this->baseObject->session->data['order_attributes']);
    }
}
