<?php

if (!defined('DIR_CORE') || !IS_ADMIN) {
    header('Location: static_pages/');
}

/**
 * Class ControllerResponsesOrderAttributesAttributes
 *
 * @property ModelSaleOrderAttributes $model_sale_order_attributes
 */
class ControllerResponsesOrderAttributesAttributes extends AController
{
    /** @var AAttribute_Manager */
    protected $attribute_manager;

    public function get_attributes_list()
    {
        //init controller data
        $this->extensions->hk_InitData($this, __FUNCTION__);

        $this->loadModel('sale/order_attributes');
        $attributes = $this->model_sale_order_attributes->getAttributesForGroup(
            $this->request->get['customer_group_id'],
            $this->language->getContentLanguageID()
        );
        foreach ($attributes as $attr) {
            $this->data['attributes'][$attr['global_attribute_id']] = $attr['name'];
        }

        //update controller data
        $this->extensions->hk_UpdateData($this, __FUNCTION__);

        $this->load->library('json');
        $this->response->addJSONHeader();
        $this->response->setOutput(AJson::encode($this->data['attributes']));
    }

    public function remove_attribute()
    {
        $this->loadLanguage('order_attributes/order_attributes');
        $this->loadModel('sale/order_attributes');
        $this->model_sale_order_attributes->removeCustomerAttributeFromGroup(
            $this->request->get['attribute_id'],
            $this->request->get['customer_group_id']
        );
        $this->response->setOutput($this->language->get('text_attribute_removed'));
    }

    public function update_attribute()
    {
        $this->loadLanguage('order_attributes/order_attributes');
        $this->loadModel('sale/order_attributes');

        $data = $this->request->get;

        //needs to validate attribute properties
        // first - prepare data for validation
        if (!isset($data['required'])) {
            $data['required'] = 0;
        }

        if (has_value($data['regexp_pattern'])) {
            $data['regexp_pattern'] = trim($data['regexp_pattern']);
            if ($data['regexp_pattern'][0] != '/') {
                $data['regexp_pattern'] = '/'.$data['regexp_pattern'].'/';
            }
        }

        $this->attribute_manager = new AAttribute_Manager('order_attribute');
        $data['attribute_type_id'] = $this->attribute_manager->getAttributeTypeID('order_attribute');

        $errors = $this->attribute_manager->validateAttributeCommonData($data);

        if (!$errors) {
            $this->model_sale_order_attributes->updateAttribute($data);
            $this->response->setOutput($this->language->get('text_success_attribute'));
        } else {
            $error = new AError('');
            $error->toJSONResponse(
                '',
                ['error_title' => implode('<br>', $errors)]
            );
        }
    }

    public function update_attribute_values()
    {
        $this->loadLanguage('order_attributes/order_attributes');
        $this->loadModel('sale/order_attributes');
        $this->model_sale_order_attributes->updateGlobalAttributeValues(
            $this->request->get['attribute_id'], $this->request->post
        );
        $this->session->data['success'] = $this->language->get('text_success_attribute');

        redirect(
            $this->html->getSecureURL(
                'order_attributes/attributes/load_attribute',
                '&customer_group_id='.$this->request->get['customer_group_id'].
                '&attribute_id='.$this->request->get['attribute_id']
            )
        );
    }

    public function load_attribute()
    {
        $this->loadLanguage('catalog/attribute');
        $this->loadLanguage('order_attributes/order_attributes');

        $this->loadModel('sale/order_attributes');

        $this->view->assign('success', $this->session->data['success']);
        unset($this->session->data['success']);

        $this->data['language_id'] = $this->language->getContentLanguageID();
        $this->data['attribute_data'] = $this->model_sale_order_attributes->getAttributeInfo(
            $this->request->get['attribute_id'],
            'edit'
        );

        $this->data['element_types'] = HtmlElementFactory::getAvailableElements();

        $this->data['elements_with_options'] = HtmlElementFactory::getElementsWithOptions();
        $this->data['selectable'] = in_array($this->data['attribute_data']['element_type'], $this->data['elements_with_options'])
                                    ? 1
                                    : 0;
        $this->data['attribute_type'] = $this->data['element_types'][$this->data['attribute_data']['element_type']]['type'];
        $this->data['no_set_values_elements'] = [
            'D',// => 'date',
            'A',// => 'IPaddress',
            'O',// => 'countries',
            'Z',// => 'zones',
            'K',// => 'captcha'
            'U',
        ];

        $this->attribute_manager = new AAttribute_Manager();

        $this->data['update_attribute'] = $this->html->getSecureURL(
            'order_attributes/attributes/update_attribute',
            '&customer_group_id='.$this->request->get['customer_group_id'].
            '&attribute_id='.$this->request->get['attribute_id']
        );

        $this->data['attribute_name'] = $this->html->buildElement(
            [
                'type'  => 'input',
                'name'  => 'name',
                'value' => $this->data['attribute_data']['name'],
            ]
        );
        $this->data['status'] = $this->html->buildElement(
            [
                'type'  => 'checkbox',
                'name'  => 'status',
                'value' => $this->data['attribute_data']['status'],
                'style' => 'btn_switch btn-group-xs',
            ]
        );

        $this->data['attribute_sort_order'] = $this->html->buildElement(
            [
                'type'  => 'input',
                'name'  => 'sort_order',
                'value' => $this->data['attribute_data']['sort_order'],
                'style' => 'small-field',
            ]
        );

        $this->data['show_shipping'] = $this->html->buildElement(
            [
                'type'    => 'checkbox',
                'name'    => 'show_shipping',
                'value'   => 1,
                'checked' => (bool) $this->data['attribute_data']['show_shipping'],
                'style'   => 'btn_switch btn-group-xs',
            ]
        );

        $this->data['show_payment'] = $this->html->buildElement(
            [
                'type'    => 'checkbox',
                'name'    => 'show_payment',
                'value'   => 1,
                'checked' => (bool) $this->data['attribute_data']['show_payment'],
                'style'   => 'btn_switch btn-group-xs',
            ]
        );

        $this->data['show_guest_checkout'] = $this->html->buildElement(
            [
                'type'    => 'checkbox',
                'name'    => 'show_guest_checkout',
                'value'   => 1,
                'checked' => (bool) $this->data['attribute_data']['show_guest_checkout'],
                'style'   => 'btn_switch btn-group-xs',
            ]
        );

        $this->data['visible'] = $this->html->buildElement(
            [
                'type'    => 'checkbox',
                'name'    => 'visible',
                'value'   => 1,
                'checked' => $this->data['attribute_data']['visible_by_customer'],
                'style'   => 'btn_switch btn-group-xs',
            ]
        );

        $this->data['required'] = $this->html->buildElement(
            [
                'type'    => 'checkbox',
                'name'    => 'required',
                'value'   => 1,
                'checked' => (bool) $this->data['attribute_data']['required'],
                'style'   => 'btn_switch btn-group-xs',
            ]
        );
        $this->data['element_type'] = $this->html->buildElement(
            [
                'type'  => 'hidden',
                'name'  => 'element_type',
                'value' => $this->data['attribute_data']['element_type'],
            ]
        );

        $this->data['update_attribute_values'] = $this->html->getSecureURL(
            'order_attributes/attributes/update_attribute_values',
            '&customer_group_id='.$this->request->get['customer_group_id'].
            '&attribute_id='.$this->request->get['attribute_id']
        );

        $this->data['remove_attribute_link'] = $this->html->getSecureURL(
            'order_attributes/attributes/remove_attribute',
            '&customer_group_id='.$this->request->get['customer_group_id'].
            '&attribute_id='.$this->request->get['attribute_id']
        );

        // form of option values list
        $form = new AForm('HT');
        $form->setForm(['form_name' => 'update_option_values']);
        $this->data['form']['id'] = 'update_option_values';
        $this->data['update_option_values_form']['open'] = $form->getFieldHtml(
            [
                'type'   => 'form',
                'name'   => 'update_option_values',
                'action' => $this->data['update_attribute_values'],
            ]
        );

        //form of option
        $form = new AForm('HT');
        $form->setForm(
            [
                'form_name' => 'option_value_form',
            ]
        );

        $this->data['form']['id'] = 'option_value_form';
        $this->data['form']['form_open'] = $form->getFieldHtml(
            [
                'type'   => 'form',
                'name'   => 'option_value_form',
                'action' => $this->data['update_attribute_values'],
            ]
        );

        //Load option values rows
        if ($this->data['attribute_data']['element_type'] == 'U') {
            $this->_file_upload_settings_form();
        } else {
            $this->data['entry_regexp_pattern'] = $this->language->get('entry_regexp_pattern');
            $this->data['regexp_pattern'] = $this->html->buildElement(
                [
                    'type'  => 'input',
                    'name'  => 'regexp_pattern',
                    'value' => $this->data['attribute_data']['regexp_pattern'],
                    'style' => 'medium-field',
                ]
            );

            $this->data['entry_error_text'] = $this->language->get('entry_error_text');
            $this->data['error_text'] = $this->html->buildElement(
                [
                    'type'  => 'input',
                    'name'  => 'error_text',
                    'value' => $this->data['attribute_data']['error_text'],
                    'style' => 'large-field',
                ]
            );
            $this->data['attribute_values'] = [];

            foreach ($this->data['attribute_data']['values'] as $key => $item) {
                $this->data['attribute_values'][$key]['row'] = $this->attributeValueForm($item, $form);
            }
        }

        $this->data['button_remove_attribute'] = $this->html->buildElement(
            [
                'type'  => 'button',
                'href'  => $this->html->getSecureURL(
                    'order_attributes/attributes/remove_attribute',
                    '&attribute_id='.$this->request->get['attribute_id'].'&customer_group_id='
                    .$this->request->get['customer_group_id']
                ),
                'text'  => $this->language->get('button_remove_attribute'),
                'style' => 'button3',
            ]
        );
        $this->data['button_save'] = $this->html->buildElement(
            [
                'type'  => 'button',
                'text'  => $this->language->get('button_save'),
                'style' => 'button1',
            ]
        );
        $this->data['button_reset'] = $this->html->buildElement(
            [
                'type'  => 'button',
                'text'  => $this->language->get('button_reset'),
                'style' => 'button2',
            ]
        );

        $this->data['update_attribute_values'] = $this->html->getSecureURL(
            'sale/customer_attributes_response/update_attribute_values',
            '&customer_group_id='.$this->request->get['customer_group_id'].
            '&attribute_id='.$this->request->get['attribute_id']
        );

        $this->data['remove_attribute_link'] = $this->html->getSecureURL(
            'order_attributes/attributes/remove_attribute',
            '&customer_group_id='.$this->request->get['customer_group_id'].
            '&attribute_id='.$this->request->get['attribute_id']
        );

        $this->data['new_attribute_row'] = '';

        if (in_array($this->data['attribute_data']['element_type'], $this->data['elements_with_options'])
            || $this->data['empty_values']
        ) {
            $this->data['new_attribute_row'] = $this->attributeValueForm([], $form);
        }

        $this->view->batchAssign($this->data);
        $this->processTemplate('responses/order_attributes/attribute_values.tpl');
    }

    /**
     * @param $item
     * @param AForm $form
     *
     * @return string
     * @throws AException
     */
    private function attributeValueForm($item, $form)
    {
        if (isset($item['attribute_value_id'])) {
            $attribute_value_id = $item['attribute_value_id'];
            $this->data['row_id'] = 'row'.$attribute_value_id;
            $this->data['attr_val_id'] = $attribute_value_id;
        } else {
            $this->data['row_id'] = 'new_row';
            $attribute_value_id = null;
        }

        $this->data['form']['fields']['attribute_value_id'] = $form->getFieldHtml(
            [
                'type'  => 'hidden',
                'name'  => 'attribute_value_id['.$attribute_value_id.']',
                'value' => $attribute_value_id,
            ]
        );

        $this->data['form']['fields']['attribute_value'] = $form->getFieldHtml(
            [
                'type'  => 'input',
                'name'  => 'name['.$attribute_value_id.']',
                'value' => $item['value'],
                'style' => $this->data['attribute_data']['element_type'] == 'H' && !$item['value'] ? 'alert alert-danger' : '',
                'placeholder' => 'please set a value!'
            ]
        );

        $this->data['form']['fields']['sort_order'] = $form->getFieldHtml(
            [
                'type'  => 'input',
                'name'  => 'sort_order['.$attribute_value_id.']',
                'value' => $item['sort_order'],
                'style' => 'small-field',
            ]
        );

        $this->view->batchAssign($this->data);
        return $this->view->fetch('responses/order_attributes/attribute_value_row.tpl');
    }

    /**
     * method that return part of attribute form
     *
     * @param array $params
     *
     * @throws AException
     * @internal param array $param
     */
    public function getOrderAttributeSubform($params = [])
    {
        $attributes_fields = [];
        $atr_val_id = null;

        //init controller data
        $this->extensions->hk_InitData($this, __FUNCTION__);
        $this->loadLanguage('catalog/attribute');
        $this->loadLanguage('order_attributes/order_attributes');

        $this->data = array_merge($this->data, $params['data']);

        // remove form fields that do not needed here
        unset($this->data['form']['fields']);

        $this->data['elements_with_options'] = HtmlElementFactory::getElementsWithOptions();

        $k = array_search('Z', $this->data['elements_with_options']);
        unset($this->data['elements_with_options'][$k]);
        $k = array_search('O', $this->data['elements_with_options']);
        unset($this->data['elements_with_options'][$k]);

        $results = HtmlElementFactory::getAvailableElements();
        $element_types = ['' => $this->language->get('text_select')];
        foreach ($results as $key => $type) {
            // allowed field types
            if (!in_array($key, ['P', 'L', 'Z'])) {
                $element_types[$key] = $type['type'];
            }
        }
        /**
         * @var $form AForm
         */
        $form = $params['aform'];
        /**
         * @var $attribute_manager AAttribute_Manager
         */
        $attribute_manager = $params['attribute_manager'];

        $this->data['form']['fields']['element_type'] = $form->getFieldHtml(
            [
                'type'     => 'selectbox',
                'name'     => 'element_type',
                'value'    => $this->data['element_type'],
                'required' => true,
                'options'  => $element_types,
            ]
        );
        $this->data['form']['fields']['sort_order'] = $form->getFieldHtml(
            [
                'type'  => 'input',
                'name'  => 'sort_order',
                'value' => $this->data['sort_order'],
                'style' => 'small-field',
            ]
        );
        $this->data['form']['fields']['required'] = $form->getFieldHtml(
            [
                'type'    => 'checkbox',
                'name'    => 'required',
                'value'   => 1,
                'checked' => (bool) $this->data['required'],
            ]
        );

        $this->data['form']['fields']['regexp_pattern'] = $form->getFieldHtml(
            [
                'type'  => 'input',
                'name'  => 'regexp_pattern',
                'value' => $this->data['regexp_pattern'],
                'style' => 'large-field',
            ]
        );
        $this->data['form']['fields']['error_text'] = $form->getFieldHtml(
            [
                'type'  => 'input',
                'name'  => 'error_text',
                'value' => $this->data['error_text'],
                'style' => 'large-field',
            ]
        );

        //Build attribute values part of the form
        if ($this->request->get['attribute_id']) {
            $this->data['child_count'] = $attribute_manager->totalChildren($this->request->get['attribute_id']);
            if ($this->data['child_count'] > 0) {
                $children_attr = $attribute_manager->getAttributes([], 0, $this->request->get['attribute_id']);
                foreach ($children_attr as $attr) {
                    $this->data['children'][] = [
                        'name' => $attr['name'],
                        'link' => $this->html->getSecureURL(
                            'catalog/attribute/update',
                            '&attribute_id='.$attr['attribute_id']
                        ),
                    ];
                }
            }

            $attribute_values = $attribute_manager->getAttributeValues($this->request->get['attribute_id']);
            foreach ($attribute_values as $atr_val) {
                $atr_val_id = $atr_val['attribute_value_id'];
                $attributes_fields[$atr_val_id]['sort_order'] = $form->getFieldHtml(
                    [
                        'type'  => 'input',
                        'name'  => 'sort_orders['.$atr_val_id.']',
                        'value' => $atr_val['sort_order'],
                        'style' => 'small-field',
                    ]
                );
                $attributes_fields[$atr_val_id]['values'] = $form->getFieldHtml(
                    [
                        'type'  => 'input',
                        'name'  => 'values['.$atr_val_id.']',
                        'value' => $atr_val['value'],
                        'style' => 'medium-field',
                    ]
                );
                $attributes_fields[$atr_val_id]['attribute_value_ids'] = $form->getFieldHtml(
                    [
                        'type'  => 'hidden',
                        'name'  => 'attribute_value_ids['.$atr_val_id.']',
                        'value' => $atr_val_id,
                        'style' => 'medium-field',
                    ]
                );
            }
        }
        if (!$attributes_fields) {
            $attributes_fields[0]['sort_order'] = $form->getFieldHtml(
                [
                    'type'  => 'input',
                    'name'  => 'sort_orders[]',
                    'value' => '',
                    'style' => 'small-field no-save',
                ]
            );
            $attributes_fields[0]['values'] = $form->getFieldHtml(
                [
                    'type'  => 'input',
                    'name'  => 'values[]',
                    'value' => '',
                    'style' => 'medium-field no-save',
                ]
            );
            $attributes_fields[0]['attribute_value_ids'] = $form->getFieldHtml(
                [
                    'type'  => 'hidden',
                    'name'  => 'attribute_value_ids['.$atr_val_id.']',
                    'value' => 'new',
                    'style' => 'medium-field',
                ]
            );
        }

        $this->data['form']['settings_fields'] = [
            'extensions' => $form->getFieldHtml(
                [
                    'type'  => 'input',
                    'name'  => 'settings[extensions]',
                    'value' => $this->data['settings']['extensions'],
                    'style' => 'no-save',
                ]
            ),
            'min_size'   => $form->getFieldHtml(
                [
                    'type'  => 'input',
                    'name'  => 'settings[min_size]',
                    'value' => $this->data['settings']['min_size'],
                    'style' => 'small-field no-save',
                ]
            ),
            'max_size'   => $form->getFieldHtml(
                [
                    'type'  => 'input',
                    'name'  => 'settings[max_size]',
                    'value' => $this->data['settings']['max_size'],
                    'style' => 'small-field no-save',
                ]
            ),
            'directory'  => $form->getFieldHtml(
                [
                    'type'  => 'input',
                    'name'  => 'settings[directory]',
                    'value' => $this->data['settings']['directory'],
                    'style' => 'no-save',
                ]
            ),
        ];
        $this->data['entry_upload_dir'] = sprintf($this->language->get('entry_upload_dir'), 'admin/system/upload/');
        $this->data['form']['attribute_values'] = $attributes_fields;
        $this->view->batchAssign($this->data);

        //update controller data
        $this->extensions->hk_UpdateData($this, __FUNCTION__);
        $this->processTemplate('responses/order_attributes/global_attribute_order_attribute_subform.tpl');
    }

    protected function _file_upload_settings_form()
    {
        $this->data['extensions'] = $this->html->buildElement(
            [
                'type'  => 'input',
                'name'  => 'settings[extensions]',
                'value' => $this->data['attribute_data']['settings']['extensions'],
                'style' => 'no-save',
            ]
        );

        $this->data['min_size'] = $this->html->buildElement(
            [
                'type'  => 'input',
                'name'  => 'settings[min_size]',
                'value' => $this->data['attribute_data']['settings']['min_size'],
                'style' => 'small-field no-save',
            ]
        );
        $this->data['max_size'] = $this->html->buildElement(
            [
                'type'  => 'input',
                'name'  => 'settings[max_size]',
                'value' => $this->data['attribute_data']['settings']['max_size'],
                'style' => 'small-field no-save',
            ]
        );
        $this->data['directory'] = $this->html->buildElement(
            [
                'type'  => 'input',
                'name'  => 'settings[directory]',
                'value' => $this->data['attribute_data']['settings']['directory'],
                'style' => 'no-save',
            ]
        );

        $this->data['entry_upload_dir'] = sprintf($this->language->get('entry_upload_dir'), 'admin/system/upload/');
    }
}