<?php
if ( !defined ( 'DIR_CORE' )) {
	header ( 'Location: static_pages/' );
}

class ModelOrderOrderAttributes extends Model {

	private $showIn = array('shipping', 'payment', 'guest_checkout');

	public function getAttributesForGroup($customer_group_id, $showIn = '') {

		if ( $showIn != '' && !in_array($showIn, $this->showIn) ) {
			return array();
		}

		$languageID = $this->config->get('storefront_language_id');

		$where = "gad.language_id = " . (int) $languageID . "
				AND oag.visible_by_customer = 1
				AND oag.status = 1";

		if ( $showIn != '' ) {
			$where .= " AND oag.customer_group_id = " . (int) $customer_group_id;
			$where .= " AND oag.show_" . $showIn . " = 1";
		}

		$sql = "SELECT
					oag.global_attribute_id,
					oag.customer_group_id,
					oag.show_shipping,
					oag.show_payment,
					oag.show_guest_checkout,
					oag.visible_by_customer,
					gad.name,
					gad.error_text,
					ga.attribute_id,
					ga.element_type,
					ga.sort_order,
					ga.settings,
					ga.required,
					ga.regexp_pattern
				FROM " . $this->db->table('order_attributes_to_groups')." oag
				INNER JOIN " . $this->db->table('global_attributes_descriptions')." gad ON oag.global_attribute_id = gad.attribute_id
				INNER JOIN " . $this->db->table('global_attributes')." ga ON oag.global_attribute_id = ga.attribute_id
				WHERE " . $where . "
				ORDER BY ga.sort_order ASC";
		$results = $this->db->query($sql);
		foreach ( $results->rows as &$row ) {
			if ( has_value($row['settings']) ) {
				$row['settings'] = unserialize($row['settings']);
			}
			$row['values'] = $this->getAttributeValues($row['attribute_id'], $languageID);
		}
		return $results->rows;
	}

	private function getAttributeValues($attribute_id, $language_id) {

		$sql = "SELECT gav.attribute_value_id, gav.sort_order, gavd.value
				FROM " . $this->db->table('global_attributes_values')." gav
				INNER JOIN " . $this->db->table('global_attributes_value_descriptions')." gavd
						ON gav.attribute_value_id = gavd.attribute_value_id
				WHERE gav.attribute_id = " . (int) $attribute_id . " AND gavd.language_id = " . (int) $language_id . "
				ORDER BY gav.sort_order ASC";

		$results = $this->db->query($sql);
		return $results->rows;
	}

	public function addAttributesToOrder($orderID, $data) {
		$data = (array)$data;
		foreach ( $data as $attr_id => $val ) {
			$this->db->query(  "INSERT INTO " . $this->db->table('order_attributes')."
								SET global_attribute_id = " . (int) $attr_id . ",
									order_id = " . (int) $orderID );

			$id = $this->db->getLastId();

			if ( is_array($val) ) {
				foreach ( $val as $attr_val ) {
					$this->db->query("INSERT INTO " . $this->db->table('order_attribute_values') . "
						SET
							order_attribute_id = " . $id . ",
							order_attribute_value = '" . $this->db->escape($attr_val) . "'"
					);
				}
			} else {
				$this->db->query("INSERT INTO " . $this->db->table('order_attribute_values') . "
					SET
						order_attribute_id = " . $id . ",
						order_attribute_value = '" . $this->db->escape($val) . "'"
				);
			}
		}

	}

	public function getCustomerVisibleAttributes($orderID) {
		$global = $this->getVisibleAttributes($orderID);

		$attributes = array();
		foreach ( $global as $val ) {
			$attribute = $this->db->query(
				"SELECT oa.order_attribute_id, oa.global_attribute_id
				FROM " . $this->db->table('order_attributes')." oa
				INNER JOIN " . $this->db->table('global_attributes ga')." ON oa.global_attribute_id = ga.attribute_id
				WHERE oa.order_id = " . (int) $orderID . "
					AND oa.global_attribute_id = " . $val['global_attribute_id']."
				ORDER BY ga.sort_order"

			);

			$results = $attribute->rows;

			foreach ( $results as &$item ) {
				$selected_values = $this->db->query(
					"SELECT order_attribute_value_id, order_attribute_value
					FROM " . $this->db->table('order_attribute_values') . "
					WHERE order_attribute_id = " . $item['order_attribute_id']
				);
				$item['selected_values'] = $selected_values->rows;

				$item = array_merge($item, $this->getAttributeInfo($item['global_attribute_id']));
				$attributes[] = $item;
			}

		}

		return $attributes;
	}

	public function getVisibleAttributes($orderID) {

		$results = $this->db->query(
			"SELECT oag.global_attribute_id
			FROM " . $this->db->table('order_attributes_to_groups')." oag
			INNER JOIN " . $this->db->table('orders')." o
				ON oag.customer_group_id = o.customer_group_id
			INNER JOIN " . $this->db->table('global_attributes')." ga ON oag.global_attribute_id = ga.attribute_id
			WHERE o.order_id = " . (int) $orderID . " AND oag.visible_by_customer = 1
			ORDER BY ga.sort_order");

		return $results->rows;
	}

	public function validateAttributesForEdit($customerID, $data) {

		$errors = array();

		$check = $this->getCustomerVisibleAttributes($customerID);
		foreach ( $check as $check_attr ) {
			//for captcha
			if($check_attr['element_type']=='K'
				&& (!isset($this->session->data['captcha']) || $this->session->data['captcha'] != $data[$check_attr['global_attribute_id']])
			){
				$errors[$check_attr['global_attribute_id']] = $this->language->get('error_captcha');
			}
			if ( empty($data[$check_attr['order_attribute_id']]) && $check_attr['required'] == 1 ) {
				$errors[$check_attr['order_attribute_id']] = $this->language->get('error_required');
			}else if(!empty($data[$check_attr['global_attribute_id']]) && !preg_match($check_attr['regexp_pattern'],$data[$check_attr['global_attribute_id']])){
				$errors[$check_attr['global_attribute_id']] = $check_attr['error_text'];
			}
		}
		return $errors;
	}

	//MOD
	public function startsWith($string, $startString)
	{
			$len = strlen($startString);

			return substr($string, 0, $len) === $startString;
	}


	public function validateAttributesForCreate($groupID, $data, $showIn = '') {

		$errors = array();
		$check = $this->getAttributesForGroup($groupID, $showIn);

		foreach ( $check as $check_attr ) {
			//for captcha
			if($check_attr['element_type']=='K'
				&& (!isset($this->session->data['captcha']) || $this->session->data['captcha'] != $data[$check_attr['global_attribute_id']])
			){
				$errors[$check_attr['global_attribute_id']] = $this->language->get('error_captcha');
			}
			if ( empty($data[$check_attr['global_attribute_id']]) && $check_attr['required'] == 1 ) {
				//$this->log->write(print_r($check_attr, true).' $check_attr in MODEL foreach');

				//MOD
				if ($this->startsWith($check_attr['name'], 'Payment:')) {
						//$required = false; // allow to skip
						//$check_attr['name'] = $this->str_replace_first('Payment:', '', $check_attr['name']);
				} else {
						//$required = $check_attr['required'];
						$errors[$check_attr['global_attribute_id']] = $this->language->get('error_required');
				}


			}else if($check_attr['regexp_pattern'] && !empty($data[$check_attr['global_attribute_id']])){
					if(!is_array($data[$check_attr['global_attribute_id']])){
						if(!preg_match($check_attr['regexp_pattern'],$data[$check_attr['global_attribute_id']])){
							$errors[$check_attr['global_attribute_id']] = $check_attr['error_text'];
						}
					}else{
						foreach($data[$check_attr['global_attribute_id']] as $dd){
							if(!preg_match($check_attr['regexp_pattern'],$dd)){
								$errors[$check_attr['global_attribute_id']] = $check_attr['error_text'];
								break;
							}
						}
					}
			}
		}
		return $errors;
	}

	public function getAttributeInfo($attrID) {
		$languageID = $this->config->get('storefront_language_id');
		$results = $this->db->query(
			"SELECT
				oag.customer_group_id,
				oag.show_shipping,
				oag.show_payment,
				oag.show_guest_checkout,
				oag.visible_by_customer,
				oag.status,
				gad.name,
				gad.error_text,
				ga.attribute_id,
				ga.element_type,
				ga.sort_order,
				ga.settings,
				ga.required,
				ga.regexp_pattern
			FROM " . $this->db->table('order_attributes_to_groups')." oag
			INNER JOIN " . $this->db->table('global_attributes_descriptions')." gad ON oag.global_attribute_id = gad.attribute_id
			INNER JOIN " . $this->db->table('global_attributes')." ga ON oag.global_attribute_id = ga.attribute_id
			WHERE
				ga.attribute_id = " . (int) $attrID . "
				AND language_id = " . (int) $languageID . "
				AND ga.status = 1
			ORDER BY ga.sort_order ASC"
		);

		if ( has_value($results->row['settings']) ) {
			$results->row['settings'] = unserialize($results->row['settings']);
		}

		$values = $this->getAttributeValues($results->row['attribute_id'], $languageID);

		$results->row['values'] = array();

		foreach ( $values as $val ) {
			$results->row['values'][$val['attribute_value_id']] = $val;
		}
		return $results->row;
	}


	public function getOrderAttributes($orderID) {

		$attributes = $this->db->query("
			SELECT order_attribute_id, global_attribute_id
			FROM " . $this->db->table('order_attributes')."
			WHERE order_id = " . (int) $orderID
		);

		$results = $attributes->rows;

		foreach ( $results as &$item ) {
			$selected_values = $this->db->query(
				"SELECT order_attribute_value_id, order_attribute_value
				FROM " . $this->db->table('order_attribute_values') . "
				WHERE order_attribute_id = " . $item['order_attribute_id']
			);
			$item['selected_values'] = $selected_values->rows;

			$item = array_merge($item, $this->getAttributeInfo($item['global_attribute_id']));
		}

		return $results;
	}

	public function getOrderAttributesIds($orderID) {
		$ids = array();
		$res = $this->db->query('SELECT order_attribute_id FROM ' . $this->db->table('order_attributes').' WHERE order_id = ' . (int) $orderID);
		foreach ( $res->rows as $row ) {
			$ids[] = $row['order_attribute_id'];
		}
		return $ids;
	}


}
