<?php
if ( !defined ( 'DIR_CORE' )) {
	header ( 'Location: static_pages/' );
}
/**
 * Class ExtensionOrderAttributes
 *
 */
class ExtensionOrderAttributes extends Extension {

	public $errors = array();
	public $data = array();
	protected $registry;

	public function  __construct() {
		$this->registry = Registry::getInstance();
	}
	
	public function onControllerResponsesCommonTabs_InitData() {
		if($this->baseObject->parent_controller!='sale/customer_group'){ return null;}
		$that =& $this->baseObject;
		if ( !isset($that->request->get['customer_group_id']) ) { return null; }

		$that->loadLanguage('extension/order_attributes');

		$that->data['tabs']['order_attributes'] = array(
			'name' => 'order_attributes',
			'text' => $that->language->get('order_attributes_name'),
			'href' => $that->html->getSecureURL('sale/order_attributes/update', '&customer_group_id=' . $that->request->get['customer_group_id']),
			'active' => $that->request->get['rt']=='sale/order_attributes/update' ? true : false,
			'sort_order' => 2
		);
	}



	public function onControllerPagesSaleOrder_InitData() {
		$this->baseObject->loadLanguage('extension/order_attributes');
	}

	public function onControllerPagesSaleOrderTabs_UpdateData() {
		$that =& $this->baseObject;
		$groups = $that->view->getData('groups');
		$groups[] = 'order_attributes';
		$that->view->assign('groups', $groups);
		$that->view->assign('link_order_attributes', $that->html->getSecureURL('sale/order_attributes/details', '&order_id=' . $that->request->get['order_id']));
		$that->view->assign('tab_order_attributes', $that->language->get('order_attributes_name'));
		if($that->data['parent_controller'] == 'sale/order_attributes/details'){
			$that->view->assign('active', 'order_attributes');
		}
	}

	public function onControllerPagesCheckoutShipping_InitData() {
		$that =& $this->baseObject;

		$that->loadLanguage('extension/order_attributes');
		$that->loadModel('order/order_attributes');

		if ( $that->request->is_POST() ) {
			if ( has_value($that->request->files['attributes']['name']) ) {
				$this->_process_file_upload();
			}
			if ( $this->_validate('shipping') && empty($this->errors) ) {
				foreach ((array)$that->request->post['attributes'] as $key => $val) {
					$that->session->data['order_attributes'][$key] = $val;
				}
			} else {
				$that->session->data['order_attributes_errors'] = $this->errors;
				header('Location: ' . $that->html->getSecureURL('checkout/shipping','&mode=edit'));
				exit();
			}
		}else{
			if($this->_is_attributes_presents('shipping') && $that->request->get['mode']!='edit'){
				header('Location: ' . $that->html->getSecureURL('checkout/shipping','&mode=edit'));
				exit(); //forbid skipping of shipping page
			}
		}

	}

	public function onControllerPagesCheckoutShipping_UpdateData() {
		$that =& $this->baseObject;
		$data = array();

		if ( has_value($that->session->data['order_attributes_errors']) ) {
			$data['errors'] = $that->session->data['order_attributes_errors'];
			unset($that->session->data['order_attributes_errors']);
		}

		$selected = array();
		if ( isset($that->session->data['order_attributes']) ) {
			$selected = $that->session->data['order_attributes'];
		}

		$data['text_additional_attributes'] = $that->language->get('text_additional_attributes');
		$attributes = $that->model_order_order_attributes->getAttributesForGroup(
			$that->customer->getCustomerGroupId(),
			'shipping'
		);

		$elements = HtmlElementFactory::getAvailableElements();
		$html_multivalue_elements = HtmlElementFactory::getMultivalueElements();
		$elements_with_options = HtmlElementFactory::getElementsWithOptions();

		foreach ( $attributes as $attribute ) {

			$values = array();
			$value = ( !empty($selected) ) ? $selected[$attribute['attribute_id']] : '';
			$val_name = '';

			foreach ( $attribute['values'] as $val ) {
				$val_name = $val['value'];
				$values[$val['attribute_value_id']] = $val['value'];
			}

			if ( !in_array($attribute['element_type'], $elements_with_options) && empty($value) ) {
				$value = $val_name;
			}

			$html_type = $elements[ $attribute['element_type'] ]['type'];

			$option_data = array(
				'type' => $html_type,
				'name' => !in_array($attribute['element_type'], $html_multivalue_elements) ? 'attributes['.$attribute['global_attribute_id'].']' : 'attributes['.$attribute['global_attribute_id'].'][]',
				'value' => $value,
				'options' => $values,
				'required' => $attribute['required']
			);


			if ( $html_type == 'checkbox' ) {
				if($value==''){
				    $value = 1;
					$option_data['value'] = $value;
			    }
				if(!in_array($value, array('0','1'))){
				  $option_data['label_text'] = $value;
				}
			    $option_data['checked'] = $preset_value ? true : false;

			} elseif ( $html_type == 'checkboxgroup' ) {
				$option_data['scrollbox'] = true;
			} elseif ( $html_type == 'radio' && !empty($selected) ) {
				$option_data['value'] = $selected[$attribute['attribute_id']][0];
			} elseif ( $html_type == 'date' ) {
				$option_data['dateformat'] = format4Datepicker($that->language->get('date_format_short'));
			}

			$data['attributes'][] = array(
				'id' => $attribute['global_attribute_id'],
				'name' => $attribute['name'],
				'type' => $html_type,
				'html' => $that->html->buildElement($option_data),
			);

		}

		$view = new AView($this->registry, 0);
		$view->batchAssign($data);
		$that->view->addHookVar('order_attributes', $view->fetch('pages/checkout/order_attributes.tpl'));
	}

	public function onControllerPagesCheckoutPayment_InitData() {
		$this->baseObject->loadLanguage('extension/order_attributes');
	}
	public function onControllerPagesCheckoutPayment_processData() {
		$that =& $this->baseObject;
		$that->loadModel('order/order_attributes');

		if ( $that->request->is_POST() ) {

			if ( has_value($that->request->files['attributes']['name']) ) {
				$this->_process_file_upload();
			}

			if ( $this->_validate('payment') && empty($this->errors) ) {
				foreach ((array)$that->request->post['attributes'] as $key => $val) {
					$that->session->data['order_attributes'][$key] = $val;
				}
			} else {
				$that->session->data['order_attributes_errors'] = $this->errors;
				header('Location: ' . $that->html->getSecureURL('checkout/payment','&mode=edit'));
				exit();
			}
		}else{
			if($this->_is_attributes_presents('payment') && $that->request->get['mode']!='edit'){
				header('Location: ' . $that->html->getSecureURL('checkout/payment','&mode=edit'));
				exit(); // forbid skipping of payment page
			}
		}
	}

	public function onControllerPagesCheckoutPayment_UpdateData() {
		$that =& $this->baseObject;
		$data = array();

		$that->loadModel('order/order_attributes');

		if ( has_value($that->session->data['order_attributes_errors']) ) {
			$data['errors'] = $that->session->data['order_attributes_errors'];
			unset($that->session->data['order_attributes_errors']);
		}

		$selected = array();
		if ( isset($that->session->data['order_attributes']) ) {
			$selected = $that->session->data['order_attributes'];
		}
		$data['text_additional_attributes'] = $that->language->get('text_additional_attributes');

		$attributes = $that->model_order_order_attributes->getAttributesForGroup(
			$that->customer->getCustomerGroupId(),
			'payment'
		);

		$elements = HtmlElementFactory::getAvailableElements();
		$html_multivalue_elements = HtmlElementFactory::getMultivalueElements();
		$elements_with_options = HtmlElementFactory::getElementsWithOptions();

		foreach ( $attributes as $attribute ) {

			$values = array();
			$value = ( !empty($selected) ) ? $selected[$attribute['attribute_id']] : '';
			$val_name = '';

			foreach ( $attribute['values'] as $val ) {

				$val_name = $val['value'];

				$values[$val['attribute_value_id']] = $val['value'];
			}

			if ( !in_array($attribute['element_type'], $elements_with_options) && empty($value) ) {
				$value = $val_name;
			}

			$html_type = $elements[ $attribute['element_type'] ]['type'];

			$option_data = array(
				'type' => $html_type,
				'name' => !in_array($attribute['element_type'], $html_multivalue_elements) ? 'attributes['.$attribute['global_attribute_id'].']' : 'attributes['.$attribute['global_attribute_id'].'][]',
				'value' => $value,
				'options' => $values,
				'required' => $attribute['required']
			);

			if ( $html_type == 'checkbox' ) {
				$option_data['label_text'] = $value;
				if ( !empty($option_data['value']) && !empty($selected) ) {
					$option_data['checked'] = true;
				}
			} elseif ( $html_type == 'checkboxgroup' ) {
				$option_data['scrollbox'] = true;
			} elseif ( $html_type == 'radio' && !empty($selected) ) {
				$option_data['value'] = $selected[$attribute['attribute_id']][0];
			} elseif ( $html_type == 'date' ) {
				$option_data['dateformat'] = format4Datepicker($that->language->get('date_format_short'));
			}

			$data['attributes'][] = array(
				'id' => $attribute['global_attribute_id'],
				'name' => $attribute['name'],
				'type' => $html_type,
				'html' => $that->html->buildElement($option_data),
			);

		}

		$view = new AView($this->registry, 0);
		$view->batchAssign($data);
		$that->view->addHookVar('order_attributes', $view->fetch('pages/checkout/order_attributes.tpl'));
	}

	public function onControllerPagesCheckoutConfirm_InitData() {
		$this->baseObject->loadLanguage('extension/order_attributes');
	}
	public function onControllerPagesCheckoutConfirm_UpdateData() {
		$that =& $this->baseObject;
		$data = array();
		$that->loadModel('order/order_attributes');

		$data['text_additional_attributes'] = $that->language->get('text_additional_attributes');

		$selected = $that->session->data['order_attributes'];

		$attributes = array();
		if ( is_array($selected) && has_value($selected) ) {
			foreach ( $selected as $id => $item ) {
				$attributes[] = $that->model_order_order_attributes->getAttributeInfo($id);
			}
		}

		uasort($attributes, array('self','sort_attributes'));

		$elements = HtmlElementFactory::getAvailableElements();
		$elements_with_options = HtmlElementFactory::getElementsWithOptions();

		foreach ( $attributes as $attribute ) {
			if ( !isset($attribute['attribute_id'])) {
				continue;
			}
			$values = array();
			$value = $selected[$attribute['attribute_id']];
			$val_name = '';

			foreach ( $attribute['values'] as $val ) {

				$val_name = $val['value'];

				$values[$val['attribute_value_id']] = $val['value'];
			}

			$html_type = $elements[ $attribute['element_type'] ]['type'];
			if($attribute['element_type']=='K') continue;
			$selected_vals = array();

			if ( in_array($attribute['element_type'], $elements_with_options) ) {

				if ( is_array($value) ) {
					if ( in_array($attribute['element_type'], array('O','Z')) ) { // for countries and zones
						$selected_vals[] = $value;
					} else {
						foreach ( $value as $val ) {
							$selected_vals[] = $values[$val];
						}
					}
				} else {
					if ( in_array($attribute['element_type'], array('O','Z')) ) { // for countries and zones
						$selected_vals[] = $value;
					} else {
						$selected_vals[] = $attribute['values'][$value]['value'];
					}
				}
			} else {
				$selected_vals[] = $value;
			}

			$data['attributes'][] = array(
				'id' => $attribute['attribute_id'],
				'name' => $attribute['name'],
				'type' => $html_type,
				'values' => $selected_vals
			);

		}

		$view = new AView($this->registry, 0);
		$view->batchAssign($data);
		$that->view->addHookVar('order_attributes', $view->fetch('pages/checkout/order_attributes_confirm.tpl'));

	}

	public function onControllerPagesCheckoutGuestStep2_InitData() {
		$that =& $this->baseObject;
		$that->loadLanguage('extension/order_attributes');
		$that->loadModel('order/order_attributes');


		if( ($this->_is_attributes_presents('shipping') || $this->_is_attributes_presents('payment')) && $that->request->get['mode']!='edit'){
			header('Location: ' . $that->html->getSecureURL('checkout/guest_step_2','&mode=edit'));
			exit(); //forbid skipping of shipping page
		}
		if ( $that->request->is_POST() && !has_value($that->request->post['coupon']) ) {
			if ( has_value($that->request->files['attributes']['name']) ) {
				$this->_process_file_upload();
			}
			if ( $this->_validate('guest_checkout') && empty($this->errors) ) {
				foreach ((array)$that->request->post['attributes'] as $key => $val) {
					$that->session->data['order_attributes'][$key] = $val;
				}
			}else {
				unset($that->request->server[ 'REQUEST_METHOD' ]);
				$that->session->data['order_attributes_errors'] = $this->errors;
			}
		}
	}

	public function onControllerPagesCheckoutGuestStep2_UpdateData() {
		$that =& $this->baseObject;
		$data = array();
		$that->loadModel('order/order_attributes');

		if ( has_value($that->session->data['order_attributes_errors']) ) {
			$data['errors'] = $that->session->data['order_attributes_errors'];
			unset($that->session->data['order_attributes_errors']);
		}

		$selected = array();
		if ( isset($that->session->data['order_attributes']) ) {
			$selected = $that->session->data['order_attributes'];
		}
		$data['text_additional_attributes'] = $that->language->get('text_additional_attributes');
		$customer_group_id = $that->customer->getCustomerGroupId();
		$customer_group_id = !$customer_group_id ? $that->config->get('config_customer_group_id'): $customer_group_id;

		$attributes = $that->model_order_order_attributes->getAttributesForGroup( $customer_group_id, 'guest_checkout' );

		$elements = HtmlElementFactory::getAvailableElements();
		$html_multivalue_elements = HtmlElementFactory::getMultivalueElements();
		$elements_with_options = HtmlElementFactory::getElementsWithOptions();

		foreach ( $attributes as $attribute ) {

			$values = array();
			$value = ( !empty($selected) ) ? $selected[$attribute['attribute_id']] : '';

			$val_name = '';

			foreach ( $attribute['values'] as $val ) {
				$val_name = $val['value'];
				$values[$val['attribute_value_id']] = $val['value'];
			}

			if ( !in_array($attribute['element_type'], $elements_with_options) ) {

				$value = $val_name;
			}

			$html_type = $elements[ $attribute['element_type'] ]['type'];

			$option_data = array(
				'type' => $html_type,
				'name' => !in_array($attribute['element_type'], $html_multivalue_elements) ? 'attributes['.$attribute['global_attribute_id'].']' : 'attributes['.$attribute['global_attribute_id'].'][]',
				'value' => $value,
				'options' => $values,
				'required' => $attribute['required']
			);

			if($html_type=='countries' || $html_type=='zones'){
				$that->loadModel('localisation/country');
				$country_info = $that->model_localisation_country->getCountry((int)$that->config->get('config_country_id'));
				$option_data['value'] = $country_info['name'];
			}

			if ( $html_type == 'checkbox' ) {
				$option_data['label_text'] = $value;
				if ( !empty($option_data['value']) && !empty($selected) ) {
					$option_data['checked'] = true;
				}
			} elseif ( $html_type == 'checkboxgroup' ) {
				$option_data['scrollbox'] = true;
			} elseif ( $html_type == 'date' ) {
				$option_data['dateformat'] = format4Datepicker($that->language->get('date_format_short'));
			} elseif ( $html_type == 'radio' && !empty($selected) ) {
				$option_data['value'] = $selected[$attribute['attribute_id']][0];
			}

			$data['attributes'][] = array(
				'id' => $attribute['global_attribute_id'],
				'name' => $attribute['name'],
				'type' => $html_type,
				'html' => $that->html->buildElement($option_data),
			);

		}

		$view = new AView($this->registry, 0);
		$view->batchAssign($data);
		$that->view->addHookVar('order_attributes', $view->fetch('pages/checkout/order_attributes.tpl'));
	}

	public function onControllerPagesCheckoutGuestStep3_InitData() {
		$this->baseObject->loadLanguage('extension/order_attributes');
	}
	public function onControllerPagesCheckoutGuestStep3_UpdateData() {
		$that =& $this->baseObject;
		$data = array();
		$that->loadModel('order/order_attributes');

		$data['text_additional_attributes'] = $that->language->get('text_additional_attributes');

		$selected = (array)$that->session->data['order_attributes'];

		$attributes = array();
		foreach ( $selected as $id => $item ) {
			$attributes[] = $that->model_order_order_attributes->getAttributeInfo($id);
		}

		uasort($attributes, array('self','sort_attributes'));

		$elements = HtmlElementFactory::getAvailableElements();
		$elements_with_options = HtmlElementFactory::getElementsWithOptions();

		foreach ( $attributes as $attribute ) {
			if ( !isset($attribute['attribute_id']) ) {
				continue;
			}
			$values = array();
			$value = $selected[$attribute['attribute_id']];
			$val_name = '';

			foreach ( $attribute['values'] as $val ) {

				$val_name = $val['value'];

				$values[$val['attribute_value_id']] = $val['value'];
			}

			$html_type = $elements[ $attribute['element_type'] ]['type'];

			$selected_vals = array();
			if ( in_array($attribute['element_type'], $elements_with_options) ) {
				if ( is_array($value) ) {
					if ( in_array($attribute['element_type'], array('O','Z')) ) { // for countries and zones
						$selected_vals = $value;
					} else {
						foreach ( $value as $val ) {
							$selected_vals[] = $values[$val];
						}
					}
				} else {
					if ( in_array($attribute['element_type'], array('O','Z')) ) { // for countries and zones
						$selected_vals[] = $value;
					} else {
						$selected_vals[] = $attribute['values'][$value]['value'];
					}

				}
			} else {
				$selected_vals[] = $value;
			}

			$data['attributes'][] = array(
				'id' => $attribute['attribute_id'],
				'name' => $attribute['name'],
				'type' => $html_type,
				//'html' => $that->html->buildElement($option_data),
				'values' => $selected_vals
			);

		}

		$view = new AView($this->registry, 0);
		$view->batchAssign($data);
		$that->view->addHookVar('order_attributes', $view->fetch('pages/checkout/order_attributes_confirm.tpl'));
	}

	public function onControllerPagesCheckoutSuccess_InitData() {
		$that =& $this->baseObject;
		if (isset($that->session->data['order_id'])) {
			$that->loadModel('order/order_attributes');
			$that->model_order_order_attributes->addAttributesToOrder(
				$that->session->data['order_id'],
				$that->session->data['order_attributes']
			);

			unset($that->session->data['order_attributes']);
		}

	}

	public function onControllerPagesAccountInvoice_InitData() {
		$that =& $this->baseObject;
		$data = array();

		$that->loadLanguage('extension/order_attributes');
		$that->loadModel('order/order_attributes');
		$that->loadModel('account/order');

		$data['text_additional_attributes'] = $that->language->get('text_additional_attributes');

		if (isset($that->request->get['order_id'])){
			$order_id = (int)$that->request->get['order_id'];
		} else{
			$order_id = 0;
		}

		$guest = false;
		$enc = new AEncryption($that->config->get('encryption_key'));
		if (isset($that->request->get['ot']) && $that->config->get('config_guest_checkout')){
			//try to decrypt order token
			$ot = $that->request->get['ot'];
			$decrypted = $enc->decrypt($ot);
			list($order_id, $email) = explode('::', $decrypted);

			$order_id = (int)$order_id;
			if (!$decrypted || !$order_id || !$email){
				return null;
			}
			$order_info = $that->model_account_order->getOrder($order_id, '', 'view');
			//compare emails
			if ($order_info['email'] != $email){
				return null;
			}
			$guest = true;
		}

		$attributes = $that->model_order_order_attributes->getCustomerVisibleAttributes($order_id);

		$elements = HtmlElementFactory::getAvailableElements();
		$elements_with_options = HtmlElementFactory::getElementsWithOptions();


		foreach ( $attributes as $attribute ) {
			if ( !isset($attribute['element_type']) ) {
				continue;
			}

			$values = array();
			$value = array();
			if ( count($attribute['selected_values']) > 1 ) {
				foreach ($attribute['selected_values'] as $val) {
					$value[$val['order_attribute_value']] = $val['order_attribute_value'];
				}
			} else {
				$value = $attribute['selected_values'][0]['order_attribute_value'];
			}

			foreach ( $attribute['values'] as $val ) {
				$values[$val['attribute_value_id']] = $val['value'];
			}

			$selected_vals = array();
			if ( in_array($attribute['element_type'], $elements_with_options) ) {
				if ( is_array($value) ) {
					if ( in_array($attribute['element_type'], array('O','Z')) ) { // for countries and zones
						$selected_vals = $value;
					} else {
						foreach ( $value as $val ) {
							$selected_vals[] = $values[$val];
						}
					}
				} else {
					if ( in_array($attribute['element_type'], array('O','Z')) ) { // for countries and zones
						$selected_vals[] = $value;
					} else {
						$selected_vals[] = $attribute['values'][$value]['value'];
					}
				}
			} else {
				$selected_vals[] = $value;
			}

			$html_type = $elements[ $attribute['element_type'] ]['type'];
			$data['attributes'][] = array(
				'id' => $attribute['attribute_id'],
				'name' => $attribute['name'],
				'type' => $html_type,
				'values' => $selected_vals
			);

		}

		$view = new AView($this->registry, 0);
		$view->batchAssign($data);
		$that->view->addHookVar('order_attributes', $view->fetch('pages/checkout/order_attributes_invoice.tpl'));
	}

	private function _validate($showIn = '') {
		$that =& $this->baseObject;
		$customer_group_id = $that->customer->getCustomerGroupId();
		$customer_group_id = !$customer_group_id ? $that->config->get('config_customer_group_id'): $customer_group_id;
		$errors = $that->model_order_order_attributes->validateAttributesForCreate(
			$customer_group_id,
			$that->request->post['attributes'],
			$showIn
		);

		if ( !empty($errors) ) {
			foreach ( $errors as $id => $error ) {
				$this->errors[$id] = $error;
			}
			return false;
		}
		return true;
	}

	private function _is_attributes_presents($show_in){
		$that =& $this->baseObject;
		$customer_group_id = $that->customer->getCustomerGroupId();
		$customer_group_id = !$customer_group_id ? $that->config->get('config_customer_group_id'): $customer_group_id;
		$attributes = $that->model_order_order_attributes->getAttributesForGroup( $customer_group_id, $show_in );

		$is_visible = false;
		foreach($attributes as $attribute){

			if($attribute['visible_by_customer']){
				$is_visible = true;
				break;
			}
		}

		return $is_visible;
	}


	private function sort_attributes($a, $b) {
	    if ($a['sort_order'] == $b['sort_order']) {
	        return 0;
	    }
	    return ($a['sort_order'] < $b['sort_order']) ? -1 : 1;
	}

	private function _process_file_upload() {
		$that =& $this->baseObject;
		$fm = new AFile();

		foreach ( $that->request->files['attributes']['name'] as $id => $name ) {

			$attribute_data = $that->model_order_order_attributes->getAttributeInfo($id);

			if ( $attribute_data['required'] && !has_value($name) ) {
				$this->errors[$id] = $that->language->get('error_required');
			} else {
				if ( !has_value($name) ) {
					continue;
				}

				$file_path_info = $fm->getUploadFilePath($attribute_data['settings']['directory'], $name);
				$that->request->post['attributes'][$id] = $file_path_info['name'];

				$file_data = array(
					'option_id' => $id,
					'name' => $file_path_info['name'],
					'path' => $file_path_info['path'],
					'type' => $that->request->files['attributes']['type'][$id],
					'tmp_name' => $that->request->files['attributes']['tmp_name'][$id],
					'error' => $that->request->files['attributes']['error'][$id],
					'size' => $that->request->files['attributes']['size'][$id],
				);

				$file_errors = $fm->validateFileOption($attribute_data['settings'], $file_data);

				if ( has_value($file_errors) ) {
					$this->errors[$id] = $file_errors[0];
				}

				if ( !has_value($this->errors) ) {
					$result = move_uploaded_file($file_data['tmp_name'], $file_path_info['path']);

					$dataset = new ADataset('file_uploads','admin');
					$dataset->addRows(
						array(
							'date_added'=> date("Y-m-d H:i:s",time()),
							'name' => $file_path_info['name'],
							'type' => $file_data['type'],
							'section' => 'order_attribute',
							'section_id' => $attribute_data['attribute_id'],
							'path' => $file_path_info['path']));
				}
			}
		}
	}

	public function onControllerPagesCatalogAttribute_UpdateData() {
		$form = $this->baseObject->data[ 'form' ];
		unset($form[ 'fields' ][ 'attribute_parent' ]);
		$this->baseObject->view->assign('form',$form);
	}
}