<?php

/* Hooks */
if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

class ExtensionOptionsListing extends Extension
{
    public $data = [];
    protected $routes = [];

    public function __construct()
    {
        $this->registry = Registry::getInstance();
        if (true == $this->config->get('embed_mode')) {
            $this->routes['cart_rt'] = 'r/checkout/cart/embed';
        } else {
            $this->routes['cart_rt'] = 'checkout/cart';
        }
    }

    public function __get($key)
    {
        return $this->registry->get($key);
    }

    public function pageclass()
    {
        $request = $this->request->get;
        $pagedata = [];

        $url = '';
        if (isset($request['page'])) {
            $url .= '&page=' . $request['page'];
        }

        if (isset($request['page'])) {
            $page = $request['page'];
        } else {
            $page = 1;
        }

        if (isset($request['limit'])) {
            $limit = (int) $request['limit'];
            $limit = $limit > 50 ? 50 : $limit;
        } else {
            $limit = $this->baseObject->config->get('config_catalog_limit');
        }

        if (isset($request['sort'])) {
            $sorting_href = $request['sort'];
        } else {
            $sorting_href = $this->baseObject->config->get('config_product_default_sort_order');
        }

        list($sort, $order) = explode('-', $sorting_href);
        if ('name' == $sort) {
            $sort = 'pd.' . $sort;
        } elseif (in_array($sort, ['sort_order', 'price'])) {
            $sort = 'p.' . $sort;
        }

        // for search
        if (isset($request['model'])) {
            $model = $request['model'];
            $pagedata['model'] = $model;
        }

        if (isset($request['description'])) {
            $description = $request['description'];
            $pagedata['description'] = $description;
        }

        if (isset($request['keyword'])) {
            $keyword = $request['keyword'];
            $pagedata['keyword'] = $keyword;
        }

        $pagedata['order'] = $order;
        $pagedata['page'] = $page;
        $pagedata['limit'] = $limit;
        $pagedata['sorting_href'] = $sorting_href;
        $pagedata['sort'] = $sort;

        return $pagedata;
    }

    public function onControllerPagesProductProduct_UpdateData()
    {
        if (!$this->module_enabled($this->baseObject)) {
            return null;
        }
        $product_id = $this->baseObject->request->get['product_id'];
        if (empty($product_id)) {// cart revert
            $product_id = $this->baseObject->request->get['key'];
        }
        // $this->baseObject->loadModel('extension/options_listing');
        $this->baseObject->load->model('extension/options_listing');
        $view = new AView($this->registry, 0);
        // get all data from the Controller
        $data = $this->baseObject->view->getData();
        $data['unit'] = $this->baseObject->model_extension_options_listing->getProductSettings($product_id);
        // $view->batchAssign($data);
        $this->baseObject->view->assign('unit', $data['unit']);
    }

    // //////////OPTIONS START
    protected function module_enabled($that)
    {
        return $that->config->get('options_listing_status');
    }

    public function onControllerPagesProductCategory_UpdateData()   //     category
    {
        if (!IS_ADMIN) {
            if (!$this->module_enabled($this->baseObject)) {
                return null;
            }
            if ('main' != $this->baseObject_method) {
                return null;
            }
            if ('1' == $this->baseObject->config->get('options_listing_listing_status_category')) {
                $this->qty_listing($this->baseObject);
            }
        }
    }


    public function onControllerPagesProductRefinedSearch_UpdateData()
    {
        if (!IS_ADMIN) {
            if (!$this->module_enabled($this->baseObject)) {
                return null;
            }
            if ('main' != $this->baseObject_method) {
                return null;
            }
            if ('1' == $this->baseObject->config->get('options_listing_listing_status_search')) {
                $this->qty_listing($this->baseObject);
            }
        }
    }

    public function onControllerPagesProductCollection_UpdateData()
    {
        if (!IS_ADMIN) {
            if (!$this->module_enabled($this->baseObject)) {
                return null;
            }
            if ('main' != $this->baseObject_method) {
                return null;
            }
            if ('1' == $this->baseObject->config->get('options_listing_listing_status_category')) {
                $this->qty_listing($this->baseObject);
            }
        }
    }

    protected function qty_listing($that)
    {
        if (!IS_ADMIN) {
            $products = $that->view->getData('products');
            $products = !is_array($products) ? [] : $products;
            $product_ids = [];
            $this->baseObject->loadLanguage('product/product');
            $this->baseObject->loadLanguage('options_listing/options_listing');
            $this->baseObject->loadModel('catalog/product');
            // $this->load->model('extension/options_listing');
            $this->baseObject->loadModel('extension/options_listing');
            foreach ($products as $product) {
                $product_ids[] = $product['product_id'];
            }
            if ($this->baseObject->customer->isLogged()) {
                $promotion = new APromotion();
            }

            $view = new AView($this->registry, 0);

            foreach ($products as &$product) {
                if (!$this->baseObject->customer->isLogged()) {
                    // $product['price'] = 'Login/register for wholesale pricing';
                    $product['special'] = '';
                    $product['price'] = '';
                    // hook default add to cart button in listing
                    $product['add'] = '#';
                    $torender = '<div class="price nopricingtag"><a href="' . $this->html->getSecureURL('account/login') . '">' . $this->baseObject->language->get('options_listing_login') . '</a></div>';
                    // listing
                    $this->baseObject->view->addHookVar('product_listing_details1_' . $product['product_id'], $torender);
                }

                // add fields
                if ($this->baseObject->customer->isLogged()) {
                    $product_info = $this->baseObject->model_catalog_product->getProduct($product['product_id']);
                    // $this->baseObject->log->write((int) $product['product_id'].'pr='.print_r($product_info, true).' productsINFO');
                    $product_discounts = $promotion->getProductDiscounts($product['product_id']);
                    $discounts = [];
                    foreach ($product_discounts as $discount) {
                        $discounts[] = [
                            'quantity' => $discount['quantity'],
                            'price' => $this->currency->format($this->tax->calculate($discount['price'], $product_info['tax_class_id'], (bool) $this->config->get('config_tax'))),
                        ];
                    }
                    $this->data['discounts'] = $discounts;
                    // START OPTIONS
                    $elements_with_options = HtmlElementFactory::getElementsWithOptions();
                    $options = [];
                    $product_options = $this->model_catalog_product->getProductOptions($product['product_id']);
                    // get info from cart if key presents
                    $cart_product_info = [];
                    if ($key) {
                        $cart_product_info = $this->model_catalog_product->getProduct($request['key']);
                    } else {
                        $cart_product_info = $this->model_catalog_product->getProduct($product['product_id']);
                    }
                    // $this->baseObject->log->write(print_r($cart_product_info, true));
                    foreach ($product_options as $option) {
                        $values = [];
                        $disabled_values = [];
                        $name = $price = '';
                        $default_value = $cart_product_info['options'][$option['product_option_id']];
                        if ('R' == $option['element_type']) {
                            $default_value = is_array($default_value) ? current($default_value) : (string) $default_value;
                        }
                        $preset_value = $default_value;
                        $opt_stock_message = '';
                        foreach ($option['option_value'] as $option_value) {
                            $default_value = $option_value['default'] && !$default_value ? $option_value['product_option_value_id'] : $default_value;
                            // for case when trying to add to cart without required options. we get option-array back inside _GET
                            if (has_value($request['option'][$option['product_option_id']])) {
                                $default_value = $request['option'][$option['product_option_id']];
                            }

                            $name = $option_value['name'];
                            // check if we disable option based on stock settings
                            if ($option_value['subtract'] && $this->config->get('config_nostock_autodisable') && $option_value['quantity'] <= 0) {
                                continue;
                            }

                            // Stock and status
                            $opt_stock_message = '';
                            // if options has stock tracking and not allowed to be purchased out of stock
                            if ($option_value['subtract'] && !$product_info['stock_checkout']) {
                                if ($option_value['quantity'] <= 0) {
                                    // show out of stock message
                                    $opt_stock_message = $this->language->get('text_out_of_stock');
                                    $disabled_values[] = $option_value['product_option_value_id'];
                                } else {
                                    if ($this->config->get('config_stock_display')) {
                                        if ($option_value['quantity'] > 0) {
                                            $opt_stock_message = $option_value['quantity'] . ' ' . $this->language->get('text_instock');
                                            $opt_stock_message = "({$opt_stock_message})";
                                        }
                                    }
                                }
                            } else {
                                if ($option_value['subtract'] && $product_info['stock_checkout']) {
                                    if ($option_value['quantity'] <= 0) {
                                        // $opt_stock_message = "({$product_info['stock_status']})";
                                        $opt_stock_message = $product_info['stock_status'] ? "({$product_info['stock_status']})" : '';
                                    }
                                }
                            }

                            // Apply option price modifier
                            if ('%' == $option_value['prefix']) {
                                $price = $this->tax->calculate(
                                    $product_price * $option_value['price'] / 100,
                                    $product_info['tax_class_id'],
                                    (bool) $this->config->get('config_tax')
                                );
                                if (0 != $price) {
                                    $price = $this->currency->format($price);
                                } else {
                                    $price = '';
                                }
                            } else {
                                $price = $this->tax->calculate($option_value['price'], $product_info['tax_class_id'], (bool) $this->config->get('config_tax'));
                                if (0 != $price) {
                                    $price = $this->currency->format($price);
                                } else {
                                    $price = '';
                                }
                            }

                            $values[$option_value['product_option_value_id']] = $option_value['name'] . ' ' . $price . ' ' . $opt_stock_message;
                            // disable stock tracking for product if some of option have subtract
                            if ($option_value['subtract']) {
                                $product_info['subtract'] = false;
                            }

                            if ('B' == $option['element_type']) {
                                $name = $default_value = preg_replace("/\r|\n/", ' ', $option_value['name']);
                                if ($price) {
                                    $default_value .= '</br>';
                                    $name .= ' ';
                                }
                                if ($price) {
                                    $default_value .= $price . ' ';
                                    $name .= $price;
                                }
                                $option['required'] = false;
                            }
                        }

                        $option_data = [];

                        // if not values are build, nothing to show
                        if (count($values)) {
                            $value = '';
                            // add price to option name if it is not element with options
                            if (!in_array($option['element_type'], $elements_with_options) && 'B' != $option['element_type']) {
                                $option['name'] .= ' <small>' . $price . '</small>';
                                if ($opt_stock_message) {
                                    $option['name'] .= '<br />' . $opt_stock_message;
                                }
                                $value = $default_value ? $default_value : $name;
                            } else {
                                if ('B' == $option['element_type']) {
                                    $value = $name;
                                }
                            }

                            // set default selection is nothing selected
                            if (!has_value($value)) {
                                if (has_value($default_value)) {
                                    $value = $default_value;
                                }
                            }

                            // for checkbox with empty value
                            if ('' == $value && 'C' == $option['element_type']) {
                                $value = 1;
                            }

                            $option_data = [
                                'type' => $option['html_type'],
                                'name' => !in_array($option['element_type'], HtmlElementFactory::getMultivalueElements()) ? 'option[' . $option['product_option_id'] . ']' : 'option[' . $option['product_option_id'] . '][]',
                                'value' => $value,
                                'options' => $values,
                                'disabled_options' => $disabled_values,
                                'required' => $option['required'],
                                'placeholder' => $option['option_placeholder'],
                                'regexp_pattern' => $option['regexp_pattern'],
                                'error_text' => $option['error_text'],
                            ];

                            if ('C' == $option['element_type']) {
                                if (!in_array($value, ['0', '1'])) {
                                    $option_data['label_text'] = $value;
                                }
                                $option_data['checked'] = $preset_value ? true : false;
                            }

                            $options[] = [
                                'name' => $option['name'],
                                'html' => $this->html->buildElement($option_data),  // not a string!!! it's object!
                            ];
                        }
                    }
                    $data['discounts'] = $discounts;
                    $data['options'] = $options;

                    $data['unit'] = $that->model_extension_options_listing->getProductSettings($product['product_id']); // $product_info['unit'];
                    $data['product_id'] = (int) $product['product_id'];
                    $data['action'] = $this->html->getSecureURL($this->routes['cart_rt']);
                    // END OPTIONS
                    if ($cart_product_info['minimum'] > 0) {
                        $minimum_quanity = $cart_product_info['minimum'];
                    } else {
                        $minimum_quanity = 1;
                    }

                    // print_r($product);
                    $torender = '<input type="text" class="opt_qty" name="quantity" id="product_quantity_' . $product['product_id'] . '" data-id="' . $product['product_id'] . '" value="' . (int) $minimum_quanity . '" placeholder="" class="form-control short" size="3"></form>';
                    $this->baseObject->view->addHookVar('product_listing_details1_' . $product['product_id'], $torender);
                    $view->batchAssign($data);
                    $this->baseObject->view->addHookVar('product_listing_details0_' . $product['product_id'], $view->fetch('pages/options_listing/listing_data.tpl'));
                }
            }
            if (!$this->baseObject->customer->isLogged()) {
                $this->document->addStyle(
                    [
                        'href' => $this->baseObject->view->templateResource('/css/options_listing_restrict.css'),
                        'rel' => 'stylesheet',
                        'media' => 'screen',
                    ]
                );
            }

            $this->document->addScriptBottom($this->baseObject->view->templateResource('/js/listalign.js'));
            $this->document->addStyle(
                [
                    'href' => $this->baseObject->view->templateResource('/css/options_listing.css'),
                    'rel' => 'stylesheet',
                    'media' => 'screen',
                ]
            );
            $that->view->assign('products', $products);
        }
    }

    public function onControllerCommonFooter_UpdateData()
    {
        if (!IS_ADMIN) {
            $actionaj = $this->baseObject->html->getSEOURL($this->routes['cart_rt'], '', '&encode');
            $this->baseObject->view->assign('cart_ajax_url', $this->baseObject->html->getURL('r/product/product/addToCart'));
            $this->baseObject->view->assign('actionaj', $actionaj);
        }
    }

    public function onControllerBlocksBestseller_UpdateData()
    {
        if (!$this->module_enabled($this->baseObject)) {
            return null;
        }
        if ('1' == $this->baseObject->config->get('options_listing_block_status_bestsellers')) {
            $this->qty_listing($this->baseObject);
        }
    }

    public function onControllerBlocksLatest_UpdateData()
    {
        if (!$this->module_enabled($this->baseObject)) {
            return null;
        }
        if ('1' == $this->baseObject->config->get('options_listing_block_status_latest')) {
            $this->qty_listing($this->baseObject);
        }
    }

    public function onControllerBlocksSpecial_UpdateData()
    {
        if (!$this->module_enabled($this->baseObject)) {
            return null;
        }
        if ('1' == $this->baseObject->config->get('options_listing_listing_status_special')) {
            $this->qty_listing($this->baseObject);
        }
    }

    public function onControllerBlocksListingBlock_UpdateData()
    {
        if (!$this->module_enabled($this->baseObject)) {
            return null;
        }
        if ('main' != $this->baseObject_method) {
            return null;
        }
        if ('1' == $this->baseObject->config->get('options_listing_listing_status_special')) {
            $this->qty_listing($this->baseObject);
        }
    }

    public function onControllerPagesProductManufacturer_UpdateData()
    {
        if (!IS_ADMIN) {
            if (!$this->module_enabled($this->baseObject)) {
                return null;
            }
            if ('main' != $this->baseObject_method) {
                return null;
            }
            if ('1' == $this->baseObject->config->get('options_listing_listing_status_manufacturer')) {
                $this->qty_listing($this->baseObject);
            }
        }
    }

    

    public function onControllerPagesProductSearch_UpdateData()
    {
        if (!IS_ADMIN) {
            if (!$this->module_enabled($this->baseObject)) {
                return null;
            }
            if ('main' != $this->baseObject_method) {
                return null;
            }
            if ('1' == $this->baseObject->config->get('options_listing_listing_status_search')) {
                $this->qty_listing($this->baseObject);
            }
        }
    }

    public function onControllerPagesProductSpecial_UpdateData()
    {
        if (!$this->module_enabled($this->baseObject)) {
            return null;
        }
        if ('main' != $this->baseObject_method) {
            return null;
        }
        if ('1' == $this->baseObject->config->get('options_listing_listing_status_special')) {
            $this->qty_listing($this->baseObject);
        }
    }

    // unit
    public function onControllerPagesCatalogProduct_InitData()
    {
        if (IS_ADMIN) {
            // if (in_array($this->baseObject->method, array('update', 'insert'))) {
            $product_id = (int) $this->baseObject->request->get['product_id'];
            $this->baseObject->load->model('extension/options_listing');
            if ($this->baseObject->request->is_POST() && $product_id) {
                $unit = $this->baseObject->request->post['unit'];
                $this->baseObject->model_extension_options_listing->updateProductSettings($product_id, $unit);
            }
        }
    }

    public function onControllerResponsesListingGridProduct_InitData()
    {
        if (!$this->module_enabled($this->baseObject)) {
            return null;
        }
        $product_id = (int) $this->baseObject->request->get['id'];
        if (!$this->baseObject->request->is_POST() || !$product_id) {
            return null;
        }
        $post = $this->baseObject->request->post;
        if (isset($post['unit'])) {
            $this->baseObject->load->model('extension/options_listing');
            $this->baseObject->model_extension_options_listing->updateProductSettings($product_id, $post['unit']);
        }
    }

    public function onControllerPagesCatalogProduct_UpdateData()
    {
        $that = $this->baseObject;
        if (!$this->module_enabled($this->baseObject)) {
            return null;
        }
        $product_id = (int) $that->request->get['product_id'];
        $product_info = $that->view->getData('product_info');

        $product_info['unit'] = $that->model_extension_options_listing->getProductSettings($product_id);
        $viewport_mode = 'catalog/product/update' == $that->request->get['viewport_rt'] ? true : false;
        $view = new AView(Registry::getInstance(), 0);
        if (in_array($this->baseObject_method, ['update'])) {
            $data = $that->view->getData('form');
            // add fields related to donation
            $that->view->assign('entry_unit', 'Unit');
            $data['fields']['data'] = [
                'unit' => $that->html->buildElement(
                    [
                        'type' => 'input',
                        'name' => 'unit',
                        'value' => $product_info['unit'],
                        // 'style' => 'tiny-field',
                        // 'required' => true,
                    ]
                ), ]
                    +
                    $data['fields']['data'];

            $that->view->assign('form', $data);
        }
    }

    // //////////OPTIONS END
    public function onControllerPagesProductSearch_InitData()   // search
    {
        if (!IS_ADMIN) {
            if ('1' == $this->baseObject->config->get('options_listing_listing_status_search')) {
                $this->baseObject->loadLanguage('options_listing/options_listing');
                $request = $this->request->get;
                if (isset($request['category_id'])) {
                    $category_id = explode(',', $request['category_id']);
                    end($category_id);
                    $category_id = current($category_id);
                } else {
                    $category_id = '';
                }

                $pagedata = $this->pageclass();
                $limit = $pagedata['limit'];
                // $this->baseObject->config->get('config_catalog_limit');    cache or sql bug
                $this->baseObject->load->model('catalog/product');
                // ($keyword, $category_id = 0, $description = false, $model = false, $sort = 'p.sort_order', $order = 'ASC', $start = 0, $limit = 20)
                $products_result = $this->baseObject->model_catalog_product->getProductsByKeyword(
                    $pagedata['keyword'],
                    $category_id,
                    isset($pagedata['description']) ? $pagedata['description'] : '',
                    isset($pagedata['model']) ? $pagedata['model'] : '',
                    $pagedata['sort'],
                    $pagedata['order'],
                    ($pagedata['page'] - 1) * $limit,
                    $limit
                );
                // $this->baseObject->log->write(serialize($products_result));
                // $this->processingclass($products_result);
            }
        }
    }

    public function onControllerBlocksfeatured_UpdateData()
    {
        if (!$this->module_enabled($this->baseObject)) {
            return null;
        }

        if ('1' == $this->baseObject->config->get('options_listing_block_status_featured')) {
            $this->qty_listing($this->baseObject);
        }
    }
}
