<?php

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

class ModelExtensionOfflineCreditCardProcessing extends Model
{
    public function getMethod($address)
    {
        $this->load->language('offline_credit_card_processing/offline_credit_card_processing');
        if ($this->config->get('offline_credit_card_processing_status')) {
            $query = $this->db->query(
                "SELECT * 
                FROM ".$this->db->table('zones_to_locations')." 
                WHERE location_id = '".(int) $this->config->get('offline_credit_card_processing_location_id' )."' 
                    AND country_id = '".(int) $address['country_id']."' 
                    AND (zone_id = '".(int) $address['zone_id']."' OR zone_id = '0')"
            );

            $min = $this->config->get("offline_credit_card_processing_minimum_total");
            $max = $this->config->get("offline_credit_card_processing_maximum_total");
            $amount = $this->cart->getFinalTotal();

            if ((has_value($min) && $amount < $min) || (has_value($max) && $amount > $max)) {
                $status = false;
            } elseif (!$this->config->get('offline_credit_card_processing_location_id')) {
                $status = true;
            } elseif ($query->num_rows) {
                $status = true;
            } else {
                $status = false;
            }
        } else {
            $status = false;
        }

        $method_data = [];
        if ($status) {
            $method_data = [
                'id'         => 'offline_credit_card_processing',
                'title'      => $this->language->get('text_title'),
                'sort_order' => $this->config->get('offline_credit_card_processing_sort_order'),
            ];
        }
        return $method_data;
    }

    public function save_cc_details($data)
    {
        $key_sql = '';
        $order_id = $data['order_id'];
        if (!$order_id) {
            return false;
        }

        if ($this->dcrypt->active) {
            $this->log->write(var_Export($data, true));
            $data = $this->dcrypt->encrypt_data($data, 'order_credit_card_details');
            $key_sql = ", key_id = '".(int) $data['key_id']."'";
        }

        $this->db->query(
            "INSERT INTO `".$this->db->table("order_credit_card_details")."`
            SET order_id = '".(int) $order_id."',
                card_data = '".$this->db->escape($data['card_data'])."' ".$key_sql.", 
                date_added = NOW()"
        );
        return true;
    }
}